/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.hr.perf.EvalWorkFlowFactory;
import com.kingdee.eas.hr.perf.EvalWorkFlowInfo;
import com.kingdee.eas.hr.perf.FellowTypeEnum;
import com.kingdee.eas.hr.perf.client.AbstractWorkFlowDefineBasePropsUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class WorkFlowDefineBasePropsUI
extends AbstractWorkFlowDefineBasePropsUI {
    private static final Logger logger = CoreUIObject.getLogger(WorkFlowDefineBasePropsUI.class);
    private String RES = "com.kingdee.eas.hr.perf.client.WorkFlowDefineResource";
    int MAXWORKFLOWLEVEL = 10;

    public WorkFlowDefineBasePropsUI() throws Exception {
        this.kDNumberTextFieldconcurrenceLevels.setSupportedEmpty(true);
    }

    protected void initUserConfig() {
    }

    public void storeFields(EvalWorkFlowInfo wfInfo) {
        wfInfo.setName(this.txtname.getText());
        wfInfo.setNumber(this.txtNumber.getText());
        wfInfo.setWfLevels(this.kDNumberTextFieldwfLevels.getIntegerValue());
        FellowTypeEnum type = this.radioButtonSameSuperiorAllPosition.isSelected() ? FellowTypeEnum.SAMESUPERIOR_ALLPOSITION : (this.radioButtonSameSuperiorOtherPosition.isSelected() ? FellowTypeEnum.SAMESUPERIOR_OTHERPOSITION : (this.radioButtonSamePositionOtherPerson.isSelected() ? FellowTypeEnum.SAMEPOSITION_OTHERPERSON : (this.radioSameGradeLeve.isSelected() ? FellowTypeEnum.SAMEJOBLEVEL : FellowTypeEnum.SAMESUPERIOR_ALLPOSITION)));
        wfInfo.setFellowType(type);
        if (!PFVerifyUtils.objectIsNull(this.kDNumberTextFieldconcurrenceLevels.getText())) {
            wfInfo.setConcurrenceLevels(this.kDNumberTextFieldconcurrenceLevels.getIntegerValue());
        } else {
            wfInfo.setConcurrenceLevels(0);
        }
    }

    public boolean verifyData(EvalWorkFlowInfo wfInfo) throws Exception {
        if (PFVerifyUtils.objectIsNull(this.txtNumber.getText())) {
            this.txtNumber.requestFocus();
            this.showErrorMessage("workflowNumberNotNull");
        } else if (!PFVerifyUtils.isNumberString(this.txtNumber.getText())) {
            this.txtNumber.requestFocus();
            this.showErrorMessage("workflowNumberMustNumber");
        } else if (this.txtNumber.getText().trim().length() > 255) {
            this.txtNumber.requestFocus();
            this.showErrorMessage("numberTooLong");
        }
        if (PFVerifyUtils.objectIsNull(this.txtname.getText())) {
            this.txtname.requestFocus();
            this.showErrorMessage("workflowNameNotNull");
        } else if (this.txtname.getText().trim().length() > 255) {
            this.txtname.requestFocus();
            this.showErrorMessage("nameTooLong");
        }
        if (PFVerifyUtils.objectIsNull(this.kDNumberTextFieldwfLevels.getText())) {
            this.kDNumberTextFieldwfLevels.requestFocus();
            this.showErrorMessage("workflowLevelNotNull");
        }
        if (this.kDNumberTextFieldwfLevels.getIntegerValue() <= 0 || this.kDNumberTextFieldwfLevels.getIntegerValue() > this.MAXWORKFLOWLEVEL) {
            this.kDNumberTextFieldwfLevels.requestFocus();
            String message = EASResource.getString((String)this.RES, (String)"workflowLevelIllegal");
            Object[] variables = new Object[]{new Integer(0), new Integer(this.MAXWORKFLOWLEVEL)};
            MsgBox.showError((Component)((Object)this), (String)MessageFormat.format(message, variables));
            this.setCursorOfDefault();
            SysUtil.abort();
        }
        if (!(PFVerifyUtils.objectIsNull(this.kDNumberTextFieldconcurrenceLevels.getText()) || this.kDNumberTextFieldconcurrenceLevels.getIntegerValue() >= 0 && this.kDNumberTextFieldconcurrenceLevels.getIntegerValue() <= this.kDNumberTextFieldwfLevels.getIntegerValue() - 1)) {
            this.kDNumberTextFieldconcurrenceLevels.requestFocus();
            this.showErrorMessage("workflowConcurrentInvalid");
        }
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)this.txtNumber.getText(), CompareType.EQUALS);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(filterItem);
        if (wfInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)wfInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filterItem = new FilterItemInfo("solutionPeriod.id", (Object)wfInfo.getSolutionPeriod().getId().toString());
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1 and #2");
        } else {
            filterItem = new FilterItemInfo("solutionPeriod.id", (Object)wfInfo.getSolutionPeriod().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        if (EvalWorkFlowFactory.getRemoteInstance().exists(filter)) {
            this.txtNumber.requestFocus();
            this.showErrorMessage("workflowNumberNotDup");
        }
        this.storeFields(wfInfo);
        return true;
    }

    public int getConcurrentLevel() {
        return Integer.parseInt(this.kDNumberTextFieldconcurrenceLevels.getText());
    }

    private void showErrorMessage(String message) {
        String s = EASResource.getString((String)this.RES, (String)message);
        MsgBox.showError((Component)((Object)this), (String)s);
        this.setCursorOfDefault();
        SysUtil.abort();
    }
}

