/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDNumberTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.hr.perf.ConcurrenceArgsInfo;
import com.kingdee.eas.hr.perf.EvalWorkFlowInfo;
import com.kingdee.eas.hr.perf.client.AbstractWorkFlowDefineConCurrencyNodeDetailPropsUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class WorkFlowDefineConCurrencyNodeDetailPropsUI
extends AbstractWorkFlowDefineConCurrencyNodeDetailPropsUI {
    private static final Logger logger = CoreUIObject.getLogger(WorkFlowDefineConCurrencyNodeDetailPropsUI.class);
    private String RES = "com.kingdee.eas.hr.perf.client.WorkFlowDefineResource";
    private KDLabelContainer container;
    private KDNumberTextField numberTxtField;
    private HashMap levelHash = new HashMap();
    private HashMap concurHash = new HashMap();
    private HashMap levelContainerHash = new HashMap();
    private HashMap concurContainerHash = new HashMap();
    int y = 40;
    int MAXCONCURREN = 20;
    int MAXNODE = 50;

    protected void initUserConfig() {
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    private void clearAll() {
        this.levelHash = new HashMap();
        this.concurHash = new HashMap();
        this.levelContainerHash = new HashMap();
        this.concurContainerHash = new HashMap();
        this.kDPanel1.removeAll();
    }

    public void initLevel(EvalWorkFlowInfo wfInfo) {
        this.clearAll();
        int concurrentlevel = wfInfo.getConcurrenceLevels();
        for (int i = 0; i < concurrentlevel; ++i) {
            this.numberTxtField = new KDNumberTextField();
            this.numberTxtField.setRequired(true);
            this.numberTxtField.setName("pf_kdNumber1" + i);
            this.levelHash.put("" + i, this.numberTxtField);
            this.container = new KDLabelContainer();
            this.container.setName("pf_kdContainer1" + i);
            this.container.setBoundLabelText(EASResource.getString((String)this.RES, (String)"di"));
            this.container.setBoundLabelLength(20);
            this.container.setBoundLabelUnderline(true);
            this.container.setBoundEditor((JComponent)this.numberTxtField);
            this.container.setBounds(new Rectangle(52, this.y + i * 30, 81, 19));
            this.kDPanel1.add((Component)this.container, null);
            this.levelContainerHash.put("" + i, this.container);
            this.numberTxtField = new KDNumberTextField();
            this.numberTxtField.setRequired(true);
            this.numberTxtField.setName("pf_kdNumber2" + i);
            this.concurHash.put("" + i, this.numberTxtField);
            this.container = new KDLabelContainer();
            this.container.setName("pf_kdContainer2" + i);
            this.container.setBoundLabelText(EASResource.getString((String)this.RES, (String)"levelsConcurrent"));
            this.container.setBoundLabelLength(130);
            this.container.setBoundLabelUnderline(true);
            this.container.setBoundEditor((JComponent)this.numberTxtField);
            this.container.setBounds(new Rectangle(140, this.y + i * 30, 188, 19));
            this.kDPanel1.add((Component)this.container, null);
            this.concurContainerHash.put("" + i, this.container);
        }
        Dimension dimension = new Dimension(this.kDPanel1.getPreferredSize().width, this.y + (concurrentlevel + 1) * 30);
        this.kDPanel1.setPreferredSize(dimension);
        this.kDPanel1.revalidate();
    }

    public boolean verifyData(EvalWorkFlowInfo wfInfo) throws Exception {
        Object[] variables;
        String message;
        int maxlevels = wfInfo.getWfLevels();
        HashMap<String, String> oldValue = new HashMap<String, String>();
        int totalConcurrentNode = 0;
        int n = wfInfo.getConcurrenceLevels();
        for (int i = 0; i < n; ++i) {
            KDNumberTextField numberTxtField = (KDNumberTextField)this.levelHash.get("" + i);
            if (PFVerifyUtils.objectIsNull(numberTxtField.getText())) {
                numberTxtField.requestFocus();
                this.showErrorMessage("levelComeOnConcurrentNotNull");
            } else if (numberTxtField.getIntegerValue() == 1) {
                numberTxtField.requestFocus();
                this.showErrorMessage("firstLevelNotConcurrent");
            } else if (numberTxtField.getIntegerValue() < 1 || numberTxtField.getIntegerValue() > maxlevels) {
                numberTxtField.requestFocus();
                message = EASResource.getString((String)this.RES, (String)"concurrentLevelIllegal");
                variables = new Object[]{new Integer(1), new Integer(maxlevels)};
                MsgBox.showError((Component)((Object)this), (String)MessageFormat.format(message, variables));
                this.setCursorOfDefault();
                SysUtil.abort();
            } else if (oldValue.containsKey(numberTxtField.getIntegerValue().toString())) {
                numberTxtField.requestFocus();
                this.showErrorMessage("hasAlreadyLevelConcurrent");
            } else {
                oldValue.put(numberTxtField.getIntegerValue().toString(), numberTxtField.getIntegerValue().toString());
            }
            numberTxtField = (KDNumberTextField)this.concurHash.get("" + i);
            if (PFVerifyUtils.objectIsNull(numberTxtField.getText())) {
                numberTxtField.requestFocus();
                this.showErrorMessage("levelConcurrentsNotNull");
            } else if (numberTxtField.getIntegerValue() <= 1 || numberTxtField.getIntegerValue() > this.MAXCONCURREN) {
                numberTxtField.requestFocus();
                message = EASResource.getString((String)this.RES, (String)"levelConcurrenceIllegal");
                variables = new Object[]{new Integer(1), new Integer(this.MAXCONCURREN)};
                MsgBox.showError((Component)((Object)this), (String)MessageFormat.format(message, variables));
                this.setCursorOfDefault();
                SysUtil.abort();
            }
            totalConcurrentNode += numberTxtField.getIntegerValue().intValue();
        }
        int totalNode = totalConcurrentNode + (wfInfo.getWfLevels() - wfInfo.getConcurrenceLevels());
        if (totalNode > this.MAXNODE) {
            message = EASResource.getString((String)this.RES, (String)"nodeExceedMax");
            variables = new Object[]{new Integer(totalNode), new Integer(this.MAXNODE)};
            MsgBox.showError((Component)((Object)this), (String)MessageFormat.format(message, variables));
            this.setCursorOfDefault();
            SysUtil.abort();
        }
        this.storeFields(wfInfo);
        return true;
    }

    public void storeFields(EvalWorkFlowInfo wInfo) {
        this.bindConcurrentArgsToData(wInfo, (IObjectCollection)wInfo.getConcurArgs());
    }

    private void bindConcurrentArgsToData(EvalWorkFlowInfo wInfo, IObjectCollection detailCollection) {
        if (detailCollection == null) {
            return;
        }
        detailCollection.clear();
        int n = wInfo.getConcurrenceLevels();
        for (int i = 0; i < n; ++i) {
            ConcurrenceArgsInfo info2 = new ConcurrenceArgsInfo();
            KDNumberTextField number = (KDNumberTextField)this.levelHash.get("" + i);
            info2.setConcurrenceLevel(Integer.parseInt(number.getText()));
            number = (KDNumberTextField)this.concurHash.get("" + i);
            info2.setCount(Integer.parseInt(number.getText()));
            detailCollection.addObject((IObjectValue)info2);
        }
    }

    private void showErrorMessage(String message) {
        String s = EASResource.getString((String)this.RES, (String)message);
        MsgBox.showError((Component)((Object)this), (String)s);
        this.setCursorOfDefault();
        SysUtil.abort();
    }
}

