/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.perf.CommentEnum;
import com.kingdee.eas.hr.perf.ConcurrenceArgsCollection;
import com.kingdee.eas.hr.perf.ConcurrenceArgsInfo;
import com.kingdee.eas.hr.perf.EvalWorkFlowInfo;
import com.kingdee.eas.hr.perf.EvaluNodeCollection;
import com.kingdee.eas.hr.perf.EvaluNodeInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.ParticipatorTypeEnum;
import com.kingdee.eas.hr.perf.client.AbstractWorkFlowDefineConfirmPropsUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.ViewEvaluObjectUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.log4j.Logger;

public class WorkFlowDefineConfirmPropsUI
extends AbstractWorkFlowDefineConfirmPropsUI {
    private static final Logger logger = CoreUIObject.getLogger(WorkFlowDefineConfirmPropsUI.class);
    private String RES = "com.kingdee.eas.hr.perf.client.WorkFlowDefineResource";
    private int isAllocate = -1;
    EvalWorkFlowInfo wInfo;
    Color redColor = new Color(0, 0, 0);
    Color blackColor = new Color(143, 11, 193);
    Color linkInitColor = Color.decode("#00479D");
    Color linkEnterColor = Color.decode("#E74B00");
    int strLen = 0;

    public WorkFlowDefineConfirmPropsUI() throws Exception {
        this.viewEvaluObjectLabelContainer.addMouseListener((MouseListener)new MyMouseListener());
        this.viewEvaluObjectLabelContainer.getBoundLabel().setForeground(this.linkInitColor);
        this.wfInfoTable.setEnabled(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public boolean verifyData(EvalWorkFlowInfo wInfo) throws Exception {
        return true;
    }

    public void initViewUI(EvalWorkFlowInfo wfInfo) {
        if (this.isAllocate == -1) {
            try {
                EvaluSolutionInfo info = EvaluSolutionFactory.getRemoteInstance().getEvaluSolutionInfo((IObjectPK)new ObjectUuidPK(wfInfo.getSolutionPeriod().getEvaluSolution().getId().toString()));
                this.isAllocate = info.getAllocateTarget();
            }
            catch (Exception ex) {
                super.handleException(ex);
            }
        }
        this.viewEvaluObjectLabelContainer.setVisible(this.isAllocate == 0);
        this.wInfo = wfInfo;
        this.kDLabelContainerwfLevel.setBoundLabelText(EASResource.getString((String)this.RES, (String)"wflevels") + wfInfo.getWfLevels());
        this.kDLabelContainerConcurrentLevel.setBoundLabelText(EASResource.getString((String)this.RES, (String)"concurrentLevels") + wfInfo.getConcurrenceLevels());
        this.wfInfoTable.checkParsed();
        this.wfInfoTable.removeRows();
        this.wfInfoTable.getColumn("wfLevels").setWidth(70);
        this.wfInfoTable.getColumn("weight").setWidth(50);
        if (this.isAllocate == 2) {
            this.wfInfoTable.getColumn("weight").getStyleAttributes().setHided(true);
        }
        this.wfInfoTable.getColumn("visibleWeight").setWidth(100);
        this.wfInfoTable.getColumn("canGrade").setWidth(60);
        this.wfInfoTable.getColumn("canComment").setWidth(60);
        this.wfInfoTable.getColumn("canEvaluLevel").setWidth(110);
        this.wfInfoTable.getColumn("participator").setWidth(170);
        boolean flag = false;
        int count = 0;
        boolean currentRowIndex = false;
        ConcurrenceArgsInfo conInfo = null;
        int n = wfInfo.getWfLevels();
        for (int i = 0; i < n; ++i) {
            StringBuffer strBuffer;
            EvaluNodeInfo nodeInfo;
            String temp;
            IRow row;
            ConcurrenceArgsCollection collection = wfInfo.getConcurArgs();
            flag = false;
            int m = collection.size();
            for (int j = 0; j < m; ++j) {
                conInfo = collection.get(j);
                if (conInfo.getConcurrenceLevel() != i + 1) continue;
                flag = true;
                break;
            }
            if (flag) {
                row = this.wfInfoTable.addRow();
                row.getCell("wfLevels").setValue((Object)new Integer(i + 1));
                temp = "" + PFVerifyUtils.formatBigDecimal(this.getLevelWeightCount(wfInfo, i + 1), 2) + "%";
                row.getCell("weight").setValue((Object)temp);
                row.getCell("weight").getStyleAttributes().setFontColor(this.redColor);
                int len = conInfo.getCount();
                for (int k = 0; k < len; ++k) {
                    nodeInfo = this.getNodeBySeqNumber(wfInfo, count + 1);
                    row = this.wfInfoTable.addRow();
                    strBuffer = new StringBuffer();
                    strBuffer.append("  ");
                    strBuffer.append(EASResource.getString((String)this.RES, (String)"binfaLabel"));
                    strBuffer.append(k + 1);
                    row.getCell("wfLevels").setValue((Object)strBuffer.toString());
                    temp = PFVerifyUtils.formatBigDecimal(nodeInfo.getWeight(), 2) + "%";
                    row.getCell("weight").setValue((Object)temp);
                    row.getCell("weight").getStyleAttributes().setFontColor(this.blackColor);
                    temp = nodeInfo.isWeightVisable() ? EASResource.getString((String)this.RES, (String)"true") : EASResource.getString((String)this.RES, (String)"false");
                    row.getCell("visibleWeight").setValue((Object)temp);
                    temp = nodeInfo.isCanGrade() ? EASResource.getString((String)this.RES, (String)"true") : EASResource.getString((String)this.RES, (String)"false");
                    row.getCell("canGrade").setValue((Object)temp);
                    boolean isCanComment = !CommentEnum.noComment.equals((Object)nodeInfo.getCanComment());
                    temp = isCanComment ? EASResource.getString((String)this.RES, (String)"true") : EASResource.getString((String)this.RES, (String)"false");
                    row.getCell("canComment").setValue((Object)temp);
                    temp = nodeInfo.isCanEvaluateLevel() ? EASResource.getString((String)this.RES, (String)"true") : EASResource.getString((String)this.RES, (String)"false");
                    row.getCell("canEvaluLevel").setValue((Object)temp);
                    strBuffer = new StringBuffer();
                    if (ParticipatorTypeEnum.ORGUNIT.equals((Object)nodeInfo.getParticipatorType())) {
                        this.strLen = nodeInfo.getNodeName().lastIndexOf("(");
                        strBuffer.append(nodeInfo.getNodeName().substring(0, this.strLen + 1));
                        strBuffer.append(nodeInfo.getParticipatorType().toString());
                        strBuffer.append("-");
                        strBuffer.append(nodeInfo.getNodeName().substring(this.strLen + 1));
                    } else {
                        strBuffer.append(nodeInfo.getNodeName());
                        strBuffer.append("(");
                        strBuffer.append(nodeInfo.getParticipatorType().toString());
                        if (ParticipatorTypeEnum.RELATION.equals((Object)nodeInfo.getParticipatorType())) {
                            if (nodeInfo.getRefNode() > 0) {
                                strBuffer.append(EASResource.getString((String)this.RES, (String)"relatedNodeLabel"));
                                strBuffer.append(nodeInfo.getRefNode());
                            }
                            if (nodeInfo.getRefNode() == -1) {
                                strBuffer.append(EASResource.getString((String)this.RES, (String)"relatedNodeForSelfLabel"));
                            }
                        }
                        strBuffer.append(")");
                    }
                    row.getCell("participator").setValue((Object)strBuffer.toString());
                    ++count;
                }
                continue;
            }
            nodeInfo = this.getNodeBySeqNumber(wfInfo, count + 1);
            row = this.wfInfoTable.addRow();
            row.getCell("wfLevels").setValue((Object)new Integer(nodeInfo.getNodeLevel()));
            temp = PFVerifyUtils.formatBigDecimal(nodeInfo.getWeight(), 2) + "%";
            row.getCell("weight").setValue((Object)temp);
            row.getCell("weight").getStyleAttributes().setFontColor(this.redColor);
            temp = nodeInfo.isWeightVisable() ? EASResource.getString((String)this.RES, (String)"true") : EASResource.getString((String)this.RES, (String)"false");
            row.getCell("visibleWeight").setValue((Object)temp);
            temp = nodeInfo.isCanGrade() ? EASResource.getString((String)this.RES, (String)"true") : EASResource.getString((String)this.RES, (String)"false");
            row.getCell("canGrade").setValue((Object)temp);
            boolean isCanComment = !CommentEnum.noComment.equals((Object)nodeInfo.getCanComment());
            temp = isCanComment ? EASResource.getString((String)this.RES, (String)"true") : EASResource.getString((String)this.RES, (String)"false");
            row.getCell("canComment").setValue((Object)temp);
            temp = nodeInfo.isCanEvaluateLevel() ? EASResource.getString((String)this.RES, (String)"true") : EASResource.getString((String)this.RES, (String)"false");
            row.getCell("canEvaluLevel").setValue((Object)temp);
            strBuffer = new StringBuffer();
            if (ParticipatorTypeEnum.ORGUNIT.equals((Object)nodeInfo.getParticipatorType())) {
                this.strLen = nodeInfo.getNodeName().lastIndexOf("(");
                strBuffer.append(nodeInfo.getNodeName().substring(0, this.strLen + 1));
                strBuffer.append(nodeInfo.getParticipatorType().toString());
                strBuffer.append("-");
                strBuffer.append(nodeInfo.getNodeName().substring(this.strLen + 1));
            } else {
                strBuffer.append(nodeInfo.getNodeName());
                strBuffer.append("(");
                strBuffer.append(nodeInfo.getParticipatorType().toString());
                if (ParticipatorTypeEnum.RELATION.equals((Object)nodeInfo.getParticipatorType())) {
                    if (nodeInfo.getRefNode() > 0) {
                        strBuffer.append(EASResource.getString((String)this.RES, (String)"relatedNodeLabel"));
                        strBuffer.append(nodeInfo.getRefNode());
                    }
                    if (nodeInfo.getRefNode() == -1) {
                        strBuffer.append(EASResource.getString((String)this.RES, (String)"relatedNodeForSelfLabel"));
                    }
                }
                strBuffer.append(")");
            }
            row.getCell("participator").setValue((Object)strBuffer.toString());
            ++count;
        }
        this.wfInfoTable.revalidate();
        this.kDContainer1.revalidate();
    }

    private EvaluNodeInfo getNodeBySeqNumber(EvalWorkFlowInfo wfInfo, int count) {
        EvaluNodeCollection collection = wfInfo.getEvaluNodes();
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            EvaluNodeInfo nodeInfo = collection.get(i);
            if (nodeInfo.getSeqNumber() != count) continue;
            return nodeInfo;
        }
        return null;
    }

    private BigDecimal getLevelWeightCount(EvalWorkFlowInfo wfInfo, int level) {
        BigDecimal amount = new BigDecimal("0.0");
        EvaluNodeCollection collection = wfInfo.getEvaluNodes();
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            EvaluNodeInfo nodeInfo = collection.get(i);
            if (nodeInfo.getNodeLevel() != level) continue;
            amount = amount.add(this.isAllocate == 2 && nodeInfo.getWeight() == null ? new BigDecimal("0.0") : nodeInfo.getWeight());
        }
        return amount;
    }

    class MyMouseListener
    extends MouseAdapter {
        @Override
        public void mouseEntered(MouseEvent e) {
            if (e.getComponent() instanceof KDLabelContainer) {
                ((KDLabelContainer)e.getComponent()).getBoundLabel().setForeground(WorkFlowDefineConfirmPropsUI.this.linkEnterColor);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (e.getComponent() instanceof KDLabelContainer) {
                ((KDLabelContainer)e.getComponent()).getBoundLabel().setForeground(WorkFlowDefineConfirmPropsUI.this.linkInitColor);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getComponent() instanceof KDLabelContainer) {
                try {
                    UIContext uiContext = new UIContext((Object)this);
                    uiContext.put((Object)"evalWorkFlowInfo", (Object)WorkFlowDefineConfirmPropsUI.this.wInfo);
                    IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                    IUIWindow window = uiFactory.create(ViewEvaluObjectUI.class.getName(), (Map)uiContext, null, null);
                    window.show();
                }
                catch (Exception e1) {
                    WorkFlowDefineConfirmPropsUI.this.handUIException(e1);
                }
            }
        }
    }
}

