/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectValueForEditUIUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.perf.AuditState2Enum;
import com.kingdee.eas.hr.perf.EvaluTargetInfo;
import com.kingdee.eas.hr.perf.ExecuteStatuEnum;
import com.kingdee.eas.hr.perf.IPlanFreqType;
import com.kingdee.eas.hr.perf.IPlanItemCategory;
import com.kingdee.eas.hr.perf.IWorkItem;
import com.kingdee.eas.hr.perf.IWorkPlan;
import com.kingdee.eas.hr.perf.PlanFreqTypeCollection;
import com.kingdee.eas.hr.perf.PlanFreqTypeEnum;
import com.kingdee.eas.hr.perf.PlanFreqTypeException;
import com.kingdee.eas.hr.perf.PlanFreqTypeFactory;
import com.kingdee.eas.hr.perf.PlanFreqTypeInfo;
import com.kingdee.eas.hr.perf.PlanItemCategoryCollection;
import com.kingdee.eas.hr.perf.PlanItemCategoryFactory;
import com.kingdee.eas.hr.perf.PlanItemCategoryInfo;
import com.kingdee.eas.hr.perf.WorkItemCollection;
import com.kingdee.eas.hr.perf.WorkItemFactory;
import com.kingdee.eas.hr.perf.WorkItemInfo;
import com.kingdee.eas.hr.perf.WorkPlanCollection;
import com.kingdee.eas.hr.perf.WorkPlanFactory;
import com.kingdee.eas.hr.perf.WorkPlanInfo;
import com.kingdee.eas.hr.perf.client.AbstractWorkPlanEditUI;
import com.kingdee.eas.hr.perf.client.EvaluTargetListUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.perf.client.PlanSendMailListUI;
import com.kingdee.eas.hr.perf.client.PlanWriteListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class WorkPlanEditUI
extends AbstractWorkPlanEditUI {
    private static final long serialVersionUID = -61166L;
    private String resClass = "com.kingdee.eas.hr.perf.client.PlanFreqTypeResource.";
    private String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private String lab_head_1 = EASResource.getString((String)(this.resClass + "LAB_HEAD_1"));
    private String lab_head_2 = EASResource.getString((String)(this.resClass + "LAB_HEAD_2"));
    private String lab_head_3 = EASResource.getString((String)(this.resClass + "LAB_HEAD_3"));
    private PersonInfo curPerson = null;
    private List empLists = null;
    private IWorkPlan iWorkPlan = null;
    boolean isLoad = true;
    private Date startDate = null;
    private Date endDate = null;
    private WorkPlanInfo workPlanInfo = null;
    private WorkPlanInfo oldWorkPlanInfo = null;
    private boolean loadFinish = false;
    private Calendar now = Calendar.getInstance();
    private PlanFreqTypeInfo currType = null;
    private String attachMentTempID = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.dealPlanFreqType();
        PerfClientUtils.checkValidPerson(this);
        PerfClientUtils.checkValidHRO(this);
        this.tblMain.setColumnMoveable(true);
        this.setCurrPerson();
        this.initUI();
        this.cboEmpName.setSelectedItem((Object)this.curPerson);
        this.loadData();
        this.loadFinish = true;
        this.setViewStatus();
    }

    private void initUI() throws Exception {
        this.initPlanFreq();
        this.initEmpList();
        this.initTable();
        Font font = new Font(this.labHead.getFont().getName(), this.labHead.getFont().getStyle(), this.labHead.getFont().getSize() + 9);
        this.labHead.setFont(font);
    }

    private void initPlanFreq() throws Exception {
        int i;
        IPlanFreqType iPFT = PlanFreqTypeFactory.getRemoteInstance();
        PlanFreqTypeCollection pftColl = iPFT.getEnableList();
        if (pftColl == null || pftColl.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PlanFreqTypeResource.freqTypeFirst"));
            SysUtil.abort();
        }
        PlanFreqTypeInfo pftInfo = null;
        int size = pftColl.size();
        for (i = 0; i < size; ++i) {
            pftInfo = pftColl.get(i);
            this.cboPlanFreq.addItem((Object)pftInfo);
            if (!pftInfo.isIsDefault()) continue;
            this.cboPlanFreq.setSelectedIndex(i);
        }
        if (this.currType != null) {
            size = this.cboPlanFreq.getItemCount();
            for (i = 0; i < size; ++i) {
                pftInfo = (PlanFreqTypeInfo)this.cboPlanFreq.getItemAt(i);
                if (!pftInfo.getId().equals((Object)this.currType.getId())) continue;
                this.cboPlanFreq.setSelectedIndex(i);
            }
        }
        if (pftColl.size() == 0) {
            this.btnPrePeriod.setEnabled(false);
            this.btnNextPeriod.setEnabled(false);
            this.btnSendMail.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            this.menuItemPrePeriod.setEnabled(false);
            this.menuItemNextPeriod.setEnabled(false);
            this.menuItemSendMail.setEnabled(false);
            this.menuItemSubmit.setEnabled(false);
        }
    }

    private void initEmpList() throws Exception {
        if (this.curPerson == null) {
            return;
        }
        this.cboEmpName.addItem((Object)this.curPerson);
        this.iWorkPlan = WorkPlanFactory.getRemoteInstance();
        this.empLists = this.iWorkPlan.getEmpList(this.curPerson.getId().toString());
        boolean flag = true;
        PersonInfo p1 = null;
        PersonInfo p2 = null;
        int size = this.empLists.size();
        for (int i = 0; i < size; ++i) {
            flag = true;
            int length = this.cboEmpName.getItemCount();
            for (int j = 0; j < length; ++j) {
                p1 = (PersonInfo)this.cboEmpName.getItemAt(j);
                p2 = (PersonInfo)this.empLists.get(i);
                if (!p1.getId().toString().equals(p2.getId().toString())) continue;
                flag = false;
            }
            if (!flag) continue;
            this.cboEmpName.addItem(this.empLists.get(i));
        }
        Map map = this.iWorkPlan.getEmpPositionInfo(this.curPerson.getId().toString());
        if (map == null) {
            throw new PlanFreqTypeException(PlanFreqTypeException.WORKPLAN_PERSON_NO_POSITION);
        }
        if (map.get("Position") != null) {
            this.txtPosition.setText(map.get("Position").toString());
        }
        if (map.get("SuperPosition") != null) {
            this.txtSuperPosition.setText(map.get("SuperPosition").toString());
        }
        if (map.get("SuperNames") != null) {
            String superNames = map.get("SuperNames").toString();
            superNames = superNames.replaceAll("!#!", "");
            this.txtSuperName.setText(superNames);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnInsert.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDel.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSendMail.setIcon(EASResource.getIcon((String)"imgTbtn_sendmessage"));
        this.menuItemSendMail.setIcon(EASResource.getIcon((String)"imgTbtn_sendmessage"));
        this.btnViewPerf.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.menuItemViewPerf.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.btnPrePeriod.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.menuItemPrePeriod.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.btnNextPeriod.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.menuItemNextPeriod.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.btnPlanWritePerson.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.menuItemPlanWritePerson.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.kdcWorkItem.addButton((JButton)this.btnInsert);
        this.kdcWorkItem.addButton((JButton)this.btnDel);
        this.btnImportPrePlan.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.menuItemImportPrePlan.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.setButtonDefaultStyl(this.btnSubmit);
        boolean flag = false;
        if (this.getUIContext().get("isFromWorkbench") != null) {
            flag = true;
        }
        this.actionAudit.setVisible(flag);
        this.actionUnAudit.setVisible(flag);
    }

    private String getFixedDataStr(PlanFreqTypeInfo prtInfo) {
        int day = this.now.get(5);
        int month = this.now.get(2);
        Calendar end = (Calendar)this.now.clone();
        if (prtInfo.getType() == PlanFreqTypeEnum.WEEK) {
            this.now.set(7, 2);
            end = (Calendar)this.now.clone();
            end.add(6, 6);
        } else if (prtInfo.getType() == PlanFreqTypeEnum.TENDAYS) {
            if (day < 11) {
                this.now.set(5, 1);
                end = (Calendar)this.now.clone();
                end.add(6, 9);
            } else if (day >= 11 && day < 21) {
                this.now.set(5, 11);
                end = (Calendar)this.now.clone();
                end.add(6, 9);
            } else {
                this.now.set(5, 21);
                end = (Calendar)this.now.clone();
                end.add(2, 1);
                end.set(5, 1);
                end.add(6, -1);
            }
        } else if (prtInfo.getType() == PlanFreqTypeEnum.MONTH) {
            this.now.set(5, 1);
            end = (Calendar)this.now.clone();
            end.add(2, 1);
            end.add(6, -1);
        } else if (prtInfo.getType() == PlanFreqTypeEnum.QUARTER) {
            this.now.set(5, 1);
            end = (Calendar)this.now.clone();
            if (month < 3) {
                this.now.set(2, 0);
                end.set(2, 3);
                end.add(6, -1);
            } else if (month >= 3 && month < 6) {
                this.now.set(2, 3);
                end.set(2, 6);
                end.add(6, -1);
            } else if (month >= 6 && month < 9) {
                this.now.set(2, 6);
                end.set(2, 9);
                end.add(6, -1);
            } else if (month >= 9 && month < 12) {
                this.now.set(2, 9);
                end.add(1, 1);
                end.set(2, 0);
                end.set(5, 1);
                end.add(6, -1);
            }
        } else if (prtInfo.getType() == PlanFreqTypeEnum.HALFYEAR) {
            this.now.set(5, 1);
            end = (Calendar)this.now.clone();
            if (month < 6) {
                this.now.set(2, 0);
                end.set(2, 6);
                end.add(6, -1);
            } else {
                this.now.set(2, 6);
                end.add(1, 1);
                end.set(2, 0);
                end.add(6, -1);
            }
        } else if (prtInfo.getType() == PlanFreqTypeEnum.YEAR) {
            this.now.set(5, 1);
            this.now.set(2, 0);
            end = (Calendar)this.now.clone();
            end.add(1, 1);
            end.set(2, 0);
            end.add(6, -1);
        }
        this.startDate = this.now.getTime();
        this.endDate = end.getTime();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        return sf.format(this.startDate);
    }

    private void fillTable() {
        WorkItemCollection wiColl = this.workPlanInfo.getWorkItem();
        IRow row = null;
        WorkItemInfo workItemInfo = null;
        ArrayList array = this.getSortedWorkItemColl(wiColl);
        this.tblMain.removeRows();
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            workItemInfo = (WorkItemInfo)array.get(i);
            row = this.tblMain.addRow();
            row.setHeight(50);
            row.setUserObject((Object)workItemInfo);
            row.getCell("id").setValue((Object)workItemInfo.getId());
            row.getCell("number").setValue((Object)workItemInfo.getNumber());
            row.getCell("planItem").setValue((Object)workItemInfo.getPlanItem());
            row.getCell("category").setValue((Object)workItemInfo.getPlanItemCategory());
            row.getCell("requirement").setValue((Object)workItemInfo.getRequirement());
            row.getCell("excutor").setValue((Object)workItemInfo.getExecutor());
            row.getCell("accomplishResult").setValue((Object)workItemInfo.getAccomplishResult());
            row.getCell("statue").setValue((Object)workItemInfo.getStatue());
            if (workItemInfo.getGuage() != null) {
                row.getCell("guage").setValue((Object)workItemInfo.getGuage().multiply(new BigDecimal("100.00")));
            }
            row.getCell("problem").setValue((Object)workItemInfo.getProblem());
            row.getCell("advice").setValue((Object)workItemInfo.getAdvice());
            row.getCell("planStartDate").setValue((Object)workItemInfo.getPlanStartDate());
            row.getCell("planEndDate").setValue((Object)workItemInfo.getPlanEndDate());
            row.getCell("exeStartDate").setValue((Object)workItemInfo.getExeStartDate());
            row.getCell("exeEndDate").setValue((Object)workItemInfo.getExeEndDate());
            row.getCell("planTimeCost").setValue((Object)workItemInfo.getPlanTimeCost());
            row.getCell("exeTimeCost").setValue((Object)workItemInfo.getExeTimeCost());
            row.getCell("selfLastUpdateTime").setValue((Object)workItemInfo.getSelfLastUpdateTime());
            row.getCell("superLastUpdateTime").setValue((Object)workItemInfo.getSuperLastUpdateTime());
            row.getCell("founder").setValue((Object)workItemInfo.getFounder());
            if (workItemInfo.getAuditState() != null) {
                row.getCell("auditState").setValue((Object)workItemInfo.getAuditState());
                if (AuditState2Enum.AUDITED.equals((Object)workItemInfo.getAuditState())) {
                    row.getStyleAttributes().setLocked(true);
                    row.getCell("accomplishResult").getStyleAttributes().setLocked(false);
                    row.getCell("statue").getStyleAttributes().setLocked(false);
                    row.getCell("guage").getStyleAttributes().setLocked(false);
                    row.getCell("problem").getStyleAttributes().setLocked(false);
                    row.getCell("exeStartDate").getStyleAttributes().setLocked(false);
                    row.getCell("exeEndDate").getStyleAttributes().setLocked(false);
                    row.getCell("exeTimeCost").getStyleAttributes().setLocked(false);
                }
            } else {
                row.getCell("auditState").setValue((Object)AuditState2Enum.UNAUDIT);
            }
            row.getCell("auditor").setValue((Object)workItemInfo.getAuditor());
            if (workItemInfo.getEvaluTarget() == null) continue;
            row.getCell("goalNumber").setValue((Object)workItemInfo.getEvaluTarget().getNumber());
            row.getCell("goalContent").setValue((Object)workItemInfo.getEvaluTarget().getContent());
            row.getCell("evaluTargetId").setValue((Object)workItemInfo.getEvaluTarget());
        }
        this.tblMain.getColumn("goalNumber").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("goalContent").getStyleAttributes().setLocked(true);
    }

    private ArrayList getSortedWorkItemColl(WorkItemCollection coll) {
        int i;
        ArrayList ret = new ArrayList();
        WorkItemCollection numberSet = new WorkItemCollection();
        ArrayList<WorkItemInfo> nullNumberSet = new ArrayList<WorkItemInfo>();
        int n = coll.size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (coll.get(i2).getNumber() == null) {
                nullNumberSet.add(coll.get(i2));
                continue;
            }
            numberSet.add(coll.get(i2));
        }
        Object[] numbers = new String[numberSet.size()];
        int n2 = numberSet.size();
        for (i = 0; i < n2; ++i) {
            numbers[i] = numberSet.get(i).getNumber();
        }
        Arrays.sort(numbers);
        ret.addAll(nullNumberSet);
        for (i = 0; i < numbers.length; ++i) {
            int n3 = numberSet.size();
            for (int j = 0; j < n3; ++j) {
                if (!numberSet.get(j).getNumber().equals(numbers[i]) || ret.contains(numberSet.get(j))) continue;
                ret.add(numberSet.get(j));
            }
        }
        return ret;
    }

    public boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        if (!b) {
            return b;
        }
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                try {
                    this.actionSubmit.setDaemonRun(false);
                    ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                    this.actionSubmit.actionPerformed(event);
                    if (this.attachMentTempID != null) {
                        this.updateBoAttchAsso();
                    }
                    return !this.actionSubmit.isInvokeFailed();
                }
                catch (Exception exc) {
                    return false;
                }
            }
            if (result == 1) {
                this.deleteBoAttchAsso();
                return true;
            }
            return false;
        }
        this.deleteBoAttchAsso();
        return true;
    }

    public boolean isModify() {
        try {
            ControlUtilities.checkFocusAndCommit();
            this.storeData();
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        if (this.oldWorkPlanInfo == null) {
            return false;
        }
        return !ObjectValueForEditUIUtil.objectValueEquals((AbstractObjectValue)this.workPlanInfo, (AbstractObjectValue)this.oldWorkPlanInfo);
    }

    private void updateControlState() {
        int i;
        this.tblMain.getStyleAttributes().setLocked(false);
        this.txtPlanDesc.setEnabled(true);
        this.txtTarget.setEnabled(true);
        this.txtSelfComplete.setEnabled(true);
        this.btnInsert.setEnabled(true);
        this.btnDel.setEnabled(true);
        PlanFreqTypeInfo prtInfo = (PlanFreqTypeInfo)this.cboPlanFreq.getSelectedItem();
        int days = prtInfo.getDays();
        Calendar cal = Calendar.getInstance();
        Calendar nowCal = Calendar.getInstance();
        cal.setTime(this.endDate);
        cal.add(6, days);
        if (DateTimeUtils.dayBefore((Date)cal.getTime(), (Date)nowCal.getTime())) {
            this.tblMain.getStyleAttributes().setLocked(true);
            this.btnDel.setEnabled(false);
            this.btnInsert.setEnabled(false);
            this.actionImportPrePlan.setEnabled(false);
            this.txtPlanDesc.setEnabled(false);
            this.txtTarget.setEnabled(false);
            this.txtSelfComplete.setEnabled(false);
            this.txtSuperAdvice.setEnabled(false);
            this.actionSubmit.setEnabled(false);
        } else {
            this.tblMain.getStyleAttributes().setLocked(false);
            this.btnDel.setEnabled(true);
            this.btnInsert.setEnabled(true);
            this.actionImportPrePlan.setEnabled(true);
            this.txtPlanDesc.setEnabled(true);
            this.txtTarget.setEnabled(true);
            this.txtSelfComplete.setEnabled(true);
            this.txtSuperAdvice.setEnabled(true);
            this.actionSubmit.setEnabled(true);
        }
        if (((PersonInfo)this.cboEmpName.getSelectedItem()).equals((Object)this.curPerson)) {
            this.txtSuperAdvice.setEditable(false);
            this.tblMain.getColumn("advice").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("advice").getStyleAttributes().setBackground(new Color(0xD9D9D2));
        } else {
            this.txtSuperAdvice.setEditable(true);
            this.tblMain.getColumn("advice").getStyleAttributes().setLocked(false);
            this.tblMain.getColumn("advice").getStyleAttributes().setBackground(Color.WHITE);
        }
        this.setViewStatus();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        this.labHead.setText(this.curPerson.getName() + this.lab_head_1 + sf.format(this.startDate) + this.lab_head_2 + sf.format(this.endDate) + this.lab_head_3);
        EventListener[] listener = this.pkStartDate.getEditor().getListeners(DataChangeListener.class);
        for (i = 0; i < listener.length; ++i) {
            if (!(listener[i] instanceof DataChangeListener)) continue;
            this.pkStartDate.removeDataChangeListener((DataChangeListener)listener[i]);
        }
        this.pkStartDate.setValue((Object)this.startDate);
        for (i = 0; i < listener.length; ++i) {
            if (!(listener[i] instanceof DataChangeListener)) continue;
            this.pkStartDate.addDataChangeListener((DataChangeListener)listener[i]);
        }
    }

    private void loadData() throws Exception {
        PlanFreqTypeInfo prtInfo;
        PersonInfo pInfo = (PersonInfo)this.cboEmpName.getSelectedItem();
        Map map = this.iWorkPlan.getEmpPositionInfo(pInfo.getId().toString());
        if (map == null) {
            throw new PlanFreqTypeException(PlanFreqTypeException.WORKPLAN_PERSON_NO_POSITION);
        }
        if (map.get("Position") != null) {
            this.txtPosition.setText(map.get("Position").toString());
        }
        if (map.get("SuperPosition") != null) {
            this.txtSuperPosition.setText(map.get("SuperPosition").toString());
        }
        if (map.get("SuperNames") != null) {
            String superNames = map.get("SuperNames").toString();
            superNames = superNames.replaceAll("!#!", "");
            this.txtSuperName.setText(superNames);
        }
        if ((prtInfo = (PlanFreqTypeInfo)this.cboPlanFreq.getSelectedItem()) == null) {
            return;
        }
        String dateStr = this.getFixedDataStr(prtInfo);
        if (!this.isLoad) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)pInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("planFreqType", (Object)prtInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("startDate", (Object)dateStr));
        if (!PFUtils.getParamValue()) {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        }
        viewInfo.put("selector", (Object)this.getSelectors());
        this.updateControlState();
        WorkPlanCollection coll = WorkPlanFactory.getRemoteInstance().getWorkPlanCollection(viewInfo);
        if (coll.size() != 0) {
            this.workPlanInfo = coll.get(0);
            this.oldWorkPlanInfo = (WorkPlanInfo)this.workPlanInfo.clone();
        } else {
            this.workPlanInfo = new WorkPlanInfo();
            this.workPlanInfo.setPerson((PersonInfo)this.cboEmpName.getSelectedItem());
            this.workPlanInfo.setPlanFreqType((PlanFreqTypeInfo)this.cboPlanFreq.getSelectedItem());
            if (this.startDate != null) {
                this.workPlanInfo.setStartDate(DateTimeUtils.truncateDate((Date)this.startDate));
            }
            if (this.endDate != null) {
                this.workPlanInfo.setEndDate(DateTimeUtils.truncateDate((Date)this.endDate));
            }
            this.oldWorkPlanInfo = (WorkPlanInfo)this.workPlanInfo.clone();
        }
        if (this.workPlanInfo == null) {
            this.tblMain.removeRows();
            this.txtPlanDesc.setText(null);
            this.txtSelfComplete.setText(null);
            this.txtSuperAdvice.setText(null);
            this.txtTarget.setText(null);
        } else {
            this.txtPlanDesc.setText(this.workPlanInfo.getDescription());
            this.txtSelfComplete.setText(this.workPlanInfo.getAccomplishResult());
            this.txtSuperAdvice.setText(this.workPlanInfo.getAdvice());
            this.txtTarget.setText(this.workPlanInfo.getTarget());
            this.fillTable();
        }
    }

    private void dealPlanFreqType() throws Exception {
        WorkPlanFactory.getRemoteInstance().dealPlanFreqType();
    }

    private void storeData() throws Exception {
        ControlUtilities.checkFocusAndCommit();
        if (this.workPlanInfo == null) {
            this.workPlanInfo = new WorkPlanInfo();
        }
        this.workPlanInfo.setPerson((PersonInfo)this.cboEmpName.getSelectedItem());
        this.workPlanInfo.setPlanFreqType((PlanFreqTypeInfo)this.cboPlanFreq.getSelectedItem());
        this.workPlanInfo.setDescription(this.txtPlanDesc.getText());
        this.workPlanInfo.setAccomplishResult(this.txtSelfComplete.getText());
        this.workPlanInfo.setAdvice(this.txtSuperAdvice.getText());
        this.workPlanInfo.setTarget(this.txtTarget.getText());
        this.workPlanInfo.setStartDate(DateTimeUtils.truncateDate((Date)this.startDate));
        this.workPlanInfo.setEndDate(DateTimeUtils.truncateDate((Date)this.endDate));
        WorkItemInfo wiInfo = null;
        IRow row = null;
        boolean isAddNew = false;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getUserObject() == null) {
                isAddNew = true;
                wiInfo = new WorkItemInfo();
                row.setUserObject((Object)wiInfo);
            } else {
                wiInfo = (WorkItemInfo)row.getUserObject();
                isAddNew = false;
            }
            wiInfo.setNumber((String)row.getCell("number").getValue());
            wiInfo.setPlanItem((String)row.getCell("planItem").getValue());
            wiInfo.setPlanItemCategory((PlanItemCategoryInfo)row.getCell("category").getValue());
            wiInfo.setRequirement((String)row.getCell("requirement").getValue());
            wiInfo.setExecutor((PersonInfo)row.getCell("excutor").getValue());
            wiInfo.setAccomplishResult((String)row.getCell("accomplishResult").getValue());
            if (row.getCell("statue").getValue() != null) {
                wiInfo.setStatue((ExecuteStatuEnum)((Object)row.getCell("statue").getValue()));
            } else {
                wiInfo.setStatue(ExecuteStatuEnum.PLANED);
            }
            if (row.getCell("guage").getValue() != null) {
                wiInfo.setGuage(((BigDecimal)row.getCell("guage").getValue()).multiply(new BigDecimal("0.01")));
            } else {
                wiInfo.setGuage(null);
            }
            wiInfo.setProblem((String)row.getCell("problem").getValue());
            wiInfo.setAdvice((String)row.getCell("advice").getValue());
            wiInfo.setPlanStartDate((Date)row.getCell("planStartDate").getValue());
            wiInfo.setPlanEndDate((Date)row.getCell("planEndDate").getValue());
            wiInfo.setExeStartDate((Date)row.getCell("exeStartDate").getValue());
            wiInfo.setExeEndDate((Date)row.getCell("exeEndDate").getValue());
            if (row.getCell("planTimeCost").getValue() != null) {
                wiInfo.setPlanTimeCost(new BigDecimal(row.getCell("planTimeCost").getValue().toString()));
            }
            if (row.getCell("exeTimeCost").getValue() != null) {
                wiInfo.setExeTimeCost(new BigDecimal(row.getCell("exeTimeCost").getValue().toString()));
            }
            wiInfo.setFounder((PersonInfo)row.getCell("founder").getValue());
            wiInfo.setAuditor((PersonInfo)row.getCell("auditor").getValue());
            wiInfo.setAuditState((AuditState2Enum)((Object)row.getCell("auditState").getValue()));
            wiInfo.setEvaluTarget((EvaluTargetInfo)row.getCell("evaluTargetId").getValue());
            if (!isAddNew) continue;
            this.workPlanInfo.getWorkItem().add(wiInfo);
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("planFreqType.id"));
        sic.add(new SelectorItemInfo("workItem.*"));
        sic.add(new SelectorItemInfo("workItem.planItemCategory.*"));
        sic.add(new SelectorItemInfo("workItem.executor.id"));
        sic.add(new SelectorItemInfo("workItem.executor.name"));
        sic.add(new SelectorItemInfo("workItem.monitor.id"));
        sic.add(new SelectorItemInfo("workItem.monitor.name"));
        sic.add(new SelectorItemInfo("workItem.founder.id"));
        sic.add(new SelectorItemInfo("workItem.founder.name"));
        sic.add(new SelectorItemInfo("workItem.auditor.id"));
        sic.add(new SelectorItemInfo("workItem.auditor.name"));
        sic.add(new SelectorItemInfo("workItem.evaluTarget.id"));
        sic.add(new SelectorItemInfo("workItem.evaluTarget.number"));
        sic.add(new SelectorItemInfo("workItem.evaluTarget.content"));
        return sic;
    }

    private void setViewStatus() {
        if (this.getOprtState() == OprtState.VIEW) {
            this.tblMain.getStyleAttributes().setLocked(true);
            this.btnDel.setEnabled(false);
            this.btnInsert.setEnabled(false);
            this.txtPlanDesc.setEnabled(false);
            this.txtTarget.setEnabled(false);
            this.txtSelfComplete.setEnabled(false);
            this.txtSuperAdvice.setEnabled(false);
            this.cboEmpName.setEnabled(false);
            this.btnSendMail.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            this.btnPlanWritePerson.setEnabled(false);
            this.btnImportPrePlan.setEnabled(false);
            this.menuItemImportPrePlan.setEnabled(false);
            this.actionSendMail.setVisible(false);
            this.actionSubmit.setVisible(false);
            this.actionPlanWritePerson.setVisible(false);
            this.actionImportPrePlan.setVisible(false);
            this.btnCacleAssociation.setVisible(false);
        }
    }

    private void initTable() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setWrapText(true);
        KDComboBox kdcStatue = new KDComboBox();
        Iterator iter = ExecuteStatuEnum.iterator();
        while (iter.hasNext()) {
            kdcStatue.addItem(iter.next());
        }
        this.tblMain.getColumn("statue").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)kdcStatue));
        KDComboBox kdcCategory = new KDComboBox();
        IPlanItemCategory iCat = PlanItemCategoryFactory.getRemoteInstance();
        PlanItemCategoryCollection pCall = iCat.getPlanItemCategoryCollection("where hrOrgUnit='" + SysContext.getSysContext().getCurrentHRUnit().getId() + "'");
        int size = pCall.size();
        for (int i = 0; i < size; ++i) {
            kdcCategory.addItem((Object)pCall.get(i));
        }
        this.tblMain.getColumn("category").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)kdcCategory));
        this.tblMain.getColumn("planStartDate").setEditor(EmployeeClientUtils.getDateCellEditor());
        this.tblMain.getColumn("planStartDate").getStyleAttributes().setNumberFormat(EmployeeClientUtils.getDateFormatStr());
        this.tblMain.getColumn("planEndDate").setEditor(EmployeeClientUtils.getDateCellEditor());
        this.tblMain.getColumn("planEndDate").getStyleAttributes().setNumberFormat(EmployeeClientUtils.getDateFormatStr());
        this.tblMain.getColumn("exeStartDate").setEditor(EmployeeClientUtils.getDateCellEditor());
        this.tblMain.getColumn("exeStartDate").getStyleAttributes().setNumberFormat(EmployeeClientUtils.getDateFormatStr());
        this.tblMain.getColumn("exeEndDate").setEditor(EmployeeClientUtils.getDateCellEditor());
        this.tblMain.getColumn("exeEndDate").getStyleAttributes().setNumberFormat(EmployeeClientUtils.getDateFormatStr());
        this.tblMain.getColumn("selfLastUpdateTime").getStyleAttributes().setBackground(new Color(0xD9D9D2));
        this.tblMain.getColumn("selfLastUpdateTime").getStyleAttributes().setNumberFormat("yyyy-MM-dd hh:mm:ss");
        this.tblMain.getColumn("superLastUpdateTime").getStyleAttributes().setBackground(new Color(0xD9D9D2));
        this.tblMain.getColumn("superLastUpdateTime").getStyleAttributes().setNumberFormat("yyyy-MM-dd hh:mm:ss");
        KDFormattedTextField kft = new KDFormattedTextField();
        kft.setDataType(1);
        kft.setDataVerifierType(12);
        kft.setSupportedEmpty(true);
        kft.setMaximumValue((Comparable)new BigDecimal("100.00"));
        kft.setMinimumValue((Comparable)new BigDecimal("0.00"));
        kft.setPrecision(2);
        this.tblMain.getColumn("guage").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)kft));
        this.tblMain.getColumn("guage").getStyleAttributes().setNumberFormat("0.00");
        KDFormattedTextField kft2 = new KDFormattedTextField();
        kft2.setDataVerifierType(12);
        kft2.setSupportedEmpty(true);
        kft2.setDataType(1);
        kft2.setMaximumValue((Comparable)new BigDecimal("9999"));
        kft2.setMinimumValue((Comparable)new BigDecimal("0"));
        kft2.setPrecision(3);
        this.tblMain.getColumn("planTimeCost").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)kft2));
        this.tblMain.getColumn("planTimeCost").getStyleAttributes().setNumberFormat("%r{#.###}d");
        this.tblMain.getColumn("exeTimeCost").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)kft2));
        this.tblMain.getColumn("exeTimeCost").getStyleAttributes().setNumberFormat("%r{#.###}d");
        KDComboBox kdcExecutor = new KDComboBox();
        KDComboBox kdcMonitor = new KDComboBox();
        if (this.empLists != null) {
            int size2 = this.empLists.size();
            for (int i = 0; i < size2; ++i) {
                kdcExecutor.addItem(this.empLists.get(i));
                kdcMonitor.addItem(this.empLists.get(i));
            }
        }
        kdcExecutor.addItem((Object)this.curPerson);
        kdcMonitor.addItem((Object)this.curPerson);
        this.tblMain.getColumn("excutor").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)kdcExecutor));
        this.tblMain.getColumn("monitor").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("founder").getStyleAttributes().setBackground(new Color(0xD9D9D2));
        this.tblMain.getColumn("founder").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("selfLastUpdateTime").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("superLastUpdateTime").getStyleAttributes().setLocked(true);
        this.tblMain.getViewManager().setFreezeView(0, 5);
        KDTextField txtFEditor = new KDTextField();
        txtFEditor.setMaxLength(80);
        this.tblMain.getColumn("number").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtFEditor));
        this.tblMain.getColumn("goalNumber").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtFEditor));
        KDTextArea txtAEditor = new KDTextArea();
        txtAEditor.setMaxLength(255);
        this.tblMain.getColumn("planItem").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextArea)txtAEditor));
        txtAEditor = new KDTextArea();
        txtAEditor.setMaxLength(500);
        this.tblMain.getColumn("requirement").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextArea)txtAEditor));
        this.tblMain.getColumn("accomplishResult").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextArea)txtAEditor));
        this.tblMain.getColumn("problem").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextArea)txtAEditor));
        this.tblMain.getColumn("advice").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextArea)txtAEditor));
        KDTextArea txtCEditor = new KDTextArea();
        txtCEditor.setMaxLength(2000);
        this.tblMain.getColumn("goalContent").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextArea)txtCEditor));
        this.tblMain.getColumn("goalContent").getStyleAttributes().setWrapText(true);
        this.tblMain.getColumn("number").getStyleAttributes().setBackground(Color.WHITE);
        this.tblMain.getColumn("requirement").getStyleAttributes().setBackground(Color.WHITE);
        this.tblMain.getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
    }

    private void setCurrPerson() throws Exception {
        Map map = this.getUIContext();
        if (map.get("person") != null) {
            this.curPerson = (PersonInfo)map.get("person");
            return;
        }
        String pId = (String)map.get("ID");
        if (pId != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("startDate"));
            sic.add(new SelectorItemInfo("planFreqType.id"));
            sic.add(new SelectorItemInfo("planFreqType.type"));
            sic.add(new SelectorItemInfo("person.*"));
            WorkPlanInfo workPlan = WorkPlanFactory.getRemoteInstance().getWorkPlanInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)pId)), sic);
            this.curPerson = workPlan.getPerson();
            this.currType = workPlan.getPlanFreqType();
            this.now.setTime(workPlan.getStartDate());
        } else {
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            this.curPerson = userInfo.getPerson();
        }
    }

    @Override
    protected void btnDel_actionPerformed(ActionEvent e) throws Exception {
        int[] rowID = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        int result = -1;
        for (int i = rowID.length - 1; i >= 0; --i) {
            row = this.tblMain.getRow(rowID[i]);
            if (!AuditState2Enum.AUDITED.equals(row.getCell("auditState").getValue())) {
                if (!(this.curPerson.getId().toString().equals(((PersonInfo)row.getCell("founder").getValue()).getId().toString()) || (result = MsgBox.showConfirm2((String)EASResource.getString((String)this.RES, (String)"planIsNotCreatedBySelf"))) != 2 && result != 1)) {
                    return;
                }
                if (row.getUserObject() != null) {
                    this.workPlanInfo.getWorkItem().remove((WorkItemInfo)row.getUserObject());
                }
                this.tblMain.removeRow(rowID[i]);
                continue;
            }
            MsgBox.showInfo((String)EASResource.getString((String)this.RES, (String)"auditedWorkItemCanNotModifyOrDelete"));
        }
    }

    @Override
    protected void btnInsert_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.tblMain.addRow();
        row.setHeight(50);
        row.getCell("founder").setValue((Object)this.curPerson);
        row.getCell("excutor").setValue((Object)this.curPerson);
        row.getCell("statue").setValue((Object)ExecuteStatuEnum.PLANED);
        row.getCell("auditState").setValue((Object)AuditState2Enum.UNAUDIT);
    }

    private void checkValid() throws Exception {
        if (this.cboPlanFreq.getSelectedItem() == null) {
            throw new PlanFreqTypeException(PlanFreqTypeException.NOT_SELECT_PLANFREQTYPE);
        }
        IRow row = null;
        Date sDate = null;
        Date eDate = null;
        Object[] param = null;
        HashSet<String> set = new HashSet<String>();
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("number").getValue() != null) {
                if (set.contains(((String)row.getCell("number").getValue()).trim())) {
                    this.tblMain.getEditManager().editCellAt(row.getRowIndex(), row.getCell("number").getColumnIndex());
                    throw new PlanFreqTypeException(PlanFreqTypeException.WORKITEM_DUPNUM);
                }
                set.add(((String)row.getCell("number").getValue()).trim());
            }
            if (row.getCell("planItem").getValue() == null) {
                throw new PlanFreqTypeException(PlanFreqTypeException.NOT_INPUT_PLANITEM);
            }
            if (row.getCell("excutor").getValue() == null) {
                throw new PlanFreqTypeException(PlanFreqTypeException.NOT_INPUT_PLANITEM_EXE);
            }
            param = new Object[]{Integer.toString(i + 1)};
            sDate = (Date)row.getCell("planStartDate").getValue();
            eDate = (Date)row.getCell("planEndDate").getValue();
            if (sDate != null && eDate != null && DateTimeUtils.dayAfter((Date)sDate, (Date)eDate)) {
                throw new PlanFreqTypeException(PlanFreqTypeException.WORKITEM_PLANDATE_ERROR, param);
            }
            sDate = (Date)row.getCell("exeStartDate").getValue();
            eDate = (Date)row.getCell("exeEndDate").getValue();
            if (sDate == null || eDate == null || !DateTimeUtils.dayAfter((Date)sDate, (Date)eDate)) continue;
            throw new PlanFreqTypeException(PlanFreqTypeException.WORKITEM_EXEDATE_ERROR, param);
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        int i;
        this.checkValid();
        this.storeData();
        Date date = new Date();
        if (((PersonInfo)this.cboEmpName.getSelectedItem()).equals((Object)this.curPerson)) {
            int n = this.workPlanInfo.getWorkItem().size();
            for (i = 0; i < n; ++i) {
                this.workPlanInfo.getWorkItem().get(i).setSelfLastUpdateTime(date);
            }
            n = this.tblMain.getRowCount();
            for (i = 0; i < n; ++i) {
                this.tblMain.getRow(i).getCell("selfLastUpdateTime").setValue((Object)date);
            }
        } else {
            int n = this.workPlanInfo.getWorkItem().size();
            for (i = 0; i < n; ++i) {
                this.workPlanInfo.getWorkItem().get(i).setSuperLastUpdateTime(date);
            }
            n = this.tblMain.getRowCount();
            for (i = 0; i < n; ++i) {
                this.tblMain.getRow(i).getCell("superLastUpdateTime").setValue((Object)date);
            }
        }
        IObjectPK pk = this.iWorkPlan.submit((CoreBaseInfo)this.workPlanInfo);
        this.workPlanInfo.setId(BOSUuid.read((String)pk.toString()));
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        if (this.attachMentTempID != null) {
            this.updateBoAttchAsso();
        }
        this.oldWorkPlanInfo = (WorkPlanInfo)this.workPlanInfo.clone();
        this.refresh();
    }

    @Override
    protected void cboEmpName_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1 && this.loadFinish) {
            this.loadData();
        }
    }

    @Override
    protected void cboPlanFreq_itemStateChanged(ItemEvent e) throws Exception {
        super.cboPlanFreq_itemStateChanged(e);
        if (e.getStateChange() == 1 && this.loadFinish) {
            this.now = Calendar.getInstance();
            this.loadData();
        }
    }

    @Override
    public void actionPrePeriod_actionPerformed(ActionEvent e) throws Exception {
        if (this.cboPlanFreq.getSelectedItem() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PlanFreqTypeResource", (String)"planFreqRequired"));
            this.cboPlanFreq.requestFocus();
            return;
        }
        if (this.isLoad && this.actionSubmit.isEnabled() && this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"dataChanged"));
            if (result == 0) {
                this.checkValid();
                this.actionSubmit.setDaemonRun(false);
                ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                this.actionSubmit.actionPerformed(event);
            } else if (result == 2) {
                SysUtil.abort();
            }
        }
        int day = this.now.get(5);
        PlanFreqTypeInfo prtInfo = (PlanFreqTypeInfo)this.cboPlanFreq.getSelectedItem();
        if (prtInfo.getType() == PlanFreqTypeEnum.DAY) {
            this.now.add(6, -1);
        } else if (prtInfo.getType() == PlanFreqTypeEnum.WEEK) {
            this.now.add(3, -1);
        } else if (prtInfo.getType() == PlanFreqTypeEnum.TENDAYS) {
            if (day == 1) {
                this.now.set(5, 21);
                this.now.add(2, -1);
            } else if (day == 11) {
                this.now.set(5, 1);
            } else {
                this.now.set(5, 11);
            }
        } else if (prtInfo.getType() == PlanFreqTypeEnum.MONTH) {
            this.now.add(2, -1);
        } else if (prtInfo.getType() == PlanFreqTypeEnum.QUARTER) {
            this.now.add(2, -3);
        } else if (prtInfo.getType() == PlanFreqTypeEnum.HALFYEAR) {
            this.now.add(2, -6);
        } else if (prtInfo.getType() == PlanFreqTypeEnum.YEAR) {
            this.now.add(1, -1);
        }
        this.loadData();
    }

    @Override
    public void actionNextPeriod_actionPerformed(ActionEvent e) throws Exception {
        if (this.cboPlanFreq.getSelectedItem() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PlanFreqTypeResource", (String)"planFreqRequired"));
            this.cboPlanFreq.requestFocus();
            return;
        }
        if (this.isLoad && this.actionSubmit.isEnabled() && this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"dataChanged"));
            if (result == 0) {
                this.checkValid();
                this.actionSubmit.setDaemonRun(false);
                ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                this.actionSubmit.actionPerformed(event);
            } else if (result == 2) {
                SysUtil.abort();
            }
        }
        int day = this.now.get(5);
        PlanFreqTypeInfo prtInfo = (PlanFreqTypeInfo)this.cboPlanFreq.getSelectedItem();
        if (prtInfo.getType() == PlanFreqTypeEnum.DAY) {
            this.now.add(6, 1);
        } else if (prtInfo.getType() == PlanFreqTypeEnum.WEEK) {
            this.now.add(3, 1);
        } else if (prtInfo.getType() == PlanFreqTypeEnum.TENDAYS) {
            if (day == 1) {
                this.now.set(5, 11);
            } else if (day == 11) {
                this.now.set(5, 21);
            } else {
                this.now.set(5, 1);
                this.now.add(2, 1);
            }
        } else if (prtInfo.getType() == PlanFreqTypeEnum.MONTH) {
            this.now.add(2, 1);
        } else if (prtInfo.getType() == PlanFreqTypeEnum.QUARTER) {
            this.now.add(2, 3);
        } else if (prtInfo.getType() == PlanFreqTypeEnum.HALFYEAR) {
            this.now.add(2, 6);
        } else if (prtInfo.getType() == PlanFreqTypeEnum.YEAR) {
            this.now.add(1, 1);
        }
        this.loadData();
    }

    @Override
    public void actionPlanWritePerson_actionPerformed(ActionEvent e) throws Exception {
        super.actionPlanWritePerson_actionPerformed(e);
        UIContext uiContext = new UIContext(this.getUIContext().get("OwnerWindow"));
        IUIFactory uiFactory = null;
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow uiWindow = uiFactory.create(PlanWriteListUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    @Override
    public void actionSendMail_actionPerformed(ActionEvent e) throws Exception {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        UIContext uiContext = new UIContext(this.getUIContext().get("OwnerWindow"));
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("PlanFreqType", this.cboPlanFreq.getSelectedItem());
        this.isLoad = false;
        this.actionPrePeriod_actionPerformed(null);
        context.put("PreStartDate", sf.format(this.startDate));
        context.put("PreEndDate", sf.format(this.endDate));
        this.actionNextPeriod_actionPerformed(null);
        context.put("CurStartDate", sf.format(this.startDate));
        context.put("CurEndDate", sf.format(this.endDate));
        context.put("Subject", this.labHead.getText());
        uiContext.put("PARAM", context);
        IUIFactory uiFactory = null;
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow uiWindow = uiFactory.create(PlanSendMailListUI.class.getName(), (Map)uiContext);
        uiWindow.show();
        this.isLoad = true;
    }

    @Override
    public void actionViewPerf_actionPerformed(ActionEvent e) throws Exception {
        PersonInfo pInfo = (PersonInfo)this.cboEmpName.getSelectedItem();
        UIContext uiContext = new UIContext(this.getUIContext().get("OwnerWindow"));
        uiContext.put("PERSON_ID", pInfo.getId().toString());
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        HashSet<Object> idSet = new HashSet<Object>();
        for (int i = 0; i < selectRows.length; ++i) {
            if (this.tblMain.getRow(selectRows[i]).getCell("id").getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)this.RES, (String)"dataIsNotSaved"));
                return;
            }
            idSet.add(this.tblMain.getRow(selectRows[i]).getCell("id").getValue());
        }
        uiContext.put("idSet", idSet);
        IUIFactory uiFactory = null;
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow uiWindow = uiFactory.create(EvaluTargetListUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        uiWindow.show();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("evaluTarget.id"));
        view.getSelector().add(new SelectorItemInfo("evaluTarget.number"));
        view.getSelector().add(new SelectorItemInfo("evaluTarget.content"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        CoreBaseCollection coll = WorkItemFactory.getRemoteInstance().getCollection(view);
        int size = coll.size();
        block1: for (int i = 0; i < size; ++i) {
            IRow row = null;
            int count = this.tblMain.getRowCount();
            for (int j = 0; j < count; ++j) {
                WorkItemInfo info;
                String id = null;
                row = this.tblMain.getRow(j);
                if (row.getCell("id").getValue() != null) {
                    id = row.getCell("id").getValue().toString();
                }
                if (!(info = (WorkItemInfo)coll.get(i)).getId().toString().equals(id) || info.getEvaluTarget() == null) continue;
                row.getCell("goalNumber").setValue((Object)info.getEvaluTarget().getNumber());
                row.getCell("goalContent").setValue((Object)info.getEvaluTarget().getContent());
                row.getCell("evaluTargetId").setValue((Object)info.getEvaluTarget());
                continue block1;
            }
        }
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACHIEVEMENT_MANAGEMENT;
    }

    @Override
    public void actionImportPrePlan_actionPerformed(ActionEvent e) throws Exception {
        if (this.cboPlanFreq.getSelectedItem() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PlanFreqTypeResource", (String)"planFreqRequired"));
            this.cboPlanFreq.requestFocus();
            return;
        }
        Calendar preDate = (Calendar)this.now.clone();
        int day = preDate.get(5);
        PlanFreqTypeInfo prtInfo = (PlanFreqTypeInfo)this.cboPlanFreq.getSelectedItem();
        if (prtInfo.getType() == PlanFreqTypeEnum.DAY) {
            preDate.add(6, -1);
        } else if (prtInfo.getType() == PlanFreqTypeEnum.WEEK) {
            preDate.add(3, -1);
        } else if (prtInfo.getType() == PlanFreqTypeEnum.TENDAYS) {
            if (day == 1) {
                preDate.set(5, 21);
                preDate.add(2, -1);
            } else if (day == 11) {
                preDate.set(5, 1);
            } else {
                preDate.set(5, 11);
            }
        } else if (prtInfo.getType() == PlanFreqTypeEnum.MONTH) {
            preDate.add(2, -1);
        } else if (prtInfo.getType() == PlanFreqTypeEnum.QUARTER) {
            preDate.add(2, -3);
        } else if (prtInfo.getType() == PlanFreqTypeEnum.HALFYEAR) {
            preDate.add(2, -6);
        } else if (prtInfo.getType() == PlanFreqTypeEnum.YEAR) {
            preDate.add(1, -1);
        }
        Date aStartDate = preDate.getTime();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        PersonInfo pInfo = (PersonInfo)this.cboEmpName.getSelectedItem();
        filter.getFilterItems().add(new FilterItemInfo("workPlan.person.id", (Object)pInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("workPlan.planFreqType", (Object)prtInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("workPlan.startDate", (Object)sf.format(aStartDate)));
        filter.getFilterItems().add(new FilterItemInfo("workPlan.hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("workPlan.target"));
        viewInfo.getSelector().add(new SelectorItemInfo("workPlan.description"));
        viewInfo.getSelector().add(new SelectorItemInfo("planItemCategory.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("executor.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("executor.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("executor.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("monitor.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("monitor.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("monitor.number"));
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        WorkItemCollection coll = WorkItemFactory.getRemoteInstance().getWorkItemCollection(viewInfo);
        if (coll == null || coll.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"noPrePlan"));
            SysUtil.abort();
        }
        IRow row = null;
        WorkItemInfo wiInfo = null;
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            wiInfo = coll.get(i);
            row = this.tblMain.addRow();
            row.getCell("number").setValue((Object)wiInfo.getNumber());
            row.getCell("planItem").setValue((Object)wiInfo.getPlanItem());
            row.getCell("category").setValue((Object)wiInfo.getPlanItemCategory());
            row.getCell("requirement").setValue((Object)wiInfo.getRequirement());
            row.getCell("excutor").setValue((Object)wiInfo.getExecutor());
            row.getCell("accomplishResult").setValue((Object)wiInfo.getAccomplishResult());
            row.getCell("statue").setValue((Object)wiInfo.getStatue());
            if (wiInfo.getGuage() != null) {
                row.getCell("guage").setValue((Object)wiInfo.getGuage().multiply(new BigDecimal("100.00")));
            }
            row.getCell("problem").setValue((Object)wiInfo.getProblem());
            row.getCell("advice").setValue((Object)wiInfo.getAdvice());
            row.getCell("planStartDate").setValue((Object)wiInfo.getPlanStartDate());
            row.getCell("planEndDate").setValue((Object)wiInfo.getPlanEndDate());
            row.getCell("exeStartDate").setValue((Object)wiInfo.getExeStartDate());
            row.getCell("exeEndDate").setValue((Object)wiInfo.getExeEndDate());
            row.getCell("planTimeCost").setValue((Object)wiInfo.getPlanTimeCost());
            row.getCell("exeTimeCost").setValue((Object)wiInfo.getExeTimeCost());
            row.getCell("founder").setValue((Object)this.curPerson);
            if (wiInfo.getAuditState() != null) {
                row.getCell("auditState").setValue((Object)wiInfo.getAuditState());
            }
            row.getCell("auditState").setValue((Object)AuditState2Enum.UNAUDIT);
        }
        if (coll.size() > 0) {
            this.txtTarget.setText(coll.get(0).getWorkPlan().getTarget());
            this.txtPlanDesc.setText(coll.get(0).getWorkPlan().getDescription());
        }
    }

    @Override
    protected void pkStartDate_dataChanged(DataChangeEvent e) throws Exception {
        int result;
        if (this.isModify() && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"dataChanged"))) == 0) {
            this.actionSubmit.setDaemonRun(false);
            ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
            this.actionSubmit.actionPerformed(event);
        }
        Date newDate = (Date)e.getNewValue();
        this.now.setTime(newDate);
        this.loadData();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)this.RES, (String)"notSelected"));
            SysUtil.abort();
        }
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        PersonInfo personInfo = userInfo.getPerson();
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        WorkItemCollection workItems = new WorkItemCollection();
        int n = rows.length;
        for (int i = 0; i < n; ++i) {
            IRow row = this.tblMain.getRow(rows[i]);
            if (AuditState2Enum.AUDITED.equals(row.getCell("auditState").getValue())) continue;
            row.getCell("auditState").setValue((Object)AuditState2Enum.AUDITED);
            row.getCell("auditor").setValue((Object)personInfo);
            workItems.add(this.getWorkItemInfo(rows[i]));
        }
        if (!workItems.isEmpty()) {
            WorkPlanFactory.getRemoteInstance().audit(workItems);
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RES, (String)"auditSuccess"));
    }

    private WorkItemInfo getWorkItemInfo(int rowIndex) {
        IRow row = this.tblMain.getRow(rowIndex);
        WorkItemInfo workItemInfo = (WorkItemInfo)row.getUserObject();
        workItemInfo.setAuditState((AuditState2Enum)((Object)row.getCell("auditState").getValue()));
        workItemInfo.setAuditor((PersonInfo)row.getCell("auditor").getValue());
        return workItemInfo;
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)this.RES, (String)"notSelected"));
            SysUtil.abort();
        }
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int n = rows.length;
        for (int i = 0; i < n; ++i) {
            IRow row = this.tblMain.getRow(rows[i]);
            if (AuditState2Enum.AUDITED.equals(row.getCell("auditState").getValue())) continue;
            MsgBox.showInfo((String)EASResource.getString((String)this.RES, (String)"notAudited"));
            SysUtil.abort();
        }
        WorkItemCollection workItems = new WorkItemCollection();
        int n2 = rows.length;
        for (int i = 0; i < n2; ++i) {
            IRow row = this.tblMain.getRow(rows[i]);
            row.getCell("auditState").setValue((Object)AuditState2Enum.UNAUDIT);
            row.getCell("auditor").setValue(null);
            workItems.add(this.getWorkItemInfo(rows[i]));
        }
        if (!workItems.isEmpty()) {
            WorkPlanFactory.getRemoteInstance().unAudit(workItems);
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RES, (String)"antiAuditSuccess"));
    }

    @Override
    protected void btnCacleAssociation_actionPerformed(ActionEvent e) throws Exception {
        int i;
        this.checkSelected();
        int[] selectedRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        HashSet<String> idSet = new HashSet<String>();
        for (int i2 = 0; i2 < selectedRows.length; ++i2) {
            IRow row = this.tblMain.getRow(selectedRows[i2]);
            if (row.getCell("id").getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)this.RES, (String)"dataIsNotSaved"));
                return;
            }
            if (row.getCell("evaluTargetId").getValue() == null) continue;
            String id = row.getCell("id").getValue().toString();
            idSet.add(id);
        }
        IWorkItem iWorkItem = WorkItemFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("evaluTargetId"));
        evi.getSelector().add(new SelectorItemInfo("auditState"));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(fi);
        CoreBaseCollection coll = iWorkItem.getCollection(evi);
        int size = coll.size();
        for (int i3 = 0; i3 < size; ++i3) {
            WorkItemInfo info = (WorkItemInfo)coll.get(i3);
            if (!AuditState2Enum.AUDITED.equals((Object)info.getAuditState())) continue;
            MsgBox.showInfo((String)EASResource.getString((String)this.RES, (String)"auditedWorkItemCanNotCancleAssociation"));
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        int size2 = coll.size();
        for (i = 0; i < size2; ++i) {
            WorkItemInfo info = (WorkItemInfo)coll.get(i);
            info.setEvaluTarget(null);
            idList.add(info.getId().toString());
        }
        iWorkItem.submit(coll);
        size2 = idList.size();
        block3: for (i = 0; i < size2; ++i) {
            IRow row = null;
            int count = this.tblMain.getRowCount();
            for (int j = 0; j < count; ++j) {
                String id = null;
                row = this.tblMain.getRow(j);
                if (row.getCell("id").getValue() != null) {
                    id = row.getCell("id").getValue().toString();
                }
                if (!idList.get(i).toString().equals(id)) continue;
                row.getCell("goalNumber").setValue(null);
                row.getCell("goalContent").setValue(null);
                row.getCell("evaluTargetId").setValue(null);
                continue block3;
            }
        }
    }

    private void checkSelected() {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private void refresh() throws Exception {
        this.tblMain.refresh();
        this.loadData();
    }

    @Override
    public IUIActionPostman prepareInit() {
        PerfClientUtils.checkValidPerson(this);
        PerfClientUtils.checkValidHRO(this);
        IUIActionPostman postman = super.prepareInit();
        RequestContext request = new RequestContext();
        String pId = (String)this.getUIContext().get("ID");
        if (pId != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("startDate"));
            sic.add(new SelectorItemInfo("planFreqType.id"));
            sic.add(new SelectorItemInfo("planFreqType.type"));
            sic.add(new SelectorItemInfo("person.*"));
            request.put("setCurPersonSic", (Object)sic);
            request.put("setCurPersonID", (Object)new ObjectUuidPK(BOSUuid.read((String)pId)));
        }
        String oql = "where hrOrgUnit='" + SysContext.getSysContext().getCurrentHRUnit().getId() + "'";
        request.put("oql", (Object)oql);
        postman.setRequestContext((Serializable)request);
        return postman;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        if (this.workPlanInfo.getId() == null) {
            if (this.attachMentTempID == null) {
                this.attachMentTempID = acm.getAttID().toString();
            }
            acm.showAttachmentListUIByBoID(this.attachMentTempID, (Object)this);
        } else {
            acm.showAttachmentListUIByBoID(this.workPlanInfo.getId().toString(), (Object)this);
        }
    }

    private void updateBoAttchAsso() throws Exception {
        IBoAttchAsso bAttch = BoAttchAssoFactory.getRemoteInstance();
        BoAttchAssoInfo bInfo = null;
        FilterInfo filterInfo = new FilterInfo();
        EntityViewInfo view = new EntityViewInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("boID", (Object)this.attachMentTempID));
        view.setFilter(filterInfo);
        BoAttchAssoCollection boCollection = bAttch.getBoAttchAssoCollection(view);
        if (boCollection != null) {
            int count = boCollection.size();
            for (int i = 0; i < count; ++i) {
                bInfo = boCollection.get(i);
                bInfo.setBoID(this.workPlanInfo.getId().toString());
                bAttch.update((IObjectPK)new ObjectUuidPK(bInfo.getId()), bInfo);
            }
        }
    }

    private void deleteBoAttchAsso() {
        try {
            if (this.workPlanInfo.getId() == null && this.attachMentTempID != null) {
                IBoAttchAsso bAttch = BoAttchAssoFactory.getRemoteInstance();
                IAttachment iAttachment = AttachmentFactory.getRemoteInstance();
                BoAttchAssoInfo bInfo = null;
                AttachmentInfo aInfo = null;
                FilterInfo filterInfo = new FilterInfo();
                EntityViewInfo view = new EntityViewInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("boID", (Object)this.attachMentTempID));
                view.setFilter(filterInfo);
                view.setSelector(this.getSeletor());
                BoAttchAssoCollection boCollection = bAttch.getBoAttchAssoCollection(view);
                if (boCollection != null) {
                    int count = boCollection.size();
                    for (int i = 0; i < count; ++i) {
                        bInfo = boCollection.get(i);
                        aInfo = bInfo.getAttachment();
                        iAttachment.delete((IObjectPK)new ObjectUuidPK(aInfo.getId()));
                    }
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private SelectorItemCollection getSeletor() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("attachment.*"));
        return sic;
    }
}

