/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodCollection;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.web.PerfWebUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class EvaluTaskUtil {
    private static final Logger logger = Logger.getLogger(EvaluTaskUtil.class);

    public static String getEvaluTaskDataXml(HttpServletRequest request) {
        String solutionPeriodID = request.getParameter("id");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        int COLS = 17;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person1.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("mdEvaluator.auditState", (Object)new Integer(80)));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        String xmlData = null;
        int pageCount = Integer.parseInt(request.getParameter("pageCount"));
        int pageNumber = Integer.parseInt(request.getParameter("pageNumber"));
        int start = (pageNumber - 1) * pageCount;
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "EvaluTaskQuery"));
            iqec.option().isAutoIgnoreZero = false;
            iqec.option().isAutoTranslateBoolean = true;
            iqec.option().isAutoTranslateEnum = true;
            iqec.setObjectView(viewInfo);
            list.add("" + iqec.getRowCount());
            IRowSet rowSet = iqec.executeQuery(start, pageCount);
            while (rowSet.next()) {
                String[] array = new String[COLS];
                array[0] = rowSet.getString("id");
                array[1] = rowSet.getString("person.name");
                array[2] = rowSet.getString("mdEvaluGroup.name");
                array[3] = rowSet.getString("evalReDetail.name");
                array[4] = rowSet.getString("person.number");
                array[5] = rowSet.getString("position.name");
                array[6] = rowSet.getString("JobGrade.name");
                array[7] = rowSet.getString("adminOrgUnit.displayName");
                array[8] = rowSet.getString("paperState");
                array[9] = rowSet.getString("solutionPeriod.id");
                array[10] = rowSet.getString("paper.id");
                array[11] = rowSet.getString("multiDimObject.id");
                array[12] = rowSet.getString("person1.id");
                array[13] = rowSet.getString("mdEvaluator.auditState");
                array[14] = rowSet.getString("evalReDetail.id");
                array[15] = rowSet.getString("oprtState");
                array[16] = rowSet.getString("mdEvaluator.id");
                list.add(array);
            }
            xmlData = PerfWebUtils.makeProcDataToXMLData(list, COLS);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            xmlData = PerfWebUtils.makeErrorProcDataToXMLData(ctx, COLS);
        }
        return xmlData;
    }

    public static MultiDimentionSolutionPeriodCollection getcomboSolutionPeriod(Context ctx) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("MDSolution.MultiDimntModeE", (Object)new Integer(100), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("mdEvaluator.auditState", (Object)new Integer(80)));
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.SPStatuEnum", (Object)new Integer(101)));
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.SPStatuEnum", (Object)new Integer(102)));
        filter.getFilterItems().add(new FilterItemInfo("MDSolution.solutionType", (Object)new Integer(100)));
        filter.setMaskString("#0 and #1 and #2 and(#3 or #4) and #5");
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("solutionPeriod.id"));
        sic.add(new SelectorItemInfo("solutionPeriod.name"));
        sic.add(new SelectorItemInfo("solutionPeriod.SPStatuEnum"));
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app", "EvaluTaskSolutionPeriodQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.setObjectView(viewInfo);
        MultiDimentionSolutionPeriodCollection coll = new MultiDimentionSolutionPeriodCollection();
        MultiDimentionSolutionPeriodInfo info = null;
        try {
            IRowSet rowSet = exec.executeQuery();
            while (rowSet.next()) {
                info = new MultiDimentionSolutionPeriodInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("solutionPeriod.id")));
                info.setName(rowSet.getString("solutionPeriod.name"));
                info.setSPStatuEnum(SolutionPeriodStatusEnum.getEnum(rowSet.getInt("solutionPeriod.SPStatuEnum")));
                coll.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return coll;
    }
}

