/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.json.org.JSONArray;
import com.kingdee.eas.cp.common.json.org.JSONObject;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.hr.perf.EvalWFObjectsCollection;
import com.kingdee.eas.hr.perf.EvalWFObjectsInfo;
import com.kingdee.eas.hr.perf.EvaluObjectFacadeFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.TargetDeliverFacadeFactory;
import com.kingdee.eas.hr.perf.TargetEvaluStoreFactory;
import com.kingdee.eas.hr.perf.web.JsonObjectUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class OrgTargetEvaluStoreManageAction
extends DispatchAction {
    private static Logger logger = Logger.getLogger(OrgTargetEvaluStoreManageAction.class);

    public ActionForward getEvaluObject(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String spId = request.getParameter("solutionPeriodId");
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        EvalWFObjectsCollection evaluWfObjColl = this.getEvaluWFObjColl(ctx, request, spId, personId);
        JSONArray evaluobjJsonArray = new JSONArray();
        JSONObject evaluobjJsonResult = new JSONObject();
        evaluobjJsonArray = this.getJSONObject(evaluWfObjColl);
        evaluobjJsonResult.put("evaluObjcet", (Object)evaluobjJsonArray);
        String resultMsg = evaluobjJsonResult.toString();
        this.handleResult(response, resultMsg);
        return null;
    }

    private void handleResult(HttpServletResponse response, String resultMsg) {
        try {
            response.setContentType("text/json;charset=utf-8");
            response.getWriter().write(resultMsg);
            response.getWriter().flush();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private void initEvaluObjectIdSet(Context ctx, HttpServletRequest request, String logInPersonId) {
        Map evaluObjectMap = new HashMap();
        try {
            evaluObjectMap = TargetEvaluStoreFactory.getLocalInstance(ctx).getOrgSubAndDeliverEvaluObject(BOSUuid.read((String)logInPersonId));
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), e.getCause());
        }
        HashMap orgMap = new HashMap();
        orgMap.putAll((Map)evaluObjectMap.get("orgMap"));
        HashSet<String> orgIdSet = new HashSet<String>();
        HashSet evaluOrgIdSet = new HashSet();
        AdminOrgUnitInfo admin2 = null;
        if (orgMap.keySet() != null && !orgMap.keySet().isEmpty()) {
            for (AdminOrgUnitInfo admin2 : orgMap.values()) {
                if (admin2.get("evaluObject") != null) {
                    if (evaluOrgIdSet.size() != 0) continue;
                    evaluOrgIdSet.addAll((Set)admin2.get("evaluObject"));
                    continue;
                }
                orgIdSet.add(admin2.getId().toString());
            }
            HttpSession session = request.getSession();
            session.setAttribute("orgobjectId", orgIdSet);
            session.setAttribute("orgevaluObject", evaluOrgIdSet);
        }
    }

    private EvalWFObjectsCollection getEvaluWFObjColl(Context ctx, HttpServletRequest request, String solutionPeriodId, String personId) {
        if (StringUtils.isEmpty((String)solutionPeriodId)) {
            return null;
        }
        HttpSession session = request.getSession();
        Set objectIdSet = (Set)session.getAttribute("orgobjectId");
        if (objectIdSet == null) {
            this.initEvaluObjectIdSet(ctx, request, personId);
            objectIdSet = (Set)session.getAttribute("orgobjectId");
        }
        Set evaluObjectSet = (Set)session.getAttribute("orgevaluObject");
        EvalWFObjectsCollection evalWFObjectsColl = null;
        try {
            evalWFObjectsColl = this.getEvalWFObjectsCollection(ctx, EvaluObjectFacadeFactory.getLocalInstance(ctx).getOrgUnitByEvaluSolutionId(BOSUuid.read((String)solutionPeriodId), objectIdSet, evaluObjectSet), solutionPeriodId, personId);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), e.getCause());
        }
        return evalWFObjectsColl;
    }

    private EvalWFObjectsCollection getEvalWFObjectsCollection(Context ctx, EvalWFObjectsCollection coll, String solutionPeriodId, String personId) {
        if (coll != null && coll.size() > 0) {
            EvalWFObjectsInfo evalWFObjectsInfo = null;
            Set objIDset = this.getVisableObjectIDs(ctx, personId, solutionPeriodId);
            Set responserIdSet = this.getOrgResponserIdSet(ctx, personId);
            for (int i = 0; i < coll.size(); ++i) {
                evalWFObjectsInfo = coll.get(i);
                if (objIDset == null || objIDset.size() < 0) {
                    return coll;
                }
                if (responserIdSet != null && responserIdSet.size() > 0) {
                    if (objIDset.contains(evalWFObjectsInfo.getEvaluObject().getId().toString()) || responserIdSet.contains(evalWFObjectsInfo.getEvaluObject().getId().toString())) continue;
                    coll.removeObject(i);
                    continue;
                }
                if (objIDset.contains(evalWFObjectsInfo.getEvaluObject().getId().toString())) continue;
                coll.removeObject(i);
            }
        }
        return coll;
    }

    private Set getVisableObjectIDs(Context ctx, String currentPersonID, String solutionPeriodId) {
        HashSet<String> visableObjectID = new HashSet<String>();
        try {
            String evaluSolutionId = this.getEvaluSolutionIdBySpId(ctx, solutionPeriodId);
            Map deliverStringMap = TargetDeliverFacadeFactory.getLocalInstance(ctx).getSolutionTargetDeliverString(evaluSolutionId, true);
            Set delivers = deliverStringMap.keySet();
            String deliverString = null;
            for (String key : delivers) {
                deliverString = (String)deliverStringMap.get(key);
                Set deliverNameSet = this.parseDeliverStringToSet(deliverString);
                Set personIdSet = this.getPersonIdSet(ctx, deliverNameSet);
                if (!personIdSet.contains(currentPersonID)) continue;
                visableObjectID.add(key);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return visableObjectID;
    }

    private Set parseDeliverStringToSet(String deliverString) {
        String newString = deliverString.replaceAll("\uff08\u9ed8\u8ba4\uff09", "").replaceAll("\uff08\u7ec4\u7ec7\u8d1f\u8d23\u4eba\u4e0a\u7ea7\uff09", "").replaceAll("\uff08\u4e0a\u7ea7\uff09", "").replaceAll("\uff08\u7ee9\u6548\u76ee\u6807\u6267\u884c\u4eba\uff09", "");
        String[] deliverNameArray = newString.split(",");
        HashSet<String> deliverNameSet = new HashSet<String>(Arrays.asList(deliverNameArray));
        return deliverNameSet;
    }

    private Set getPersonIdSet(Context ctx, Set deliverNameSet) {
        String sql = "SELECT FID FROM T_BD_Person WHERE Fname_l2 in(" + PerfUtils.convertSetToString(deliverNameSet) + ")";
        HashSet<String> personIdSet = new HashSet<String>();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            rowSet.beforeFirst();
            while (rowSet.next()) {
                personIdSet.add(rowSet.getString("fid"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return personIdSet;
    }

    private Set getOrgResponserIdSet(Context ctx, String personId) {
        HashSet<String> responserIdSet = new HashSet<String>();
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "TempResponseAdminOrgUnitQuery"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("responser.id", (Object)personId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("deleted", (Object)new Boolean(false)));
        viewInfo.setFilter(filter);
        iqec.setObjectView(viewInfo);
        try {
            IRowSet rowSet = iqec.executeQuery();
            while (rowSet.next()) {
                responserIdSet.add(rowSet.getString("id"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return responserIdSet;
    }

    private String getEvaluSolutionIdBySpId(Context ctx, String solutionPeriodId) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("evaluSolution.id"));
        SolutionPeriodInfo info = null;
        String evaluSolutionId = null;
        try {
            info = SolutionPeriodFactory.getLocalInstance(ctx).getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodId));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (info != null) {
            evaluSolutionId = info.getEvaluSolution().getId().toString();
        }
        return evaluSolutionId;
    }

    private JSONArray getJSONObject(EvalWFObjectsCollection evaluWfObjColl) {
        if (evaluWfObjColl == null || evaluWfObjColl.size() == 0) {
            return null;
        }
        JSONArray evaluobjJsonArray = new JSONArray();
        EvalWFObjectsInfo evaluWfObjectInfo = null;
        EvaluObjectInfo evaluObjectInfo = null;
        Iterator iterator = evaluWfObjColl.iterator();
        int i = 1;
        while (iterator.hasNext()) {
            evaluWfObjectInfo = (EvalWFObjectsInfo)iterator.next();
            evaluObjectInfo = evaluWfObjectInfo.getEvaluObject();
            JSONObject evaluObjectJsonObj = JsonObjectUtils.convertEvaluObjectForList(evaluObjectInfo);
            evaluobjJsonArray.put((Object)evaluObjectJsonObj);
            ++i;
        }
        return evaluobjJsonArray;
    }
}

