/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.web;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.Locale;

public class PerfWebUtils {
    private static final String procCatalogResource = "com.kingdee.eas.hr.train.TrainWebResource";

    public static String makeErrorProcDataToXMLData(Context ctx, int nCols) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<root>");
        buffer.append("<reccordcount>");
        buffer.append(-1);
        buffer.append("</reccordcount>");
        buffer.append("<data>");
        buffer.append(ResourceBase.getString((String)procCatalogResource, (String)"fetchDataError", (Locale)ctx.getLocale()));
        buffer.append("</data>");
        buffer.append("</root>");
        return buffer.toString();
    }

    public static String makeProcDataToXMLData(ArrayList list, int nCols) {
        if (list == null || list.size() == 0 || list.size() == 1) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<root>");
            buffer.append("<reccordcount>");
            buffer.append(0);
            buffer.append("</reccordcount>");
            buffer.append("<data>");
            for (int j = 0; j < nCols; ++j) {
                buffer.append("");
                buffer.append("|");
            }
            buffer.append("~#~");
            buffer.append("");
            buffer.append("~#~");
            buffer.append("");
            buffer.append("~!~");
            buffer.append("</data>");
            buffer.append("</root>");
            return buffer.toString();
        }
        int preLength = list.size() * nCols * 6 * 2;
        return PerfWebUtils.makeProcDataToXMLData(preLength, list);
    }

    public static String makeProcDataToXMLData(int preLength, ArrayList list) {
        StringBuffer buffer = new StringBuffer(preLength);
        if (list == null) {
            buffer.append("<root>");
            buffer.append("<reccordcount>");
            buffer.append(0);
            buffer.append("</reccordcount>");
            buffer.append("<data>");
            buffer.append("</data>");
            buffer.append("</root>");
            return buffer.toString();
        }
        int nSize = list.size();
        int nNum = 0;
        String[] dataArray = null;
        buffer.append("<root>");
        buffer.append("<reccordcount>");
        buffer.append(list.get(0));
        buffer.append("</reccordcount>");
        buffer.append("<data>");
        String tempData = "";
        for (int i = 1; i < nSize; ++i) {
            dataArray = (String[])list.get(i);
            nNum = dataArray.length;
            for (int j = 0; j < nNum; ++j) {
                tempData = PerfWebUtils.encodeHtmlEpecialChar(dataArray[j]);
                buffer.append(tempData);
                buffer.append("|");
            }
            buffer.append("~#~");
            buffer.append("");
            buffer.append("~#~");
            buffer.append("");
            buffer.append("~!~");
        }
        buffer.append("</data>");
        buffer.append("</root>");
        return buffer.toString();
    }

    public static String makeProcDataToXMLData(ArrayList list) {
        StringBuffer buffer = new StringBuffer();
        if (list == null) {
            buffer.append("<root>");
            buffer.append("<reccordcount>");
            buffer.append(0);
            buffer.append("</reccordcount>");
            buffer.append("<data>");
            buffer.append("</data>");
            buffer.append("</root>");
            return buffer.toString();
        }
        int nSize = list.size();
        int nNum = 0;
        String[] dataArray = null;
        buffer.append("<root>");
        buffer.append("<reccordcount>");
        buffer.append(list.get(0));
        buffer.append("</reccordcount>");
        buffer.append("<data>");
        String tempData = "";
        for (int i = 1; i < nSize; ++i) {
            dataArray = (String[])list.get(i);
            nNum = dataArray.length;
            for (int j = 0; j < nNum; ++j) {
                tempData = PerfWebUtils.encodeHtmlEpecialChar(dataArray[j]);
                buffer.append(tempData);
                buffer.append("|");
            }
            buffer.append("~#~");
            buffer.append("");
            buffer.append("~#~");
            buffer.append("");
            buffer.append("~!~");
        }
        buffer.append("</data>");
        buffer.append("</root>");
        return buffer.toString();
    }

    public static String encodeHtmlEpecialChar(String html) {
        if (html == null) {
            return "";
        }
        if (html.indexOf("&") >= 0) {
            html = html.replaceAll("&", "&amp;");
        }
        if (html.indexOf("<") >= 0) {
            html = html.replaceAll("<", "&lt;");
        }
        if (html.indexOf(">") >= 0) {
            html = html.replaceAll(">", "&gt;");
        }
        if (html.indexOf("\"") >= 0) {
            html = html.replaceAll("\"", "&quot;");
        }
        if (html.indexOf("\uffe0") >= 0) {
            html = html.replaceAll("\uffe0", "&cent;");
        }
        if (html.indexOf("\u00a7") >= 0) {
            html = html.replaceAll("\u00a7", "&sect;");
        }
        if (html.indexOf("\u00d7") >= 0) {
            html = html.replaceAll("\u00d7", "&times;");
        }
        if (html.indexOf("\u00f7") >= 0) {
            html = html.replaceAll("\u00f7", "&divide;");
        }
        if (html.indexOf(" ") >= 0) {
            html = html.replaceAll(" ", "&nbsp;");
        }
        return html;
    }

    public static String makeAllProcDataToXMLData(ArrayList list, int nCols) {
        StringBuffer buffer = new StringBuffer();
        int nSize = list.size();
        if (list == null || nSize == 1) {
            buffer.append("<root>");
            buffer.append("<reccordcount>");
            buffer.append(0);
            buffer.append("</reccordcount>");
            buffer.append("<data>");
            for (int j = 0; j < nCols; ++j) {
                buffer.append("");
                buffer.append("|");
            }
            buffer.append("~#~");
            buffer.append("");
            buffer.append("~#~");
            buffer.append("");
            buffer.append("~!~");
            buffer.append("</data>");
            buffer.append("</root>");
            return buffer.toString();
        }
        int nNum = 0;
        String[] dataArray = null;
        buffer.append("<root>");
        buffer.append("<reccordcount>");
        buffer.append(list.get(0));
        buffer.append("</reccordcount>");
        buffer.append("<data>");
        String tempData = "";
        for (int i = 1; i < nSize; ++i) {
            dataArray = (String[])list.get(i);
            nNum = dataArray.length;
            for (int j = 0; j < nNum; ++j) {
                tempData = PerfWebUtils.encodeHtmlEpecialChar(dataArray[j]);
                buffer.append(tempData);
                buffer.append("|");
            }
            buffer.append("~#~");
            buffer.append("");
            buffer.append("~#~");
            if (dataArray[5] != null && dataArray[5].length() > 0) {
                buffer.append("#FFFDDF");
            } else {
                buffer.append("");
            }
            buffer.append("~!~");
        }
        buffer.append("</data>");
        buffer.append("</root>");
        return buffer.toString();
    }

    public static UserInfo getCurrentUser(Context ctx) {
        if (ctx == null) {
            return null;
        }
        return ContextUtil.getCurrentUserInfo((Context)ctx);
    }
}

