/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.AuditStateEnum;
import com.kingdee.eas.hr.perf.EvalPersonInfo;
import com.kingdee.eas.hr.perf.EvalRelationDetailCollection;
import com.kingdee.eas.hr.perf.EvalRelationDetailFactory;
import com.kingdee.eas.hr.perf.EvalRelationDetailInfo;
import com.kingdee.eas.hr.perf.EvaluRelationCollection;
import com.kingdee.eas.hr.perf.EvaluRelationFactory;
import com.kingdee.eas.hr.perf.EvaluRelationInfo;
import com.kingdee.eas.hr.perf.FellowTypeEnum;
import com.kingdee.eas.hr.perf.MDEvaluGroupFactory;
import com.kingdee.eas.hr.perf.MDEvaluGroupInfo;
import com.kingdee.eas.hr.perf.MDEvaluTypeEnum;
import com.kingdee.eas.hr.perf.MDGroupObjectCollection;
import com.kingdee.eas.hr.perf.MDGroupObjectFactory;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorCollection;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorFactory;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorInfo;
import com.kingdee.eas.hr.perf.MultiDimTestPaperStateEnum;
import com.kingdee.eas.hr.perf.MultiDimentionObjectCollection;
import com.kingdee.eas.hr.perf.MultiDimentionObjectFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.SolutionStatusEnum;
import com.kingdee.eas.hr.perf.WFStatuEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.STConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class SelfSelectEvaluatorUtil {
    private static final String RES = "com.kingdee.eas.hr.perf.PerfWebResource";
    private static final Logger logger = Logger.getLogger(SelfSelectEvaluatorUtil.class);
    private static final SelectorItemCollection onEvaluSolutionPeriod = null;

    public static MDEvaluGroupInfo getEvaluGroupByID(Context ctx, String mdEvaluGroupID) throws Exception {
        if (mdEvaluGroupID == null) {
            return null;
        }
        SelectorItemCollection itemCollection = new SelectorItemCollection();
        itemCollection.add(new SelectorItemInfo("id"));
        itemCollection.add(new SelectorItemInfo("relation.id"));
        itemCollection.add(new SelectorItemInfo("relation.name"));
        itemCollection.add(new SelectorItemInfo("relation.minRestrict"));
        itemCollection.add(new SelectorItemInfo("relation.personRestrict"));
        itemCollection.add(new SelectorItemInfo("relation.weight"));
        itemCollection.add(new SelectorItemInfo("relation.MDEvaluTypeEnum"));
        itemCollection.add(new SelectorItemInfo("fellowType"));
        return MDEvaluGroupFactory.getLocalInstance(ctx).getMDEvaluGroupInfo((IObjectPK)new ObjectUuidPK(mdEvaluGroupID), itemCollection);
    }

    public static MultiDimEvaluatorInfo getEvaluatorBySolutionPeriodAndEvaluObject(Context ctx, String mdSolutionPeriodID, String mdEvaluObjectID) throws Exception {
        if (mdSolutionPeriodID == null || mdEvaluObjectID == null) {
            return null;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("multiDimObject.id", (Object)mdEvaluObjectID));
        filterInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)mdSolutionPeriodID));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        MultiDimEvaluatorCollection collection = MultiDimEvaluatorFactory.getLocalInstance(ctx).getMultiDimEvaluatorCollection(viewInfo);
        if (collection == null || collection.size() == 0) {
            // empty if block
        }
        return collection.get(0);
    }

    public static boolean solutionPeriodEvaluatorCanModify(MultiDimentionSolutionPeriodInfo mdSpInfo, MultiDimEvaluatorInfo dimEvaluatorInfo) {
        if (mdSpInfo != null) {
            if (SolutionStatusEnum.CLOSED.equals((Object)mdSpInfo.getMDSolution().getSolutionStatuEn())) {
                return false;
            }
            if (mdSpInfo.getSPStatuEnum().equals((Object)SolutionPeriodStatusEnum.ON_EVALU)) {
                return dimEvaluatorInfo.getAuditState().equals((Object)AuditStateEnum.UNSUBMIT) || dimEvaluatorInfo.getAuditState().equals((Object)AuditStateEnum.REBACK);
            }
            return false;
        }
        return false;
    }

    public static EvaluRelationInfo getEvaluRelationByTypeAndName(EvaluRelationCollection collection, MDEvaluTypeEnum type, String name) {
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            if (!collection.get(i).getMDEvaluTypeEnum().equals((Object)type)) continue;
            if (type.equals((Object)MDEvaluTypeEnum.APPOINT)) {
                if (!collection.get(i).getName().equals(name)) continue;
                return collection.get(i);
            }
            return collection.get(i);
        }
        return null;
    }

    public static EvalRelationDetailInfo getEvalRelationByRelationID(EvalRelationDetailCollection evalReDetails, String relationID) {
        if (evalReDetails == null || evalReDetails.size() == 0) {
            return null;
        }
        int n = evalReDetails.size();
        for (int i = 0; i < n; ++i) {
            if (!evalReDetails.get(i).getEvalRelation().getId().toString().equals(relationID)) continue;
            return evalReDetails.get(i);
        }
        return null;
    }

    private static EvaluRelationInfo getEvaluRelationByID(EvaluRelationCollection relation2, String evaluRelationID) {
        if (relation2 == null || relation2.size() == 0 || evaluRelationID == null) {
            return null;
        }
        int n = relation2.size();
        for (int i = 0; i < n; ++i) {
            if (!relation2.get(i).getId().toString().equals(evaluRelationID)) continue;
            return relation2.get(i);
        }
        return null;
    }

    private static boolean checkEvaluRelationExist(Context ctx, String relationID) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)relationID));
        return EvaluRelationFactory.getLocalInstance(ctx).exists(filterInfo);
    }

    private static void checkExistEvaluator(Context ctx, String evaluatorID) throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)evaluatorID));
        if (!MultiDimEvaluatorFactory.getLocalInstance(ctx).exists(filterInfo)) {
            // empty if block
        }
    }

    private static boolean checkRelationIsModify(EvaluRelationInfo newValue, EvaluRelationInfo oldValue, FellowTypeEnum oldFellowType) {
        if (oldValue == null || newValue == null) {
            return true;
        }
        boolean fellowTypeModify = !newValue.getMdEvaluGroup().getFellowType().equals((Object)oldFellowType);
        return SelfSelectEvaluatorUtil.isRelationModifySelf(newValue, oldValue, fellowTypeModify);
    }

    private static boolean evaluRelationHasModify(Context ctx, MDEvaluGroupInfo evaluGroupInfo, String relationID) throws BOSException, EASBizException {
        SelectorItemCollection itemCollection = new SelectorItemCollection();
        itemCollection.add(new SelectorItemInfo("id"));
        itemCollection.add(new SelectorItemInfo("name"));
        itemCollection.add(new SelectorItemInfo("personRestrict"));
        itemCollection.add(new SelectorItemInfo("mdEvaluGroup.fellowType"));
        itemCollection.add(new SelectorItemInfo("MDEvaluTypeEnum"));
        EvaluRelationInfo evaluRelationInfo = EvaluRelationFactory.getLocalInstance(ctx).getEvaluRelationInfo((IObjectPK)new ObjectUuidPK(relationID), itemCollection);
        return SelfSelectEvaluatorUtil.checkRelationIsModify(evaluRelationInfo, SelfSelectEvaluatorUtil.getEvaluRelationByID(evaluGroupInfo.getRelation(), relationID), evaluGroupInfo.getFellowType());
    }

    private static boolean isRelationModifySelf(EvaluRelationInfo newRInfo, EvaluRelationInfo oldRInfo, boolean fellowTypeModify) {
        if (newRInfo.getPersonRestrict() != oldRInfo.getPersonRestrict()) {
            return true;
        }
        if (newRInfo.getMDEvaluTypeEnum().equals((Object)MDEvaluTypeEnum.FELLOW) && fellowTypeModify) {
            return true;
        }
        if (newRInfo.getMDEvaluTypeEnum().equals((Object)MDEvaluTypeEnum.APPOINT)) {
            return !newRInfo.getName().equals(oldRInfo.getName());
        }
        return false;
    }

    private static void checkExistEvalutorAndRelation(Context ctx, MDEvaluGroupInfo evaluGroupInfo, EvalRelationDetailInfo detailInfo) throws Exception {
        String relationID = detailInfo.getEvalRelation().getId().toString();
        EvaluRelationInfo evaluRelationInfo = SelfSelectEvaluatorUtil.getEvaluRelationByID(evaluGroupInfo.getRelation(), relationID);
        String name = evaluRelationInfo.getMDEvaluTypeEnum().toString();
        if (!SelfSelectEvaluatorUtil.checkEvaluRelationExist(ctx, relationID)) {
            SelfSelectEvaluatorUtil.checkExistEvaluator(ctx, detailInfo.getMdEvaluator().getId().toString());
        }
        if (SelfSelectEvaluatorUtil.evaluRelationHasModify(ctx, evaluGroupInfo, relationID)) {
            // empty if block
        }
        SelfSelectEvaluatorUtil.checkExistEvaluator(ctx, detailInfo.getMdEvaluator().getId().toString());
    }

    public static EvalRelationDetailInfo submitDetailInfo(Context ctx, MDEvaluGroupInfo evaluGroupInfo, EvalRelationDetailInfo detailInfo) throws Exception {
        SelfSelectEvaluatorUtil.checkExistEvalutorAndRelation(ctx, evaluGroupInfo, detailInfo);
        IObjectPK objectPK = EvalRelationDetailFactory.getLocalInstance(ctx).submit(detailInfo);
        EvalRelationDetailInfo detailInfo2 = EvalRelationDetailFactory.getLocalInstance(ctx).getEvalRelationDetailInfo(objectPK);
        return detailInfo2;
    }

    public static void operateSelfRelation(Context ctx, MultiDimEvaluatorInfo dimEvaluatorInfo, MDEvaluGroupInfo evaluGroupInfo) throws Exception {
        EvalRelationDetailInfo detailInfo;
        if (dimEvaluatorInfo == null || evaluGroupInfo == null) {
            return;
        }
        EvaluRelationInfo evaluRelationInfo = SelfSelectEvaluatorUtil.getEvaluRelationByTypeAndName(evaluGroupInfo.getRelation(), MDEvaluTypeEnum.SELF, null);
        if (evaluRelationInfo == null) {
            return;
        }
        EvalRelationDetailInfo detailInfo2 = SelfSelectEvaluatorUtil.getEvalRelationByRelationID(dimEvaluatorInfo.getEvalReDetails(), evaluRelationInfo.getId().toString());
        if (detailInfo2 != null && detailInfo2.getEvalPersons() != null && detailInfo2.getEvalPersons().size() > 0) {
            return;
        }
        if (detailInfo2 == null) {
            detailInfo = new EvalRelationDetailInfo();
            detailInfo.setMdEvaluator(dimEvaluatorInfo);
            detailInfo.setEvalRelation(evaluRelationInfo);
            StringBuffer sb = new StringBuffer();
            if (MDEvaluTypeEnum.APPOINT.equals((Object)evaluRelationInfo.getMDEvaluTypeEnum())) {
                sb.append(evaluRelationInfo.getName());
                sb.append("(");
                sb.append(evaluRelationInfo.getMDEvaluTypeEnum().toString());
                sb.append(")");
            } else {
                sb.append(evaluRelationInfo.getMDEvaluTypeEnum().toString());
            }
            String sname = STConverter.tc2sc((String)sb.toString());
            String tname = STConverter.sc2tc((String)sb.toString());
            detailInfo.setName(sname, new Locale("L2"));
            detailInfo.setName(tname, new Locale("L3"));
            detailInfo.setName(sb.toString(), new Locale("L1"));
            detailInfo.setId(BOSUuid.create((BOSObjectType)detailInfo.getBOSType()));
        } else {
            detailInfo = (EvalRelationDetailInfo)detailInfo2.clone();
        }
        EvalPersonInfo evalPersonInfo = new EvalPersonInfo();
        detailInfo.getEvalPersons().add(evalPersonInfo);
        evalPersonInfo.setPerson(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
            evalPersonInfo.setPosition(PerfUtils.getPositionInfo(ctx, ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString()));
        }
        evalPersonInfo.setIsOrigin(true);
        evalPersonInfo.setPaperState(MultiDimTestPaperStateEnum.NOTSEND);
        evalPersonInfo.setWfStatus(WFStatuEnum.UNUSED);
        detailInfo.setSelected(detailInfo.getEvalPersons().size());
        detailInfo = SelfSelectEvaluatorUtil.submitDetailInfo(ctx, evaluGroupInfo, detailInfo);
        int index = -1;
        int n = dimEvaluatorInfo.getEvalReDetails().size();
        for (int i = 0; i < n; ++i) {
            if (!dimEvaluatorInfo.getEvalReDetails().get(i).getId().toString().equals(detailInfo.getId().toString())) continue;
            index = i;
            break;
        }
        if (index != -1) {
            dimEvaluatorInfo.getEvalReDetails().get(index).setSelected(detailInfo.getSelected());
            dimEvaluatorInfo.getEvalReDetails().get(index).put("evalPersons", (Object)detailInfo.getEvalPersons());
        } else {
            dimEvaluatorInfo.getEvalReDetails().add(detailInfo);
        }
    }

    public static MultiDimentionObjectCollection getCurrentUserRefMDObject(Context ctx) {
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() == null) {
            return new MultiDimentionObjectCollection();
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        try {
            return MultiDimentionObjectFactory.getLocalInstance(ctx).getMultiDimentionObjectCollection(viewInfo);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
            return new MultiDimentionObjectCollection();
        }
    }

    public static MDGroupObjectCollection getCurrentUserRefMDSolutionPeriod(Context ctx, HashSet mdObject) {
        if (mdObject == null || mdObject.size() == 0) {
            return new MDGroupObjectCollection();
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("mdObject.id", (Object)mdObject, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("mdEvaluGroup.solutionPeriod.MDSolution.MultiDimntModeE", (Object)new Integer(102)));
        filterInfo.getFilterItems().add(new FilterItemInfo("mdEvaluGroup.solutionPeriod.SPStatuEnum", (Object)SolutionPeriodStatusEnum.UN_EVALU, CompareType.NOTEQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.solutionPeriod.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.solutionPeriod.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.solutionPeriod.SPStatuEnum"));
        viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.mdEvaluGroup.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.solutionPeriod.MDSolution.operateDescript"));
        viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.solutionPeriod.MDSolution.SolutionStatuEn"));
        viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.solutionPeriod.MDSolution.hidePaperWeight"));
        viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.solutionPeriod.MDSolution.MDOptionalEnum"));
        try {
            return MDGroupObjectFactory.getLocalInstance(ctx).getMDGroupObjectCollection(viewInfo);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
            return new MDGroupObjectCollection();
        }
    }

    public static MDGroupObjectCollection getSubMDGroupObjectCollection(Context ctx) {
        Set subordinateMDObject = SelfSelectEvaluatorUtil.getSubordinatePersonRefObject(ctx);
        MDGroupObjectCollection subCollection = new MDGroupObjectCollection();
        if (subordinateMDObject != null && subordinateMDObject.size() > 0) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("mdObject.id", (Object)subordinateMDObject, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("mdEvaluGroup.solutionPeriod.MDSolution.MultiDimntModeE", (Object)new Integer(102)));
            filterInfo.getFilterItems().add(new FilterItemInfo("mdEvaluGroup.solutionPeriod.SPStatuEnum", (Object)SolutionPeriodStatusEnum.UN_EVALU, CompareType.NOTEQUALS));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfo);
            viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.solutionPeriod.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.solutionPeriod.name"));
            viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.solutionPeriod.SPStatuEnum"));
            viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.mdEvaluGroup.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.solutionPeriod.MDSolution.operateDescript"));
            viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.solutionPeriod.MDSolution.SolutionStatuEn"));
            viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.solutionPeriod.MDSolution.hidePaperWeight"));
            viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.solutionPeriod.MDSolution.MDOptionalEnum"));
            try {
                subCollection = MDGroupObjectFactory.getRemoteInstance().getMDGroupObjectCollection(viewInfo);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
        return subCollection;
    }

    public static Set getSubordinatePerson(Context ctx) {
        HashSet<String> curPersonSet = new HashSet<String>();
        String currentPersonId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        curPersonSet.add(currentPersonId);
        HashMap personMap = new HashMap();
        try {
            personMap = PerfUtils.getSubordinateByPrimaryPosition("00000000-0000-0000-0000-000000000001396FCAD0", curPersonSet);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        HashSet subordinatePerson = new HashSet();
        if (personMap.get(currentPersonId) != null) {
            subordinatePerson = (HashSet)personMap.get(currentPersonId);
        }
        return subordinatePerson;
    }

    public static Set getSubordinatePersonRefObject(Context ctx) {
        HashSet<String> subordinateMDObject = new HashSet<String>();
        Set subordinatePerson = SelfSelectEvaluatorUtil.getSubordinatePerson(ctx);
        if (subordinatePerson != null && subordinatePerson.size() > 0) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)subordinatePerson, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("MDSolution.MDOptionalEnum", (Object)"101"));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfo);
            MultiDimentionObjectCollection subCollection = new MultiDimentionObjectCollection();
            try {
                subCollection = MultiDimentionObjectFactory.getRemoteInstance().getMultiDimentionObjectCollection(viewInfo);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
            int n = subCollection.size();
            for (int i = 0; i < n; ++i) {
                subordinateMDObject.add(subCollection.get(i).getId().toString());
            }
        }
        return subordinateMDObject;
    }

    public static ArrayList sortRelation(MDEvaluGroupInfo evaluGroupInfo) {
        ArrayList<EvaluRelationInfo> relationList = new ArrayList<EvaluRelationInfo>();
        EvaluRelationInfo info = SelfSelectEvaluatorUtil.getEvaluRelationByTypeAndName(evaluGroupInfo.getRelation(), MDEvaluTypeEnum.SELF, null);
        if (info != null) {
            relationList.add(info);
        }
        if ((info = SelfSelectEvaluatorUtil.getEvaluRelationByTypeAndName(evaluGroupInfo.getRelation(), MDEvaluTypeEnum.DIRECT_SUPERIOR, null)) != null) {
            relationList.add(info);
        }
        if ((info = SelfSelectEvaluatorUtil.getEvaluRelationByTypeAndName(evaluGroupInfo.getRelation(), MDEvaluTypeEnum.INDIRECT_SUPERIOR, null)) != null) {
            relationList.add(info);
        }
        if ((info = SelfSelectEvaluatorUtil.getEvaluRelationByTypeAndName(evaluGroupInfo.getRelation(), MDEvaluTypeEnum.ORGRESPONSER, null)) != null) {
            relationList.add(info);
        }
        if ((info = SelfSelectEvaluatorUtil.getEvaluRelationByTypeAndName(evaluGroupInfo.getRelation(), MDEvaluTypeEnum.FELLOW, null)) != null) {
            relationList.add(info);
        }
        if ((info = SelfSelectEvaluatorUtil.getEvaluRelationByTypeAndName(evaluGroupInfo.getRelation(), MDEvaluTypeEnum.DIRECT_SUBORDINATOR, null)) != null) {
            relationList.add(info);
        }
        if ((info = SelfSelectEvaluatorUtil.getEvaluRelationByTypeAndName(evaluGroupInfo.getRelation(), MDEvaluTypeEnum.INDIRECT_SUBORDINATOR, null)) != null) {
            relationList.add(info);
        }
        int n = evaluGroupInfo.getRelation().size();
        for (int i = 0; i < n; ++i) {
            if (!MDEvaluTypeEnum.APPOINT.equals((Object)evaluGroupInfo.getRelation().get(i).getMDEvaluTypeEnum())) continue;
            relationList.add(evaluGroupInfo.getRelation().get(i));
        }
        return relationList;
    }

    public static List getAlreadySelectedEvaluPersonList(Context ctx, String mdSolutionPeriodID, String mdEvaluObjectID) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        if (PerfUtils.objectIsNull(mdSolutionPeriodID) || PerfUtils.objectIsNull(mdEvaluObjectID)) {
            return list;
        }
        int COLUMN = 11;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)mdSolutionPeriodID));
        filterInfo.getFilterItems().add(new FilterItemInfo("multiDimObject.id", (Object)mdEvaluObjectID));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "EvalPersonSelectedQuery"));
        iqec.setObjectView(viewInfo);
        try {
            IRowSet rowSet = iqec.executeQuery();
            String[] value = new String[COLUMN];
            int index = 0;
            while (rowSet.next()) {
                value = new String[COLUMN];
                value[0] = "" + ++index;
                value[1] = rowSet.getString("evaluRelation.MDEvaluTypeEnum");
                value[2] = PerfUtils.getWebStringValue(rowSet, "person1.number");
                value[3] = PerfUtils.getWebStringValue(rowSet, "person1.name");
                value[4] = PerfUtils.objectIsNull(rowSet.getString("adminOrgUnit.name")) ? ResourceBase.getString((String)RES, (String)"noPositionPerson", (Locale)ctx.getLocale()) : PerfUtils.getWebStringValue(rowSet, "adminOrgUnit.name");
                value[5] = PerfUtils.getWebStringValue(rowSet, "position2.name");
                value[6] = PerfUtils.getWebStringValue(rowSet, "jobLevel.name");
                value[7] = PerfUtils.getWebStringValue(rowSet, "jobGrade.name");
                value[8] = PerfUtils.getWebStringValue(rowSet, "evalReDetail.name");
                value[9] = PerfUtils.getWebStringValue(rowSet, "evalReDetail.id");
                value[10] = PerfUtils.getWebStringValue(rowSet, "id");
                list.add(value);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return list;
    }
}

