/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.SynSolutionPeriodCollection;
import com.kingdee.eas.hr.perf.SynSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.web.PerfWebUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class SynHistoryTaskUtil {
    private static final Logger logger = Logger.getLogger(SynHistoryTaskUtil.class);

    public static String getSynHistoryTaskDataXml(HttpServletRequest request) {
        String solutionPeriodID = request.getParameter("id");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        int COLS = 10;
        FilterInfo filter = new FilterInfo();
        if (solutionPeriodID == null || solutionPeriodID.length() == 0) {
            solutionPeriodID = BOSUuid.create((BOSObjectType)new SynSolutionPeriodInfo().getBOSType()).toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("evaluer.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        String xmlData = null;
        int pageCount = Integer.parseInt(request.getParameter("pageCount"));
        int pageNumber = Integer.parseInt(request.getParameter("pageNumber"));
        int start = (pageNumber - 1) * pageCount;
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "SynNodeProcessHistoryQuery"));
            iqec.option().isAutoIgnoreZero = false;
            iqec.option().isAutoTranslateBoolean = true;
            iqec.option().isAutoTranslateEnum = true;
            iqec.setObjectView(viewInfo);
            list.add("" + iqec.getRowCount());
            IRowSet rowSet = iqec.executeQuery(start, pageCount);
            while (rowSet.next()) {
                String[] array = new String[COLS];
                array[0] = rowSet.getString("person.name");
                array[1] = rowSet.getString("person.number");
                array[2] = rowSet.getString("position.name");
                array[3] = rowSet.getString("jobGrade.name");
                array[4] = rowSet.getString("rank.name");
                array[5] = rowSet.getString("adminOrgUnit.displayName");
                array[6] = rowSet.getString("person.id");
                array[7] = rowSet.getString("evaluObject.id");
                array[8] = rowSet.getString("solutionPeriod.id");
                array[9] = rowSet.getString("synFlowNode.seqNumber");
                list.add(array);
            }
            xmlData = PerfWebUtils.makeProcDataToXMLData(list, COLS);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            xmlData = PerfWebUtils.makeErrorProcDataToXMLData(ctx, COLS);
            return xmlData;
        }
        return xmlData;
    }

    public static SynSolutionPeriodCollection getcomboSolutionPeriod(Context ctx) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (ContextUtil.getCurrentUserInfo((Context)ctx) == null || ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() == null || ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId() == null) {
            return null;
        }
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null || ContextUtil.getCurrentHRUnit((Context)ctx).getId() == null) {
            return null;
        }
        FilterItemCollection filterItems = filter.getFilterItems();
        filterItems.add(new FilterItemInfo("person.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString()));
        filterItems.add(new FilterItemInfo("solution.evaluMode", (Object)new Integer(0), CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        filterItems.add(new FilterItemInfo("status", (Object)new Integer(101)));
        filterItems.add(new FilterItemInfo("status", (Object)new Integer(102)));
        filter.setMaskString("#0 and #1 and #2 and (#3 or #4)");
        viewInfo.setFilter(filter);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app", "GetSynHistoryTaskSolutionPeriodQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.setObjectView(viewInfo);
        SynSolutionPeriodCollection coll = new SynSolutionPeriodCollection();
        SynSolutionPeriodInfo info = null;
        try {
            IRowSet rowSet = exec.executeQuery();
            while (rowSet.next()) {
                info = new SynSolutionPeriodInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("id")));
                info.setName(rowSet.getString("name"));
                info.setStatus(SolutionPeriodStatusEnum.getEnum(rowSet.getInt("status")));
                coll.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            return null;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
            return null;
        }
        return coll;
    }
}

