/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.client.IHRBillEditUIBiz;
import com.kingdee.eas.hr.standby.PersonPlanBizBillFactory;
import com.kingdee.eas.hr.standby.PersonPlanBizBillInfo;
import com.kingdee.eas.hr.standby.StandbyException;
import com.kingdee.eas.hr.standby.StandbyPersonPlanFactory;
import com.kingdee.eas.hr.standby.StandbyPersonPlanInfo;
import com.kingdee.eas.hr.standby.StandbyPersonWishInfo;
import com.kingdee.eas.hr.standby.StandbyTrainingItemInfo;
import com.kingdee.eas.hr.standby.client.AbstractPersonPlanBizBillEditUI;
import com.kingdee.eas.hr.standby.client.PersonPlanBizBillEditUIBiz;
import com.kingdee.eas.hr.standby.client.StandbyUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class PersonPlanBizBillEditUI
extends AbstractPersonPlanBizBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PersonPlanBizBillEditUI.class);
    private static final String dateFormatStr = "%r{yyyy-MM-dd}t";
    private PersonPlanBizBillInfo ppbbInfo = null;
    private PersonInfo personInfo = null;
    private HashMap ppbbMap = null;
    private HashMap planMap = null;
    private HashMap wishMap = null;
    private HashMap ppMap = null;
    private HashMap pwMap = null;

    protected void beforeOnLoad() throws Exception {
        StandbyUtils.checkUserHavePerson();
        super.beforeOnLoad();
    }

    public void onLoad() throws Exception {
        this.ppbbMap = new HashMap();
        this.planMap = new HashMap();
        this.wishMap = new HashMap();
        this.ppbbMap.put("personPlan", this.planMap);
        this.ppbbMap.put("personWish", this.wishMap);
        super.onLoad();
        if (this.editData != null && this.editData.getId() != null) {
            BOSUuid ppbbId = this.editData.getId();
            this.ppbbInfo = (PersonPlanBizBillInfo)PersonPlanBizBillFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(ppbbId));
            if (this.ppbbInfo.get("planAndWish") != null) {
                this.ppbbMap = (HashMap)this.ppbbInfo.get("planAndWish");
                this.planMap = (HashMap)this.ppbbMap.get("personPlan");
                this.wishMap = (HashMap)this.ppbbMap.get("personWish");
            }
        }
        this.changePlanAndWishStatus();
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.kdtEntrys_detailPanel.getAddNewLineButton().setVisible(false);
        this.actionPersonalPlanAdd.setEnabled(true);
        this.actionPersonalPlanDelete.setEnabled(true);
        this.actionPersonalWishAdd.setEnabled(true);
        this.actionPersonalWishDelete.setEnabled(true);
        this.setTableCellEditor();
    }

    protected IHRBillEditUIBiz getBillBiz() {
        return new PersonPlanBizBillEditUIBiz();
    }

    protected DetailPanel getIgnoredDetailPanel() {
        this.kdtEntrys_detailPanel.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"PERSON_SELECT"));
        return this.kdtEntrys_detailPanel;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    public void actionPersonalPlanAdd_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntrys.getSelectManager().getActiveRowIndex() == -1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.SELECT_PERSON_FIRST"));
            return;
        }
        StandbyPersonPlanInfo ppInfo = new StandbyPersonPlanInfo();
        IRow row = this.tblPersonalPlan.addRow();
        BOSUuid ppId = BOSUuid.create((BOSObjectType)ppInfo.getBOSType());
        ppInfo.setId(ppId);
        ppInfo.setEmployee(this.personInfo);
        String key = "personPlan~" + this.personInfo.getId().toString();
        this.ppMap = this.planMap.get(key) != null ? (HashMap)this.planMap.get(key) : new HashMap();
        this.ppMap.put(ppId.toString(), ppInfo);
        this.planMap.put(key, this.ppMap);
        row.getCell("id").setValue((Object)ppId.toString());
    }

    public void actionPersonalPlanDelete_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntrys.getSelectManager().getActiveRowIndex() == -1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.SELECT_PERSON_FIRST"));
            return;
        }
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblPersonalPlan);
        if (rowIndex < 0 || rowIndex >= this.tblPersonalPlan.getRowCount()) {
            return;
        }
        String planId = this.tblPersonalPlan.getRow(rowIndex).getCell("id").getValue().toString();
        if (StandbyPersonPlanFactory.getRemoteInstance().isRefrencedByCourse(planId)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.PLAN_ISREFRENCED"));
            return;
        }
        String key = "personPlan~" + this.personInfo.getId().toString();
        if (this.planMap.get(key) != null) {
            this.ppMap = (HashMap)this.planMap.get(key);
            this.ppMap.remove(planId);
            this.planMap.put(key, this.ppMap);
        }
        this.tblPersonalPlan.removeRow(rowIndex);
    }

    public void actionPersonalWishAdd_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntrys.getSelectManager().getActiveRowIndex() == -1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.SELECT_PERSON_FIRST"));
            return;
        }
        StandbyPersonWishInfo pwInfo = new StandbyPersonWishInfo();
        IRow row = this.tblPersonalWish.addRow();
        BOSUuid pwId = BOSUuid.create((BOSObjectType)pwInfo.getBOSType());
        pwInfo.setId(pwId);
        pwInfo.setEmployee(this.personInfo);
        String key = "personWish~" + this.personInfo.getId().toString();
        this.pwMap = this.wishMap.get(key) != null ? (HashMap)this.wishMap.get(key) : new HashMap();
        this.pwMap.put(pwId.toString(), pwInfo);
        this.wishMap.put(key, this.pwMap);
        row.getCell("id").setValue((Object)pwId.toString());
    }

    public void actionPersonalWishDelete_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntrys.getSelectManager().getActiveRowIndex() == -1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.SELECT_PERSON_FIRST"));
            return;
        }
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblPersonalWish);
        if (rowIndex < 0 || rowIndex >= this.tblPersonalWish.getRowCount()) {
            return;
        }
        String pwId = this.tblPersonalWish.getRow(rowIndex).getCell("id").getValue().toString();
        String key = "personWish~" + this.personInfo.getId().toString();
        if (this.wishMap.get(key) != null) {
            this.pwMap = (HashMap)this.wishMap.get(key);
            this.pwMap.remove(pwId);
            this.wishMap.put(key, this.pwMap);
        }
        this.tblPersonalWish.removeRow(rowIndex);
    }

    private void setTableCellEditor() throws Exception {
        this.tblPersonalPlan.checkParsed();
        KDDatePicker beginDate = new KDDatePicker();
        beginDate.setValue((Object)new Date());
        this.tblPersonalPlan.getColumn("beginDate").setEditor((ICellEditor)new KDTDefaultCellEditor(beginDate));
        this.tblPersonalPlan.getColumn("beginDate").getStyleAttributes().setNumberFormat(dateFormatStr);
        KDDatePicker endDate = new KDDatePicker();
        endDate.setValue((Object)new Date());
        this.tblPersonalPlan.getColumn("endDate").setEditor((ICellEditor)new KDTDefaultCellEditor(endDate));
        this.tblPersonalPlan.getColumn("endDate").getStyleAttributes().setNumberFormat(dateFormatStr);
        KDTextField txtTarget = new KDTextField();
        txtTarget.setMaxLength(80);
        this.tblPersonalPlan.getColumn("target").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtTarget));
        KDTextField txtSummary = new KDTextField();
        txtSummary.setMaxLength(200);
        this.tblPersonalPlan.getColumn("summary").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtSummary));
        KDTextField txtDescription = new KDTextField();
        txtDescription.setMaxLength(200);
        this.tblPersonalPlan.getColumn("description").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtDescription));
        KDBizPromptBox prmtTrainingItem = new KDBizPromptBox();
        prmtTrainingItem.setQueryInfo("com.kingdee.eas.hr.standby.app.StandbyTrainingItemQuery");
        prmtTrainingItem.setEnabledMultiSelection(false);
        prmtTrainingItem.setEditable(false);
        this.tblPersonalPlan.getColumn("trainingItem").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtTrainingItem));
        this.tblPersonalPlan.getColumn("trainingItem").getStyleAttributes().setBackground(StandbyUtils.MUSTINPUT_BGCOLOR);
        KDTextField txtMethod = new KDTextField();
        txtMethod.setMaxLength(80);
        this.tblPersonalPlan.getColumn("method").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtMethod));
        this.tblPersonalPlan.getColumn("method").getStyleAttributes().setBackground(StandbyUtils.MUSTINPUT_BGCOLOR);
        this.tblPersonalWish.checkParsed();
        KDBizPromptBox prmtPositionBox = new KDBizPromptBox();
        PositionPromptBox2 position = new PositionPromptBox2((IUIObject)this);
        position.setSealUp("true");
        prmtPositionBox.setSelector((KDPromptSelector)position);
        prmtPositionBox.setDisplayFormat("$name$");
        prmtPositionBox.setEditFormat("$number$");
        prmtPositionBox.setCommitFormat("$number$");
        prmtPositionBox.setEditable(false);
        this.tblPersonalWish.getColumn("toPosition").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtPositionBox));
        this.tblPersonalWish.getColumn("toPosition").getStyleAttributes().setBackground(StandbyUtils.MUSTINPUT_BGCOLOR);
        KDTextField txtCareerPlan = new KDTextField();
        txtCareerPlan.setMaxLength(200);
        this.tblPersonalWish.getColumn("careerPlan").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtCareerPlan));
        KDTextField txtExcellence = new KDTextField();
        txtExcellence.setMaxLength(80);
        this.tblPersonalWish.getColumn("excellence").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtExcellence));
        KDTextField txtShortage = new KDTextField();
        txtShortage.setMaxLength(80);
        this.tblPersonalWish.getColumn("shortage").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtShortage));
        KDTextField txtRequest = new KDTextField();
        txtRequest.setMaxLength(200);
        this.tblPersonalWish.getColumn("request").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtRequest));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPersonalPlanAdd.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnPersonalPlanDelete.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnPersonalWishAdd.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnPersonalWishDelete.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.kdtEntrys_detailPanel.getInsertLineButton().setIcon(EASResource.getIcon((String)"imgTbtn_releasebyuser"));
        this.tblPersonalPlan.getStyleAttributes().setWrapText(true);
        this.tblPersonalPlan.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblPersonalPlan.getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        this.tblPersonalWish.getStyleAttributes().setWrapText(true);
        this.tblPersonalWish.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblPersonalWish.getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        this.setControlProperties();
    }

    private void setControlProperties() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.tblPersonalPlan.getStyleAttributes().setLocked(true);
            this.btnPersonalPlanAdd.setEnabled(false);
            this.btnPersonalPlanDelete.setEnabled(false);
            this.tblPersonalWish.getStyleAttributes().setLocked(true);
            this.btnPersonalWishAdd.setEnabled(false);
            this.btnPersonalWishDelete.setEnabled(false);
        }
    }

    public void actionColumnCopyAll_actionPerformed(ActionEvent e) throws Exception {
        ((PersonPlanBizBillEditUIBiz)this.biz).copyColumn(this.kdtEntrys, false);
        ((PersonPlanBizBillEditUIBiz)this.biz).copyColumn(this.tblPersonalPlan, false);
        ((PersonPlanBizBillEditUIBiz)this.biz).copyColumn(this.tblPersonalWish, false);
    }

    public void actionColumnCopySelect_actionPerformed(ActionEvent e) throws Exception {
        ((PersonPlanBizBillEditUIBiz)this.biz).copyColumn(this.kdtEntrys, true);
        ((PersonPlanBizBillEditUIBiz)this.biz).copyColumn(this.tblPersonalPlan, true);
        ((PersonPlanBizBillEditUIBiz)this.biz).copyColumn(this.tblPersonalWish, true);
    }

    protected void lockUIForViewStatus() {
        super.lockUIForViewStatus();
        this.kdtEntrys_detailPanel.getAddNewLineButton().setEnabled(false);
        this.kdtEntrys_detailPanel.getInsertLineButton().setEnabled(false);
        this.kdtEntrys_detailPanel.getRemoveLinesButton().setEnabled(false);
    }

    protected IObjectValue createNewData() {
        PersonPlanBizBillInfo objectValue = new PersonPlanBizBillInfo();
        UserInfo info = SysContext.getSysContext().getCurrentUserInfo();
        objectValue.setBillState(HRBillStateEnum.SAVED);
        objectValue.setApplier(info.getPerson());
        objectValue.put("planAndWish", this.ppbbMap);
        return objectValue;
    }

    protected void initListener() {
        final KDTPropertyChangeListener changeListener = new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent evt) {
                Object source = evt.getSource();
                if (source == PersonPlanBizBillEditUI.this.tblPersonalPlan) {
                    PersonPlanBizBillEditUI.this.tblPersonalPlan_cellValueChanged(evt.getRowIndex(), evt.getColIndex(), evt.getOldValue(), evt.getNewValue());
                } else if (source == PersonPlanBizBillEditUI.this.tblPersonalWish) {
                    PersonPlanBizBillEditUI.this.tblPersonalWish_cellValueChanged(evt.getRowIndex(), evt.getColIndex(), evt.getOldValue(), evt.getNewValue());
                }
            }
        };
        this.kdtEntrys.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent event) {
                PersonPlanBizBillEditUI.this.tblPersonalPlan.removeKDTPropertyChangeListener(changeListener);
                PersonPlanBizBillEditUI.this.tblPersonalWish.removeKDTPropertyChangeListener(changeListener);
                PersonPlanBizBillEditUI.this.tblPersonalPlan.removeRows();
                PersonPlanBizBillEditUI.this.tblPersonalWish.removeRows();
                if (PersonPlanBizBillEditUI.this.kdtEntrys.getRowCount() <= 0) {
                    return;
                }
                int row = PersonPlanBizBillEditUI.this.kdtEntrys.getSelectManager().getActiveRowIndex();
                PersonPlanBizBillEditUI.this.personInfo = (PersonInfo)PersonPlanBizBillEditUI.this.kdtEntrys.getRow(row).getCell("person").getValue();
                try {
                    PersonPlanBizBillEditUI.this.fillPersonPlanValue(PersonPlanBizBillEditUI.this.personInfo.getId().toString());
                    PersonPlanBizBillEditUI.this.fillPersonWishValue(PersonPlanBizBillEditUI.this.personInfo.getId().toString());
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                PersonPlanBizBillEditUI.this.tblPersonalPlan.addKDTPropertyChangeListener(changeListener);
                PersonPlanBizBillEditUI.this.tblPersonalWish.addKDTPropertyChangeListener(changeListener);
            }
        });
    }

    private void fillPersonPlanValue(String personId) throws EASBizException, BOSException {
        String key = "personPlan~" + personId;
        if (this.planMap.get(key) == null) {
            return;
        }
        this.ppMap = (HashMap)this.planMap.get(key);
        for (Object ppKey : this.ppMap.keySet()) {
            StandbyPersonPlanInfo ppInfo = (StandbyPersonPlanInfo)this.ppMap.get(ppKey);
            IRow row = this.tblPersonalPlan.addRow();
            row.getCell("id").setValue((Object)ppInfo.getId().toString());
            row.getCell("employee").setValue((Object)ppInfo.getEmployee());
            if (ppInfo.getTarget() != null) {
                row.getCell("target").setValue((Object)ppInfo.getTarget());
            }
            if (ppInfo.getTrainingItem() != null) {
                row.getCell("trainingItem").setValue((Object)ppInfo.getTrainingItem());
            }
            if (ppInfo.getSummary() != null) {
                row.getCell("summary").setValue((Object)ppInfo.getSummary());
            }
            if (ppInfo.getMethod() != null) {
                row.getCell("method").setValue((Object)ppInfo.getMethod());
            }
            if (ppInfo.getDescription() != null) {
                row.getCell("description").setValue((Object)ppInfo.getDescription());
            }
            if (ppInfo.getBeginDate() != null) {
                row.getCell("beginDate").setValue((Object)ppInfo.getBeginDate());
            }
            if (ppInfo.getEndDate() == null) continue;
            row.getCell("endDate").setValue((Object)ppInfo.getEndDate());
        }
    }

    private void fillPersonWishValue(String personId) throws EASBizException, BOSException {
        String key = "personWish~" + personId;
        if (this.wishMap.get(key) == null) {
            return;
        }
        this.pwMap = (HashMap)this.wishMap.get(key);
        for (Object pwKey : this.pwMap.keySet()) {
            StandbyPersonWishInfo pwInfo = (StandbyPersonWishInfo)this.pwMap.get(pwKey);
            IRow row = this.tblPersonalWish.addRow();
            row.getCell("id").setValue((Object)pwInfo.getId().toString());
            row.getCell("employee").setValue((Object)pwInfo.getEmployee());
            if (pwInfo.getToPosition() != null) {
                row.getCell("toPosition").setValue((Object)pwInfo.getToPosition());
            }
            if (pwInfo.getCareerPlan() != null) {
                row.getCell("careerPlan").setValue((Object)pwInfo.getCareerPlan());
            }
            if (pwInfo.getExcellence() != null) {
                row.getCell("excellence").setValue((Object)pwInfo.getExcellence());
            }
            if (pwInfo.getShortage() != null) {
                row.getCell("shortage").setValue((Object)pwInfo.getShortage());
            }
            if (pwInfo.getRequest() == null) continue;
            row.getCell("request").setValue((Object)pwInfo.getRequest());
        }
    }

    protected void tblPersonalPlan_editStopped(KDTEditEvent e) throws Exception {
        this.tblPersonalPlan_cellValueChanged(e.getRowIndex(), e.getColIndex(), e.getOldValue(), e.getValue());
    }

    private void tblPersonalPlan_cellValueChanged(int rowIndex, int colIndex, Object oldValue, Object newValue) {
        this.fillPPMap(rowIndex, colIndex, newValue);
        if (oldValue == null ? newValue != null : !oldValue.equals(newValue)) {
            this.editData.put("change", "true");
        }
    }

    private void fillPPMap(int rowIndex, int colIndex, Object newValue) {
        if (rowIndex == -1) {
            return;
        }
        IRow row = this.tblPersonalPlan.getRow(rowIndex);
        String ppId = row.getCell("id").getValue().toString();
        StandbyPersonPlanInfo ppInfo = null;
        ppInfo = this.ppMap.get(ppId) != null ? (StandbyPersonPlanInfo)this.ppMap.get(ppId) : new StandbyPersonPlanInfo();
        if (colIndex == this.tblPersonalPlan.getColumnIndex("target")) {
            ppInfo.setTarget(newValue instanceof String ? (String)newValue : "");
        } else if (colIndex == this.tblPersonalPlan.getColumnIndex("trainingItem")) {
            ppInfo.setTrainingItem(newValue instanceof StandbyTrainingItemInfo ? (StandbyTrainingItemInfo)newValue : null);
        } else if (colIndex == this.tblPersonalPlan.getColumnIndex("summary")) {
            ppInfo.setSummary(newValue instanceof String ? (String)newValue : "");
        } else if (colIndex == this.tblPersonalPlan.getColumnIndex("method")) {
            ppInfo.setMethod(newValue instanceof String ? (String)newValue : null);
        } else if (colIndex == this.tblPersonalPlan.getColumnIndex("description")) {
            ppInfo.setDescription(newValue instanceof String ? (String)newValue : "");
        } else if (colIndex == this.tblPersonalPlan.getColumnIndex("beginDate")) {
            ppInfo.setBeginDate(newValue instanceof Date ? (Date)newValue : null);
        } else if (colIndex == this.tblPersonalPlan.getColumnIndex("endDate")) {
            ppInfo.setEndDate(newValue instanceof Date ? (Date)newValue : null);
        }
    }

    protected void tblPersonalWish_editStopped(KDTEditEvent e) throws Exception {
        this.tblPersonalWish_cellValueChanged(e.getRowIndex(), e.getColIndex(), e.getOldValue(), e.getValue());
    }

    private void tblPersonalWish_cellValueChanged(int rowIndex, int colIndex, Object oldValue, Object newValue) {
        this.fillPWMap(rowIndex, colIndex, newValue);
        if (oldValue == null ? newValue != null : !oldValue.equals(newValue)) {
            this.editData.put("change", "true");
        }
    }

    private void fillPWMap(int rowIndex, int colIndex, Object newValue) {
        if (rowIndex == -1) {
            return;
        }
        IRow row = this.tblPersonalWish.getRow(rowIndex);
        String pwId = row.getCell("id").getValue().toString();
        StandbyPersonWishInfo pwInfo = null;
        pwInfo = this.pwMap.get(pwId) != null ? (StandbyPersonWishInfo)this.pwMap.get(pwId) : new StandbyPersonWishInfo();
        if (colIndex == this.tblPersonalWish.getColumnIndex("toPosition")) {
            pwInfo.setToPosition(newValue instanceof PositionInfo ? (PositionInfo)newValue : null);
        } else if (colIndex == this.tblPersonalWish.getColumnIndex("careerPlan")) {
            pwInfo.setCareerPlan(newValue instanceof String ? (String)newValue : null);
        } else if (colIndex == this.tblPersonalWish.getColumnIndex("excellence")) {
            pwInfo.setExcellence(newValue instanceof String ? (String)newValue : "");
        } else if (colIndex == this.tblPersonalWish.getColumnIndex("shortage")) {
            pwInfo.setShortage(newValue instanceof String ? (String)newValue : "");
        } else if (colIndex == this.tblPersonalWish.getColumnIndex("request")) {
            pwInfo.setRequest(newValue instanceof String ? (String)newValue : "");
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.changePlanAndWishStatus();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.changePlanAndWishStatus();
        this.tblPersonalPlan.removeRows();
        this.tblPersonalWish.removeRows();
        this.ppMap.clear();
        this.planMap.clear();
        this.pwMap.clear();
        this.wishMap.clear();
    }

    private void changePlanAndWishStatus() {
        if (this.getOprtState().equals("VIEW")) {
            this.actionPersonalPlanAdd.setEnabled(false);
            this.actionPersonalPlanDelete.setEnabled(false);
            this.actionPersonalWishAdd.setEnabled(false);
            this.actionPersonalWishDelete.setEnabled(false);
            this.tblPersonalPlan.getStyleAttributes().setLocked(false);
            this.tblPersonalWish.getStyleAttributes().setLocked(false);
        } else {
            this.actionPersonalPlanAdd.setEnabled(true);
            this.actionPersonalPlanDelete.setEnabled(true);
            this.actionPersonalWishAdd.setEnabled(true);
            this.actionPersonalWishDelete.setEnabled(true);
            this.tblPersonalPlan.getStyleAttributes().setLocked(false);
            this.tblPersonalWish.getStyleAttributes().setLocked(false);
            this.actionColumnCopyAll.setEnabled(true);
            this.actionColumnCopySelect.setEnabled(true);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.get("planAndWish") == null) {
            this.editData.put("planAndWish", this.ppbbMap);
        }
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.get("planAndWish") == null) {
            this.editData.put("planAndWish", this.ppbbMap);
        }
        super.actionSubmit_actionPerformed(e);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        int rowCount = this.kdtEntrys.getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            PersonInfo empInfo = (PersonInfo)this.kdtEntrys.getRow(row).getCell("person").getValue();
            String empName = empInfo.getName();
            String personId = empInfo.getId().toString();
            String planKey = "personPlan~" + personId;
            String wishKey = "personWish~" + personId;
            boolean result = false;
            if (this.planMap != null) {
                if (this.planMap.get(planKey) == null) {
                    result = true;
                } else {
                    HashMap pMap = (HashMap)this.planMap.get(planKey);
                    if (pMap == null || pMap.isEmpty()) {
                        result = true;
                    } else {
                        Iterator ppItr = pMap.entrySet().iterator();
                        ArrayList<StandbyTrainingItemInfo> ppList = new ArrayList<StandbyTrainingItemInfo>();
                        while (ppItr.hasNext()) {
                            boolean flagOfDate;
                            Map.Entry entry = ppItr.next();
                            StandbyPersonPlanInfo ppInfo = (StandbyPersonPlanInfo)entry.getValue();
                            if (ppInfo.getTrainingItem() == null || ppInfo.getMethod() == null) {
                                throw new StandbyException(StandbyException.EXIST_NULL_ITEMANDMETHOD, new Object[]{empName});
                            }
                            if (ppInfo.getBeginDate() != null && ppInfo.getEndDate() != null && (flagOfDate = DateTimeUtils.dayAfter((Date)ppInfo.getBeginDate(), (Date)ppInfo.getEndDate()))) {
                                throw new StandbyException(StandbyException.EXIST_BEGINAFTEREND, new Object[]{empName});
                            }
                            ppList.add(ppInfo.getTrainingItem());
                        }
                        int size = ppList.size();
                        for (int i = 0; i < size; ++i) {
                            int len = ppList.size() - i;
                            for (int j = i + 1; j < len; ++j) {
                                if (!ppList.get(i).equals(ppList.get(j))) continue;
                                throw new StandbyException(StandbyException.EXIST_REPEATTRAINITEM, new Object[]{empName});
                            }
                        }
                    }
                }
            } else {
                result = true;
            }
            if (this.wishMap == null) continue;
            if (this.wishMap.get(wishKey) == null) {
                if (!result) continue;
                throw new StandbyException(StandbyException.PLAN_WISH_ALL_NULL, new Object[]{empName});
            }
            HashMap wMap = (HashMap)this.wishMap.get(wishKey);
            if (wMap == null || wMap.isEmpty()) {
                if (!result) continue;
                throw new StandbyException(StandbyException.PLAN_WISH_ALL_NULL, new Object[]{empName});
            }
            Iterator pwItr = wMap.entrySet().iterator();
            StandbyPersonWishInfo pwInfo = null;
            while (pwItr.hasNext()) {
                Map.Entry entry = pwItr.next();
                pwInfo = (StandbyPersonWishInfo)entry.getValue();
                if (pwInfo != null && pwInfo.getToPosition() != null) continue;
                throw new StandbyException(StandbyException.TOPOSITION_ISNULL, new Object[]{empName});
            }
        }
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.onLoad();
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.onLoad();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.onLoad();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.onLoad();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PersonPlanBizBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }
}

