/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.base.client.HRBillEditUIBiz;
import com.kingdee.eas.hr.base.client.f7.EditorCreator;
import com.kingdee.eas.hr.standby.PersonPlanBizBillEntryInfo;
import com.kingdee.eas.hr.standby.StandbyPersonAdjustBizBillFactory;
import com.kingdee.eas.hr.standby.StandbyPersonFactory;
import com.kingdee.eas.hr.standby.StandbyPersonInfo;
import com.kingdee.eas.hr.standby.StandbyTypeInfo;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PersonPlanBizBillEditUIBiz
extends HRBillEditUIBiz {
    protected IObjectValue createNewDetailData(PersonInfo info) {
        PersonPlanBizBillEntryInfo entry = new PersonPlanBizBillEntryInfo();
        entry.setPerson(info);
        HashMap standbyMap = null;
        HashMap map = null;
        try {
            if (info.get("standbyPerson") != null) {
                standbyMap = (HashMap)info.get("standbyPerson");
                Iterator standbyItr = standbyMap.entrySet().iterator();
                if (standbyItr.hasNext()) {
                    Map.Entry entry1 = standbyItr.next();
                    Object key = entry1.getKey();
                    PersonInfo personInfo = new PersonInfo();
                    personInfo.setId(info.getId());
                    personInfo.setName(info.getName());
                    personInfo.setNumber(info.getNumber());
                    personInfo.put("standbyPerson", standbyMap.get(key));
                    map = StandbyPersonFactory.getRemoteInstance().getStandbyPersonInfoByPerson(personInfo);
                    standbyMap.remove(key);
                }
                info.put("standbyPerson", (Object)standbyMap);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (map != null && map.get("position") != null) {
            entry.setPosition((PositionInfo)map.get("position"));
        }
        if (map != null && map.get("admin") != null) {
            entry.setAdminOrg((AdminOrgUnitInfo)map.get("admin"));
        }
        if (map != null && map.get("toPosition") != null) {
            entry.setToPosition((PositionInfo)map.get("toPosition"));
        }
        if (map != null && map.get("toPositionUnit") != null) {
            entry.setToPositionUnit((AdminOrgUnitInfo)map.get("toPositionUnit"));
        }
        if (map != null && map.get("toUnit") != null) {
            entry.setToAdminOrg((AdminOrgUnitInfo)map.get("toUnit"));
        }
        if (map != null && map.get("standbyType") != null) {
            entry.setStandbyType((StandbyTypeInfo)map.get("standbyType"));
        }
        return entry;
    }

    protected void initEditor() throws Exception {
        super.initEditor();
        this.kdtEntrys.getColumn("bizDate").setEditor(EditorCreator.getDateCellEditor());
        this.kdtEntrys.getColumn("bizDate").getStyleAttributes().setNumberFormat("yyyy-mm-dd");
    }

    public void addLine(boolean isInsert) throws Exception {
        this.addStandbyPerson(isInsert);
    }

    protected void addStandbyPerson(boolean isInsert) throws Exception {
        String adminIdStr;
        KDBizPromptBox f7 = new KDBizPromptBox();
        f7.setQueryInfo("com.kingdee.eas.hr.standby.app.StandbyPersonQuery");
        String hrOrgId = null;
        if (this.ctx.getMainOrgContext() == null) {
            return;
        }
        HROrgUnitInfo hrOrg = (HROrgUnitInfo)this.ctx.getMainOrgContext().get((Object)OrgType.HRO);
        if (hrOrg != null) {
            hrOrgId = hrOrg.getId().toString();
        }
        if ((adminIdStr = StandbyPersonAdjustBizBillFactory.getRemoteInstance().getOrgRange(hrOrgId)) == null || adminIdStr.length() <= 0) {
            return;
        }
        StringBuffer filterSql = new StringBuffer();
        filterSql.append("isStandby = 1 ").append("and (toPositionUnit.id in (").append(adminIdStr).append(") or toUnit.id in (").append(adminIdStr).append("))");
        FilterInfo standbyPersonFilter = new FilterInfo(filterSql.toString());
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(standbyPersonFilter);
        f7.setEntityViewInfo(evi);
        f7.setEnabledMultiSelection(true);
        f7.setDataBySelector();
        if (!f7.getSelector().isCanceled()) {
            ArrayList<PersonInfo> persons = new ArrayList<PersonInfo>();
            if (f7.getData() instanceof Object[]) {
                Object[] objs = (Object[])f7.getData();
                StringBuffer personId = new StringBuffer();
                StandbyPersonInfo standbyPerson = null;
                for (int i = 0; i < objs.length; ++i) {
                    standbyPerson = (StandbyPersonInfo)objs[i];
                    personId.append("'");
                    personId.append(standbyPerson.getEmployee().getId().toString());
                    if (i == objs.length - 1) {
                        personId.append("'");
                        continue;
                    }
                    personId.append("',");
                }
                PersonCollection personCol = PersonFactory.getRemoteInstance().getPersonCollection("where id in (" + personId.toString() + ")");
                HashMap standbyMap = null;
                for (int i = 0; i < objs.length; ++i) {
                    standbyPerson = (StandbyPersonInfo)objs[i];
                    for (int j = 0; j < personCol.size(); ++j) {
                        if (!standbyPerson.getEmployee().getId().toString().equals(personCol.get(j).getId().toString())) continue;
                        PersonInfo personInfo = personCol.get(j);
                        standbyMap = personInfo.get("standbyPerson") != null ? (HashMap)personInfo.get("standbyPerson") : new HashMap();
                        standbyMap.put(standbyPerson.getId().toString(), standbyPerson);
                        personInfo.put("standbyPerson", (Object)standbyMap);
                        persons.add(personInfo);
                    }
                }
            } else {
                StandbyPersonInfo person = (StandbyPersonInfo)f7.getData();
                PersonInfo personInfo = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(person.getEmployee().getId()));
                HashMap standbyMap = null;
                standbyMap = personInfo.get("standbyPerson") != null ? (HashMap)personInfo.get("standbyPerson") : new HashMap();
                standbyMap.put(person.getId().toString(), person);
                personInfo.put("standbyPerson", (Object)standbyMap);
                persons.add(personInfo);
            }
            this.addLineByPersonList(persons, true);
        }
    }

    protected String[] getNotNullColumn() {
        return new String[]{"bizDate"};
    }

    protected boolean isAddPersonByF7() {
        return true;
    }

    protected void fillRow(IRow row, Object value, IRow dataRow, int copyCol) throws Exception {
        if (row == null) {
            return;
        }
        ICell cell = row.getCell(copyCol);
        if (cell == null) {
            return;
        }
        if (!cell.getStyleAttributes().isLocked()) {
            cell.setValue(value);
        }
    }
}

