/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.standby.client.AbstractPositionCompetencyListUI;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class PositionCompetencyListUI
extends AbstractPositionCompetencyListUI {
    private static final Logger logger = CoreUIObject.getLogger(PositionCompetencyListUI.class);
    private String curPositionId = null;

    public void onLoad() throws Exception {
        this.curPositionId = (String)this.getUIContext().get("ID");
        super.onLoad();
        this.loadPosiQualTable();
        if ("VIEW".equals(this.getOprtState())) {
            this.tblMain.getStyleAttributes().setLocked(true);
        }
    }

    private void loadPosiQualTable() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Position.id", (Object)this.curPositionId));
        view.setFilter(filter);
        this.queryPositionOfPosiQual = view;
        this.tblMain.removeRows();
        this.loadCompetIndex();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PEOPLE_ORGANIZATION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCompetIndex() throws Exception {
        this.tblMain.checkParsed();
        IMetaDataPK metaDataPK = this.queryPositionOfPosiQualPK;
        IQueryExecutor queryExec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)metaDataPK);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Position.id", (Object)this.curPositionId));
        entityViewInfo.setFilter(filter);
        queryExec.setObjectView(entityViewInfo);
        String perSql = KSqlUtil.optimize((String)queryExec.getSQL());
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)perSql.toString());
        IRowSet rs = null;
        try {
            rs = exec.executeSQL();
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        try {
            if (rs != null) {
                while (rs.next()) {
                    if (rs.getString(1) == null) continue;
                    IRow row = null;
                    row = this.tblMain.addRow();
                    row.getCell("id").setValue((Object)rs.getString("id"));
                    row.getCell("name").setValue((Object)rs.getString("POSIQUALIFICATIONNAME"));
                    row.getCell("type.name").setValue((Object)rs.getString("POSIQUALIFICATIONTYPE"));
                    row.getCell("description").setValue((Object)rs.getString("POSIQUALIFICATIONDESCRIPTION"));
                }
            }
        }
        catch (SQLException e) {
            this.handleException(e);
        }
        finally {
            rs.close();
        }
    }
}

