/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.hr.base.client.HRBillEditUIBiz;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.base.client.f7.EditorCreator;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.standby.IStandBySelect;
import com.kingdee.eas.hr.standby.IStandbyPerson;
import com.kingdee.eas.hr.standby.StandBySelectEntryInfo;
import com.kingdee.eas.hr.standby.StandBySelectFactory;
import com.kingdee.eas.hr.standby.StandbyPersonCollection;
import com.kingdee.eas.hr.standby.StandbyPersonFactory;
import com.kingdee.eas.hr.standby.StandbyPersonInfo;
import com.kingdee.eas.hr.standby.StandbyTypeInfo;
import com.kingdee.eas.hr.standby.client.StandbyTypePromptBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class StandBySelectEditUIBiz
extends HRBillEditUIBiz {
    protected IObjectValue createNewDetailData(PersonInfo info) {
        StandBySelectEntryInfo entry = new StandBySelectEntryInfo();
        entry.setPerson(info);
        PositionInfo ppInfo = (PositionInfo)info.get("personselectposition");
        if (ppInfo != null) {
            entry.setPosition(ppInfo);
            entry.setAdminOrg(ppInfo.getAdminOrgUnit());
        }
        return entry;
    }

    protected boolean isAddPersonByF7() {
        return true;
    }

    public void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.kdtEntrys.getStyleAttributes().setWrapText(true);
    }

    protected void fillRow(IRow row, Object value, IRow dataRow, int copyCol) throws Exception {
        super.fillRow(row, value, dataRow, copyCol);
        int colIndex = row.getCell("targetPostion").getColumnIndex();
        if (colIndex == copyCol) {
            PositionInfo pInfo = (PositionInfo)value;
            ICell cell = row.getCell("targetPositionOrg");
            if (pInfo != null) {
                cell.setValue((Object)pInfo.getAdminOrgUnit());
            } else {
                cell.setValue(null);
            }
        }
    }

    public void entryEditStopped(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        IRow row = this.kdtEntrys.getRow(rowIndex);
        if (colIndex == this.kdtEntrys.getColumn("targetPostion").getColumnIndex()) {
            PositionInfo pInfo = (PositionInfo)e.getValue();
            if (pInfo != null && !pInfo.equals(e.getOldValue())) {
                row.getCell("targetPositionOrg").setValue((Object)pInfo.getAdminOrgUnit());
            } else if (pInfo == null) {
                row.getCell("targetPositionOrg").setValue(null);
            }
        }
    }

    protected String[] getNotNullColumn() {
        return new String[]{"standByType", "bizDate"};
    }

    public void registerContextChangeF7(IHRF7CommonRegister register) {
        super.registerContextChangeF7(register);
        KDBizPromptBox prmtPosition = new KDBizPromptBox();
        register.registerPositionPromptBox2(prmtPosition, this.kdtEntrys.getColumn("targetPostion"));
        PositionPromptBox2 position = (PositionPromptBox2)prmtPosition.getSelector();
        position.setSealUp("false");
        KDBizPromptBox prmtAdminOrg = new KDBizPromptBox();
        register.registerAdminByOrgRangePromptBox(prmtAdminOrg, this.kdtEntrys.getColumn("targetAdminOrg"));
        AdminByOrgRangePromptBox adminF7 = (AdminByOrgRangePromptBox)prmtAdminOrg.getSelector();
        adminF7.setIncludeSealUp("false");
        ObjectValueRender kdtEntrys_standByType_OVR = new ObjectValueRender();
        kdtEntrys_standByType_OVR.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtEntrys.getColumn("standByType").setRenderer((IBasicRender)kdtEntrys_standByType_OVR);
        KDDatePicker kdtEntrys_bizDate_DatePicker = new KDDatePicker();
        kdtEntrys_bizDate_DatePicker.setName("kdtEntrys_bizDate_DatePicker");
        kdtEntrys_bizDate_DatePicker.setVisible(true);
        kdtEntrys_bizDate_DatePicker.setEditable(true);
        KDTDefaultCellEditor kdtEntrys_bizDate_CellEditor = new KDTDefaultCellEditor(kdtEntrys_bizDate_DatePicker);
        this.kdtEntrys.getColumn("bizDate").setEditor((ICellEditor)kdtEntrys_bizDate_CellEditor);
        this.kdtEntrys.getColumn("applyReason").setEditor(EditorCreator.getTextCellEditor((int)200));
        this.kdtEntrys.getColumn("auditResult").setEditor(EditorCreator.getTextCellEditor((int)200));
    }

    public void beforeStoreField(ActionEvent e) throws Exception {
        super.beforeStoreField(e);
        this.verifyNullInfo();
        this.verifyStandbyTypePerson();
        this.verifySameCasePerson();
        this.verifyMaxNumberStandbyPerson();
        this.verifyStandbyInfo();
        this.verifyCountPosition();
    }

    private void verifyStandbyTypePerson() {
        StringBuffer rowErr = new StringBuffer();
        IRow row = null;
        HashMap personMap = new HashMap();
        StandbyTypeInfo typeInfo = null;
        Set<String> typeSet = new HashSet<String>();
        String personId = null;
        PersonInfo nowPerInfo = null;
        int size = this.kdtEntrys.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.kdtEntrys.getRow(i);
            nowPerInfo = (PersonInfo)row.getCell("person").getValue();
            typeInfo = (StandbyTypeInfo)row.getCell("standByType").getValue();
            personId = nowPerInfo.getId().toString();
            if (personMap.get(personId) == null) {
                typeSet.add(typeInfo.getId().toString());
            } else {
                typeSet = (Set)personMap.get(personId);
                typeSet.add(typeInfo.getId().toString());
                if (typeSet.size() >= 2) {
                    rowErr.append(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"NO")).append(i + 1).append(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"ROW")).append(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"EMPLOYEE_CANNOT_HAVE_DIFFTYPE")).append("\n");
                }
            }
            personMap.put(personId, typeSet);
            if (rowErr.length() <= 0) continue;
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"EXIST_INVALIDATE_STANDBYPERSON_PLEASELOOKUP"), (String)rowErr.toString(), (int)1);
            SysUtil.abort();
        }
    }

    private void verifyNullInfo() throws BOSException, EASBizException {
        int i;
        StringBuffer rowErr = new StringBuffer();
        StringBuffer idBuffer = new StringBuffer();
        PersonInfo nowPerInfo = null;
        Object targetPostion = null;
        Object targetAdminOrg = null;
        IRow row = null;
        int size = this.kdtEntrys.getRowCount();
        for (i = 0; i < size; ++i) {
            row = this.kdtEntrys.getRow(i);
            nowPerInfo = (PersonInfo)row.getCell("person").getValue();
            idBuffer.append(nowPerInfo.getId().toString()).append(",");
        }
        size = this.kdtEntrys.getRowCount();
        for (i = 0; i < size; ++i) {
            row = this.kdtEntrys.getRow(i);
            targetPostion = row.getCell("targetPostion").getValue();
            targetAdminOrg = row.getCell("targetAdminOrg").getValue();
            if (targetPostion == null && targetAdminOrg == null) {
                rowErr.append(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"NO")).append(i + 1).append(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"ROW")).append(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"TOPOSITION_TOUNIT_CANNOT_ALLEMPTY")).append("\n");
                continue;
            }
            if (targetPostion == null || targetAdminOrg == null) continue;
            rowErr.append(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"NO")).append(i + 1).append(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"ROW")).append(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"TOPOSITION_TOUNIT_CANNOT_SELECTALL")).append("\n");
        }
        if (rowErr.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"EXIST_INVALIDATE_STANDBYPERSON_PLEASELOOKUP"), (String)rowErr.toString(), (int)1);
            SysUtil.abort();
        }
    }

    private void verifySameCasePerson() {
        StringBuffer rowErr = new StringBuffer();
        IRow row = null;
        PersonInfo nowPerInfo = null;
        PositionInfo targetPostion = null;
        HashSet<String> infoSet = new HashSet<String>();
        AdminOrgUnitInfo targetAdminOrg = null;
        String compId = null;
        HashMap<String, Integer> lineInfoMap = new HashMap<String, Integer>();
        int size = this.kdtEntrys.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.kdtEntrys.getRow(i);
            nowPerInfo = (PersonInfo)row.getCell("person").getValue();
            targetPostion = (PositionInfo)row.getCell("targetPostion").getValue();
            targetAdminOrg = (AdminOrgUnitInfo)row.getCell("targetAdminOrg").getValue();
            if (targetPostion != null) {
                compId = nowPerInfo.getId().toString() + "~" + targetPostion.getId().toString();
                if (infoSet.contains(compId)) {
                    rowErr.append(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"NO")).append(lineInfoMap.get(compId)).append(",").append(i + 1).append(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"ROW")).append(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"DUPLICATE_SELECT_PERSON_INFO")).append("\n");
                    continue;
                }
                infoSet.add(compId);
                lineInfoMap.put(compId, i + 1);
                continue;
            }
            if (targetAdminOrg == null) continue;
            compId = nowPerInfo.getId().toString() + "~" + targetAdminOrg.getId().toString();
            if (infoSet.contains(compId)) {
                rowErr.append(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"NO")).append(lineInfoMap.get(compId)).append(",").append(i + 1).append(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"ROW")).append(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"DUPLICATE_SELECT_PERSON_INFO")).append("\n");
                continue;
            }
            infoSet.add(compId);
            lineInfoMap.put(compId, i + 1);
        }
        if (rowErr.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"EXIST_INVALIDATE_STANDBYPERSON_PLEASELOOKUP"), (String)rowErr.toString(), (int)1);
            SysUtil.abort();
        }
    }

    private void verifyMaxNumberStandbyPerson() throws BOSException, EASBizException {
        StringBuffer rowErr = new StringBuffer();
        IRow row = null;
        PersonInfo nowPerInfo = null;
        String personId = "";
        HashSet<String> personSet = new HashSet<String>();
        int size = this.kdtEntrys.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.kdtEntrys.getRow(i);
            nowPerInfo = (PersonInfo)row.getCell("person").getValue();
            personId = nowPerInfo.getId().toString();
            personSet.add(personId);
        }
        IStandBySelect standBySelect = StandBySelectFactory.getRemoteInstance();
        Map standyMap = standBySelect.getStandbyPersonNum(personSet);
        int size2 = this.kdtEntrys.getRowCount();
        for (int i = 0; i < size2; ++i) {
            row = this.kdtEntrys.getRow(i);
            nowPerInfo = (PersonInfo)row.getCell("person").getValue();
            personId = nowPerInfo.getId().toString();
            if (standyMap.get(personId) != null) {
                Integer num = (Integer)standyMap.get(nowPerInfo.getId().toString());
                num = num + 1;
                standyMap.put(personId, num);
                if (num <= 3) continue;
                rowErr.append(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"NO")).append(i + 1).append(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"ROW")).append(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"MAX_NUMBER_SELECT_ERROR")).append("\n");
                continue;
            }
            standyMap.put(personId, 1);
        }
        if (rowErr.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"EXIST_INVALIDATE_STANDBYPERSON_PLEASELOOKUP"), (String)rowErr.toString(), (int)1);
            SysUtil.abort();
        }
    }

    private void verifyStandbyInfo() throws BOSException, EASBizException {
        IStandBySelect iStandBySelect = StandBySelectFactory.getRemoteInstance();
        StandbyPersonCollection personCollection = new StandbyPersonCollection();
        IRow row = null;
        StandbyPersonInfo standByPerson = null;
        int size = this.kdtEntrys.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.kdtEntrys.getRow(i);
            standByPerson = new StandbyPersonInfo();
            standByPerson.setEmployee((PersonInfo)row.getCell("person").getValue());
            standByPerson.setToPosition((PositionInfo)row.getCell("targetPostion").getValue());
            standByPerson.setToUnit((AdminOrgUnitInfo)row.getCell("targetAdminOrg").getValue());
            standByPerson.setStandbyType((StandbyTypeInfo)row.getCell("standByType").getValue());
            personCollection.add(standByPerson);
        }
        HashMap<String, IObjectValue> paramMap = new HashMap<String, IObjectValue>();
        paramMap.put("currentBill", this.ctx.getEditData());
        iStandBySelect.verifyStandbyPerson((IObjectCollection)personCollection, paramMap);
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) throws Exception {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.getNewOrg() instanceof HROrgUnitInfo) {
            HROrgUnitInfo hrInfo = (HROrgUnitInfo)chgVo.getNewOrg();
            KDBizPromptBox prmtStandbyType = new KDBizPromptBox();
            StandbyTypePromptBox selector = new StandbyTypePromptBox();
            HashSet<String> cuSet = new HashSet<String>();
            cuSet.add(hrInfo.getCU().getId().toString());
            selector.changeContextByCUSet(cuSet);
            prmtStandbyType.setSelector((KDPromptSelector)selector);
            prmtStandbyType.setEditable(false);
            this.kdtEntrys.getColumn("standByType").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtStandbyType));
        }
    }

    private void verifyCountPosition() throws BOSException, EASBizException {
        HashSet<String> set = new HashSet<String>();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        HashMap<String, String> positionNameMap = new HashMap<String, String>();
        IRow row = null;
        String targetPosition = null;
        int size = this.kdtEntrys.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.kdtEntrys.getRow(i);
            if (row.getCell("targetPostion").getValue() == null) continue;
            targetPosition = ((PositionInfo)row.getCell("targetPostion").getValue()).getId().toString();
            set.add(targetPosition);
            positionNameMap.put(targetPosition, ((PositionInfo)row.getCell("targetPostion").getValue()).getName());
            if (map.get(targetPosition) == null) {
                map.put(targetPosition, 1);
                continue;
            }
            Integer num = (Integer)map.get(targetPosition);
            map.put(targetPosition, num + 1);
        }
        if (set.size() > 0) {
            IStandbyPerson standbyPerson = StandbyPersonFactory.getRemoteInstance();
            Map positionMap = standbyPerson.getCountByPosition(set);
            String key = null;
            int num = 0;
            int positionNum = 0;
            Object positionName = null;
            for (Map.Entry entry : map.entrySet()) {
                key = (String)entry.getKey();
                num = (Integer)entry.getValue();
                if (num > 3) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"TargetPosLimit"));
                    SysUtil.abort();
                }
                if (!positionMap.containsKey(key) || num + (positionNum = ((Integer)positionMap.get(key)).intValue()) <= 3) continue;
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"TargetPosLimit"));
                SysUtil.abort();
            }
        }
    }
}

