/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.standby.IStandbyPersonAuditRecord;
import com.kingdee.eas.hr.standby.IStandbyPersonCourse;
import com.kingdee.eas.hr.standby.IStandbyPersonPlan;
import com.kingdee.eas.hr.standby.StandbyException;
import com.kingdee.eas.hr.standby.StandbyPersonAuditRecordCollection;
import com.kingdee.eas.hr.standby.StandbyPersonAuditRecordFactory;
import com.kingdee.eas.hr.standby.StandbyPersonAuditRecordInfo;
import com.kingdee.eas.hr.standby.StandbyPersonCourseCollection;
import com.kingdee.eas.hr.standby.StandbyPersonCourseFactory;
import com.kingdee.eas.hr.standby.StandbyPersonCourseInfo;
import com.kingdee.eas.hr.standby.StandbyPersonFactory;
import com.kingdee.eas.hr.standby.StandbyPersonInfo;
import com.kingdee.eas.hr.standby.StandbyPersonPlanCollection;
import com.kingdee.eas.hr.standby.StandbyPersonPlanFactory;
import com.kingdee.eas.hr.standby.StandbyPersonPlanInfo;
import com.kingdee.eas.hr.standby.StandbyTrainingItemFactory;
import com.kingdee.eas.hr.standby.StandbyTrainingItemInfo;
import com.kingdee.eas.hr.standby.client.AbstractStandbyPersonAuditRecordUI;
import com.kingdee.eas.hr.standby.client.IStandbyPersonEditUI;
import com.kingdee.eas.hr.standby.client.PlanProject;
import com.kingdee.eas.hr.standby.client.StandbyUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class StandbyPersonAuditRecordUI
extends AbstractStandbyPersonAuditRecordUI
implements IStandbyPersonEditUI {
    private static final Logger logger = CoreUIObject.getLogger(StandbyPersonAuditRecordUI.class);
    private String empId = null;
    private ArrayList deleteRecordIds = new ArrayList();
    private KDComboBox cboPlanProject = new KDComboBox();
    private int curCourRowID = -1;
    private static final String dateFormatStr = "%r{yyyy-MM-dd}t";
    private StandbyPersonCourseCollection oldCourCol = null;
    private StandbyPersonCourseCollection newCourCol = null;
    private StandbyPersonAuditRecordCollection oldAuditCol = null;
    private StandbyPersonAuditRecordCollection newAuditCol = null;

    public void onLoad() throws Exception {
        this.setStandbyPersonId(this.getUIContext().get("ID").toString());
        super.onLoad();
        this.setTableCellEditor();
        this.firstLoad();
        this.oldCourCol = this.getAllTraceCollection();
        this.oldAuditCol = this.getAllRecordCollection();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddTrainTrace.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDeleteTrainTrace.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnAddTrainTrace.setEnabled(true);
        this.btnDeleteTrainTrace.setEnabled(true);
        this.btnAddReviewRecord.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDeleteReviewRecord.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnAddReviewRecord.setEnabled(true);
        this.btnDeleteReviewRecord.setEnabled(true);
        this.tblTrainTrace.getStyleAttributes().setWrapText(true);
        this.tblTrainTrace.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblTrainTrace.getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        this.tblReviewRecord.getStyleAttributes().setWrapText(true);
        this.tblReviewRecord.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblReviewRecord.getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        this.setControlProperties();
    }

    private void setControlProperties() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.tblTrainTrace.getStyleAttributes().setLocked(true);
            this.btnAddTrainTrace.setEnabled(false);
            this.btnDeleteTrainTrace.setEnabled(false);
            this.tblReviewRecord.getStyleAttributes().setLocked(true);
            this.btnAddReviewRecord.setEnabled(false);
            this.btnDeleteReviewRecord.setEnabled(false);
        }
    }

    private void setTableCellEditor() throws Exception {
        this.tblTrainTrace.checkParsed();
        this.tblTrainTrace.getColumn("personPlan").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cboPlanProject));
        this.tblTrainTrace.getColumn("personPlan").getStyleAttributes().setBackground(StandbyUtils.MUSTINPUT_BGCOLOR);
        KDTextField txtSummary1 = new KDTextField();
        txtSummary1.setMaxLength(200);
        this.tblTrainTrace.getColumn("summary").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtSummary1));
        this.tblTrainTrace.getColumn("realBeginDate").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblTrainTrace.getColumn("realBeginDate").getStyleAttributes().setNumberFormat(dateFormatStr);
        this.tblTrainTrace.getColumn("realEndDate").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblTrainTrace.getColumn("realEndDate").getStyleAttributes().setNumberFormat(dateFormatStr);
        KDTextField txtRealResult = new KDTextField();
        txtRealResult.setMaxLength(200);
        this.tblTrainTrace.getColumn("realResult").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtRealResult));
        KDTextField txtIsReachTarget = new KDTextField();
        txtIsReachTarget.setMaxLength(80);
        this.tblTrainTrace.getColumn("isReachTarget").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtIsReachTarget));
        KDTextField txtFailReason = new KDTextField();
        txtFailReason.setMaxLength(200);
        this.tblTrainTrace.getColumn("failReason").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtFailReason));
        this.cboPlanProject.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (StandbyPersonAuditRecordUI.this.cboPlanProject.getSelectedItem() == null) {
                    return;
                }
                String planId = ((PlanProject)StandbyPersonAuditRecordUI.this.cboPlanProject.getSelectedItem()).getId();
                try {
                    StandbyPersonAuditRecordUI.this.tblTrainTrace.getRow(StandbyPersonAuditRecordUI.this.curCourRowID).getCell("summary").setValue((Object)StandbyPersonAuditRecordUI.this.getSummaryByPlan(planId));
                }
                catch (EASBizException e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
                catch (BOSException e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.tblTrainTrace.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                StandbyPersonAuditRecordUI.this.curCourRowID = e.getRowIndex();
                try {
                    if (e.getColIndex() == 1) {
                        StandbyPersonAuditRecordUI.this.loadCboPlanProject(StandbyPersonAuditRecordUI.this.empId);
                    }
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.tblReviewRecord.checkParsed();
        KDTextField txtProject = new KDTextField();
        txtProject.setMaxLength(80);
        this.tblReviewRecord.getColumn("project").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtProject));
        this.tblReviewRecord.getColumn("project").getStyleAttributes().setBackground(StandbyUtils.MUSTINPUT_BGCOLOR);
        KDTextField txtResult = new KDTextField();
        txtResult.setMaxLength(200);
        this.tblReviewRecord.getColumn("result").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtResult));
        this.tblReviewRecord.getColumn("result").getStyleAttributes().setBackground(StandbyUtils.MUSTINPUT_BGCOLOR);
        KDTextField txtExcellence = new KDTextField();
        txtExcellence.setMaxLength(80);
        this.tblReviewRecord.getColumn("excellence").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtExcellence));
        KDTextField txtShortage = new KDTextField();
        txtShortage.setMaxLength(80);
        this.tblReviewRecord.getColumn("shortage").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtShortage));
        KDTextField txtSumUp = new KDTextField();
        txtSumUp.setMaxLength(200);
        this.tblReviewRecord.getColumn("sumUp").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtSumUp));
    }

    public void setStandbyPersonId(String standbyPersonId) throws Exception {
        StandbyPersonInfo sbPerInfo = StandbyPersonFactory.getRemoteInstance().getStandbyPersonInfo((IObjectPK)new ObjectUuidPK(standbyPersonId));
        this.empId = sbPerInfo.getEmployee().getId().toString();
    }

    private void firstLoad() throws Exception {
        this.loadAllTraceAndRecordByEmployee();
    }

    public void secondLoad() throws Exception {
        this.loadAllTraceAndRecordByEmployee();
    }

    private void loadAllTraceAndRecordByEmployee() throws BOSException, EASBizException {
        this.tblTrainTrace.checkParsed();
        this.tblTrainTrace.removeRows();
        EntityViewInfo traceView = new EntityViewInfo();
        FilterInfo traceFilter = new FilterInfo();
        traceFilter.getFilterItems().add(new FilterItemInfo("plan.employee", (Object)this.empId));
        try {
            FilterInfo filter = new FilterInfo("isAudited = 1");
            traceFilter.mergeFilter(filter, "and");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        traceView.setFilter(traceFilter);
        StandbyPersonCourseCollection courCol = StandbyPersonCourseFactory.getRemoteInstance().getStandbyPersonCourseCollection(traceView);
        int size = courCol.size();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblTrainTrace.addRow();
            StandbyPersonCourseInfo courInfo = courCol.get(i);
            if (courInfo.getPlan() != null) {
                StandbyPersonPlanInfo planInfo = StandbyPersonPlanFactory.getRemoteInstance().getStandbyPersonPlanInfo((IObjectPK)new ObjectUuidPK(courInfo.getPlan().getId()));
                StandbyTrainingItemInfo trainingItem = StandbyTrainingItemFactory.getRemoteInstance().getStandbyTrainingItemInfo("where id = '" + planInfo.getTrainingItem().getId().toString() + "'");
                PlanProject planPrj = new PlanProject(planInfo.getId().toString(), trainingItem.getName());
                row.getCell("personPlan").setValue((Object)planPrj);
            }
            if (courInfo.getSummary() != null) {
                row.getCell("summary").setValue((Object)courInfo.getSummary());
            }
            if (courInfo.getRealBeginDate() != null) {
                row.getCell("realBeginDate").setValue((Object)courInfo.getRealBeginDate());
            }
            if (courInfo.getRealEndDate() != null) {
                row.getCell("realEndDate").setValue((Object)courInfo.getRealEndDate());
            }
            if (courInfo.getRealResult() != null) {
                row.getCell("realResult").setValue((Object)courInfo.getRealResult());
            }
            if (courInfo.getIsReachTarget() != null) {
                row.getCell("isReachTarget").setValue((Object)courInfo.getIsReachTarget());
            }
            if (courInfo.getFailReason() == null) continue;
            row.getCell("failReason").setValue((Object)courInfo.getFailReason());
        }
        this.tblReviewRecord.checkParsed();
        this.tblReviewRecord.removeRows();
        EntityViewInfo recordView = new EntityViewInfo();
        FilterInfo recordFilter = new FilterInfo();
        recordFilter.getFilterItems().add(new FilterItemInfo("employee", (Object)this.empId));
        try {
            FilterInfo filter = new FilterInfo("isAudited = 1");
            recordFilter.mergeFilter(filter, "and");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        recordView.setFilter(recordFilter);
        StandbyPersonAuditRecordCollection auditCol = StandbyPersonAuditRecordFactory.getRemoteInstance().getStandbyPersonAuditRecordCollection(recordView);
        int size2 = auditCol.size();
        for (int i = 0; i < size2; ++i) {
            IRow row = this.tblReviewRecord.addRow();
            StandbyPersonAuditRecordInfo auditInfo = auditCol.get(i);
            row.getCell("id").setValue((Object)auditInfo.getId().toString());
            if (auditInfo.getProject() != null) {
                row.getCell("project").setValue((Object)auditInfo.getProject());
            }
            if (auditInfo.getResult() != null) {
                row.getCell("result").setValue((Object)auditInfo.getResult());
            }
            if (auditInfo.getExcellence() != null) {
                row.getCell("excellence").setValue((Object)auditInfo.getExcellence());
            }
            if (auditInfo.getShortAge() != null) {
                row.getCell("shortage").setValue((Object)auditInfo.getShortAge());
            }
            if (auditInfo.getSumUp() == null) continue;
            row.getCell("sumUp").setValue((Object)auditInfo.getSumUp());
        }
    }

    public boolean saveInfo() throws Exception {
        this.checkTraceInput();
        this.checkRecordInput();
        IStandbyPersonCourse iCour = StandbyPersonCourseFactory.getRemoteInstance();
        iCour.updateBatchPersonCourse(this.getAllTraceCollection(), this.empId);
        IStandbyPersonAuditRecord iAudit = StandbyPersonAuditRecordFactory.getRemoteInstance();
        iAudit.updateBatchAuditRecord(this.getAllRecordCollection(), this.deleteRecordIds);
        this.loadAllTraceAndRecordByEmployee();
        this.deleteRecordIds = new ArrayList();
        this.oldCourCol = this.getAllTraceCollection();
        this.oldAuditCol = this.getAllRecordCollection();
        return true;
    }

    private void checkRecordInput() throws StandbyException {
        int length = this.tblReviewRecord.getRowCount();
        for (int i = 0; i < length; ++i) {
            IRow row = this.tblReviewRecord.getRow(i);
            if (row.getCell("project").getValue() == null || row.getCell("project").getValue().toString().trim().equals("")) {
                throw new StandbyException(StandbyException.PROJECT_CANNOT_EMPTY);
            }
            if (row.getCell("result").getValue() != null && !row.getCell("result").getValue().toString().trim().equals("")) continue;
            throw new StandbyException(StandbyException.RESULT_CANNOT_EMPTY);
        }
    }

    private void checkTraceInput() throws StandbyException {
        int length = this.tblTrainTrace.getRowCount();
        for (int i = 0; i < length; ++i) {
            IRow row = this.tblTrainTrace.getRow(i);
            if (row.getCell("personPlan").getValue() == null) {
                throw new StandbyException(StandbyException.COURSEPROJECT_CANNOT_EMPTY);
            }
            if (row.getCell("realBeginDate").getValue() == null && row.getCell("realEndDate").getValue() != null || row.getCell("realBeginDate").getValue() != null && row.getCell("realEndDate").getValue() == null) {
                throw new StandbyException(StandbyException.COURSE_BEGINDATE_ENDDATE_NEEDALL);
            }
            if (row.getCell("realBeginDate").getValue() == null || row.getCell("realEndDate").getValue() == null || !DateTimeUtils.dayAfter((Date)((Date)row.getCell("realBeginDate").getValue()), (Date)((Date)row.getCell("realEndDate").getValue()))) continue;
            throw new StandbyException(StandbyException.COURSE_BEGINDATE_CANNOT_AFTER_ENDDATE);
        }
    }

    private StandbyPersonCourseCollection getAllTraceCollection() {
        StandbyPersonCourseCollection courCol = new StandbyPersonCourseCollection();
        int length = this.tblTrainTrace.getRowCount();
        for (int i = 0; i < length; ++i) {
            IRow row = this.tblTrainTrace.getRow(i);
            StandbyPersonCourseInfo courInfo = new StandbyPersonCourseInfo();
            StandbyPersonPlanInfo planInfo = new StandbyPersonPlanInfo();
            if (row.getCell("personPlan").getValue() != null) {
                planInfo.setId(BOSUuid.read((String)((PlanProject)row.getCell("personPlan").getValue()).getId()));
            }
            courInfo.setPlan(planInfo);
            if (row.getCell("summary").getValue() != null) {
                courInfo.setSummary(row.getCell("summary").getValue().toString());
            } else {
                courInfo.setSummary("");
            }
            courInfo.setRealBeginDate((Date)row.getCell("realBeginDate").getValue());
            courInfo.setRealEndDate((Date)row.getCell("realEndDate").getValue());
            if (row.getCell("realResult").getValue() != null) {
                courInfo.setRealResult(row.getCell("realResult").getValue().toString());
            } else {
                courInfo.setRealResult("");
            }
            if (row.getCell("isReachTarget").getValue() != null) {
                courInfo.setIsReachTarget(row.getCell("isReachTarget").getValue().toString());
            } else {
                courInfo.setIsReachTarget("");
            }
            if (row.getCell("failReason").getValue() != null) {
                courInfo.setFailReason(row.getCell("failReason").getValue().toString());
            } else {
                courInfo.setFailReason("");
            }
            courCol.add(courInfo);
        }
        return courCol;
    }

    private StandbyPersonAuditRecordCollection getAllRecordCollection() {
        StandbyPersonAuditRecordCollection auditCol = new StandbyPersonAuditRecordCollection();
        int length = this.tblReviewRecord.getRowCount();
        for (int i = 0; i < length; ++i) {
            IRow row = this.tblReviewRecord.getRow(i);
            StandbyPersonAuditRecordInfo auditInfo = new StandbyPersonAuditRecordInfo();
            PersonInfo perInfo = new PersonInfo();
            perInfo.setId(BOSUuid.read((String)this.empId));
            auditInfo.setEmployee(perInfo);
            if (row.getCell("id").getValue() != null) {
                auditInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
            }
            if (row.getCell("project").getValue() != null) {
                auditInfo.setProject(row.getCell("project").getValue().toString());
            }
            if (row.getCell("result").getValue() != null) {
                auditInfo.setResult(row.getCell("result").getValue().toString());
            }
            if (row.getCell("excellence").getValue() != null) {
                auditInfo.setExcellence(row.getCell("excellence").getValue().toString());
            } else {
                auditInfo.setExcellence("");
            }
            if (row.getCell("shortage").getValue() != null) {
                auditInfo.setShortAge(row.getCell("shortage").getValue().toString());
            } else {
                auditInfo.setShortAge("");
            }
            if (row.getCell("sumUp").getValue() != null) {
                auditInfo.setSumUp(row.getCell("sumUp").getValue().toString());
            } else {
                auditInfo.setSumUp("");
            }
            auditCol.add(auditInfo);
        }
        return auditCol;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PEOPLE_ORGANIZATION;
    }

    private String getSummaryByPlan(String planId) throws EASBizException, BOSException {
        String strSummary = "";
        if (planId != null) {
            IStandbyPersonPlan iPlan = StandbyPersonPlanFactory.getRemoteInstance();
            StandbyPersonPlanInfo planInfo = iPlan.getStandbyPersonPlanInfo((IObjectPK)new ObjectUuidPK(planId));
            strSummary = planInfo.getSummary();
        }
        return strSummary;
    }

    private void loadCboPlanProject(String empId) throws BOSException, EASBizException {
        DefaultComboBoxModel<PlanProject> model = new DefaultComboBoxModel<PlanProject>();
        IStandbyPersonPlan iPlan = StandbyPersonPlanFactory.getRemoteInstance();
        StandbyPersonPlanCollection infos = iPlan.getStandbyPersonPlanCollection("Select * Where employee = '" + empId + "'");
        if (infos.size() > 0) {
            int size = infos.size();
            for (int i = 0; i < size; ++i) {
                StandbyPersonPlanInfo planInfo = infos.get(i);
                StandbyTrainingItemInfo trainingItem = StandbyTrainingItemFactory.getRemoteInstance().getStandbyTrainingItemInfo("where id = '" + planInfo.getTrainingItem().getId().toString() + "'");
                PlanProject planPrj = new PlanProject(planInfo.getId().toString(), trainingItem.getName());
                model.addElement(planPrj);
            }
            this.cboPlanProject.setModel(model);
            this.tblTrainTrace.getColumn("personPlan").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cboPlanProject));
        }
    }

    public void actionAddTrainTrace_actionPerformed(ActionEvent e) throws Exception {
        this.tblTrainTrace.addRow();
    }

    public void actionDeleteTrainTrace_actionPerformed(ActionEvent e) throws Exception {
        this.tblTrainTrace.removeRow(KDTableUtil.getSelectedRow((KDTable)this.tblTrainTrace));
    }

    public void actionAddReviewRecord_actionPerformed(ActionEvent e) throws Exception {
        this.tblReviewRecord.addRow();
    }

    public void actionDeleteReviewRecord_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblReviewRecord);
        if (rowIndex < 0 || rowIndex >= this.tblReviewRecord.getRowCount()) {
            return;
        }
        ICell cell = this.tblReviewRecord.getRow(rowIndex).getCell("id");
        if (cell.getValue() != null) {
            this.deleteRecordIds.add(cell.getValue().toString());
        }
        this.tblReviewRecord.removeRow(rowIndex);
    }

    public boolean isModify() {
        this.newCourCol = this.getAllTraceCollection();
        this.newAuditCol = this.getAllRecordCollection();
        return this.oldCourCol == null && this.newCourCol != null || this.oldCourCol != null && this.newCourCol == null || this.oldCourCol != null && this.newCourCol != null && !this.oldCourCol.equals((Object)this.newCourCol) || this.oldAuditCol == null && this.newAuditCol != null || this.oldAuditCol != null && this.newAuditCol == null || this.oldAuditCol != null && this.newAuditCol != null && !this.oldAuditCol.equals((Object)this.newAuditCol);
    }
}

