/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.org.util.HROrgContextManageUtil;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.org.client.AllAdminPromptBox;
import com.kingdee.eas.hr.standby.IStandbyPerson;
import com.kingdee.eas.hr.standby.StandbyPersonCollection;
import com.kingdee.eas.hr.standby.StandbyPersonFactory;
import com.kingdee.eas.hr.standby.StandbyPersonInfo;
import com.kingdee.eas.hr.standby.StandbyTypeFactory;
import com.kingdee.eas.hr.standby.StandbyTypeInfo;
import com.kingdee.eas.hr.standby.client.AbstractStandbyPersonChangeUI;
import com.kingdee.eas.hr.standby.client.StandbyTypePromptBox;
import com.kingdee.eas.hr.standby.client.StandbyUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class StandbyPersonChangeUI
extends AbstractStandbyPersonChangeUI {
    private static final Logger logger = CoreUIObject.getLogger(StandbyPersonChangeUI.class);
    private int rowID = -1;
    private String personChangeUIState = null;
    private Object selectedObj = null;
    private static final String TOSTANDBY = "TOSTANDBY";
    private static final String NEWSTANDBY = "NEWSTANDBY";
    private EmployeeMultiF7PromptBox personMultiBox = null;
    private final Color CANNOT_INPUT_COLOR = new Color(208, 208, 208);

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.personChangeUIState = this.getUIContext().get("personChangeUIState").toString();
        super.onLoad();
        this.personMultiBox = new EmployeeMultiF7PromptBox((IUIObject)this);
        this.setTableCellEditor();
        if (this.personChangeUIState.equals(TOSTANDBY)) {
            this.selectedObj = this.getUIContext().get("selectedObj");
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.TOSTANDBYPERSON_TITLE"));
            PersonCollection perCol = (PersonCollection)this.getUIContext().get("toStandbyPersonCol");
            this.loadToStandbyPerson(perCol);
        } else if (this.personChangeUIState.equals(NEWSTANDBY)) {
            this.selectedObj = this.getUIContext().get("selectedObj");
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.ADDNEW_STANDBYPERSON_TITILE"));
            this.addNewInitRow();
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnNew.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnSelectCopy.setIcon(EASResource.getIcon((String)"imgTbtn_electcopy"));
        this.btnSave.setEnabled(true);
        this.actionSubmit.setEnabled(false);
        this.menuTool.remove(0);
        this.menuBiz.setVisible(false);
        this.tblMain.getStyleAttributes().setWrapText(true);
        this.tblMain.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblMain.getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.MIDDLE);
    }

    private void addNewInitRow() {
        IRow newRow = this.tblMain.addRow();
        this.fillRowToPosOrToUnit(newRow, 0);
        this.fillRowToDate();
    }

    private void setTableCellEditor() throws Exception {
        this.tblMain.checkParsed();
        HROrgUnitCollection hrOrgUnitInfos = (HROrgUnitCollection)this.getUIContext().get("multi_org_context");
        this.personMultiBox.setIsSingleSelect(false);
        this.personMultiBox.setUserOrgRangeFilter(true);
        if (hrOrgUnitInfos != null && hrOrgUnitInfos.size() > 0) {
            HashSet<String> hrSet = new HashSet<String>();
            hrSet.add(hrOrgUnitInfos.get(0).getId().toString());
            this.personMultiBox.setHROFilter(hrSet);
        }
        KDBizPromptBox prmtPersonBox = new KDBizPromptBox();
        prmtPersonBox.setSelector((KDPromptSelector)this.personMultiBox);
        prmtPersonBox.setDisplayFormat("$name$");
        prmtPersonBox.setEditFormat("$number$");
        prmtPersonBox.setCommitFormat("$number$");
        prmtPersonBox.setEditable(false);
        this.tblMain.getColumn("empName").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtPersonBox));
        this.tblMain.getColumn("empName").getStyleAttributes().setBackground(StandbyUtils.MUSTINPUT_BGCOLOR);
        this.tblMain.getColumn("empUnit").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("empUnit").getStyleAttributes().setBackground(this.CANNOT_INPUT_COLOR);
        this.tblMain.getColumn("empPosition").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("empPosition").getStyleAttributes().setBackground(this.CANNOT_INPUT_COLOR);
        KDBizPromptBox prmtPositionBox = new KDBizPromptBox();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("ADMIN_ORGRANGE", Boolean.TRUE);
        prmtPositionBox.setSelector((KDPromptSelector)new PositionPromptBox2((IUIObject)this, map));
        prmtPositionBox.setDisplayFormat("$name$");
        prmtPositionBox.setEditFormat("$number$");
        prmtPositionBox.setCommitFormat("$number$");
        prmtPositionBox.setEditable(false);
        this.tblMain.getColumn("toPosition").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtPositionBox));
        KDBizPromptBox prmtToUnitBox = new KDBizPromptBox();
        prmtToUnitBox.setDisplayFormat("$name$");
        prmtToUnitBox.setEditFormat("$number$");
        prmtToUnitBox.setCommitFormat("$number$");
        prmtToUnitBox.setEditable(false);
        prmtToUnitBox.setSelector((KDPromptSelector)new AllAdminPromptBox((IUIObject)this));
        this.tblMain.getColumn("toUnit").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtToUnitBox));
        KDBizPromptBox prmtStandbyTypeBox = new KDBizPromptBox();
        StandbyTypePromptBox standByTypePromptBox = new StandbyTypePromptBox((IUIObject)this);
        HashSet cuSet = HROrgContextManageUtil.convertHROrgsToCUs((HROrgUnitCollection)hrOrgUnitInfos);
        standByTypePromptBox.changeContextByCUSet(cuSet);
        prmtStandbyTypeBox.setSelector((KDPromptSelector)standByTypePromptBox);
        prmtStandbyTypeBox.setDisplayFormat("$name$");
        prmtStandbyTypeBox.setEditFormat("$number$");
        prmtStandbyTypeBox.setCommitFormat("$number$");
        prmtStandbyTypeBox.setEditable(false);
        this.tblMain.getColumn("standbyType").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtStandbyTypeBox));
        this.tblMain.getColumn("standbyType").getStyleAttributes().setBackground(StandbyUtils.MUSTINPUT_BGCOLOR);
        KDTextField txtToStandbyAudit = new KDTextField();
        txtToStandbyAudit.setMaxLength(80);
        this.tblMain.getColumn("toStandbyAudit").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtToStandbyAudit));
        KDTextField txtToStandbyReason = new KDTextField();
        txtToStandbyReason.setMaxLength(200);
        this.tblMain.getColumn("toStandbyReason").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtToStandbyReason));
        this.tblMain.getColumn("toPositionUnit.name").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("toPositionUnit.name").getStyleAttributes().setBackground(this.CANNOT_INPUT_COLOR);
        KDDatePicker kdp = new KDDatePicker();
        kdp.setValue((Object)new Date());
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(kdp);
        IColumn col = this.tblMain.getColumn("startTime");
        col.setEditor((ICellEditor)cellEditor);
        col.getStyleAttributes().setNumberFormat("%{yyyy-MM-dd}t");
        this.tblMain.getColumn("startTime").getStyleAttributes().setLocked(false);
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                StandbyPersonChangeUI.this.rowID = e.getRowIndex();
            }
        });
        prmtPersonBox.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    StandbyPersonChangeUI.this.addNewRowBySelectedPerson(StandbyPersonChangeUI.this.personMultiBox.getData(), StandbyPersonChangeUI.this.rowID);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        prmtPositionBox.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    StandbyPersonChangeUI.this.addNewRowBySelectedPosition(e.getData(), StandbyPersonChangeUI.this.rowID);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
    }

    private void addNewRowBySelectedPosition(Object positionData, int rowIndex) throws BOSException {
        if (positionData != null) {
            PositionInfo postioninfo = (PositionInfo)positionData;
            this.tblMain.getCell(rowIndex, "toPositionUnit.name").setValue((Object)postioninfo.getAdminOrgUnit());
        }
    }

    private void addNewRowBySelectedPerson(Object personData, int curRowIndex) throws EASBizException, BOSException {
        if (personData != null && personData instanceof Object[]) {
            Object[] objs = (Object[])personData;
            int size = objs.length;
            for (int i = 0; i < size; ++i) {
                int iCount;
                IRow row = null;
                IRow curRow = this.tblMain.getRow(curRowIndex);
                if (i == 0) {
                    row = curRow;
                    if (row.getCell("toPosition").getValue() == null && row.getCell("toUnit").getValue() == null) {
                        iCount = this.tblMain.getRowCount() - 1;
                        this.fillRowToPosOrToUnit(row, iCount);
                    }
                    if (row.getCell("startTime").getValue() == null) {
                        this.fillRowToDate();
                    }
                } else {
                    iCount = this.tblMain.getRowCount();
                    row = this.tblMain.addRow();
                    this.fillRowToPosOrToUnit(row, iCount);
                    this.fillRowToDate();
                }
                PersonInfo personInfo = (PersonInfo)objs[i];
                row.getCell("empName").setValue((Object)personInfo);
                row.getCell("empUnit").setValue((Object)((AdminOrgUnitInfo)personInfo.get("primaryAdminOrg")));
                row.getCell("empPosition").setValue((Object)((PositionInfo)personInfo.get("primaryPosition")));
                row.getCell("standbyType").setValue((Object)this.getStandbyTypeByEmployeeId(personInfo.getId().toString()));
            }
        }
    }

    protected void btnNew_actionPerformed(ActionEvent e) throws Exception {
        this.addNewRow();
    }

    private void addNewRow() {
        int iCount = this.tblMain.getRowCount();
        IRow newRow = this.tblMain.addRow();
        this.fillRowToPosOrToUnit(newRow, iCount);
        this.fillRowToDate();
    }

    private void fillRowToPosOrToUnit(IRow row, int iRowCount) {
        if (iRowCount <= 0) {
            if (this.selectedObj != null && this.selectedObj instanceof AdminOrgUnitInfo) {
                row.getCell("toUnit").setValue(this.selectedObj);
            } else if (this.selectedObj != null && this.selectedObj instanceof PositionInfo) {
                row.getCell("toPosition").setValue(this.selectedObj);
            }
        } else {
            IRow preRow = this.tblMain.getRow(iRowCount - 1);
            Object preToPosObj = preRow.getCell("toPosition").getValue();
            Object preToUnitObj = preRow.getCell("toUnit").getValue();
            if (preToPosObj == null && preToUnitObj == null) {
                if (this.selectedObj != null && this.selectedObj instanceof AdminOrgUnitInfo) {
                    row.getCell("toUnit").setValue(this.selectedObj);
                } else if (this.selectedObj != null && this.selectedObj instanceof PositionInfo) {
                    row.getCell("toPosition").setValue(this.selectedObj);
                }
            } else {
                row.getCell("toPosition").setValue(preToPosObj);
                row.getCell("toUnit").setValue(preToUnitObj);
            }
        }
    }

    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.removeRow(KDTableUtil.getSelectedRow((KDTable)this.tblMain));
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkInputValidate()) {
            IStandbyPerson iSbPer = StandbyPersonFactory.getRemoteInstance();
            iSbPer.addBatchStandbyPerson(this.getAllStandbyPersons());
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.SAVESUCCESS"));
            this.save = true;
            this.getUIWindow().close();
        }
    }

    private boolean checkInputValidate() throws EASBizException, BOSException {
        int size = this.tblMain.getRowCount();
        if (size <= 0) {
            return false;
        }
        String errMsgs = "";
        for (int i = 0; i < size; ++i) {
            String rowErr = "";
            IRow row = this.tblMain.getRow(i);
            if (row.getCell("empName").getValue() == null || !(row.getCell("empName").getValue() instanceof PersonInfo)) {
                rowErr = rowErr + EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.EMPLOYEE_CANNOT_EMPTY") + "\n";
            }
            if (row.getCell("toPosition").getValue() != null && row.getCell("toUnit").getValue() != null) {
                rowErr = rowErr + EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.TOPOSITION_TOUNIT_CANNOT_SELECTALL") + "\n";
            }
            if (row.getCell("toPosition").getValue() == null && row.getCell("toUnit").getValue() == null) {
                rowErr = rowErr + EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.TOPOSITION_TOUNIT_CANNOT_ALLEMPTY") + "\n";
            }
            if (row.getCell("empName").getValue() != null) {
                PersonInfo nowPerInfo = (PersonInfo)row.getCell("empName").getValue();
                IPerson iPerson = PersonFactory.getRemoteInstance();
                PositionInfo nowPosInfo = iPerson.getPrimaryPosition(nowPerInfo.getId());
                if (row.getCell("toPosition").getValue() != null) {
                    PositionInfo toPosInfo = (PositionInfo)row.getCell("toPosition").getValue();
                    if (nowPosInfo.getId().equals((Object)toPosInfo.getId())) {
                        rowErr = rowErr + EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.TOPOSITION_EMPPOSITION_CANNOT_SAME") + "\n";
                    }
                }
            }
            if (row.getCell("standbyType").getValue() == null || !(row.getCell("standbyType").getValue() instanceof StandbyTypeInfo)) {
                rowErr = rowErr + EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.STANDBYTYPE_CANNOT_EMPTY") + "\n";
            }
            if (rowErr.equals("")) continue;
            rowErr = EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.NO") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.ROW") + "\n" + rowErr;
            errMsgs = errMsgs + rowErr;
        }
        if (errMsgs.equals("")) {
            return true;
        }
        MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.EXIST_INVALIDATE_STANDBYPERSON_PLEASELOOKUP"), (String)errMsgs, (int)0);
        return false;
    }

    private StandbyPersonCollection getAllStandbyPersons() {
        StandbyPersonCollection sbPersonColl = new StandbyPersonCollection();
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.getRow(i);
            StandbyPersonInfo info = new StandbyPersonInfo();
            info.setEmployee((PersonInfo)row.getCell("empName").getValue());
            info.setStandbyType((StandbyTypeInfo)row.getCell("standbyType").getValue());
            if (row.getCell("toStandbyAudit").getValue() != null) {
                info.setToStandbyAudit(row.getCell("toStandbyAudit").getValue().toString());
            }
            if (row.getCell("toStandbyReason").getValue() != null) {
                info.setToStandbyReason(row.getCell("toStandbyReason").getValue().toString());
            }
            info.setToPosition((PositionInfo)row.getCell("toPosition").getValue());
            info.setToUnit((AdminOrgUnitInfo)row.getCell("toUnit").getValue());
            info.setStartTime((Date)row.getCell("startTime").getValue());
            sbPersonColl.add(info);
        }
        return sbPersonColl;
    }

    public void actionSelectCopy_actionPerformed(ActionEvent e) throws Exception {
        HRUtils.copyToSelect((KDTable)this.tblMain);
        int[] rowIndexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int firstColumnIndex = this.tblMain.getSelectManager().getActiveColumnIndex();
        int empColIndex = this.tblMain.getColumnIndex("empName");
        if (firstColumnIndex == empColIndex) {
            Object objPosName = this.tblMain.getRow(rowIndexs[0]).getCell("empPosition").getValue();
            Object objUnitName = this.tblMain.getRow(rowIndexs[0]).getCell("empUnit").getValue();
            int length = rowIndexs.length;
            for (int i = 1; i < length; ++i) {
                this.tblMain.getRow(rowIndexs[i]).getCell("empPosition").setValue(objPosName);
                this.tblMain.getRow(rowIndexs[i]).getCell("empUnit").setValue(objUnitName);
            }
        }
    }

    private void loadToStandbyPerson(PersonCollection perCol) throws EASBizException, BOSException {
        int size = perCol.size();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.addRow();
            PersonInfo personInfo = perCol.get(i);
            row.getCell("empName").setValue((Object)personInfo);
            row.getCell("empUnit").setValue((Object)personInfo.get("unitName").toString());
            row.getCell("empPosition").setValue((Object)personInfo.get("posName").toString());
            row.getCell("standbyType").setValue((Object)this.getStandbyTypeByEmployeeId(personInfo.getId().toString()));
            if (row.getCell("startTime").getValue() == null) {
                row.getCell("startTime").setValue((Object)new Date());
            }
            this.fillRowToPosOrToUnit(row, 0);
        }
    }

    private StandbyTypeInfo getStandbyTypeByEmployeeId(String employeeId) throws EASBizException, BOSException {
        StandbyTypeInfo sbTypeInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isStandby", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("employee.id", (Object)employeeId));
        view.setFilter(filter);
        StandbyPersonCollection sbPerCol = StandbyPersonFactory.getRemoteInstance().getStandbyPersonCollection(view);
        if (sbPerCol.size() > 0) {
            StandbyPersonInfo sbPerInfo = sbPerCol.get(0);
            sbTypeInfo = StandbyTypeFactory.getRemoteInstance().getStandbyTypeInfo((IObjectPK)new ObjectUuidPK(sbPerInfo.getStandbyType().getId()));
        }
        return sbTypeInfo;
    }

    protected void showAddNew() {
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return StandbyPersonFactory.getRemoteInstance();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PEOPLE_ORGANIZATION;
    }

    private void fillRowToDate() {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            if (this.tblMain.getCell(i, "startTime").getValue() != null && !this.tblMain.getCell(i, "startTime").getValue().equals("")) continue;
            this.tblMain.getCell(i, "startTime").setValue((Object)new Date());
        }
    }
}

