/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.client;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.EmployeeTreeEditUI;
import com.kingdee.eas.hr.standby.IStandbyPerson;
import com.kingdee.eas.hr.standby.StandbyPersonFactory;
import com.kingdee.eas.hr.standby.StandbyPersonInfo;
import com.kingdee.eas.hr.standby.client.AbstractStandbyPersonEditUI;
import com.kingdee.eas.hr.standby.client.IStandbyPersonEditUI;
import com.kingdee.eas.hr.standby.client.StandbyPersonAuditRecordUI;
import com.kingdee.eas.hr.standby.client.StandbyPersonDetailListUI;
import com.kingdee.eas.hr.standby.client.StandbyPersonInfoUI;
import com.kingdee.eas.hr.standby.client.StandbyPersonPlanUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class StandbyPersonEditUI
extends AbstractStandbyPersonEditUI {
    private static final Logger logger = CoreUIObject.getLogger(StandbyPersonEditUI.class);
    private static final String TABINDEX = "TABINDEX";
    public static final int KDTABINDEX_STANDBYPERSONINFO = 0;
    public static final int KDTABINDEX_STANDBYPERSONPLAN = 1;
    public static final int KDTABINDEX_STANDBYPERSONWISH = 2;
    public static final int KDTABINDEX_STANDBYPERSONAUDIT = 3;
    public static final int KDTABINDEX_CUSTOMER = 7;
    private String curSbPerId = null;
    private PersonInfo curPersonInfo = null;
    HashMap loadedMap = new HashMap();
    HashMap reLoadMap = new HashMap();
    protected boolean isFirstLoad = true;
    private CoreUIObject uiObj = null;
    private int currentIndex = 0;
    private int showModifyFlag = 1;

    public void loadFields() {
        super.loadFields();
        try {
            this.curSbPerId = this.getUIContext().get("FromStandby") != null && this.getUIContext().get("FromStandby").toString().equals("YES") ? this.getUIContext().get("ID").toString() : this.idList.getCurrentID();
            this.curPersonInfo = this.getCurrentPersonInfoByUIContextID(this.curSbPerId);
            this.loadEmpNameAndNumberAndPosition();
            this.loadUIObj();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void storeFields() {
        super.storeFields();
        this.checkValueModify();
    }

    private void checkValueModify() {
        if (this.uiObj instanceof StandbyPersonInfoUI && ((StandbyPersonInfoUI)this.uiObj).isModify() || this.uiObj instanceof StandbyPersonPlanUI && ((StandbyPersonPlanUI)this.uiObj).isModify() || this.uiObj instanceof StandbyPersonAuditRecordUI && ((StandbyPersonAuditRecordUI)this.uiObj).isModify()) {
            this.editData.put("isChange", (Object)"TRUE");
        } else if (this.editData.get("isChange") != null) {
            this.editData.remove("isChange");
        }
    }

    protected IObjectValue createNewData() {
        return new StandbyPersonInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return StandbyPersonFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPersonDetailInfo.setIcon(EASResource.getIcon((String)"imgTbtn_business"));
        this.menuItemPersonDetailInfo.setIcon(EASResource.getIcon((String)"imgTbtn_business"));
    }

    public void onLoad() throws Exception {
        this.setTabIndexMap();
        super.onLoad();
        this.setPreferredSize(new Dimension(780, 600));
        this.txtToStandbyReason.setMaxLength(180);
        if (this.getUIContext().get("fromPage") != null && StandbyPersonDetailListUI.class.getName().equals(this.getUIContext().get("fromPage"))) {
            this.btnSubmit.setVisible(false);
            this.btnPre.setVisible(false);
            this.btnFirst.setVisible(false);
            this.btnNext.setVisible(false);
            this.btnLast.setVisible(false);
        }
        if (this.getUIContext().get("FromStandby") != null) {
            this.actionSubmit.setVisible(false);
            this.actionFirst.setVisible(false);
            this.actionPre.setVisible(false);
            this.actionNext.setVisible(false);
            this.actionLast.setVisible(false);
        }
    }

    private void loadEmpNameAndNumberAndPosition() throws Exception {
        this.txtPersonNumber.setText(this.curPersonInfo.getNumber());
        this.txtPersonName.setText(this.curPersonInfo.getName());
        this.txtPersonPosition.setText(EmployeeClientUtils.getPosition((String)this.curPersonInfo.getId().toString()));
    }

    private PersonInfo getCurrentPersonInfoByUIContextID(String uiContextId) throws Exception {
        ObjectUuidPK standbyPersonId = new ObjectUuidPK(uiContextId);
        StandbyPersonInfo sbPerInfo = ((IStandbyPerson)this.getBizInterface()).getStandbyPersonInfo((IObjectPK)standbyPersonId);
        String curEmpId = sbPerInfo.getEmployee().getId().toString();
        IPerson iPer = PersonFactory.getRemoteInstance();
        return iPer.getPersonInfo((IObjectPK)new ObjectUuidPK(curEmpId));
    }

    protected void paneMain_stateChanged(ChangeEvent e) throws Exception {
        if (this.isFirstLoad) {
            this.isFirstLoad = false;
            this.currentIndex = 0;
            return;
        }
        if ((this.uiObj instanceof StandbyPersonInfoUI && ((StandbyPersonInfoUI)this.uiObj).isModify() || this.uiObj instanceof StandbyPersonPlanUI && ((StandbyPersonPlanUI)this.uiObj).isModify() || this.uiObj instanceof StandbyPersonAuditRecordUI && ((StandbyPersonAuditRecordUI)this.uiObj).isModify()) && this.showModifyFlag == 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.Confirm_Save_Change"));
            this.showModifyFlag = 0;
            this.paneMain.setSelectedIndex(this.currentIndex);
        }
        this.showModifyFlag = 1;
        this.currentIndex = this.paneMain.getSelectedIndex();
        KDPanel pnl = (KDPanel)this.paneMain.getSelectedComponent();
        if (pnl.getClientProperty((Object)TABINDEX) == null) {
            return;
        }
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            this.btnSubmit.setEnabled(true);
        }
        this.loadUIObj();
    }

    private void loadUIObj() throws Exception {
        KDPanel pnl = (KDPanel)this.paneMain.getSelectedComponent();
        if (pnl.getClientProperty((Object)TABINDEX) == null) {
            return;
        }
        int tabIndex = (Integer)pnl.getClientProperty((Object)TABINDEX);
        if (tabIndex == 7) {
            return;
        }
        boolean isLoaded = false;
        boolean isReloaded = false;
        if (this.loadedMap.get(tabIndex) != null) {
            isLoaded = (Boolean)this.loadedMap.get(tabIndex);
        }
        if (this.reLoadMap.get(tabIndex) != null) {
            isReloaded = (Boolean)this.reLoadMap.get(tabIndex);
        }
        if (!isLoaded) {
            String strOperState = null;
            HashMap ctx = (HashMap)this.getUIContext();
            ctx.put("ID", this.curSbPerId);
            ctx.put("multi_org_context", this.getUIContext().get("multi_org_context"));
            strOperState = this.getOprtState();
            this.uiObj = (CoreUIObject)UIFactoryHelper.initUIObject((String)this.getUIClassName(tabIndex), (Map)ctx, null, (String)strOperState);
            KDScrollPane scrollPnl = new KDScrollPane();
            scrollPnl.setViewportView((Component)this.uiObj);
            pnl.add((Component)scrollPnl, (Object)"Center");
            pnl.repaint();
            this.loadedMap.put(tabIndex, Boolean.valueOf("true"));
            this.reLoadMap.put(tabIndex, Boolean.valueOf("true"));
        } else if (!isReloaded) {
            Component cmptUIObj = ((KDScrollPane)pnl.getComponent(0)).getViewport().getComponent(0);
            ((IStandbyPersonEditUI)((Object)cmptUIObj)).setStandbyPersonId(this.curSbPerId);
            ((IStandbyPersonEditUI)((Object)cmptUIObj)).secondLoad();
            this.reLoadMap.put(tabIndex, Boolean.valueOf("true"));
        }
    }

    private String getUIClassName(int tabIndex) {
        switch (tabIndex) {
            case 0: {
                return StandbyPersonInfoUI.class.getName();
            }
            case 1: {
                return StandbyPersonPlanUI.class.getName();
            }
            case 3: {
                return StandbyPersonAuditRecordUI.class.getName();
            }
        }
        return null;
    }

    private void setTabIndexMap() {
        this.pnlStandbyPersonInfo.putClientProperty((Object)TABINDEX, (Object)0);
        this.pnlStandbyPersonPlan.putClientProperty((Object)TABINDEX, (Object)1);
        this.pnlStandbyPersonAudit.putClientProperty((Object)TABINDEX, (Object)3);
        this.pnlCustomer.putClientProperty((Object)TABINDEX, (Object)7);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        KDPanel pnl = (KDPanel)this.paneMain.getSelectedComponent();
        if (pnl.getClientProperty((Object)TABINDEX) == null) {
            super.actionSubmit_actionPerformed(e);
            return;
        }
        Component cmptUIObj = null;
        int tabIndex = (Integer)pnl.getClientProperty((Object)TABINDEX);
        if (tabIndex == 0) {
            cmptUIObj = ((KDScrollPane)pnl.getComponent(0)).getViewport().getComponent(0);
            if (((IStandbyPersonEditUI)((Object)cmptUIObj)).saveInfo()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.STANDBYPERSON_INFO_SAVESUCCESS"));
            }
        } else if (tabIndex == 1) {
            cmptUIObj = ((KDScrollPane)pnl.getComponent(0)).getViewport().getComponent(0);
            if (((IStandbyPersonEditUI)((Object)cmptUIObj)).saveInfo()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.PLAN_COURSE_SAVESUCCESS"));
            }
        } else if (tabIndex == 3) {
            cmptUIObj = ((KDScrollPane)pnl.getComponent(0)).getViewport().getComponent(0);
            if (((IStandbyPersonEditUI)((Object)cmptUIObj)).saveInfo()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.PERSONAUDIT_SAVESUCCESS"));
            }
        } else if (tabIndex == 7) {
            super.actionSubmit_actionPerformed(e);
        }
        this.save = true;
    }

    public void actionPersonDetailInfo_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiCtx = new UIContext((Object)this);
        String strSelectId = this.curPersonInfo.getId().toString();
        uiCtx.put((Object)"ID", (Object)strSelectId);
        RealModeIDList idList = new RealModeIDList();
        idList.add(strSelectId);
        uiCtx.put((Object)"IDList", (Object)idList);
        uiCtx.put((Object)"isPosition", (Object)true);
        uiCtx.put((Object)"isMyArchives", (Object)"isStandBy");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EmployeeTreeEditUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
        uiWindow.show();
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        this.reLoadMap.clear();
        super.actionFirst_actionPerformed(e);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        this.reLoadMap.clear();
        super.actionLast_actionPerformed(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        this.reLoadMap.clear();
        super.actionNext_actionPerformed(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        this.reLoadMap.clear();
        super.actionPre_actionPerformed(e);
    }
}

