/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.client.tree.AdminPositionTreeBuilder;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.hr.standby.IStandbyPerson;
import com.kingdee.eas.hr.standby.StandbyPersonCollection;
import com.kingdee.eas.hr.standby.StandbyPersonFactory;
import com.kingdee.eas.hr.standby.StandbyPersonInfo;
import com.kingdee.eas.hr.standby.client.AbstractStandbyPersonF7UI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.JButton;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class StandbyPersonF7UI
extends AbstractStandbyPersonF7UI {
    private static final Logger logger = CoreUIObject.getLogger(StandbyPersonF7UI.class);
    public boolean isCanceled = true;
    protected StandbyPersonCollection standbyPersonCol = new StandbyPersonCollection();
    private boolean isRootNodeNull = false;
    protected String longNumber = null;

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                if (StandbyPersonF7UI.this.tblMain.getRowCount() != 0) {
                    StandbyPersonF7UI.this.tblMain.getSelectManager().select(0, 0);
                }
            }
        });
        this.tblList.checkParsed();
        this.tblList.getSelectManager().setSelectMode(2);
        this.tblList.getStyleAttributes().setLocked(true);
        this.initAdminPositionTree();
        this.initOperateButton();
    }

    protected void initTree() throws Exception {
    }

    private void initOperateButton() {
        this.btnDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnDel.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnAllDown.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnAllDel.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.contList.addButton((JButton)this.btnDown);
        this.contList.addButton((JButton)this.btnDel);
        this.contList.addButton((JButton)this.btnAllDown);
        this.contList.addButton((JButton)this.btnAllDel);
    }

    private void initAdminPositionTree() throws Exception {
        this.treeMain.setShowsRootHandles(false);
        AdminPositionTreeBuilder treeBuilder = new AdminPositionTreeBuilder(2, 1);
        treeBuilder.buildAllAdminTree((JTree)this.treeMain);
        DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)((DefaultTreeModel)this.treeMain.getModel()).getRoot();
        if (rootNode == null) {
            this.treeMain.setModel(null);
            return;
        }
        if (!OrgF7InnerUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)rootNode) || rootNode.getChildCount() == 0) {
            this.treeMain.setModel((TreeModel)new DefaultTreeModel((TreeNode)rootNode));
            TreePath path = new TreePath(rootNode.getPath());
            this.treeMain.expandPath(path);
            this.treeMain.setSelectionPath(path);
        } else {
            this.treeMain.setModel((TreeModel)new DefaultTreeModel((TreeNode)rootNode));
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)rootNode.getChildAt(0);
            TreePath path = new TreePath(node.getPath());
            this.treeMain.expandPath(path);
            this.treeMain.setSelectionPath(path);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
            if (rowIndex < 0) {
                return;
            }
            IRow fromRow = this.tblMain.getRow(rowIndex);
            this.insertRowData(fromRow);
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        if (this.isRootNodeNull) {
            return;
        }
        TreePath path = e.getPath();
        DefaultKingdeeTreeNode treenode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        Object userObj = treenode.getUserObject();
        FilterInfo filter = new FilterInfo();
        if (userObj != null && userObj instanceof AdminOrgUnitInfo) {
            this.chkIncludeChild.setVisible(true);
            AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)userObj;
            this.longNumber = adminInfo.getLongNumber();
            if (this.chkIncludeChild.isSelected()) {
                filter.getFilterItems().add(new FilterItemInfo("toPositionUnit.longNumber", (Object)(this.longNumber + "!%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("toPositionUnit.longNumber", (Object)this.longNumber));
                filter.getFilterItems().add(new FilterItemInfo("toUnit.longNumber", (Object)(this.longNumber + "%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("toUnit.longNumber", (Object)this.longNumber));
                filter.setMaskString(" #0 or #1 or #2 or #3");
            } else {
                filter.getFilterItems().add(new FilterItemInfo("toPositionUnit.longNumber", (Object)this.longNumber));
                filter.getFilterItems().add(new FilterItemInfo("toUnit.longNumber", (Object)this.longNumber));
                filter.setMaskString(" #0 or #1 ");
            }
        } else if (userObj != null && userObj instanceof PositionInfo) {
            this.chkIncludeChild.setVisible(false);
            PositionInfo posInfo = (PositionInfo)userObj;
            filter.getFilterItems().add(new FilterItemInfo("toPosition.id", (Object)posInfo.getId().toString()));
        } else {
            this.chkIncludeChild.setVisible(false);
        }
        if (filter.getFilterItems().size() > 0) {
            FilterInfo newFilter = new FilterInfo();
            newFilter.getFilterItems().add(new FilterItemInfo("isStandby", (Object)1));
            filter.mergeFilter(newFilter, "AND");
            filter.mergeFilter(this.getDefaultCUFilter(), "AND");
        }
        this.mainQuery.setFilter(filter);
        this.tblMain.removeRows();
    }

    protected void chkIncludeChild_itemStateChanged(ItemEvent e) throws Exception {
        FilterInfo filter = new FilterInfo();
        if (this.chkIncludeChild.isSelected()) {
            filter.getFilterItems().add(new FilterItemInfo("toPositionUnit.longNumber", (Object)(this.longNumber + "%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("toPositionUnit.longNumber", (Object)this.longNumber));
            filter.getFilterItems().add(new FilterItemInfo("toUnit.longNumber", (Object)(this.longNumber + "%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("toUnit.longNumber", (Object)this.longNumber));
            filter.setMaskString(" #0 or #1 or #2 or #3 ");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("toPositionUnit.longNumber", (Object)this.longNumber));
            filter.getFilterItems().add(new FilterItemInfo("toUnit.longNumber", (Object)this.longNumber));
            filter.setMaskString(" #0 or #1 ");
        }
        if (filter.getFilterItems().size() > 0) {
            FilterInfo newFilter = new FilterInfo();
            newFilter.getFilterItems().add(new FilterItemInfo("isStandby", (Object)1));
            filter.mergeFilter(newFilter, "AND");
            filter.mergeFilter(this.getDefaultCUFilter(), "AND");
        }
        this.mainQuery.setFilter(filter);
        this.tblMain.removeRows();
    }

    private FilterInfo getDefaultCUFilter() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.setMaskString("#0 or #1");
        return filter;
    }

    protected void btnExit_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    protected void btnSelect_actionPerformed(ActionEvent e) throws Exception {
        int size = this.tblList.getRowCount();
        this.standbyPersonCol = this.getAllSelectedStandbyPerson();
        if (size > 0) {
            this.isCanceled = false;
            this.getUIWindow().close();
        }
    }

    private StandbyPersonCollection getAllSelectedStandbyPerson() throws Exception {
        int size = this.tblList.getRowCount();
        if (size <= 0) {
            return null;
        }
        StandbyPersonCollection sbPerCol = new StandbyPersonCollection();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("employee.name"));
        sic.add(new SelectorItemInfo("employee.number"));
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblList.getRow(i);
            String sbPerId = row.getCell("id").getValue().toString();
            StandbyPersonInfo sbPerInfo = ((IStandbyPerson)this.getBizInterface()).getStandbyPersonInfo((IObjectPK)new ObjectUuidPK(sbPerId), sic);
            sbPerInfo.put("empPosition.name", row.getCell("empPosition.name").getValue());
            sbPerInfo.put("empAdminOrgUnit.name", row.getCell("empAdminOrgUnit.name").getValue());
            sbPerInfo.put("standbyType.name", row.getCell("standbyType.name").getValue());
            sbPerInfo.put("toPosition.name", row.getCell("toPosition.name").getValue());
            sbPerInfo.put("toUnit.name", row.getCell("toUnit.name").getValue());
            sbPerCol.add(sbPerInfo);
        }
        return sbPerCol;
    }

    private void insertRowData(IRow fromRow) {
        String fromSbPerId = fromRow.getCell("id").getValue().toString();
        if (!this.isExistSameStandbyPerson(fromSbPerId)) {
            IRow toRow = this.tblList.addRow();
            toRow.getCell("id").setValue(fromRow.getCell("id").getValue());
            toRow.getCell("employee.number").setValue(fromRow.getCell("employee.number").getValue());
            toRow.getCell("employee.name").setValue(fromRow.getCell("employee.name").getValue());
            toRow.getCell("empPosition.name").setValue(fromRow.getCell("empPosition.name").getValue());
            toRow.getCell("empAdminOrgUnit.name").setValue(fromRow.getCell("empAdminOrgUnit.name").getValue());
            toRow.getCell("standbyType.name").setValue(fromRow.getCell("standbyType.name").getValue());
            toRow.getCell("toPosition.name").setValue(fromRow.getCell("toPosition.name").getValue());
            toRow.getCell("toUnit.name").setValue(fromRow.getCell("toUnit.name").getValue());
        }
    }

    private boolean isExistSameStandbyPerson(String sbPerId) {
        int size = this.tblList.getRowCount();
        for (int i = 0; i < size; ++i) {
            String strId = this.tblList.getRow(i).getCell("id").getValue().toString();
            if (!sbPerId.equals(strId)) continue;
            return true;
        }
        return false;
    }

    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock sb = null;
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            sb = this.tblMain.getSelectManager().get(i);
            int j = 0;
            int bottom = 0;
            if (sb.getMode() == 8) {
                j = 0;
                bottom = this.tblMain.getRowCount();
            } else {
                j = sb.getTop();
                bottom = sb.getBottom() + 1;
            }
            while (j < bottom) {
                IRow fromRow = this.tblMain.getRow(j);
                this.insertRowData(fromRow);
                ++j;
            }
        }
    }

    protected void btnAllDown_actionPerformed(ActionEvent e) throws Exception {
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow fromRow = this.tblMain.getRow(i);
            this.insertRowData(fromRow);
        }
    }

    protected void btnAllDel_actionPerformed(ActionEvent e) throws Exception {
        this.tblList.removeRows();
    }

    protected void btnDel_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblList);
        if (rowIndex >= 0) {
            this.tblList.removeRow(rowIndex);
        }
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        try {
            return new ObjectUuidPK(this.getSelectedNodeKeyValue());
        }
        catch (Exception ex) {
            this.handUIException(ex);
            return null;
        }
    }

    protected String getQueryFieldName() {
        return null;
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected String getGroupEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return StandbyPersonFactory.getRemoteInstance();
    }

    protected void initKeyStroke() {
    }
}

