/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.org.util.HROrgContextManageUtil;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.emp.client.EmployeeCompetIndexUI;
import com.kingdee.eas.hr.standby.IStandbyPerson;
import com.kingdee.eas.hr.standby.IStandbyType;
import com.kingdee.eas.hr.standby.StandbyException;
import com.kingdee.eas.hr.standby.StandbyPersonCollection;
import com.kingdee.eas.hr.standby.StandbyPersonFactory;
import com.kingdee.eas.hr.standby.StandbyPersonInfo;
import com.kingdee.eas.hr.standby.StandbyTypeFactory;
import com.kingdee.eas.hr.standby.StandbyTypeInfo;
import com.kingdee.eas.hr.standby.client.AbstractStandbyPersonInfoUI;
import com.kingdee.eas.hr.standby.client.IStandbyPersonEditUI;
import com.kingdee.eas.hr.standby.client.PositionCompetencyListUI;
import com.kingdee.eas.hr.standby.client.PositionRequestListUI;
import com.kingdee.eas.hr.standby.client.StandbyTypePromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class StandbyPersonInfoUI
extends AbstractStandbyPersonInfoUI
implements IStandbyPersonEditUI {
    private static final Logger logger = CoreUIObject.getLogger(StandbyPersonInfoUI.class);
    private StandbyPersonInfo curSbPerInfo = null;
    private static final String RES = "com.kingdee.eas.hr.standby.StandbyResource";
    private String person1Id = null;
    private String person2Id = null;
    private String person3Id = null;
    private ArrayList oldPosList = null;
    private ArrayList newPosList = null;
    private StandbyTypeInfo oldSPTInfo = null;
    private StandbyTypeInfo newSPTInfo = null;

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        String curStandbyPersonId = (String)this.getUIContext().get("ID");
        IStandbyPerson iSbPer = StandbyPersonFactory.getRemoteInstance();
        this.curSbPerInfo = iSbPer.getStandbyPersonInfo((IObjectPK)new ObjectUuidPK(curStandbyPersonId));
        super.onLoad();
        this.firstLoad();
        if ("VIEW".equals(this.getOprtState())) {
            this.prmtStandbyType.setEnabled(false);
            this.prmtToPosition1.setEnabled(false);
            this.prmtToPosition2.setEnabled(false);
            this.prmtToPosition3.setEnabled(false);
        }
        this.oldPosList = this.getPosList();
        if (this.prmtStandbyType.getData() != null) {
            this.oldSPTInfo = (StandbyTypeInfo)this.prmtStandbyType.getData();
        }
    }

    private void firstLoad() throws Exception {
        this.loadStandbyType();
        this.loadToPositionsByEmployee();
        this.loadPersonByEmpPosition();
        this.setButtonsProperty();
    }

    public void secondLoad() throws Exception {
        this.loadStandbyType();
        this.loadToPositionsByEmployee();
        this.loadPersonByEmpPosition();
        this.setButtonsProperty();
    }

    public void setStandbyPersonId(String standbyPersonId) {
        try {
            IStandbyPerson iSbPer = StandbyPersonFactory.getRemoteInstance();
            this.curSbPerInfo = iSbPer.getStandbyPersonInfo((IObjectPK)new ObjectUuidPK(standbyPersonId));
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        HROrgUnitCollection hrOrgUnitInfos = (HROrgUnitCollection)this.getUIContext().get("multi_org_context");
        StandbyTypePromptBox standByTypePromptBox = new StandbyTypePromptBox((IUIObject)this);
        HashSet cuSet = HROrgContextManageUtil.convertHROrgsToCUs((HROrgUnitCollection)hrOrgUnitInfos);
        standByTypePromptBox.changeContextByCUSet(cuSet);
        this.prmtStandbyType.setSelector((KDPromptSelector)standByTypePromptBox);
        this.prmtStandbyType.setDisplayFormat("$name$");
        this.prmtStandbyType.setEditFormat("$number$");
        this.prmtStandbyType.setCommitFormat("$number$");
        this.prmtStandbyType.setEditable(false);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("ADMIN_ORGRANGE", Boolean.TRUE);
        this.prmtToPosition1.setSelector((KDPromptSelector)new PositionPromptBox2((IUIObject)this, map));
        this.prmtToPosition1.setDisplayFormat("$name$");
        this.prmtToPosition1.setEditFormat("$number$");
        this.prmtToPosition1.setCommitFormat("$number$");
        this.prmtToPosition1.setEditable(false);
        this.prmtToPosition2.setSelector((KDPromptSelector)new PositionPromptBox2((IUIObject)this, map));
        this.prmtToPosition2.setDisplayFormat("$name$");
        this.prmtToPosition2.setEditFormat("$number$");
        this.prmtToPosition2.setCommitFormat("$number$");
        this.prmtToPosition2.setEditable(false);
        this.prmtToPosition3.setSelector((KDPromptSelector)new PositionPromptBox2((IUIObject)this, map));
        this.prmtToPosition3.setDisplayFormat("$name$");
        this.prmtToPosition3.setEditFormat("$number$");
        this.prmtToPosition3.setCommitFormat("$number$");
        this.prmtToPosition3.setEditable(false);
        this.setControlProperties();
    }

    private void setControlProperties() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.prmtStandbyType.setReadOnly(true);
            this.prmtToPosition1.setReadOnly(true);
            this.prmtToPosition2.setReadOnly(true);
            this.prmtToPosition3.setReadOnly(true);
            this.pkToPositionDate1.setEnabled(false);
            this.pkToPositionDate2.setEnabled(false);
            this.pkToPositionDate3.setEnabled(false);
        }
    }

    private void loadStandbyType() throws EASBizException, BOSException {
        String typeId = this.curSbPerInfo.getStandbyType().getId().toString();
        IStandbyType iType = StandbyTypeFactory.getRemoteInstance();
        this.prmtStandbyType.setData((Object)iType.getStandbyTypeInfo((IObjectPK)new ObjectUuidPK(typeId)));
    }

    private void loadToPositionsByEmployee() throws EASBizException, BOSException, ParserException {
        this.clearAllToPosition();
        IStandbyPerson iSbPer = StandbyPersonFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("employee", (Object)this.curSbPerInfo.getEmployee().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("toUnit", null));
        filter.getFilterItems().add(new FilterItemInfo("isStandby", (Object)1));
        view.setFilter(filter);
        view.setSorter(new SorterItemCollection("order by toPositionLevel"));
        StandbyPersonCollection sbPerCol = iSbPer.getStandbyPersonCollection(view);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("adminOrgUnit.name"));
        if (sbPerCol.size() > 0) {
            int size = sbPerCol.size();
            for (int i = 0; i < size; ++i) {
                StandbyPersonInfo sbPerInfo = sbPerCol.get(i);
                if (sbPerInfo.getToPosition() == null || sbPerInfo.isIsHistoryStandbyPerson()) continue;
                IPosition iPos = PositionFactory.getRemoteInstance();
                PositionInfo posInfo = iPos.getPositionInfo((IObjectPK)new ObjectUuidPK(sbPerInfo.getToPosition().getId()), selector);
                int toPositionLevel = sbPerInfo.getToPositionLevel();
                if (posInfo == null) continue;
                if (toPositionLevel == 1) {
                    if (!this.prmtToPosition1.getText().trim().equals("")) {
                        this.prmtToPosition2.setData((Object)posInfo);
                        this.prmtToPositionUnit2.setData((Object)posInfo.getAdminOrgUnit());
                        this.pkToPositionDate2.setValue((Object)sbPerInfo.getToPositionDate());
                        continue;
                    }
                    if (!this.prmtToPosition2.getText().trim().equals("")) {
                        this.prmtToPosition3.setData((Object)posInfo);
                        this.prmtToPositionUnit3.setData((Object)posInfo.getAdminOrgUnit());
                        this.pkToPositionDate3.setValue((Object)sbPerInfo.getToPositionDate());
                        continue;
                    }
                    this.prmtToPosition1.setData((Object)posInfo);
                    this.prmtToPositionUnit1.setData((Object)posInfo.getAdminOrgUnit());
                    this.pkToPositionDate1.setValue((Object)sbPerInfo.getToPositionDate());
                    continue;
                }
                if (toPositionLevel == 2) {
                    this.prmtToPosition2.setData((Object)posInfo);
                    this.prmtToPositionUnit2.setData((Object)posInfo.getAdminOrgUnit());
                    this.pkToPositionDate2.setValue((Object)sbPerInfo.getToPositionDate());
                    continue;
                }
                if (toPositionLevel != 3) continue;
                this.prmtToPosition3.setData((Object)posInfo);
                this.prmtToPositionUnit3.setData((Object)posInfo.getAdminOrgUnit());
                this.pkToPositionDate3.setValue((Object)sbPerInfo.getToPositionDate());
            }
        }
    }

    protected void prmtToPosition1_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtToPosition1_dataChanged(e);
        this.setButtonsProperty();
        if (e.getNewValue() != null && e.getNewValue() instanceof PositionInfo) {
            PositionInfo toPosInfo = (PositionInfo)e.getNewValue();
            this.prmtToPositionUnit1.setValue((Object)toPosInfo.getAdminOrgUnit());
        } else {
            this.prmtToPositionUnit1.setValue(null);
        }
    }

    protected void prmtToPosition2_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtToPosition2_dataChanged(e);
        this.setButtonsProperty();
        if (e.getNewValue() != null && e.getNewValue() instanceof PositionInfo) {
            PositionInfo toPosInfo = (PositionInfo)e.getNewValue();
            this.prmtToPositionUnit2.setValue((Object)toPosInfo.getAdminOrgUnit());
        } else {
            this.prmtToPositionUnit2.setValue(null);
        }
    }

    protected void prmtToPosition3_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtToPosition3_dataChanged(e);
        this.setButtonsProperty();
        if (e.getNewValue() != null && e.getNewValue() instanceof PositionInfo) {
            PositionInfo toPosInfo = (PositionInfo)e.getNewValue();
            this.prmtToPositionUnit3.setValue((Object)toPosInfo.getAdminOrgUnit());
        } else {
            this.prmtToPositionUnit3.setValue(null);
        }
    }

    private void loadPersonByEmpPosition() throws EASBizException, BOSException {
        this.clearAllPerson();
        IStandbyPerson iSbPer = StandbyPersonFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        IPerson iPerson = PersonFactory.getRemoteInstance();
        PositionInfo posInfo = iPerson.getPrimaryPosition(this.curSbPerInfo.getEmployee().getId());
        filter.getFilterItems().add(new FilterItemInfo("toPosition", (Object)posInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isStandby", (Object)1));
        view.setFilter(filter);
        StandbyPersonCollection sbPerCol = iSbPer.getStandbyPersonCollection(view);
        if (sbPerCol.size() > 0) {
            int size = sbPerCol.size();
            for (int i = 0; i < size; ++i) {
                StandbyPersonInfo sbPerInfo = sbPerCol.get(i);
                IPerson iPer = PersonFactory.getRemoteInstance();
                PersonInfo perInfo = iPer.getPersonInfo((IObjectPK)new ObjectUuidPK(sbPerInfo.getEmployee().getId()));
                if (perInfo == null) continue;
                if (i == 0) {
                    this.txtPerson1.setText(perInfo.getName());
                    this.pkPersonDate1.setValue((Object)sbPerInfo.getToPositionDate());
                    this.person1Id = perInfo.getId().toString();
                    continue;
                }
                if (i == 1) {
                    this.txtPerson2.setText(perInfo.getName());
                    this.pkPersonDate2.setValue((Object)sbPerInfo.getToPositionDate());
                    this.person2Id = perInfo.getId().toString();
                    continue;
                }
                this.txtPerson3.setText(perInfo.getName());
                this.pkPersonDate3.setValue((Object)sbPerInfo.getToPositionDate());
                this.person3Id = perInfo.getId().toString();
            }
        }
    }

    private void setButtonsProperty() {
        if (!this.prmtToPosition1.getText().trim().equals("")) {
            this.btnToPositionRequest1.setVisible(true);
            this.btnToPositionCompetency1.setVisible(true);
        } else {
            this.btnToPositionRequest1.setVisible(false);
            this.btnToPositionCompetency1.setVisible(false);
        }
        if (!this.prmtToPosition2.getText().trim().equals("")) {
            this.btnToPositionRequest2.setVisible(true);
            this.btnToPositionCompetency2.setVisible(true);
        } else {
            this.btnToPositionRequest2.setVisible(false);
            this.btnToPositionCompetency2.setVisible(false);
        }
        if (!this.prmtToPosition3.getText().trim().equals("")) {
            this.btnToPositionRequest3.setVisible(true);
            this.btnToPositionCompetency3.setVisible(true);
        } else {
            this.btnToPositionRequest3.setVisible(false);
            this.btnToPositionCompetency3.setVisible(false);
        }
        if (!this.txtPerson1.getText().trim().equals("")) {
            this.btnPersonAbility1.setVisible(true);
        } else {
            this.btnPersonAbility1.setVisible(false);
        }
        if (!this.txtPerson2.getText().trim().equals("")) {
            this.btnPersonAbility2.setVisible(true);
        } else {
            this.btnPersonAbility2.setVisible(false);
        }
        if (!this.txtPerson3.getText().trim().equals("")) {
            this.btnPersonAbility3.setVisible(true);
        } else {
            this.btnPersonAbility3.setVisible(false);
        }
    }

    private void clearAllToPosition() {
        this.prmtToPosition1.setData((Object)"");
        this.pkToPositionDate1.setValue(null);
        this.prmtToPosition2.setData((Object)"");
        this.pkToPositionDate2.setValue(null);
        this.prmtToPosition3.setData((Object)"");
        this.pkToPositionDate3.setValue(null);
    }

    private void clearAllPerson() {
        this.txtPerson1.setText("");
        this.pkPersonDate1.setValue(null);
        this.txtPerson2.setText("");
        this.pkPersonDate2.setValue(null);
        this.txtPerson3.setText("");
        this.pkPersonDate3.setValue(null);
    }

    public boolean saveInfo() throws EASBizException, BOSException {
        HashMap map2;
        HashMap map1;
        this.checkInputValidate();
        ArrayList toPosList = this.getPosList();
        if (toPosList.size() == 2) {
            map1 = (HashMap)toPosList.get(0);
            map2 = (HashMap)toPosList.get(1);
            if (map1.get("toPosId").equals(map2.get("toPosId"))) {
                throw new StandbyException(StandbyException.TOPOSITION_CANNOT_DUP);
            }
        }
        if (toPosList.size() == 3) {
            map1 = (HashMap)toPosList.get(0);
            map2 = (HashMap)toPosList.get(1);
            HashMap map3 = (HashMap)toPosList.get(2);
            if (map1.get("toPosId").equals(map2.get("toPosId")) || map1.get("toPosId").equals(map3.get("toPosId")) || map2.get("toPosId").equals(map3.get("toPosId"))) {
                throw new StandbyException(StandbyException.TOPOSITION_CANNOT_DUP);
            }
        }
        StandbyTypeInfo sbTypeInfo = (StandbyTypeInfo)this.prmtStandbyType.getData();
        IStandbyPerson iSbPer = StandbyPersonFactory.getRemoteInstance();
        iSbPer.updateStandbyPersonInfo(this.curSbPerInfo.getEmployee().getId().toString(), toPosList, sbTypeInfo.getId().toString());
        this.oldPosList = this.getPosList();
        if (this.prmtStandbyType.getData() != null) {
            this.oldSPTInfo = (StandbyTypeInfo)this.prmtStandbyType.getData();
        }
        return true;
    }

    private void checkInputValidate() throws EASBizException, BOSException {
        if (this.prmtStandbyType.getData() == null) {
            this.prmtStandbyType.requestFocusInWindow();
            throw new StandbyException(StandbyException.STANDBYTYPE_CANNOT_EMPTY);
        }
        PositionInfo toPosInfo = null;
        if (!this.prmtToPosition1.getText().trim().equals("") && this.isToPositionEqualsEmpPosition(toPosInfo = (PositionInfo)this.prmtToPosition1.getData())) {
            this.pkToPositionDate1.requestFocusInWindow();
            throw new StandbyException(StandbyException.TOPOSITION_CANNOT_EQUAL_EMPPOSITION);
        }
        if (!this.prmtToPosition2.getText().trim().equals("") && this.isToPositionEqualsEmpPosition(toPosInfo = (PositionInfo)this.prmtToPosition2.getData())) {
            this.pkToPositionDate2.requestFocusInWindow();
            throw new StandbyException(StandbyException.TOPOSITION_CANNOT_EQUAL_EMPPOSITION);
        }
        if (!this.prmtToPosition3.getText().trim().equals("") && this.isToPositionEqualsEmpPosition(toPosInfo = (PositionInfo)this.prmtToPosition3.getData())) {
            this.pkToPositionDate3.requestFocusInWindow();
            throw new StandbyException(StandbyException.TOPOSITION_CANNOT_EQUAL_EMPPOSITION);
        }
    }

    private boolean isToPositionEqualsEmpPosition(PositionInfo toPosInfo) throws EASBizException, BOSException {
        IPerson iPer = PersonFactory.getRemoteInstance();
        PositionInfo empPosInfo = iPer.getPrimaryPosition(this.curSbPerInfo.getEmployee().getId());
        return toPosInfo.getId().equals((Object)empPosInfo.getId());
    }

    protected void btnPersonAbility1_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"ID", (Object)this.person1Id);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EmployeeCompetIndexUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected void btnPersonAbility2_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"ID", (Object)this.person2Id);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EmployeeCompetIndexUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected void btnPersonAbility3_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"ID", (Object)this.person3Id);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EmployeeCompetIndexUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected void btnToPositionCompetency1_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtToPosition1.getData() == null) {
            this.showMsgInfo();
        } else {
            UIContext uiCtx = new UIContext((Object)this);
            uiCtx.put((Object)"ID", (Object)((PositionInfo)this.prmtToPosition1.getData()).getId().toString());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PositionCompetencyListUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    protected void btnToPositionCompetency2_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtToPosition2.getData() == null) {
            this.showMsgInfo();
        } else {
            UIContext uiCtx = new UIContext((Object)this);
            uiCtx.put((Object)"ID", (Object)((PositionInfo)this.prmtToPosition2.getData()).getId().toString());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PositionCompetencyListUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    protected void btnToPositionCompetency3_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtToPosition3.getData() == null) {
            this.showMsgInfo();
        } else {
            UIContext uiCtx = new UIContext((Object)this);
            uiCtx.put((Object)"ID", (Object)((PositionInfo)this.prmtToPosition3.getData()).getId().toString());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PositionCompetencyListUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    protected void btnToPositionRequest1_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtToPosition1.getData() == null) {
            this.showMsgInfo();
        } else {
            UIContext uiCtx = new UIContext((Object)this);
            uiCtx.put((Object)"ID", (Object)((PositionInfo)this.prmtToPosition1.getData()).getId().toString());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PositionRequestListUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    protected void btnToPositionRequest2_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtToPosition2.getData() == null) {
            this.showMsgInfo();
        } else {
            UIContext uiCtx = new UIContext((Object)this);
            uiCtx.put((Object)"ID", (Object)((PositionInfo)this.prmtToPosition2.getData()).getId().toString());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PositionRequestListUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    protected void btnToPositionRequest3_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtToPosition3.getData() == null) {
            this.showMsgInfo();
        } else {
            UIContext uiCtx = new UIContext((Object)this);
            uiCtx.put((Object)"ID", (Object)((PositionInfo)this.prmtToPosition3.getData()).getId().toString());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PositionRequestListUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    private void showMsgInfo() {
        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"TARGETPOSITIONISNULL"));
    }

    public boolean isModify() {
        this.newPosList = this.getPosList();
        if (this.prmtStandbyType.getData() != null) {
            this.newSPTInfo = (StandbyTypeInfo)this.prmtStandbyType.getData();
        }
        if (this.oldPosList == null && this.newPosList != null || this.oldPosList != null && this.newPosList == null || this.oldPosList != null && this.newPosList != null && !this.oldPosList.equals(this.newPosList)) {
            return true;
        }
        return this.oldSPTInfo == null && this.newSPTInfo != null || this.oldSPTInfo != null && this.newSPTInfo == null || this.oldSPTInfo != null && this.newSPTInfo != null && !this.oldSPTInfo.equals(this.newSPTInfo);
    }

    private ArrayList getPosList() {
        Date toPosDate;
        PositionInfo toPosInfo;
        ArrayList posList = new ArrayList();
        HashMap<String, Object> map = null;
        if (!this.prmtToPosition1.getText().trim().equals("")) {
            toPosInfo = (PositionInfo)this.prmtToPosition1.getData();
            toPosDate = (Date)this.pkToPositionDate1.getValue();
            map = new HashMap<String, Object>();
            map.put("toPosId", toPosInfo.getId().toString());
            map.put("toPosLevel", 1);
            map.put("toPosDate", toPosDate);
            posList.add(map);
        }
        if (!this.prmtToPosition2.getText().trim().equals("")) {
            toPosInfo = (PositionInfo)this.prmtToPosition2.getData();
            toPosDate = (Date)this.pkToPositionDate2.getValue();
            map = new HashMap();
            map.put("toPosId", toPosInfo.getId().toString());
            map.put("toPosLevel", 2);
            map.put("toPosDate", toPosDate);
            posList.add(map);
        }
        if (!this.prmtToPosition3.getText().trim().equals("")) {
            toPosInfo = (PositionInfo)this.prmtToPosition3.getData();
            toPosDate = (Date)this.pkToPositionDate3.getValue();
            map = new HashMap();
            map.put("toPosId", toPosInfo.getId().toString());
            map.put("toPosLevel", 3);
            map.put("toPosDate", toPosDate);
            posList.add(map);
        }
        return posList;
    }
}

