/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.client;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.hraux.util.HRTreeUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HierarchyCollection;
import com.kingdee.eas.basedata.org.HierarchyFactory;
import com.kingdee.eas.basedata.org.HierarchyInfo;
import com.kingdee.eas.basedata.org.IHierarchy;
import com.kingdee.eas.basedata.org.client.tree.NewOrgTreeHelper;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.standby.ForUpgradeFactory;
import com.kingdee.eas.hr.standby.client.AbstractStandbyPersonMapUI;
import com.kingdee.eas.hr.standby.client.StandbyPersonMapFilterUI;
import com.kingdee.eas.hr.standby.client.chart.DrawStandbyPerson;
import com.kingdee.eas.hr.standby.client.chart.OrgUnit;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class StandbyPersonMapUI
extends AbstractStandbyPersonMapUI {
    private static final Logger logger = CoreUIObject.getLogger(StandbyPersonMapUI.class);
    private DefaultKingdeeTreeNode node = null;
    private boolean treeLoaded = false;
    private DrawStandbyPerson mapPanel = null;
    private HierarchyInfo hierarchyInfo = null;
    private HierarchyInfo defaultHierarchyInfo = null;
    private boolean isRefresh = false;
    private CommonQueryDialog commonQueryDialog = null;
    private StandbyPersonMapFilterUI customerPanel = null;
    private IMetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.org.app", "PositionTotalReportQuery");
    private int level;
    private boolean horizontal;
    private boolean displayPerson;
    private boolean includeVirtualOrg = true;
    private boolean isFirstDefaultQuery = true;
    private KDPanel emptyPanel = null;

    private void buildTree() throws Exception {
        this.treeLoaded = false;
        this.treeMain.setShowsRootHandles(true);
        DefaultKingdeeTreeNode rootNode = null;
        if (this.defaultHierarchyInfo != null && this.hierarchyInfo.getId().toString().equalsIgnoreCase(this.defaultHierarchyInfo.getId().toString())) {
            rootNode = HRTreeUtil.createAdminTreeNodeByUserRange((boolean)false, (boolean)this.includeVirtualOrg, (boolean)false, (boolean)false, null, (boolean)false);
            if (rootNode != null) {
                DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)rootNode);
                this.treeMain.setModel((TreeModel)treeModel);
                this.locateCurrOrg();
                if (!this.treeLoaded) {
                    this.treeLoaded = true;
                    this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot());
                }
            }
        } else {
            rootNode = NewOrgTreeHelper.createAdminHierarchyTreeNode((String)this.hierarchyInfo.getId().toString(), (boolean)false);
            if (rootNode != null) {
                DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)rootNode);
                this.treeMain.setModel((TreeModel)treeModel);
                this.treeLoaded = true;
                this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot());
            }
        }
        if (rootNode == null) {
            this.treeMain.setModel((TreeModel)new DefaultTreeModel(null));
            if (this.emptyPanel == null) {
                this.emptyPanel = new KDPanel();
            }
            this.pnlMain.add((Component)this.emptyPanel, (Object)"right");
        }
    }

    private void locateCurrOrg() throws Exception {
        PersonInfo pInfo = SysContext.getSysContext().getCurrentUserInfo().getPerson();
        if (pInfo == null) {
            return;
        }
        IPerson iPerson = PersonFactory.getRemoteInstance();
        AdminOrgUnitInfo adminInfo = iPerson.getPrimaryAdminOrgUnit(pInfo.getId());
        this.treeLoaded = true;
        if (adminInfo == null) {
            this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot());
            return;
        }
        this.expandTreeNode(this.treeMain, adminInfo.getId().toString());
    }

    public void expandTreeNode(KDTree tree, String orgUnitId) {
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        this.findNodeByUnitID((DefaultKingdeeTreeNode)model.getRoot(), orgUnitId);
        if (this.node != null) {
            Object[] nodes = this.node.getPath();
            TreePath path = new TreePath(nodes);
            tree.setSelectionPath(path);
        } else {
            tree.setSelectionNode((DefaultKingdeeTreeNode)tree.getModel().getRoot());
        }
    }

    private DefaultKingdeeTreeNode findNodeByUnitID(DefaultKingdeeTreeNode parentNode, String orgUnitId) {
        if (parentNode.getUserObject() instanceof AdminOrgUnitInfo && ((AdminOrgUnitInfo)parentNode.getUserObject()).getId().toString().equals(orgUnitId)) {
            this.node = parentNode;
        } else {
            for (int i = 0; i < parentNode.getChildCount(); ++i) {
                this.findNodeByUnitID((DefaultKingdeeTreeNode)parentNode.getChildAt(i), orgUnitId);
            }
        }
        return null;
    }

    public void onLoad() throws Exception {
        ForUpgradeFactory.getRemoteInstance().checkIsUpgrade();
        super.onLoad();
        this.setButtonDefaultStyl(this.btnRefresh);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.setButtonDefaultStyl(this.btnQuery);
        this.loadHierarchyData();
        this.actionQuery_actionPerformed(null);
    }

    private void loadHierarchyData() throws Exception {
        IHierarchy iHierarchy = HierarchyFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(this.getCUFilterForQuery());
        SorterItemInfo sortInfo = new SorterItemInfo("isDefault");
        sortInfo.setSortType(SortType.DESCEND);
        evi.getSorter().add(sortInfo);
        HierarchyCollection hierarchyCollection = iHierarchy.getHierarchyCollection(evi);
        for (int i = 0; i < hierarchyCollection.size(); ++i) {
            if (!hierarchyCollection.get(i).isIsDefault()) continue;
            this.defaultHierarchyInfo = hierarchyCollection.get(i);
            this.hierarchyInfo = hierarchyCollection.get(i);
        }
    }

    protected FilterInfo getCUFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        filter.setMaskString("#0 or #1 or #2");
        return filter;
    }

    public static DefaultKingdeeTreeNode getSelectTreeNode(KDTree tree) {
        TreePath path;
        DefaultKingdeeTreeNode selectNode = null;
        if (tree != null && (path = tree.getSelectionPath()) != null) {
            selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        }
        return selectNode;
    }

    private void getChildrenNodes(DefaultKingdeeTreeNode parent, DefaultMutableTreeNode root) {
        if (parent.getUserObject() instanceof AdminOrgUnitInfo) {
            AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)parent.getUserObject();
            OrgUnit unit = new OrgUnit();
            unit.ID = adminInfo.getId().toString();
            unit.level = adminInfo.getLevel();
            unit.name = adminInfo.getName();
            unit.number = adminInfo.getNumber();
            if (!HRTreeUtil.isTreeNodeDisable((DefaultKingdeeTreeNode)parent) && adminInfo.get("CAN_VIEW") != null) {
                unit.canView = true;
            }
            root.setUserObject(unit);
            DefaultMutableTreeNode child = null;
            for (int i = parent.getChildCount() - 1; i >= 0; --i) {
                child = new DefaultMutableTreeNode();
                this.getChildrenNodes((DefaultKingdeeTreeNode)parent.getChildAt(i), child);
                root.add(child);
            }
        }
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
        if (this.treeLoaded) {
            DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
            DefaultKingdeeTreeNode selectNode = StandbyPersonMapUI.getSelectTreeNode(this.treeMain);
            if (selectNode == null) {
                return;
            }
            this.getChildrenNodes(selectNode, (DefaultMutableTreeNode)root);
            if (this.mapPanel == null) {
                this.mapPanel = new DrawStandbyPerson(this.getWidth(), this.getHeight(), (DefaultMutableTreeNode)root, 0, true, this.level, this.horizontal, this.displayPerson, true);
                this.mapPanel.setUserComponents(this.getUserComponents());
                this.mapPanel.preButton.setVisible(false);
                this.mapPanel.nextButton.setVisible(false);
            } else {
                this.mapPanel.setRootNode((DefaultMutableTreeNode)root);
            }
            if (this.isRefresh) {
                this.mapPanel.clearCacheData();
            }
            this.pnlMain.setDividerLocation(240);
            this.pnlMain.add((Component)((Object)this.mapPanel), (Object)"right");
            this.pnlMain.revalidate();
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.isRefresh = true;
        this.buildTree();
        this.isRefresh = false;
    }

    protected OrgUnit getSelectNode() {
        return this.mapPanel.getSelectNode();
    }

    protected Component[] getUserComponents() {
        return null;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = this.getQueryInfo(this.mainQueryPK).getFullName();
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            this.isFirstDefaultQuery = false;
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
            if (solution != null && solution.getQueryPanelInfo() != null && solution.getQueryPanelInfo().size() > 0 && solution.getQueryPanelInfo().get(0).getCustomerParams() != null && CustomerParams.getCustomerParams2((String)solution.getQueryPanelInfo().get(0).getCustomerParams()) != null) {
                CustomerParams params = CustomerParams.getCustomerParams2((String)solution.getQueryPanelInfo().get(0).getCustomerParams());
                this.level = params.getInt("Level");
                this.horizontal = !params.getBoolean("DisplayType");
                this.displayPerson = params.getBoolean("DisplayPP");
                this.includeVirtualOrg = params.getBoolean("IncludeVirtualOrg");
                this.buildTree();
                if (this.mapPanel != null) {
                    this.mapPanel.setRepaintData(this.level, this.horizontal, this.displayPerson, true);
                }
                return;
            }
            this.showFilterDialog();
        } else {
            this.showFilterDialog();
        }
        this.isFirstDefaultQuery = false;
    }

    private QueryInfo getQueryInfo(IMetaDataPK queryPK) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getQuery(queryPK);
    }

    private void showFilterDialog() throws Exception {
        this.isFirstDefaultQuery = false;
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            this.commonQueryDialog.setHeight(350);
            this.commonQueryDialog.setWidth(400);
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.commonQueryDialog.setQueryObjectPK(this.mainQueryPK);
            this.commonQueryDialog.setShowFilter(false);
            this.commonQueryDialog.setShowSorter(false);
            this.commonQueryDialog.setShowToolbar(true);
            this.customerPanel = new StandbyPersonMapFilterUI();
            this.commonQueryDialog.addUserPanel((KDPanel)this.customerPanel);
            String commonQueryRes = "com.kingdee.eas.hr.time.TimeResource";
            this.commonQueryDialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)commonQueryRes, (String)"CONDITION_QUERY"));
        }
        if (this.commonQueryDialog.show()) {
            CustomerParams params = this.customerPanel.getCustomerParams();
            this.level = params.getInt("Level");
            this.horizontal = !params.getBoolean("DisplayType");
            this.displayPerson = params.getBoolean("DisplayPP");
            this.includeVirtualOrg = params.getBoolean("IncludeVirtualOrg");
            this.buildTree();
            if (this.mapPanel != null) {
                this.mapPanel.setRepaintData(this.level, this.horizontal, this.displayPerson, true);
            }
            return;
        }
        SysUtil.abort();
    }
}

