/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.hr.standby.IStandbyPersonPlan;
import com.kingdee.eas.hr.standby.IStandbyPersonWish;
import com.kingdee.eas.hr.standby.StandbyException;
import com.kingdee.eas.hr.standby.StandbyPersonFactory;
import com.kingdee.eas.hr.standby.StandbyPersonInfo;
import com.kingdee.eas.hr.standby.StandbyPersonPlanCollection;
import com.kingdee.eas.hr.standby.StandbyPersonPlanFactory;
import com.kingdee.eas.hr.standby.StandbyPersonPlanInfo;
import com.kingdee.eas.hr.standby.StandbyPersonWishCollection;
import com.kingdee.eas.hr.standby.StandbyPersonWishFactory;
import com.kingdee.eas.hr.standby.StandbyPersonWishInfo;
import com.kingdee.eas.hr.standby.StandbyTrainingItemFactory;
import com.kingdee.eas.hr.standby.StandbyTrainingItemInfo;
import com.kingdee.eas.hr.standby.client.AbstractStandbyPersonPlanUI;
import com.kingdee.eas.hr.standby.client.IStandbyPersonEditUI;
import com.kingdee.eas.hr.standby.client.StandbyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class StandbyPersonPlanUI
extends AbstractStandbyPersonPlanUI
implements IStandbyPersonEditUI {
    private static final Logger logger = CoreUIObject.getLogger(StandbyPersonPlanUI.class);
    private String empId = null;
    private static final String dateFormatStr = "%r{yyyy-MM-dd}t";
    private ArrayList deletePlanIds = new ArrayList();
    private ArrayList deleteWishIds = new ArrayList();
    private StandbyPersonPlanCollection oldPlanCol = null;
    private StandbyPersonPlanCollection newPlanCol = null;
    private StandbyPersonWishCollection oldWishCol = null;
    private StandbyPersonWishCollection newWishCol = null;

    public void onLoad() throws Exception {
        this.setStandbyPersonId(this.getUIContext().get("ID").toString());
        super.onLoad();
        this.setTableCellEditor();
        this.firstLoad();
        this.oldPlanCol = this.getAllPlanCollection();
        this.oldWishCol = this.getAllWishCollection();
    }

    private void firstLoad() throws Exception {
        this.loadAllPlanAndWish();
    }

    public void secondLoad() throws Exception {
        this.loadAllPlanAndWish();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddPlan.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDeletePlan.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnAddPlan.setEnabled(true);
        this.btnDeletePlan.setEnabled(true);
        this.btnAddWish.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDeleteWish.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnAddWish.setEnabled(true);
        this.btnDeleteWish.setEnabled(true);
        this.tblPlan.getStyleAttributes().setWrapText(true);
        this.tblPlan.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblPlan.getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        this.tblWish.getStyleAttributes().setWrapText(true);
        this.tblWish.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblWish.getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        this.setControlProperties();
    }

    private void setControlProperties() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.tblPlan.getStyleAttributes().setLocked(true);
            this.btnAddPlan.setEnabled(false);
            this.btnDeletePlan.setEnabled(false);
            this.tblWish.getStyleAttributes().setLocked(true);
            this.btnAddWish.setEnabled(false);
            this.btnDeleteWish.setEnabled(false);
        }
    }

    private void setTableCellEditor() throws Exception {
        this.tblPlan.checkParsed();
        KDDatePicker beginDate = new KDDatePicker();
        beginDate.setValue((Object)new Date());
        this.tblPlan.getColumn("beginDate").setEditor((ICellEditor)new KDTDefaultCellEditor(beginDate));
        this.tblPlan.getColumn("beginDate").getStyleAttributes().setNumberFormat(dateFormatStr);
        KDDatePicker endDate = new KDDatePicker();
        endDate.setValue((Object)new Date());
        this.tblPlan.getColumn("endDate").setEditor((ICellEditor)new KDTDefaultCellEditor(endDate));
        this.tblPlan.getColumn("endDate").getStyleAttributes().setNumberFormat(dateFormatStr);
        KDTextField txtTarget = new KDTextField();
        txtTarget.setMaxLength(80);
        this.tblPlan.getColumn("target").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtTarget));
        KDTextField txtSummary = new KDTextField();
        txtSummary.setMaxLength(200);
        this.tblPlan.getColumn("summary").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtSummary));
        KDTextField txtDescription = new KDTextField();
        txtDescription.setMaxLength(200);
        this.tblPlan.getColumn("description").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtDescription));
        KDBizPromptBox prmtTrainingItem = new KDBizPromptBox();
        prmtTrainingItem.setQueryInfo("com.kingdee.eas.hr.standby.app.StandbyTrainingItemQuery");
        prmtTrainingItem.setEnabledMultiSelection(false);
        prmtTrainingItem.setEditable(false);
        this.tblPlan.getColumn("trainingItem").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtTrainingItem));
        this.tblPlan.getColumn("trainingItem").getStyleAttributes().setBackground(StandbyUtils.MUSTINPUT_BGCOLOR);
        KDTextField txtMethod = new KDTextField();
        txtMethod.setMaxLength(80);
        this.tblPlan.getColumn("method").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtMethod));
        this.tblPlan.getColumn("method").getStyleAttributes().setBackground(StandbyUtils.MUSTINPUT_BGCOLOR);
        this.tblWish.checkParsed();
        KDBizPromptBox prmtPositionBox = new KDBizPromptBox();
        PositionPromptBox2 position = new PositionPromptBox2((IUIObject)this);
        position.setSealUp("true");
        prmtPositionBox.setSelector((KDPromptSelector)position);
        prmtPositionBox.setDisplayFormat("$name$");
        prmtPositionBox.setEditFormat("$number$");
        prmtPositionBox.setCommitFormat("$number$");
        prmtPositionBox.setEditable(false);
        this.tblWish.getColumn("toPosition").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtPositionBox));
        KDTextField txtCareerPlan = new KDTextField();
        txtCareerPlan.setMaxLength(200);
        this.tblWish.getColumn("careerPlan").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtCareerPlan));
        KDTextField txtExcellence = new KDTextField();
        txtExcellence.setMaxLength(80);
        this.tblWish.getColumn("excellence").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtExcellence));
        KDTextField txtShortage = new KDTextField();
        txtShortage.setMaxLength(80);
        this.tblWish.getColumn("shortage").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtShortage));
        KDTextField txtRequest = new KDTextField();
        txtRequest.setMaxLength(200);
        this.tblWish.getColumn("request").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtRequest));
    }

    private void loadAllPlanAndWish() throws EASBizException, BOSException {
        this.tblPlan.checkParsed();
        this.tblPlan.removeRows();
        EntityViewInfo planView = new EntityViewInfo();
        FilterInfo planFilter = new FilterInfo();
        planFilter.getFilterItems().add(new FilterItemInfo("employee", (Object)this.empId));
        try {
            FilterInfo filter = new FilterInfo("isAudited = 1");
            planFilter.mergeFilter(filter, "and");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        planView.setFilter(planFilter);
        StandbyPersonPlanCollection planCol = StandbyPersonPlanFactory.getRemoteInstance().getStandbyPersonPlanCollection(planView);
        int size = planCol.size();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblPlan.addRow();
            StandbyPersonPlanInfo planInfo = planCol.get(i);
            row.getCell("id").setValue((Object)planInfo.getId().toString());
            if (planInfo.getTarget() != null) {
                row.getCell("target").setValue((Object)planInfo.getTarget());
            }
            if (planInfo.getTrainingItem() != null) {
                StandbyTrainingItemInfo trainingItem = StandbyTrainingItemFactory.getRemoteInstance().getStandbyTrainingItemInfo((IObjectPK)new ObjectUuidPK(planInfo.getTrainingItem().getId()));
                row.getCell("trainingItem").setValue((Object)trainingItem);
            }
            if (planInfo.getSummary() != null) {
                row.getCell("summary").setValue((Object)planInfo.getSummary());
            }
            if (planInfo.getMethod() != null) {
                row.getCell("method").setValue((Object)planInfo.getMethod());
            }
            if (planInfo.getDescription() != null) {
                row.getCell("description").setValue((Object)planInfo.getDescription());
            }
            if (planInfo.getBeginDate() != null) {
                row.getCell("beginDate").setValue((Object)planInfo.getBeginDate());
            }
            if (planInfo.getEndDate() == null) continue;
            row.getCell("endDate").setValue((Object)planInfo.getEndDate());
        }
        this.tblWish.checkParsed();
        this.tblWish.removeRows();
        EntityViewInfo wishView = new EntityViewInfo();
        FilterInfo wishFilter = new FilterInfo();
        wishFilter.getFilterItems().add(new FilterItemInfo("employee", (Object)this.empId));
        try {
            FilterInfo filter = new FilterInfo("isAudited = 1");
            wishFilter.mergeFilter(filter, "and");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        wishView.setFilter(wishFilter);
        StandbyPersonWishCollection wishCol = StandbyPersonWishFactory.getRemoteInstance().getStandbyPersonWishCollection(wishView);
        int size2 = wishCol.size();
        for (int i = 0; i < size2; ++i) {
            IRow row = this.tblWish.addRow();
            StandbyPersonWishInfo wishInfo = wishCol.get(i);
            row.getCell("id").setValue((Object)wishInfo.getId().toString());
            if (wishInfo.getToPosition() != null) {
                PositionInfo posInfo = PositionFactory.getRemoteInstance().getPositionInfo((IObjectPK)new ObjectUuidPK(wishInfo.getToPosition().getId()));
                row.getCell("toPosition").setValue((Object)posInfo);
            }
            if (wishInfo.getCareerPlan() != null) {
                row.getCell("careerPlan").setValue((Object)wishInfo.getCareerPlan());
            }
            if (wishInfo.getExcellence() != null) {
                row.getCell("excellence").setValue((Object)wishInfo.getExcellence());
            }
            if (wishInfo.getShortage() != null) {
                row.getCell("shortage").setValue((Object)wishInfo.getShortage());
            }
            if (wishInfo.getRequest() == null) continue;
            row.getCell("request").setValue((Object)wishInfo.getRequest());
        }
    }

    private StandbyPersonPlanCollection getAllPlanCollection() {
        StandbyPersonPlanCollection planCol = new StandbyPersonPlanCollection();
        int length = this.tblPlan.getRowCount();
        for (int i = 0; i < length; ++i) {
            IRow row = this.tblPlan.getRow(i);
            StandbyPersonPlanInfo planInfo = new StandbyPersonPlanInfo();
            PersonInfo perInfo = new PersonInfo();
            perInfo.setId(BOSUuid.read((String)this.empId));
            planInfo.setEmployee(perInfo);
            if (row.getCell("id").getValue() != null) {
                planInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
            }
            if (row.getCell("target").getValue() != null) {
                planInfo.setTarget(row.getCell("target").getValue().toString());
            } else {
                planInfo.setTarget("");
            }
            StandbyTrainingItemInfo trainingItem = null;
            if (row.getCell("trainingItem").getValue() != null) {
                trainingItem = (StandbyTrainingItemInfo)row.getCell("trainingItem").getValue();
                planInfo.setTrainingItem(trainingItem);
            }
            if (row.getCell("summary").getValue() != null) {
                planInfo.setSummary(row.getCell("summary").getValue().toString());
            } else {
                planInfo.setSummary("");
            }
            if (row.getCell("method").getValue() != null) {
                planInfo.setMethod(row.getCell("method").getValue().toString());
            }
            if (row.getCell("description").getValue() != null) {
                planInfo.setDescription(row.getCell("description").getValue().toString());
            } else {
                planInfo.setDescription("");
            }
            planInfo.setBeginDate((Date)row.getCell("beginDate").getValue());
            planInfo.setEndDate((Date)row.getCell("endDate").getValue());
            planCol.add(planInfo);
        }
        return planCol;
    }

    private StandbyPersonWishCollection getAllWishCollection() {
        StandbyPersonWishCollection wishCol = new StandbyPersonWishCollection();
        int length = this.tblWish.getRowCount();
        for (int i = 0; i < length; ++i) {
            IRow row = this.tblWish.getRow(i);
            StandbyPersonWishInfo wishInfo = new StandbyPersonWishInfo();
            PersonInfo perInfo = new PersonInfo();
            perInfo.setId(BOSUuid.read((String)this.empId));
            wishInfo.setEmployee(perInfo);
            if (row.getCell("id").getValue() != null) {
                wishInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
            }
            if (row.getCell("toPosition").getValue() != null) {
                wishInfo.setToPosition((PositionInfo)row.getCell("toPosition").getValue());
            }
            if (row.getCell("careerPlan").getValue() != null) {
                wishInfo.setCareerPlan(row.getCell("careerPlan").getValue().toString());
            } else {
                wishInfo.setCareerPlan("");
            }
            if (row.getCell("excellence").getValue() != null) {
                wishInfo.setExcellence(row.getCell("excellence").getValue().toString());
            } else {
                wishInfo.setExcellence("");
            }
            if (row.getCell("shortage").getValue() != null) {
                wishInfo.setShortage(row.getCell("shortage").getValue().toString());
            } else {
                wishInfo.setShortage("");
            }
            if (row.getCell("request").getValue() != null) {
                wishInfo.setRequest(row.getCell("request").getValue().toString());
            } else {
                wishInfo.setRequest("");
            }
            wishCol.add(wishInfo);
        }
        return wishCol;
    }

    public boolean saveInfo() throws EASBizException, BOSException {
        this.checkPlanInput();
        this.checkWishInput();
        IStandbyPersonPlan iPlan = StandbyPersonPlanFactory.getRemoteInstance();
        iPlan.updateBatchPersonPlan(this.getAllPlanCollection(), this.deletePlanIds);
        IStandbyPersonWish iWish = StandbyPersonWishFactory.getRemoteInstance();
        iWish.updateBatchPersonWish(this.getAllWishCollection(), this.deleteWishIds);
        this.loadAllPlanAndWish();
        this.deletePlanIds = new ArrayList();
        this.deleteWishIds = new ArrayList();
        this.oldPlanCol = this.getAllPlanCollection();
        this.oldWishCol = this.getAllWishCollection();
        return true;
    }

    private void checkPlanInput() throws StandbyException {
        int length = this.tblPlan.getRowCount();
        for (int i = 0; i < length; ++i) {
            IRow row = this.tblPlan.getRow(i);
            if (row.getCell("trainingItem").getValue() == null) {
                throw new StandbyException(StandbyException.PLANPROJECT_CANNOT_EMPT);
            }
            if (row.getCell("method").getValue() == null || row.getCell("method").getValue().toString().trim().equals("")) {
                throw new StandbyException(StandbyException.PLANMETHOD_CANNOT_EMPTY);
            }
            if (row.getCell("beginDate").getValue() == null && row.getCell("endDate").getValue() != null || row.getCell("beginDate").getValue() != null && row.getCell("endDate").getValue() == null) {
                throw new StandbyException(StandbyException.PLAN_BEGINDATE_ENDDATE_NEEDALL);
            }
            if (row.getCell("beginDate").getValue() == null || row.getCell("endDate").getValue() == null || !DateTimeUtils.dayAfter((Date)((Date)row.getCell("beginDate").getValue()), (Date)((Date)row.getCell("endDate").getValue()))) continue;
            throw new StandbyException(StandbyException.PLAN_BEGINDATE_CANNOT_AFTER_ENDDATE);
        }
    }

    private boolean checkWishInput() throws EASBizException, BOSException {
        boolean flag = true;
        PositionInfo toPosInfo = null;
        int size = this.tblWish.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblWish.getRow(i);
            if (row.getCell("toPosition").getValue() != null) {
                toPosInfo = (PositionInfo)row.getCell("toPosition").getValue();
                IPerson iPer = PersonFactory.getRemoteInstance();
                PositionInfo empPosInfo = iPer.getPrimaryPosition(BOSUuid.read((String)this.empId));
                if (!toPosInfo.getId().toString().toUpperCase().equals(empPosInfo.getId().toString().toUpperCase())) continue;
                MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.NO") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.ROW") + EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.TOPOSITION_EMPPOSITION_CANNOT_SAME")));
                flag = false;
                SysUtil.abort();
                continue;
            }
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.TOPOSITIONCANNOTNULL"));
            SysUtil.abort();
        }
        return flag;
    }

    public void setStandbyPersonId(String standbyPersonId) throws Exception {
        StandbyPersonInfo sbPerInfo = StandbyPersonFactory.getRemoteInstance().getStandbyPersonInfo((IObjectPK)new ObjectUuidPK(standbyPersonId));
        this.empId = sbPerInfo.getEmployee().getId().toString();
    }

    protected void btnAddPlan_actionPerformed(ActionEvent e) throws Exception {
        this.tblPlan.addRow();
    }

    protected void btnDeletePlan_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblPlan);
        if (rowIndex < 0 || rowIndex >= this.tblPlan.getRowCount()) {
            return;
        }
        ICell cell = this.tblPlan.getRow(rowIndex).getCell("id");
        if (cell.getValue() != null) {
            String planId = cell.getValue().toString();
            IStandbyPersonPlan iPlan = StandbyPersonPlanFactory.getRemoteInstance();
            if (iPlan.isRefrencedByCourse(planId)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.PLAN_ISREFRENCED"));
                return;
            }
            this.deletePlanIds.add(cell.getValue().toString());
        }
        this.tblPlan.removeRow(rowIndex);
    }

    public void actionAddPlan_actionPerformed(ActionEvent e) throws Exception {
        this.tblPlan.addRow();
    }

    public void actionDeletePlan_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblPlan);
        if (rowIndex < 0 || rowIndex >= this.tblPlan.getRowCount()) {
            return;
        }
        ICell cell = this.tblPlan.getRow(rowIndex).getCell("id");
        if (cell.getValue() != null) {
            String planId = cell.getValue().toString();
            IStandbyPersonPlan iPlan = StandbyPersonPlanFactory.getRemoteInstance();
            if (iPlan.isRefrencedByCourse(planId)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.PLAN_ISREFRENCED"));
                return;
            }
            this.deletePlanIds.add(cell.getValue().toString());
        }
        this.tblPlan.removeRow(rowIndex);
    }

    public void actionAddWish_actionPerformed(ActionEvent e) throws Exception {
        this.tblWish.addRow();
    }

    public void actionDeleteWish_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblWish);
        if (rowIndex < 0 || rowIndex >= this.tblWish.getRowCount()) {
            return;
        }
        ICell cell = this.tblWish.getRow(rowIndex).getCell("id");
        if (cell.getValue() != null) {
            this.deleteWishIds.add(cell.getValue().toString());
        }
        this.tblWish.removeRow(rowIndex);
    }

    public boolean isModify() {
        this.newPlanCol = this.getAllPlanCollection();
        this.newWishCol = this.getAllWishCollection();
        return this.oldPlanCol == null && this.newPlanCol != null || this.oldPlanCol != null && this.newPlanCol == null || this.oldPlanCol != null && this.newPlanCol != null && !this.oldPlanCol.equals((Object)this.newPlanCol) || this.oldWishCol == null && this.newWishCol != null || this.oldWishCol != null && this.newWishCol == null || this.oldWishCol != null && this.newWishCol != null && !this.oldWishCol.equals((Object)this.newWishCol);
    }
}

