/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.standby.client.AbstractStandbyPersonReportFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class StandbyPersonReportFilterUI
extends AbstractStandbyPersonReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(StandbyPersonReportFilterUI.class);

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void initLayout() {
        super.initLayout();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("ALL_ADMIN", Boolean.TRUE);
        map.put("TRUE", Boolean.TRUE);
        PositionPromptBox2 pSel = new PositionPromptBox2((IUIObject)this, map);
        this.prmtToPosition.setSelector((KDPromptSelector)pSel);
        this.prmtToPosition.setSelector((KDPromptSelector)new PositionPromptBox2((IUIObject)this, map));
        this.prmtToPosition.setDisplayFormat("$name$");
        this.prmtToPosition.setEditFormat("$number$");
        this.prmtToPosition.setCommitFormat("$number$");
        this.prmtToPosition.setEditable(false);
        this.prmtToPosition.setEnabled(true);
        this.btnUnit.setSelected(true);
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        this.getHRF7Register().registerAdminByOrgRangePromptBox(this.prmtToUnit);
        AdminByOrgRangePromptBox admin = (AdminByOrgRangePromptBox)this.prmtToUnit.getSelector();
        admin.setIncludeSealUp("false");
        admin.setIsSingleSelect(true);
    }

    public boolean verify() {
        if (!super.verify()) {
            return false;
        }
        if (this.prmtToUnit.getText().trim().equals("") && this.prmtToPosition.getText().trim().equals("")) {
            this.prmtToUnit.requestFocusInWindow();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.TOUNIT_TOPOSITION_CANNOT_EMPTY"));
            return false;
        }
        return true;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        return filter;
    }

    public Object getParam() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String toUnitId = null;
        if (!this.prmtToUnit.getText().trim().equals("")) {
            AdminOrgUnitInfo toUnitInfo = (AdminOrgUnitInfo)this.prmtToUnit.getData();
            toUnitId = toUnitInfo.getId().toString();
        }
        map.put("toUnit", toUnitId);
        String toPosId = null;
        if (!this.prmtToPosition.getText().trim().equals("")) {
            PositionInfo toPosInfo = (PositionInfo)this.prmtToPosition.getData();
            toPosId = toPosInfo.getId().toString();
        }
        map.put("toPosition", toPosId);
        int state = 1;
        if (this.btnHistory.isSelected()) {
            state = 0;
        }
        if (this.btnAll.isSelected()) {
            state = 2;
        }
        map.put("state", state);
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)this.prmtHROrg.getValue();
        if (orgUnitInfo != null && orgUnitInfo.getId() != null) {
            map.put("hrOrgUnitId", orgUnitInfo.getId().toString());
        }
        if (this.btnUnit.isSelected()) {
            map.put("includeSealUp", this.chkShowSealUp.isSelected());
            map.put("ShowVirtualOrg", this.chkShowVirtualOrg.isSelected());
        }
        return map;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        if (cp == null) {
            cp = new CustomerParams();
        }
        cp.putBoolean("isUnit", this.btnUnit.isSelected());
        cp.putBoolean("isPosition", this.btnPosition.isSelected());
        String toUnitId = null;
        if (this.prmtToUnit.getData() != null) {
            AdminOrgUnitInfo toUnitInfo = (AdminOrgUnitInfo)this.prmtToUnit.getData();
            toUnitId = toUnitInfo.getId().toString();
        }
        cp.addCustomerParam("toUnit", toUnitId);
        String toPosId = null;
        if (this.prmtToPosition.getData() != null) {
            PositionInfo toPosInfo = (PositionInfo)this.prmtToPosition.getData();
            toPosId = toPosInfo.getId().toString();
        }
        cp.addCustomerParam("toPosition", toPosId);
        int state = 1;
        if (this.btnHistory.isSelected()) {
            state = 0;
        }
        if (this.btnAll.isSelected()) {
            state = 2;
        }
        cp.putInt("state", state);
        cp.putBoolean(this.chkShowSealUp.getName(), this.chkShowSealUp.isSelected());
        cp.putBoolean("ShowVirtualOrg", this.chkShowVirtualOrg.isSelected());
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (cp == null) {
            return;
        }
        this.btnUnit.setSelected(cp.getBoolean("isUnit"));
        this.btnPosition.setSelected(cp.getBoolean("isPosition"));
        if (cp.getCustomerParam("toUnit") != null) {
            try {
                AdminOrgUnitInfo toUnitInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(cp.getCustomerParam("toUnit")));
                this.prmtToUnit.setData((Object)toUnitInfo);
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else {
            this.prmtToUnit.setData(null);
        }
        if (cp.getCustomerParam("toPosition") != null) {
            try {
                PositionInfo toPosInfo = PositionFactory.getRemoteInstance().getPositionInfo((IObjectPK)new ObjectUuidPK(cp.getCustomerParam("toPosition")));
                this.prmtToPosition.setData((Object)toPosInfo);
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else {
            this.prmtToPosition.setData(null);
        }
        int state = cp.getInt("state");
        if (state == 1) {
            this.btnNow.setSelected(true);
        } else if (state == 0) {
            this.btnHistory.setSelected(true);
        } else if (state == 2) {
            this.btnAll.setSelected(true);
        }
        this.chkShowSealUp.setSelected(cp.getBoolean(this.chkShowSealUp.getName()));
        this.chkShowVirtualOrg.setSelected(cp.getBoolean("ShowVirtualOrg"));
    }

    public void clear() {
        super.clear();
        this.prmtToUnit.setData(null);
        this.prmtToPosition.setData(null);
        this.btnNow.setSelected(true);
        this.btnUnit.setSelected(true);
        this.chkShowSealUp.setSelected(false);
        this.chkShowVirtualOrg.setSelected(false);
    }

    protected void btnUnit_itemStateChanged(ItemEvent e) throws Exception {
        super.btnUnit_itemStateChanged(e);
        this.prmtToUnit.setEnabled(true);
        this.chkShowSealUp.setEnabled(true);
        this.chkShowVirtualOrg.setEnabled(true);
        this.prmtToPosition.setEnabled(false);
        this.prmtToPosition.setData(null);
    }

    protected void btnPosition_itemStateChanged(ItemEvent e) throws Exception {
        super.btnPosition_itemStateChanged(e);
        this.prmtToPosition.setEnabled(true);
        this.prmtToUnit.setEnabled(false);
        this.chkShowSealUp.setEnabled(false);
        this.chkShowSealUp.setSelected(false);
        this.chkShowVirtualOrg.setEnabled(false);
        this.chkShowVirtualOrg.setSelected(false);
        this.prmtToUnit.setData(null);
    }
}

