/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.DynQueryListUI;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.client.context.IDelegationSupport;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.framework.client.context.OrgContextHelper;
import com.kingdee.eas.framework.client.context.OrgContextManager;
import com.kingdee.eas.hr.base.OutputExcelUtil;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.org.client.HRPositionEditUI;
import com.kingdee.eas.hr.standby.IStandbyPersonFacade;
import com.kingdee.eas.hr.standby.StandbyPersonFacadeFactory;
import com.kingdee.eas.hr.standby.client.AbstractStandbyPersonReportUI;
import com.kingdee.eas.hr.standby.client.StandbyPersonEditUI;
import com.kingdee.eas.hr.standby.client.StandbyPersonReportFilterUI;
import com.kingdee.eas.hr.standby.client.StandbyPersonToPositionMatchUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class StandbyPersonReportUI
extends AbstractStandbyPersonReportUI
implements IDelegationSupport {
    private static final Logger logger = CoreUIObject.getLogger(StandbyPersonReportUI.class);
    private Color ACROSS_BGCOLOR = new Color(255, 255, 255);
    private boolean isFirstDefaultQuery = true;
    private HashMap curFilterMap = null;
    private CommonQueryDialog commonQueryDialog = null;
    private EntityViewInfo mainQuery = null;
    IMetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.standby.app.StandbyPersonQuery");
    private StandbyPersonReportFilterUI customerPanel = null;

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintView.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuItemExportData.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnToPositionMatch.setIcon(EASResource.getIcon((String)"imgTbtn_diathesisaccord"));
        this.menuItemToPositionMatch.setIcon(EASResource.getIcon((String)"imgTbtn_diathesisaccord"));
        this.btnPersonDetail.setIcon(EASResource.getIcon((String)"imgTbtn_business"));
        this.menuItemPersonDetail.setIcon(EASResource.getIcon((String)"imgTbtn_business"));
        this.btnToPositionDetail.setIcon(EASResource.getIcon((String)"imgTbtn_jobinfo"));
        this.menuItemToPositionDetail.setIcon(EASResource.getIcon((String)"imgTbtn_jobinfo"));
        this.btnQueryScheme.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewlist"));
        this.btnQueryScheme.setEnabled(true);
        this.tblMain.getStyleAttributes().setWrapText(true);
        this.tblMain.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblMain.getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.MIDDLE);
        this.setButtonDefaultStyl(this.btnFilter);
        this.setButtonDefaultStyl(this.btnRefresh);
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPrintView);
        this.menuView.setMnemonic('V');
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.performCommonQuery();
    }

    public void actionQueryScheme_actionPerformed(ActionEvent e) throws Exception {
        super.actionQueryScheme_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"parentUIName", (Object)this.getMetaDataPK().getFullName());
        uiContext.put((Object)"queryFullName", (Object)this.mainQueryPK.getFullName());
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow curDialog = uiFactory.create(DynQueryListUI.class.getName(), (Map)uiContext);
            curDialog.show();
        }
        catch (UIException exl) {
            this.handleException((Exception)((Object)exl));
        }
    }

    private void loadReportData(HashMap map) throws EASBizException, BOSException {
        if (map == null) {
            return;
        }
        this.tblMain.checkParsed();
        int state = (Integer)map.get("state");
        if (state == 0) {
            this.tblMain.getColumn("toStandbyAudit").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("toStandbyReason").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("toCommonAudit").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("toCommonReason").getStyleAttributes().setHided(false);
        } else if (state == 1) {
            this.tblMain.getColumn("toCommonAudit").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("toCommonReason").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("toStandbyAudit").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("toStandbyReason").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("toStandbyAudit").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("toStandbyReason").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("toCommonAudit").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("toCommonReason").getStyleAttributes().setHided(false);
        }
        this.tblMain.removeRows();
        IStandbyPersonFacade iSbPerFacade = StandbyPersonFacadeFactory.getRemoteInstance();
        ArrayList list = iSbPerFacade.getResultReportPerson(map);
        int size = list.size();
        if (size <= 0) {
            return;
        }
        HashMap newMap = null;
        String preFlagId = ((HashMap)list.get(0)).get("toPosOrToUnitId").toString();
        boolean isChangeColor = false;
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.addRow();
            newMap = (HashMap)list.get(i);
            String curFlagId = newMap.get("toPosOrToUnitId").toString();
            if (!preFlagId.equals(curFlagId)) {
                isChangeColor = !isChangeColor;
                preFlagId = curFlagId;
            }
            if (isChangeColor) {
                row.getStyleAttributes().setBackground(this.ACROSS_BGCOLOR);
            }
            row.getCell("id").setValue((Object)newMap.get("id").toString());
            row.getCell("toPositionId").setValue(newMap.get("toPositionId"));
            row.getCell("toUnit").setValue(newMap.get("toUnit"));
            row.getCell("toPosition").setValue(newMap.get("toPosition"));
            row.getCell("employeeId").setValue(newMap.get("employeeId"));
            row.getCell("empName").setValue(newMap.get("empName"));
            row.getCell("empUnit").setValue(newMap.get("empUnit"));
            row.getCell("empPosition").setValue(newMap.get("empPosition"));
            row.getCell("standbyType").setValue(newMap.get("standbyType"));
            row.getCell("toStandbyAudit").setValue(newMap.get("toStandbyAudit"));
            row.getCell("toStandbyReason").setValue(newMap.get("toStandbyReason"));
            row.getCell("toCommonAudit").setValue(newMap.get("toCommonAudit"));
            row.getCell("toCommonReason").setValue(newMap.get("toCommonReason"));
            row.getCell("standbyState").setValue(newMap.get("standbyState"));
            row.getCell("isStandby").setValue(newMap.get("isStandby"));
            row.getCell("startTime").setValue(newMap.get("startTime"));
            row.getCell("endTime").setValue(newMap.get("endTime"));
            row.getCell("toPositionUnit.name").setValue(newMap.get("toPositionUnit.name"));
        }
    }

    public KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected void performCommonQuery() throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        String queryName = loader.getQuery(this.standbyPersonQueryPK).getFullName();
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
            if (solution.getSolutionType().getValue().equals("10")) {
                this.showFilterDialog(this.customerPanel);
            } else {
                CustomerParams cp = CustomerParams.getCustomerParams2((String)CompUtils.getCustmerParamsUtil((QuerySolutionInfo)solution));
                StandbyPersonReportFilterUI filterUI = new StandbyPersonReportFilterUI();
                filterUI.setCustomerParams(cp);
                this.mainQuery = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
                this.curFilterMap = (HashMap)filterUI.getParam();
                this.curFilterMap.put("mainQuery", this.mainQuery);
                this.loadReportData(this.curFilterMap);
            }
            this.isFirstDefaultQuery = false;
        } else {
            this.showFilterDialog(this.customerPanel);
        }
    }

    private void showFilterDialog(StandbyPersonReportFilterUI customerPanel) throws EASBizException, BOSException {
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            this.commonQueryDialog.setHeight(370);
            this.commonQueryDialog.setWidth(430);
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.commonQueryDialog.setQueryObjectPK(this.mainQueryPK);
            this.commonQueryDialog.setShowFilter(true);
            this.commonQueryDialog.setShowSorter(false);
            this.commonQueryDialog.setShowToolbar(true);
            this.commonQueryDialog.setDisShowRowCount(true);
            this.commonQueryDialog.setDynQueryVisible(true);
            if (this.orgContextManager != null) {
                if (this.orgContextManager.getOwner() != null && this.orgContextManager.getOwner() instanceof CustomerQueryPanel) {
                    this.commonQueryDialog.addUserPanel((KDPanel)((CustomerQueryPanel)this.orgContextManager.getOwner()));
                }
                this.orgContextManager.init(this.getUIContext());
            }
            this.commonQueryDialog.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.STANDBYPERSONREPORT_FILTER"));
            this.commonQueryDialog.setMaxReturnCountVisible(true);
        }
        if (this.commonQueryDialog.show()) {
            this.mainQuery = this.commonQueryDialog.getEntityViewInfoResult();
            this.curFilterMap = (HashMap)((StandbyPersonReportFilterUI)this.commonQueryDialog.getUserPanel(0)).getParam();
            this.curFilterMap.put("mainQuery", this.mainQuery);
            this.loadReportData(this.curFilterMap);
        } else {
            SysUtil.abort();
        }
    }

    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        if (this.commonQueryDialog != null && this.getUIContext() != null && "report".equals(this.getUIContext().get("UIClassParam"))) {
            this.commonQueryDialog.changeOwner((Component)((Object)this));
        }
        this.performCommonQuery();
    }

    public void actionPersonDetail_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow curRow = this.tblMain.getRow(KDTableUtil.getSelectedRow((KDTable)this.tblMain));
        int isStandby = Integer.valueOf(curRow.getCell("isStandby").getValue().toString());
        if (isStandby == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.STANDBYPERSON_ISHISTORY"));
            return;
        }
        String sbPerId = curRow.getCell("id").getValue().toString();
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"ID", (Object)sbPerId);
        RealModeIDList idList = new RealModeIDList();
        idList.add(sbPerId);
        uiCtx.put((Object)"IDList", (Object)idList);
        uiCtx.put((Object)"isPosition", (Object)true);
        uiCtx.put((Object)"Owner", (Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(StandbyPersonEditUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
        uiWindow.show();
    }

    public void actionToPositionMatch_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow curRow = this.tblMain.getRow(KDTableUtil.getSelectedRow((KDTable)this.tblMain));
        int isStandby = Integer.valueOf(curRow.getCell("isStandby").getValue().toString());
        if (isStandby == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.STANDBYPERSON_ISHISTORY"));
            return;
        }
        UIContext uiCtx = new UIContext((Object)this);
        String empId = curRow.getCell("employeeId").getValue().toString();
        uiCtx.put((Object)"empId", (Object)empId);
        Object toPos = curRow.getCell("toPositionId").getValue();
        String toPositionId = null;
        if (toPos != null) {
            toPositionId = toPos.toString();
        }
        uiCtx.put((Object)"toPositionId", (Object)toPositionId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(StandbyPersonToPositionMatchUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
        uiWindow.show();
    }

    public void actionToPositionDetail_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow curRow = this.tblMain.getRow(KDTableUtil.getSelectedRow((KDTable)this.tblMain));
        int isStandby = Integer.valueOf(curRow.getCell("isStandby").getValue().toString());
        if (isStandby == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.STANDBYPERSON_ISHISTORY"));
            return;
        }
        Object toPos = curRow.getCell("toPositionId").getValue();
        if (toPos == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.SELECTEDEMPLOYEE_NO_TOPOSITION"));
            return;
        }
        String toPositionId = toPos.toString();
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"ID", (Object)toPositionId);
        uiCtx.put((Object)"FromChart", (Object)"YES");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(HRPositionEditUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
        uiWindow.show();
    }

    private void checkSelected() {
        if (this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.loadReportData(this.curFilterMap);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        OutputExcelUtil excelUtil = new OutputExcelUtil();
        excelUtil.appendToExcel(this.tblMain, true, true, this.getUITitle());
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    public void actionPrintView_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PEOPLE_ORGANIZATION;
    }

    protected void initOrgContextManager() {
        super.initOrgContextManager();
        IMultiOrgSupport owner = this.getMainCustomerQueryPanel();
        if (owner != null && this instanceof IDelegationSupport) {
            try {
                MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.standby.app", "StandbyPersonQuery");
                OrgContextHelper helper = new OrgContextHelper((IMetaDataPK)mainQueryPK, this.tblMain);
                this.orgContextManager = new OrgContextManager(owner, ContextTypeEnum.INQUERYING, helper, (IDelegationSupport)this);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    protected IMultiOrgSupport getMainCustomerQueryPanel() {
        if (this.customerPanel == null) {
            try {
                this.customerPanel = new StandbyPersonReportFilterUI();
                this.customerPanel.setMetaDataPKForPemmission((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.standby.app.StandbyPersonQuery"));
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return this.customerPanel;
    }

    public String getPropertyOfBizOrg(OrgType orgType) {
        return null;
    }

    public String[] getPropertyOfCopOrg() {
        return null;
    }
}

