/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.hraux.DiplomaFactory;
import com.kingdee.eas.basedata.hraux.DiplomaInfo;
import com.kingdee.eas.basedata.hraux.IBasicItem;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.TechnicalPostFactory;
import com.kingdee.eas.hr.base.TechnicalPostInfo;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.org.JobLevelFactory;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.hr.standby.client.AbstractStandbyPersonSelectListFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import javax.swing.ComboBoxModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class StandbyPersonSelectListFilterUI
extends AbstractStandbyPersonSelectListFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(StandbyPersonSelectListFilterUI.class);

    public void initLayout() {
        super.initLayout();
        this.txtFromYear.setEnabled(false);
        this.txtFromYear.setDataType(0);
        this.txtFromYear.setMaximumValue((Comparable)Integer.valueOf(99));
        this.txtFromYear.setMinimumValue((Comparable)Integer.valueOf(0));
        this.txtFromYear.setDataVerifierType(12);
        this.txtToYear.setEnabled(false);
        this.txtToYear.setDataType(0);
        this.txtToYear.setMaximumValue((Comparable)Integer.valueOf(99));
        this.txtToYear.setMinimumValue((Comparable)Integer.valueOf(0));
        this.txtToYear.setDataVerifierType(12);
        try {
            this.cboDiploma.setModel((ComboBoxModel)EmployeeClientUtils.getComboModel((IBasicItem)DiplomaFactory.getRemoteInstance()));
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.cboDiploma.setSelectedIndex(-1);
        this.cboDiploma.setEnabled(false);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("ALL_ADMIN", Boolean.TRUE);
        map.put("TRUE", Boolean.TRUE);
        this.prmtToPosition.setSelector((KDPromptSelector)new PositionPromptBox2((IUIObject)this, map));
        this.prmtToPosition.setDisplayFormat("$name$");
        this.prmtToPosition.setEditFormat("$number$");
        this.prmtToPosition.setCommitFormat("$number$");
        this.prmtToPosition.setEditable(false);
        this.cboMatch.setSelectedIndex(5);
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        register.registerPositionPromptBox2(this.prmtPosition);
        PositionPromptBox2 position = (PositionPromptBox2)this.prmtPosition.getSelector();
        position.setSealUp("true");
        register.registerTechnicalPostPromptBox(this.prmtPost);
        register.registerJobLevelPromptBox(this.prmtLevel);
        register.registerPositionPromptBox2(this.prmtToPosition);
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public boolean verify() {
        if (this.chkPosition.isSelected() && this.prmtPosition.getText().trim().equals("")) {
            this.prmtPosition.requestFocusInWindow();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.POSITION_CANNOT_EMPTY"));
            return false;
        }
        if (this.chkLevel.isSelected() && this.prmtLevel.getText().trim().equals("")) {
            this.prmtLevel.requestFocusInWindow();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.LEVEL_CANNOT_EMPTY"));
            return false;
        }
        if (this.chkYear.isSelected() && this.txtFromYear.getText().trim().equals("")) {
            this.txtFromYear.requestFocusInWindow();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.FROMYEAR_CANNOT_EMPTY"));
            return false;
        }
        if (this.chkYear.isSelected() && this.txtToYear.getText().trim().equals("")) {
            this.txtToYear.requestFocusInWindow();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.TOYEAR_CANNOT_EMPTY"));
            return false;
        }
        if (!(this.chkPosition.isSelected() || this.chkLevel.isSelected() || this.chkYear.isSelected())) {
            this.prmtPosition.requestFocusInWindow();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.POSITION_LEVEL_YEAR_MUST_SELECTONE"));
            return false;
        }
        if (this.chkIsCompare.isSelected() && this.prmtToPosition.getText().trim().equals("")) {
            this.prmtToPosition.requestFocusInWindow();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.TOPOSITION_CANNOT_EMPTY"));
            return false;
        }
        if (this.chkIsCompare.isSelected() && this.cboMatch.getSelectedIndex() < 0) {
            this.cboMatch.requestFocusInWindow();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.PERCENT_CANNOT_EMPTY"));
            return false;
        }
        return super.verify();
    }

    public HashMap getAllFilters() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isPosition", this.chkPosition.isSelected());
        map.put("isLevel", this.chkLevel.isSelected());
        map.put("isYear", this.chkYear.isSelected());
        map.put("isDiploma", this.chkDiploma.isSelected());
        map.put("isPost", this.chkPost.isSelected());
        map.put("isCompare", this.chkIsCompare.isSelected());
        String positionId = null;
        if (!StringUtils.isEmpty((String)this.prmtPosition.getText().trim())) {
            positionId = ((PositionInfo)this.prmtPosition.getData()).getId().toString();
        }
        map.put("positionId", positionId);
        String levelId = null;
        if (!StringUtils.isEmpty((String)this.prmtLevel.getText().trim())) {
            levelId = ((JobLevelInfo)this.prmtLevel.getData()).getId().toString();
        }
        map.put("levelId", levelId);
        map.put("fromYear", this.txtFromYear.getText());
        map.put("toYear", this.txtToYear.getText());
        String diplomaId = null;
        if (this.cboDiploma.getSelectedIndex() != -1) {
            diplomaId = ((DiplomaInfo)this.cboDiploma.getSelectedItem()).getId().toString();
        }
        map.put("diplomaId", diplomaId);
        String postId = null;
        if (this.prmtPost.getData() != null) {
            postId = ((TechnicalPostInfo)this.prmtPost.getData()).getId().toString();
        }
        map.put("postId", postId);
        String toPositionId = null;
        if (!this.prmtToPosition.getText().trim().equals("")) {
            toPositionId = ((PositionInfo)this.prmtToPosition.getData()).getId().toString();
        }
        map.put("toPositionId", toPositionId);
        String hrId = ((HROrgUnitInfo)this.prmtHROrg.getData()).getId().toString();
        map.put("hrId", hrId);
        map.put("selectedMatch", this.cboMatch.getSelectedItem());
        return map;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        if (cp == null) {
            cp = new CustomerParams();
        }
        cp.putBoolean("isPosition", this.chkPosition.isSelected());
        cp.putBoolean("isLevel", this.chkLevel.isSelected());
        cp.putBoolean("isYear", this.chkYear.isSelected());
        cp.putBoolean("isCompare", this.chkIsCompare.isSelected());
        cp.putBoolean("isDiploma", this.chkDiploma.isSelected());
        cp.putBoolean("isPost", this.chkPost.isSelected());
        String positionId = null;
        if (!this.prmtPosition.getText().trim().equals("")) {
            positionId = ((PositionInfo)this.prmtPosition.getData()).getId().toString();
        }
        cp.addCustomerParam("position", positionId);
        String levelId = null;
        if (!this.prmtLevel.getText().trim().equals("")) {
            levelId = ((JobLevelInfo)this.prmtLevel.getData()).getId().toString();
        }
        cp.addCustomerParam("level", levelId);
        cp.addCustomerParam("fromYear", this.txtFromYear.getText());
        cp.addCustomerParam("toYear", this.txtToYear.getText());
        String diplomaId = null;
        if (this.cboDiploma.getSelectedIndex() != -1) {
            diplomaId = ((DiplomaInfo)this.cboDiploma.getSelectedItem()).getId().toString();
        }
        cp.addCustomerParam("diploma", diplomaId);
        String postId = null;
        if (this.prmtPost.getData() != null) {
            postId = ((TechnicalPostInfo)this.prmtPost.getData()).getId().toString();
        }
        cp.addCustomerParam("post", postId);
        String toPositionId = null;
        if (!this.prmtToPosition.getText().trim().equals("")) {
            toPositionId = ((PositionInfo)this.prmtToPosition.getData()).getId().toString();
        }
        cp.addCustomerParam("toPosition", toPositionId);
        cp.putInt("selectedMatch", this.cboMatch.getSelectedIndex());
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (cp == null) {
            return;
        }
        this.chkPosition.setSelected(cp.getBoolean("isPosition"));
        this.chkLevel.setSelected(cp.getBoolean("isLevel"));
        this.chkYear.setSelected(cp.getBoolean("isYear"));
        this.chkIsCompare.setSelected(cp.getBoolean("isCompare"));
        this.chkDiploma.setSelected(cp.getBoolean("isDiploma"));
        this.chkPost.setSelected(cp.getBoolean("isPost"));
        if (cp.getCustomerParam("position") != null) {
            try {
                PositionInfo posInfo = PositionFactory.getRemoteInstance().getPositionInfo((IObjectPK)new ObjectUuidPK(cp.getCustomerParam("position").toString()));
                this.prmtPosition.setData((Object)posInfo);
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else {
            this.prmtPosition.setData(null);
        }
        if (cp.getCustomerParam("level") != null) {
            try {
                JobLevelInfo levelInfo = JobLevelFactory.getRemoteInstance().getJobLevelInfo((IObjectPK)new ObjectUuidPK(cp.getCustomerParam("level").toString()));
                this.prmtLevel.setData((Object)levelInfo);
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else {
            this.prmtLevel.setData(null);
        }
        if (cp.getCustomerParam("fromYear") == null || cp.getCustomerParam("fromYear").toString().equals("")) {
            this.txtFromYear.setValue(null);
        } else {
            this.txtFromYear.setValue((Object)Integer.valueOf(cp.getCustomerParam("fromYear").toString()));
        }
        if (cp.getCustomerParam("toYear") == null || cp.getCustomerParam("toYear").toString().equals("")) {
            this.txtToYear.setValue(null);
        } else {
            this.txtToYear.setValue((Object)Integer.valueOf(cp.getCustomerParam("toYear").toString()));
        }
        if (cp.getCustomerParam("diploma") != null) {
            try {
                DiplomaInfo diplomaInfo = DiplomaFactory.getRemoteInstance().getDiplomaInfo((IObjectPK)new ObjectUuidPK(cp.getCustomerParam("diploma").toString()));
                this.cboDiploma.setSelectedItem((Object)diplomaInfo);
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else {
            this.cboDiploma.setSelectedIndex(-1);
        }
        if (cp.getCustomerParam("post") != null) {
            try {
                TechnicalPostInfo postInfo = TechnicalPostFactory.getRemoteInstance().getTechnicalPostInfo((IObjectPK)new ObjectUuidPK(cp.getCustomerParam("post").toString()));
                this.prmtPost.setData((Object)postInfo);
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else {
            this.prmtPost.setData(null);
        }
        if (cp.getCustomerParam("toPosition") != null) {
            try {
                PositionInfo toPosInfo = PositionFactory.getRemoteInstance().getPositionInfo((IObjectPK)new ObjectUuidPK(cp.getCustomerParam("toPosition").toString()));
                this.prmtToPosition.setData((Object)toPosInfo);
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else {
            this.prmtToPosition.setData(null);
        }
        this.cboMatch.setSelectedIndex(cp.getInt("selectedMatch"));
    }

    public void clear() {
        Object hrInfo = this.prmtHROrg.getData();
        super.clear();
        this.prmtHROrg.setData(null);
        this.prmtHROrg.setData(hrInfo);
        this.chkPosition.setSelected(false);
        this.chkLevel.setSelected(false);
        this.chkYear.setSelected(false);
        this.chkIsCompare.setSelected(false);
        this.chkDiploma.setSelected(false);
        this.chkPost.setSelected(false);
        this.prmtPosition.setData(null);
        this.prmtLevel.setData(null);
        this.txtFromYear.setValue(null);
        this.txtToYear.setValue(null);
        this.cboDiploma.setSelectedIndex(-1);
        this.prmtPost.setData(null);
        this.prmtToPosition.setData(null);
        this.cboMatch.setSelectedIndex(5);
    }

    protected void chkIsCompare_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkIsCompare.isSelected()) {
            this.prmtToPosition.setEnabled(true);
            this.cboMatch.setEnabled(true);
        } else {
            this.prmtToPosition.setEnabled(false);
            this.cboMatch.setEnabled(false);
            this.prmtToPosition.setData(null);
            this.cboMatch.setSelectedIndex(5);
        }
    }

    protected void chkLevel_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkLevel.isSelected()) {
            this.prmtLevel.setEnabled(true);
            this.prmtLevel.setRequired(true);
        } else {
            this.prmtLevel.setEnabled(false);
            this.prmtLevel.setRequired(false);
            this.prmtLevel.setData(null);
        }
    }

    protected void chkPosition_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkPosition.isSelected()) {
            this.prmtPosition.setEnabled(true);
            this.prmtPosition.setRequired(true);
        } else {
            this.prmtPosition.setEnabled(false);
            this.prmtPosition.setRequired(false);
            this.prmtPosition.setData(null);
        }
    }

    protected void chkYear_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkYear.isSelected()) {
            this.txtFromYear.setEnabled(true);
            this.txtToYear.setEnabled(true);
            this.txtFromYear.setRequired(true);
            this.txtToYear.setRequired(true);
        } else {
            this.txtFromYear.setEnabled(false);
            this.txtToYear.setEnabled(false);
            this.txtFromYear.setRequired(false);
            this.txtToYear.setRequired(false);
            this.txtFromYear.setValue(null);
            this.txtToYear.setValue(null);
        }
    }

    protected void chkDiploma_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkDiploma.isSelected()) {
            this.cboDiploma.setEnabled(true);
        } else {
            this.cboDiploma.setEnabled(false);
            this.cboDiploma.setSelectedIndex(-1);
        }
    }

    protected void chkPost_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkPost.isSelected()) {
            this.prmtPost.setEnabled(true);
        } else {
            this.prmtPost.setEnabled(false);
            this.prmtPost.setData(null);
        }
    }

    public KDBizPromptBox getPrmtHROrg() {
        return this.prmtHROrg;
    }
}

