/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.client.ui.IMainUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.client.context.IDelegationSupport;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.hr.base.client.HROrgContextPromptBoxFactory;
import com.kingdee.eas.hr.emp.client.EmployeeTreeEditUI;
import com.kingdee.eas.hr.standby.IStandbyPersonFacade;
import com.kingdee.eas.hr.standby.StandbyPersonFacadeFactory;
import com.kingdee.eas.hr.standby.client.AbstractStandbyPersonSelectListUI;
import com.kingdee.eas.hr.standby.client.StandbyPersonChangeUI;
import com.kingdee.eas.hr.standby.client.StandbyPersonSelectListFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class StandbyPersonSelectListUI
extends AbstractStandbyPersonSelectListUI
implements IDelegationSupport {
    private static final Logger logger = CoreUIObject.getLogger(StandbyPersonSelectListUI.class);
    private static final String PERSONChANGEUI_STATE = "TOSTANDBY";
    private CommonQueryDialog commonQueryDialog = null;
    private StandbyPersonSelectListFilterUI customerPanel;

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.mainQuery = null;
        this.showFilterDialog();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getStyleAttributes().setLocked(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnToStandby.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.menuItemAddNew.setEnabled(true);
        this.btnAddNew.setEnabled(true);
        this.btnRemove.setEnabled(true);
        this.btnEdit.setVisible(false);
        this.btnRefresh.setVisible(false);
        this.btnLocate.setVisible(false);
    }

    protected void showFilterDialog() throws Exception {
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            this.commonQueryDialog.setHeight(380);
            this.commonQueryDialog.setWidth(400);
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.commonQueryDialog.setQueryObjectPK(this.mainQueryPK);
            this.commonQueryDialog.setShowFilter(true);
            this.commonQueryDialog.setShowSorter(false);
            if (this.orgContextManager != null) {
                if (this.orgContextManager.getOwner() != null && this.orgContextManager.getOwner() instanceof CustomerQueryPanel) {
                    this.commonQueryDialog.addUserPanel((KDPanel)((CustomerQueryPanel)this.orgContextManager.getOwner()));
                }
                this.orgContextManager.init(this.getUIContext());
                HROrgContextPromptBoxFactory promptBoxFactory = new HROrgContextPromptBoxFactory(this.orgContextManager, this.getUIContext(), true);
                this.commonQueryDialog.setPromptBoxFactory((IPromptBoxFactory)promptBoxFactory);
            }
            this.commonQueryDialog.setMaxReturnCountVisible(false);
        }
        if (this.commonQueryDialog.show()) {
            FilterInfo commonFilter = this.commonQueryDialog.getCommonFilter();
            IStandbyPersonFacade iSbPerFacade = StandbyPersonFacadeFactory.getRemoteInstance();
            ArrayList listResult = iSbPerFacade.getResultFilterPerson(this.customerPanel.getAllFilters(), commonFilter);
            Map uiContext = this.getUIContext();
            String isFromStandbySelect = (String)uiContext.get("isFromStandbySelect");
            if ("true".equals(isFromStandbySelect)) {
                KDTable table = (KDTable)uiContext.get("entryTable");
                this.loadResultToTable(table, listResult);
                SysUtil.abort();
            } else {
                this.loadResultPersons(listResult);
            }
        } else {
            SysUtil.abort();
        }
    }

    private void loadResultToTable(KDTable table, ArrayList list) {
        if (list == null) {
            return;
        }
        ArrayList oldEmpIdList = this.getEmpIdList();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            HashMap map = (HashMap)list.get(i);
            String newEmpId = map.get("id").toString();
            if (oldEmpIdList.size() > 0 && this.isExistInTable(oldEmpIdList, newEmpId)) continue;
            IRow row = table.addRow();
            row.getCell("id").setValue((Object)newEmpId);
            PersonInfo nowPerInfo = new PersonInfo();
            nowPerInfo.setId(BOSUuid.read((String)newEmpId));
            row.getCell("person").setValue((Object)nowPerInfo);
            row.getCell("empNumber").setValue(map.get("number"));
            row.getCell("empName").setValue(map.get("name"));
            row.getCell("adminOrg").setValue((Object)((AdminOrgUnitInfo)map.get("AdminOrgUnit")));
            row.getCell("position").setValue((Object)((PositionInfo)map.get("Position")));
        }
    }

    private void loadResultPersons(ArrayList list) throws SQLException {
        if (list == null) {
            return;
        }
        ArrayList oldEmpIdList = this.getEmpIdList();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            HashMap map = (HashMap)list.get(i);
            String newEmpId = map.get("id").toString();
            if (oldEmpIdList.size() > 0 && this.isExistInTable(oldEmpIdList, newEmpId)) continue;
            IRow row = this.tblMain.addRow();
            row.getCell("id").setValue((Object)newEmpId);
            row.getCell("number").setValue(map.get("number"));
            row.getCell("name").setValue(map.get("name"));
            row.getCell("unit").setValue(map.get("AdminOrgUnit.name"));
            row.getCell("position").setValue(map.get("Position.name"));
        }
    }

    private ArrayList getEmpIdList() {
        ArrayList<String> list = new ArrayList<String>();
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            String empId = this.tblMain.getRow(i).getCell("id").getValue().toString();
            list.add(empId);
        }
        return list;
    }

    private boolean isExistInTable(ArrayList oldEmpIdList, String empId) {
        int size = oldEmpIdList.size();
        for (int i = 0; i < size; ++i) {
            if (!empId.equals(oldEmpIdList.get(i))) continue;
            return true;
        }
        return false;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.showFilterDialog();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiCtx = new UIContext((Object)this);
        String curEmpId = this.tblMain.getRow(KDTableUtil.getSelectedRow((KDTable)this.tblMain)).getCell("id").getValue().toString();
        uiCtx.put((Object)"ID", (Object)curEmpId);
        RealModeIDList idList = new RealModeIDList();
        idList.add(curEmpId);
        uiCtx.put((Object)"IDList", (Object)idList);
        uiCtx.put((Object)"isPosition", (Object)true);
        uiCtx.put((Object)"isMyArchives", (Object)"isStandBy");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EmployeeTreeEditUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
        uiWindow.show();
    }

    public void actionToStandby_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiCtx = new UIContext();
        Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
        uiCtx.put((Object)"OwnerWindow", (Object)ownerWindow);
        IMainUIObject mainObject = SystemEntry.instance.getMainUIObject();
        uiCtx.put((Object)"IMainUIObject", (Object)mainObject);
        uiCtx.put((Object)"personChangeUIState", (Object)PERSONChANGEUI_STATE);
        uiCtx.put((Object)"toStandbyPersonCol", (Object)this.getAllToStandbyPerson());
        uiCtx.put((Object)"selectedObj", this.getUIContext().get("selectedObj"));
        this.getUIWindow().close();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(StandbyPersonChangeUI.class.getName(), (Map)uiCtx, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    private PersonCollection getAllToStandbyPerson() throws EASBizException, BOSException {
        PersonCollection perCol = new PersonCollection();
        KDTSelectBlock sb = null;
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            sb = this.tblMain.getSelectManager().get(i);
            int j = 0;
            int bottom = 0;
            if (sb.getMode() == 8) {
                j = 0;
                bottom = this.tblMain.getRowCount();
            } else {
                j = sb.getTop();
                bottom = sb.getBottom() + 1;
            }
            while (j < bottom) {
                IRow row = this.tblMain.getRow(j);
                PersonInfo perInfo = new PersonInfo();
                perInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
                perInfo.setName(row.getCell("name").getValue().toString());
                perInfo.put("unitName", (Object)row.getCell("unit").getValue().toString());
                perInfo.put("posName", (Object)row.getCell("position").getValue().toString());
                perCol.add(perInfo);
                ++j;
            }
        }
        return perCol;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.tblMain.removeRow(KDTableUtil.getSelectedRow((KDTable)this.tblMain));
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PEOPLE_ORGANIZATION;
    }

    protected IMultiOrgSupport getMainCustomerQueryPanel() {
        if (this.customerPanel == null) {
            try {
                this.customerPanel = new StandbyPersonSelectListFilterUI();
                Map uiContext = this.getUIContext();
                String isFromStandbySelect = (String)uiContext.get("isFromStandbySelect");
                if ("true".equals(isFromStandbySelect)) {
                    HROrgUnitInfo hrInfo = (HROrgUnitInfo)uiContext.get("curHro");
                    KDBizPromptBox prmtHrOrg = this.customerPanel.getPrmtHROrg();
                    prmtHrOrg.setData((Object)hrInfo);
                    prmtHrOrg.setEditable(false);
                    prmtHrOrg.setEnabled(false);
                }
                this.customerPanel.setPanelName(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.FILTERPANEL"));
                this.customerPanel.setMetaDataPKForPemmission((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.standby.app", "StandbyPersonQuery"));
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return this.customerPanel;
    }

    public String getPropertyOfBizOrg(OrgType orgType) {
        return null;
    }

    public String[] getPropertyOfCopOrg() {
        return null;
    }
}

