/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.standby.IStandbyPerson;
import com.kingdee.eas.hr.standby.StandbyPersonFactory;
import com.kingdee.eas.hr.standby.StandbyPersonInfo;
import com.kingdee.eas.hr.standby.client.AbstractStandbyPersonToCommonUI;
import com.kingdee.eas.hr.standby.client.StandbyPersonPromtBox;
import com.kingdee.eas.hr.standby.client.StandbyUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class StandbyPersonToCommonUI
extends AbstractStandbyPersonToCommonUI {
    private static final Logger logger = CoreUIObject.getLogger(StandbyPersonToCommonUI.class);
    private ArrayList initIdsList = null;
    private final StandbyPersonPromtBox sbPerPromtBox = new StandbyPersonPromtBox((IUIObject)this);

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.initIdsList = (ArrayList)this.getUIContext().get("standbyPersonIds");
        super.onLoad();
        this.setTableCellEditor();
        if (this.initIdsList.size() > 0) {
            this.loadInitStandbyPerson(this.getInitStandbyPerson(this.initIdsList));
        }
    }

    private IRowSet getInitStandbyPerson(ArrayList list) throws BOSException {
        int size = list.size();
        if (size <= 0) {
            return null;
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.standby.app.StandbyPersonQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        StringBuffer strMask = new StringBuffer();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        for (int i = 0; i < size; ++i) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)list.get(i).toString()));
            if (i != 0) {
                strMask.append(" or ");
            }
            strMask.append(" #" + i);
        }
        filter.setMaskString(strMask.toString());
        view.setFilter(filter);
        exec.setObjectView(view);
        return exec.executeQuery();
    }

    private void loadInitStandbyPerson(IRowSet rs) throws SQLException {
        if (rs != null) {
            rs.beforeFirst();
            while (rs.next()) {
                IRow row = this.tblMain.addRow();
                row.getCell("id").setValue((Object)rs.getString("id"));
                row.getCell("empName").setValue((Object)rs.getString("employee.name"));
                row.getCell("empUnit").setValue((Object)rs.getString("empAdminOrgUnit.name"));
                row.getCell("empPosition").setValue((Object)rs.getString("empPosition.name"));
                row.getCell("toPosition").setValue((Object)rs.getString("toPosition.name"));
                row.getCell("toUnit").setValue((Object)rs.getString("toUnit.name"));
                row.getCell("standbyType").setValue((Object)rs.getString("standbyType.name"));
                row.getCell("endTime").setValue((Object)new Date());
            }
        }
    }

    private void setTableCellEditor() throws Exception {
        this.tblMain.checkParsed();
        KDBizPromptBox prmtSbPersonBox = new KDBizPromptBox();
        prmtSbPersonBox.setSelector((KDPromptSelector)this.sbPerPromtBox);
        this.tblMain.getColumn("empName").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSbPersonBox));
        this.tblMain.getColumn("empUnit").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("empPosition").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("toPosition").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("toUnit").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("standbyType").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("empName").getStyleAttributes().setBackground(StandbyUtils.MUSTINPUT_BGCOLOR);
        this.tblMain.getColumn("empUnit").getStyleAttributes().setBackground(StandbyUtils.MUSTINPUT_BGCOLOR);
        this.tblMain.getColumn("empPosition").getStyleAttributes().setBackground(StandbyUtils.MUSTINPUT_BGCOLOR);
        this.tblMain.getColumn("standbyType").getStyleAttributes().setBackground(StandbyUtils.MUSTINPUT_BGCOLOR);
        KDTextField txtToCommonAudit = new KDTextField();
        txtToCommonAudit.setMaxLength(80);
        this.tblMain.getColumn("toCommonAudit").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtToCommonAudit));
        KDTextField txtToCommonReason = new KDTextField();
        txtToCommonReason.setMaxLength(200);
        this.tblMain.getColumn("toCommonReason").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtToCommonReason));
        KDDatePicker kdp = new KDDatePicker();
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(kdp);
        IColumn col = this.tblMain.getColumn("endTime");
        col.setEditor((ICellEditor)cellEditor);
        col.getStyleAttributes().setNumberFormat("%{yyyy-MM-dd}t");
        this.tblMain.getColumn("toStandbyAudit").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("toStandbyReason").getStyleAttributes().setHided(true);
        prmtSbPersonBox.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    StandbyPersonToCommonUI.this.setCellsValue();
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
    }

    private void setCellsValue() {
        Object newValue = this.sbPerPromtBox.getData();
        if (newValue != null && newValue instanceof Object[]) {
            IRow curRow = this.tblMain.getRow(KDTableUtil.getSelectedRow((KDTable)this.tblMain));
            IRow row = null;
            Object[] obj = (Object[])newValue;
            int length = obj.length;
            for (int i = 0; i < length; ++i) {
                StandbyPersonInfo sbPerInfo = (StandbyPersonInfo)obj[i];
                row = i == 0 ? curRow : this.tblMain.addRow();
                row.getCell("id").setValue((Object)sbPerInfo.getId().toString());
                row.getCell("empName").setValue((Object)sbPerInfo.getEmployee().getName());
                row.getCell("empUnit").setValue(sbPerInfo.get("empAdminOrgUnit.name"));
                row.getCell("empPosition").setValue(sbPerInfo.get("empPosition.name"));
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                row.getCell("endTime").setValue((Object)sdf.format(new Date()));
                if (sbPerInfo.get("toPosition.name") != null) {
                    row.getCell("toPosition").setValue(sbPerInfo.get("toPosition.name"));
                }
                if (sbPerInfo.get("toUnit.name") != null) {
                    row.getCell("toUnit").setValue(sbPerInfo.get("toUnit.name"));
                }
                row.getCell("standbyType").setValue(sbPerInfo.get("standbyType.name"));
                row.getCell("toCommonAudit").setValue((Object)"");
                row.getCell("toCommonReason").setValue((Object)"");
            }
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnNew.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnSave.setEnabled(true);
        this.tblMain.getStyleAttributes().setWrapText(true);
        this.tblMain.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblMain.getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.MIDDLE);
    }

    protected void btnNewNew_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.addRow();
    }

    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.removeRow(KDTableUtil.getSelectedRow((KDTable)this.tblMain));
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isInputValidate()) {
            return;
        }
        IStandbyPerson iSbPer = StandbyPersonFactory.getRemoteInstance();
        ArrayList toCommonList = this.getUpdateList();
        if (MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.TOCOMMON_ISRESERVE")) == 1) {
            iSbPer.standbyPersonToCommon(toCommonList, false);
        } else {
            iSbPer.standbyPersonToCommon(toCommonList, true);
        }
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.TOCOMMON_SUCCESS"));
        this.save = true;
        this.getUIWindow().close();
    }

    private boolean isInputValidate() {
        int size = this.tblMain.getRowCount();
        if (size <= 0) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row.getCell("id").getValue() == null) {
                MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.NO") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.ROW_EMPLOYEE_CANNOT_EMPTY")));
                return false;
            }
            String sbPerId = row.getCell("id").getValue().toString();
            if (!this.isExistSameStandbyPerson(sbPerId, i)) continue;
            MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.NO") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.ROW_STANDBYPERSON_DUMP")));
            return false;
        }
        return true;
    }

    private boolean isExistSameStandbyPerson(String sbPerId, int curIndex) {
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row;
            if (i == curIndex || (row = this.tblMain.getRow(i)).getCell("id").getValue() == null || !row.getCell("id").getValue().toString().equals(sbPerId)) continue;
            return true;
        }
        return false;
    }

    private ArrayList getUpdateList() {
        ArrayList list = new ArrayList();
        HashMap<String, String> map = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row.getCell("id").getValue() == null) continue;
            map = new HashMap<String, String>();
            map.put("id", row.getCell("id").getValue().toString());
            String strAudit = "";
            if (row.getCell("toCommonAudit").getValue() != null) {
                strAudit = row.getCell("toCommonAudit").getValue().toString();
            }
            map.put("toCommonAudit", strAudit);
            String strReason = "";
            if (row.getCell("toCommonReason").getValue() != null) {
                strReason = row.getCell("toCommonReason").getValue().toString();
            }
            map.put("toCommonReason", strReason);
            Object endTime = "";
            if (row.getCell("endTime").getValue() != null) {
                endTime = row.getCell("endTime").getValue();
            }
            map.put("endTime", (String)endTime);
            list.add(map);
        }
        return list;
    }

    protected void showAddNew() {
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return StandbyPersonFactory.getRemoteInstance();
    }
}

