/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.competmodel.CompetIndexGradeInfo;
import com.kingdee.eas.hr.competmodel.CompetenceIndexInfo;
import com.kingdee.eas.hr.competmodel.client.CompetMatchPanel;
import com.kingdee.eas.hr.emp.EmployeeCompetIndexCollection;
import com.kingdee.eas.hr.emp.EmployeeCompetIndexFactory;
import com.kingdee.eas.hr.emp.EmployeeCompetIndexInfo;
import com.kingdee.eas.hr.emp.IEmployeeCompetIndex;
import com.kingdee.eas.hr.org.IPositionCompetIndex;
import com.kingdee.eas.hr.org.PersonPositionMatch;
import com.kingdee.eas.hr.org.PositionCompetIndexCollection;
import com.kingdee.eas.hr.org.PositionCompetIndexFactory;
import com.kingdee.eas.hr.org.PositionCompetIndexInfo;
import com.kingdee.eas.hr.standby.IStandbyPerson;
import com.kingdee.eas.hr.standby.StandbyPersonCollection;
import com.kingdee.eas.hr.standby.StandbyPersonFactory;
import com.kingdee.eas.hr.standby.StandbyPersonInfo;
import com.kingdee.eas.hr.standby.client.AbstractStandbyPersonToPositionMatchUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import org.apache.log4j.Logger;

public class StandbyPersonToPositionMatchUI
extends AbstractStandbyPersonToPositionMatchUI {
    private static final Logger logger = CoreUIObject.getLogger(StandbyPersonToPositionMatchUI.class);
    private PersonInfo curEmpInfo = null;
    private String curToPositionId = null;
    private String curPositionId = null;
    private CompetMatchPanel cmPanel = null;

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        String empId = this.getUIContext().get("empId").toString();
        IPerson iPerson = PersonFactory.getRemoteInstance();
        this.curEmpInfo = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(empId));
        this.curPositionId = iPerson.getPrimaryPosition(BOSUuid.read((String)empId)).getId().toString();
        if (this.getUIContext().get("toPositionId") != null) {
            this.curToPositionId = this.getUIContext().get("toPositionId").toString();
        }
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("positionGrade").setWidth(200);
        this.prepareData();
        this.loadTableAndChart();
    }

    private void prepareData() throws Exception {
        this.txtEmpName.setText(this.curEmpInfo.getName());
        PositionInfo posInfo = PositionFactory.getRemoteInstance().getPositionInfo((IObjectPK)new ObjectUuidPK(this.curPositionId));
        this.txtEmpPositionName.setText(posInfo.getName());
        this.loadToPosition();
    }

    private void loadToPosition() throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("employee", (Object)this.curEmpInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("toUnit", null));
        filter.getFilterItems().add(new FilterItemInfo("isStandby", (Object)1));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        IStandbyPerson iSbPer = StandbyPersonFactory.getRemoteInstance();
        StandbyPersonCollection sbPerCol = iSbPer.getStandbyPersonCollection(view);
        IPosition iPos = PositionFactory.getRemoteInstance();
        int size = sbPerCol.size();
        if (size <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.NO_TOPOSITION"));
            SysUtil.abort();
        }
        for (int i = 0; i < size; ++i) {
            StandbyPersonInfo sbInfo = sbPerCol.get(i);
            PositionInfo posInfo = iPos.getPositionInfo((IObjectPK)new ObjectUuidPK(sbInfo.getToPosition().getId()));
            this.cboToPosition.addItem((Object)posInfo);
        }
        if (this.curToPositionId != null) {
            PositionInfo curToPosInfo = iPos.getPositionInfo((IObjectPK)new ObjectUuidPK(this.curToPositionId));
            this.cboToPosition.setSelectedItem((Object)curToPosInfo);
        } else {
            this.cboToPosition.setSelectedIndex(-1);
        }
    }

    protected void cboToPosition_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            this.loadTableAndChart();
        }
    }

    private void loadTableAndChart() throws Exception {
        if (this.cboToPosition.getSelectedItem() == null) {
            return;
        }
        this.loadTableData();
        String selectedToPosId = ((PositionInfo)this.cboToPosition.getSelectedItem()).getId().toString();
        String personId = this.curEmpInfo.getId().toString();
        if (this.cmPanel == null) {
            this.cmPanel = new CompetMatchPanel(selectedToPosId, personId);
            this.cmPanel.setBounds(0, 0, this.tabPanlMain.getWidth(), this.tabPanlMain.getHeight());
            this.panlChart.add((Component)this.cmPanel);
        } else {
            this.cmPanel.updateModel(selectedToPosId, personId);
        }
        this.panlChart.invalidate();
    }

    private void loadTableData() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        String selectedToPosId = ((PositionInfo)this.cboToPosition.getSelectedItem()).getId().toString();
        IPositionCompetIndex iPosiCompInGrade = PositionCompetIndexFactory.getRemoteInstance();
        PositionCompetIndexCollection oldColl = iPosiCompInGrade.getPositionCompetIndexCollection("select *,position.id,competIndex.*,competIndex.type.*,indexGrade.indexGrade.* where position='" + selectedToPosId + "' order by priority ");
        IEmployeeCompetIndex iEMPCI = EmployeeCompetIndexFactory.getRemoteInstance();
        EmployeeCompetIndexCollection empCIColl = iEMPCI.getEmployeeCompetIndexCollection("select *,person.id,empCompetIndex.*,empCompetIndex.type.*,indexGrade.indexGrade.* where person='" + this.curEmpInfo.getId().toString() + "'");
        IRow row = null;
        PositionCompetIndexInfo pciInfo = null;
        EmployeeCompetIndexInfo eciInfo = null;
        CompetenceIndexInfo ciInfo = null;
        CompetenceIndexInfo ciEmpInfo = null;
        CompetIndexGradeInfo cigInfo = null;
        int personIndex = 0;
        int positionIndex = 0;
        int size = oldColl.size();
        for (int i = 0; i < size; ++i) {
            pciInfo = oldColl.get(i);
            ciInfo = pciInfo.getCompetIndex();
            cigInfo = pciInfo.getIndexGrade();
            row = this.tblMain.addRow();
            row.getCell("type").setValue((Object)ciInfo.getType());
            row.getCell("competIndexName").setValue((Object)ciInfo);
            if (cigInfo != null) {
                row.getCell("positionGrade").setValue((Object)cigInfo.getIndexGrade());
            }
            row.getCell("matching").setValue((Object)PersonPositionMatch.MATCHING_B);
            row.getCell("priority").setValue((Object)pciInfo.getPriority());
            row.getCell("description").setValue((Object)ciInfo.getDescription());
            int length = empCIColl.size();
            for (int j = 0; j < length; ++j) {
                eciInfo = empCIColl.get(j);
                ciEmpInfo = eciInfo.getEmpCompetIndex();
                if (!ciInfo.getId().toString().equals(ciEmpInfo.getId().toString())) continue;
                row.getCell("personGrade").setValue(eciInfo.getIndexGrade() == null ? null : eciInfo.getIndexGrade().getIndexGrade());
                positionIndex = cigInfo != null ? cigInfo.getIndexGrade().getIndex() : -1;
                personIndex = eciInfo.getIndexGrade().getIndexGrade().getIndex();
                if (positionIndex > personIndex) {
                    row.getCell("matching").setValue((Object)PersonPositionMatch.MATCHING_B);
                    continue;
                }
                if (positionIndex == personIndex) {
                    row.getCell("matching").setValue((Object)PersonPositionMatch.MATCHING_A);
                    continue;
                }
                row.getCell("matching").setValue((Object)PersonPositionMatch.MATCHING_C);
            }
        }
    }
}

