/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.hraux.util.HRTreeUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.context.IDelegationSupport;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.hr.base.HROrgContextManagerFacadeFactory;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.EmployeePerformanceEditUI;
import com.kingdee.eas.hr.org.OrgHRCommonFactory;
import com.kingdee.eas.hr.standby.ForUpgradeFactory;
import com.kingdee.eas.hr.standby.IStandbyPerson;
import com.kingdee.eas.hr.standby.StandbyPersonFactory;
import com.kingdee.eas.hr.standby.client.AbstractStandbyPersonUI;
import com.kingdee.eas.hr.standby.client.StandbyPersonEditUI;
import com.kingdee.eas.hr.standby.client.StandbyPersonListFilterUI;
import com.kingdee.eas.hr.standby.client.StandbyPersonToPositionMatchUI;
import com.kingdee.eas.hr.train.client.TrainRecordInfoEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class StandbyPersonUI
extends AbstractStandbyPersonUI
implements IDelegationSupport {
    private static final Logger logger = CoreUIObject.getLogger(StandbyPersonUI.class);
    private boolean isFirstDefaultQuery = true;
    private DefaultKingdeeTreeNode treenode = null;
    private boolean isRootNodeNull = false;
    protected String longNumber = null;
    private FilterInfo queryFilter = null;
    private CommonQueryDialog commonQueryDialog = null;
    private HashMap positionHROCache = new HashMap();
    private boolean isDoQuery = false;

    protected boolean isSupportDynQuery() {
        return false;
    }

    protected void initTree() throws Exception {
    }

    public void onLoad() throws Exception {
        ForUpgradeFactory.getRemoteInstance().checkIsUpgrade();
        this.getUIContext().put("ORGEXT", Boolean.FALSE);
        super.onLoad();
        HRUtils.removeLintMenu((KDTable)this.tblMain, (KDTMenuManager)this.getMenuManager(this.tblMain));
        this.initCommonQueryDialog();
        if (!this.isDoQuery) {
            this.performCommonQuery();
        }
        this.btnAddNew.setVisible(false);
        this.btnToCommon.setVisible(false);
        this.btnPersonFilter.setVisible(false);
        this.actionPerformanceInfo.setEnabled(true);
        this.actionTrainingInfo.setEnabled(true);
        this.menuBiz.setVisible(false);
        this.btnQueryScheme.setVisible(false);
        this.initAdminPositionTree();
    }

    private HROrgUnitCollection getHROrgUnitCollection() {
        OrgUnitInfo info;
        if (this.orgContextManager != null && (info = (OrgUnitInfo)this.getUIContext().get(this.orgContextManager.getMainOrgType())) instanceof HROrgUnitInfo) {
            HROrgUnitCollection hrOrgUnitCollection = new HROrgUnitCollection();
            hrOrgUnitCollection.add((HROrgUnitInfo)info);
            return hrOrgUnitCollection;
        }
        return null;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPersonFilter.setIcon(EASResource.getIcon((String)"imgTbtn_querypersonnel"));
        this.menuItemPersonFilter.setIcon(EASResource.getIcon((String)"imgTbtn_querypersonnel"));
        this.btnToCommon.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.menuItemToCommon.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.btnPersonPositionMatch.setIcon(EASResource.getIcon((String)"imgTbtn_EmpPosMeasure"));
        this.menuItemPersonPositionMatch.setIcon(EASResource.getIcon((String)"imgTbtn_EmpPosMeasure"));
        this.btnPerformanceInfo.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.btnTrainingInfo.setIcon(EASResource.getIcon((String)"imgTbtn_demandcollateresult"));
        this.btnLocate.setVisible(false);
        this.btnLocate.setEnabled(false);
        this.menuItemLocate.setVisible(false);
        this.menuItemLocate.setEnabled(false);
        this.btnQueryScheme.setVisible(true);
        this.btnQueryScheme.setEnabled(true);
    }

    private void initAdminPositionTree() throws Exception {
        this.treeMain.setShowsRootHandles(true);
        DefaultKingdeeTreeNode rootNode = HRTreeUtil.createAdminTreeNodeByUserRange((boolean)true, (boolean)this.chkShowVirtualOrg.isSelected(), (boolean)true, (boolean)false, null);
        if (rootNode == null) {
            this.treeMain.setModel(null);
            return;
        }
        if (!OrgF7InnerUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)rootNode) || rootNode.getChildCount() == 0) {
            this.treeMain.setModel((TreeModel)new DefaultTreeModel((TreeNode)rootNode));
            TreePath path = new TreePath(rootNode.getPath());
            this.treeMain.expandPath(path);
            this.treeMain.setSelectionPath(path);
        } else {
            this.treeMain.setModel((TreeModel)new DefaultTreeModel((TreeNode)rootNode));
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)rootNode.getChildAt(0);
            TreePath path = new TreePath(node.getPath());
            this.treeMain.expandPath(path);
            this.treeMain.setSelectionPath(path);
        }
    }

    public void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        try {
            return new ObjectUuidPK(this.getSelectedNodeKeyValue());
        }
        catch (Exception ex) {
            this.handUIException(ex);
            return null;
        }
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getGroupEditUIName() {
        return null;
    }

    protected String getQueryFieldName() {
        return "";
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return StandbyPersonEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return StandbyPersonFactory.getRemoteInstance();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiCtx, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(StandbyPersonEditUI.class.getName(), (Map)uiCtx, null, OprtState.EDIT);
        uiWindow.show();
        this.isDoRefresh(uiWindow);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.performCommonQuery();
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        if (this.isRootNodeNull) {
            return;
        }
        TreePath path = null;
        path = e != null ? e.getPath() : this.treeMain.getSelectionPath();
        if (path == null) {
            return;
        }
        this.treenode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (OrgF7InnerUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)this.treenode)) {
            this.mainQuery = null;
            this.refreshData();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.NO_ORG_PERMISSION"));
            return;
        }
        Object userObj = this.treenode.getUserObject();
        FilterInfo filter = new FilterInfo();
        if (userObj != null && userObj instanceof AdminOrgUnitInfo) {
            this.chkIncludeChild.setVisible(true);
            AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)userObj;
            this.longNumber = adminInfo.getLongNumber();
            if (this.chkIncludeChild.isSelected()) {
                filter.getFilterItems().add(new FilterItemInfo("toPositionUnit.longNumber", (Object)(this.longNumber + "!%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("toPositionUnit.longNumber", (Object)this.longNumber));
                filter.getFilterItems().add(new FilterItemInfo("toUnit.longNumber", (Object)(this.longNumber + "%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("toUnit.longNumber", (Object)this.longNumber));
                filter.setMaskString(" #0 or #1 or #2 or #3");
            } else {
                filter.getFilterItems().add(new FilterItemInfo("toPositionUnit.longNumber", (Object)this.longNumber));
                filter.getFilterItems().add(new FilterItemInfo("toUnit.longNumber", (Object)this.longNumber));
                filter.setMaskString(" #0 or #1 ");
            }
            if (!this.chkShowVirtualOrg.isSelected()) {
                FilterInfo isVirtualFilter = new FilterInfo("toUnit.isVirtual = 0 or toPositionUnit.isVirtual = 0");
                filter.mergeFilter(isVirtualFilter, "and");
            }
        } else if (userObj != null && userObj instanceof PositionInfo) {
            this.chkIncludeChild.setVisible(false);
            PositionInfo posInfo = (PositionInfo)userObj;
            filter.getFilterItems().add(new FilterItemInfo("toPosition.id", (Object)posInfo.getId().toString()));
        } else {
            this.chkIncludeChild.setVisible(false);
        }
        FilterInfo dialogQueryFilter = null;
        if (this.queryFilter != null) {
            dialogQueryFilter = (FilterInfo)this.queryFilter.clone();
        }
        filter = HRUtil.customMergeFilter((FilterInfo)filter, dialogQueryFilter, (String)"AND");
        filter = HRUtil.customMergeFilter((FilterInfo)filter, (FilterInfo)this.getDefaultFilterForQuery(), (String)"AND");
        if (this.mainQuery == null) {
            EntityViewInfo view;
            this.mainQuery = view = new EntityViewInfo();
        }
        this.mainQuery.setFilter(filter);
        this.refreshData();
    }

    private void refreshData() throws BOSException {
        this.tblMain.removeRows();
    }

    protected void chkIncludeChild_itemStateChanged(ItemEvent e) throws Exception {
        super.chkIncludeChild_itemStateChanged(e);
        FilterInfo filter = new FilterInfo();
        if (this.chkIncludeChild.isSelected()) {
            filter.getFilterItems().add(new FilterItemInfo("toPositionUnit.longNumber", (Object)(this.longNumber + "%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("toPositionUnit.longNumber", (Object)this.longNumber));
            filter.getFilterItems().add(new FilterItemInfo("toUnit.longNumber", (Object)(this.longNumber + "%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("toUnit.longNumber", (Object)this.longNumber));
            filter.setMaskString(" #0 or #1 or #2 or #3 ");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("toPositionUnit.longNumber", (Object)this.longNumber));
            filter.getFilterItems().add(new FilterItemInfo("toUnit.longNumber", (Object)this.longNumber));
            filter.setMaskString(" #0 or #1 ");
        }
        FilterInfo dialogQueryFilter = null;
        if (this.queryFilter != null) {
            dialogQueryFilter = (FilterInfo)this.queryFilter.clone();
        }
        filter = HRUtil.customMergeFilter((FilterInfo)filter, dialogQueryFilter, (String)"AND");
        filter = HRUtil.customMergeFilter((FilterInfo)filter, (FilterInfo)this.getDefaultFilterForQuery(), (String)"AND");
        if (this.mainQuery == null) {
            EntityViewInfo view;
            this.mainQuery = view = new EntityViewInfo();
        }
        if (!this.chkShowVirtualOrg.isSelected()) {
            FilterInfo isVirtualFilter = new FilterInfo("toUnit.isVirtual = 0 or toPositionUnit.isVirtual = 0");
            filter.mergeFilter(isVirtualFilter, "and");
        }
        this.mainQuery.setFilter(filter);
        this.refreshData();
    }

    protected void performCommonQuery() throws Exception {
        String queryName;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (!(this.isPerformDefaultQuery(iQuery, queryName = StandbyPersonUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName()) && this.isHasPermission() || this.isFirstDefaultQuery())) {
            int iMaxNumView = iQuery.getMaxNumView(this.getMetaDataPK().getFullName(), queryName);
            if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
                EntityViewInfo defaultView = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
                if (defaultView == null || StringUtils.isEmpty((String)defaultView.toString())) {
                    this.showFilterDialog(iMaxNumView);
                } else {
                    this.MaxReturnRowCount = iMaxNumView;
                    this.mainQuery = defaultView;
                    this.queryFilter = defaultView.getFilter();
                    FilterInfo dialogQueryFilter = null;
                    if (this.queryFilter != null) {
                        dialogQueryFilter = (FilterInfo)this.queryFilter.clone();
                    }
                    FilterInfo filterInfo = HRUtil.customMergeFilter((FilterInfo)dialogQueryFilter, (FilterInfo)this.getDefaultFilterForQuery(), (String)"AND");
                    this.mainQuery.setFilter(filterInfo);
                    this.handleDynamicQuery(Util.getDynSelector((EntityViewInfo)this.mainQuery));
                    this.refreshData();
                }
                this.isFirstDefaultQuery = false;
            } else {
                this.showFilterDialog(iMaxNumView);
            }
        }
    }

    private void showFilterDialog(int iMaxNumView) throws Exception {
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            this.commonQueryDialog.setHeight(370);
            this.commonQueryDialog.setWidth(430);
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.commonQueryDialog.setQueryObjectPK(this.mainQueryPK);
            this.commonQueryDialog.setShowFilter(true);
            this.commonQueryDialog.setShowSorter(false);
            this.commonQueryDialog.setShowToolbar(true);
            if (this.orgContextManager != null) {
                if (this.orgContextManager.getOwner() != null && this.orgContextManager.getOwner() instanceof CustomerQueryPanel) {
                    StandbyPersonListFilterUI queryPanel = (StandbyPersonListFilterUI)this.orgContextManager.getOwner();
                    this.commonQueryDialog.addUserPanel((KDPanel)queryPanel);
                }
                this.orgContextManager.init(this.getUIContext());
            }
            this.commonQueryDialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
            this.commonQueryDialog.setMaxReturnCountVisible(true);
        }
        if (this.commonQueryDialog.show()) {
            this.mainQuery = this.commonQueryDialog.getEntityViewInfoResult();
            this.queryFilter = this.mainQuery.getFilter();
            FilterInfo filter = this.buildTreeFilterInfo();
            FilterInfo dialogQueryFilter = null;
            if (this.queryFilter != null) {
                dialogQueryFilter = (FilterInfo)this.queryFilter.clone();
            }
            filter = HRUtil.customMergeFilter((FilterInfo)filter, dialogQueryFilter, (String)"AND");
            filter = HRUtil.customMergeFilter((FilterInfo)filter, (FilterInfo)this.getDefaultFilterForQuery(), (String)"AND");
            this.mainQuery.setFilter(filter);
            this.handleDynamicQuery(Util.getDynSelector((EntityViewInfo)this.mainQuery));
            this.refreshData();
            this.isDoQuery = true;
        } else {
            SysUtil.abort();
        }
    }

    private FilterInfo buildTreeFilterInfo() throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        TreePath path = this.treeMain.getSelectionPath();
        if (path == null) {
            return filterInfo;
        }
        this.treenode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (OrgF7InnerUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)this.treenode)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)"-1"));
            return filterInfo;
        }
        Object userObj = this.treenode.getUserObject();
        FilterInfo filter = new FilterInfo();
        if (userObj != null && userObj instanceof AdminOrgUnitInfo) {
            AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)userObj;
            this.longNumber = adminInfo.getLongNumber();
            if (this.chkIncludeChild.isSelected()) {
                filter.getFilterItems().add(new FilterItemInfo("toPositionUnit.longNumber", (Object)(this.longNumber + "!%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("toPositionUnit.longNumber", (Object)this.longNumber));
                filter.getFilterItems().add(new FilterItemInfo("toUnit.longNumber", (Object)(this.longNumber + "%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("toUnit.longNumber", (Object)this.longNumber));
                filter.setMaskString(" #0 or #1 or #2 or #3");
            } else {
                filter.getFilterItems().add(new FilterItemInfo("toPositionUnit.longNumber", (Object)this.longNumber));
                filter.getFilterItems().add(new FilterItemInfo("toUnit.longNumber", (Object)this.longNumber));
                filter.setMaskString(" #0 or #1 ");
            }
        } else if (userObj != null && userObj instanceof PositionInfo) {
            PositionInfo posInfo = (PositionInfo)userObj;
            filter.getFilterItems().add(new FilterItemInfo("toPosition.id", (Object)posInfo.getId().toString()));
        }
        return filterInfo;
    }

    public void actionPersonPositionMatch_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiCtx = new UIContext((Object)this);
        String empId = this.tblMain.getRow(KDTableUtil.getSelectedRow((KDTable)this.tblMain)).getCell("employeeID").getValue().toString();
        uiCtx.put((Object)"empId", (Object)empId);
        Object toPos = this.tblMain.getRow(KDTableUtil.getSelectedRow((KDTable)this.tblMain)).getCell("toPositionID").getValue();
        String toPositionId = null;
        if (toPos != null) {
            toPositionId = toPos.toString();
        }
        uiCtx.put((Object)"toPositionId", (Object)toPositionId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(StandbyPersonToPositionMatchUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.tblMain.removeRows();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmRemove()) {
            String empId;
            IStandbyPerson iSbPer = (IStandbyPerson)this.getBizInterface();
            if (iSbPer.getToPositionAndToUnitCountByPerson(empId = this.tblMain.getRow(KDTableUtil.getSelectedRow((KDTable)this.tblMain)).getCell("employeeID").getValue().toString()) >= 2) {
                iSbPer.deleteStandbyPersonAndOther(this.getSelectedKeyValue(), true);
            } else if (MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.DELETE_ISRESERVE")) == 1) {
                iSbPer.deleteStandbyPersonAndOther(this.getSelectedKeyValue(), false);
            } else {
                iSbPer.deleteStandbyPersonAndOther(this.getSelectedKeyValue(), true);
            }
            this.refreshData();
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        HROrgUnitCollection hrOrgUnitCollection = this.getHROrgUnitCollection();
        Collection hrIds = EmployeeClientUtils.transInfoCollectionToIdCollection((IObjectCollection)hrOrgUnitCollection);
        FilterInfo toUnitFilterInfo = EmployeeClientUtils.getAdminRangeFilterInfo((Collection)hrIds, (String)"toUnit.id");
        FilterInfo toPositionFilterInfo = EmployeeClientUtils.getAdminRangeFilterInfo((Collection)hrIds, (String)"toPositionUnit.id");
        FilterInfo filter = null;
        try {
            filter = HRUtil.customMergeFilter((FilterInfo)toUnitFilterInfo, (FilterInfo)toPositionFilterInfo, (String)"OR");
            FilterInfo sFilter = new FilterInfo();
            sFilter.getFilterItems().add(new FilterItemInfo("toUnit.isSealUp", (Object)Boolean.FALSE));
            sFilter.getFilterItems().add(new FilterItemInfo("toUnit.isSealUp", null));
            sFilter.setMaskString("#0 or #1");
            filter.mergeFilter(sFilter, "and");
            if (!this.chkShowVirtualOrg.isSelected()) {
                FilterInfo isVirtualFilter = new FilterInfo("toUnit.isVirtual = 0 or toPositionUnit.isVirtual = 0");
                filter.mergeFilter(isVirtualFilter, "and");
            }
            return filter;
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
            return super.getDefaultFilterForQuery();
        }
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PEOPLE_ORGANIZATION;
    }

    protected IMultiOrgSupport getMainCustomerQueryPanel() {
        try {
            StandbyPersonListFilterUI filterUI = new StandbyPersonListFilterUI();
            filterUI.setPanelName(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.FILTERPANEL"));
            filterUI.setMetaDataPKForPemmission(this.mainQueryPK);
            return filterUI;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    public String getPropertyOfBizOrg(OrgType orgType) {
        return null;
    }

    public String[] getPropertyOfCopOrg() {
        return null;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (action == null) {
            return null;
        }
        String selectedId = this.getCurRowAdminOrgUnitId();
        if (selectedId != null) {
            ObjectUuidPK pk = null;
            HROrgUnitInfo hrOrgUnitInfo = this.getMyOrgPK(selectedId);
            if (hrOrgUnitInfo != null) {
                pk = new ObjectUuidPK(hrOrgUnitInfo.getId());
            }
            return pk;
        }
        return super.getOrgPK(action);
    }

    protected HROrgUnitInfo getMyOrgPK(String selectedId) {
        if (selectedId == null) {
            return null;
        }
        HROrgUnitInfo info = null;
        if (this.positionHROCache.containsKey(selectedId)) {
            info = (HROrgUnitInfo)this.positionHROCache.get(selectedId);
        } else {
            try {
                info = BOSUuid.read((String)selectedId).getType().toString().equals("74AE612E") ? OrgHRCommonFactory.getRemoteInstance().getPositionOrgHRO(selectedId) : OrgHRCommonFactory.getRemoteInstance().getAdminOrgHRO(selectedId);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (info != null) {
            this.positionHROCache.put(selectedId, info);
        }
        return info;
    }

    private String getCurRowAdminOrgUnitId() {
        IRow row;
        String id = null;
        int[] rowID = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (rowID.length > 0 && (row = this.tblMain.getRow(rowID[0])) != null) {
            if (row.getCell("toUnitID").getValue() != null) {
                id = row.getCell("toUnitID").getValue().toString();
            } else if (row.getCell("toPositionID").getValue() != null) {
                id = row.getCell("toPositionID").getValue().toString();
            }
        }
        return id;
    }

    protected void handlePermissionForItemAction(ItemAction action) {
    }

    private boolean isHasPermission() {
        if (this.getUIContext().get(OrgType.HRO) != null) {
            HROrgUnitInfo hrOrgUnitInfo = (HROrgUnitInfo)this.getUIContext().get(OrgType.HRO);
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            try {
                if (hrOrgUnitInfo.isIsBizUnit() && PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(hrOrgUnitInfo.getId()), HROrgContextManagerFacadeFactory.getRemoteInstance().getPermissionItem(MetaDataTypeList.BASEQUERY, this.getMainQueryPK()))) {
                    return false;
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return true;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"multi_org_context", (Object)this.getHROrgUnitCollection());
    }

    protected void chkShowVirtualOrg_itemStateChanged(ItemEvent e) throws Exception {
        this.initAdminPositionTree();
    }

    public void actionPerformanceInfo_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiCtx = new UIContext((Object)this);
        String empId = this.tblMain.getRow(KDTableUtil.getSelectedRow((KDTable)this.tblMain)).getCell("employeeID").getValue().toString();
        uiCtx.put((Object)"ID", (Object)empId);
        uiCtx.put((Object)"StandbyPersonUI", (Object)"StandbyPersonUI");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(EmployeePerformanceEditUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
        uiWindow.show();
    }

    public void actionTrainingInfo_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiCtx = new UIContext((Object)this);
        String empId = this.tblMain.getRow(KDTableUtil.getSelectedRow((KDTable)this.tblMain)).getCell("employeeID").getValue().toString();
        uiCtx.put((Object)"FromPage", (Object)"StandbyPersonUI");
        uiCtx.put((Object)"ID", (Object)empId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(TrainRecordInfoEditUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
        uiWindow.show();
    }
}

