/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.hr.standby.IStandbyPersonWish;
import com.kingdee.eas.hr.standby.StandbyPersonFactory;
import com.kingdee.eas.hr.standby.StandbyPersonInfo;
import com.kingdee.eas.hr.standby.StandbyPersonWishCollection;
import com.kingdee.eas.hr.standby.StandbyPersonWishFactory;
import com.kingdee.eas.hr.standby.StandbyPersonWishInfo;
import com.kingdee.eas.hr.standby.client.AbstractStandbyPersonWishUI;
import com.kingdee.eas.hr.standby.client.IStandbyPersonEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class StandbyPersonWishUI
extends AbstractStandbyPersonWishUI
implements IStandbyPersonEditUI {
    private static final Logger logger = CoreUIObject.getLogger(StandbyPersonWishUI.class);
    private String empId = null;
    private ArrayList deleteIds = new ArrayList();

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.setStandbyPersonId(this.getUIContext().get("ID").toString());
        super.onLoad();
        this.setTableCellEditor();
        this.firstLoad();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddWish.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDeleteWish.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnAddWish.setEnabled(true);
        this.btnDeleteWish.setEnabled(true);
        this.tblMain.getStyleAttributes().setWrapText(true);
        this.tblMain.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblMain.getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        this.setControlProperties();
    }

    private void setControlProperties() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.tblMain.getStyleAttributes().setLocked(true);
            this.btnAddWish.setEnabled(false);
            this.btnDeleteWish.setEnabled(false);
        }
    }

    private void setTableCellEditor() throws Exception {
        this.tblMain.checkParsed();
        KDBizPromptBox prmtPositionBox = new KDBizPromptBox();
        PositionPromptBox2 position = new PositionPromptBox2((IUIObject)this);
        position.setSealUp("true");
        prmtPositionBox.setSelector((KDPromptSelector)position);
        prmtPositionBox.setDisplayFormat("$name$");
        prmtPositionBox.setEditFormat("$number$");
        prmtPositionBox.setCommitFormat("$number$");
        prmtPositionBox.setEditable(false);
        this.tblMain.getColumn("toPosition").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtPositionBox));
        KDTextField txtCareerPlan = new KDTextField();
        txtCareerPlan.setMaxLength(200);
        this.tblMain.getColumn("careerPlan").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtCareerPlan));
        KDTextField txtExcellence = new KDTextField();
        txtExcellence.setMaxLength(80);
        this.tblMain.getColumn("excellence").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtExcellence));
        KDTextField txtShortage = new KDTextField();
        txtShortage.setMaxLength(80);
        this.tblMain.getColumn("shortage").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtShortage));
        KDTextField txtRequest = new KDTextField();
        txtRequest.setMaxLength(200);
        this.tblMain.getColumn("request").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtRequest));
    }

    public void setStandbyPersonId(String standbyPersonId) throws Exception {
        StandbyPersonInfo sbPerInfo = StandbyPersonFactory.getRemoteInstance().getStandbyPersonInfo((IObjectPK)new ObjectUuidPK(standbyPersonId));
        this.empId = sbPerInfo.getEmployee().getId().toString();
    }

    private void firstLoad() throws Exception {
        this.loadAllWishByEmployee();
    }

    public void secondLoad() throws Exception {
        this.loadAllWishByEmployee();
    }

    private void loadAllWishByEmployee() throws EASBizException, BOSException {
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("employee", (Object)this.empId));
        view.setFilter(filter);
        StandbyPersonWishCollection wishCol = StandbyPersonWishFactory.getRemoteInstance().getStandbyPersonWishCollection(view);
        int size = wishCol.size();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.addRow();
            StandbyPersonWishInfo wishInfo = wishCol.get(i);
            row.getCell("id").setValue((Object)wishInfo.getId().toString());
            if (wishInfo.getToPosition() != null) {
                PositionInfo posInfo = PositionFactory.getRemoteInstance().getPositionInfo((IObjectPK)new ObjectUuidPK(wishInfo.getToPosition().getId()));
                row.getCell("toPosition").setValue((Object)posInfo);
            }
            if (wishInfo.getCareerPlan() != null) {
                row.getCell("careerPlan").setValue((Object)wishInfo.getCareerPlan());
            }
            if (wishInfo.getExcellence() != null) {
                row.getCell("excellence").setValue((Object)wishInfo.getExcellence());
            }
            if (wishInfo.getShortage() != null) {
                row.getCell("shortage").setValue((Object)wishInfo.getShortage());
            }
            if (wishInfo.getRequest() == null) continue;
            row.getCell("request").setValue((Object)wishInfo.getRequest());
        }
    }

    private boolean checkInputValidate() throws EASBizException, BOSException {
        PositionInfo toPosInfo = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row.getCell("toPosition").getValue() == null) continue;
            toPosInfo = (PositionInfo)row.getCell("toPosition").getValue();
            IPerson iPer = PersonFactory.getRemoteInstance();
            PositionInfo empPosInfo = iPer.getPrimaryPosition(BOSUuid.read((String)this.empId));
            if (!toPosInfo.getId().toString().equals(empPosInfo.getId().toString())) continue;
            MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.NO") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.ROW") + EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.TOPOSITION_EMPPOSITION_CANNOT_SAME")));
            return false;
        }
        return true;
    }

    public boolean saveInfo() throws Exception {
        if (!this.checkInputValidate()) {
            return false;
        }
        IStandbyPersonWish iWish = StandbyPersonWishFactory.getRemoteInstance();
        iWish.updateBatchPersonWish(this.getAllWishCollection(), this.deleteIds);
        this.loadAllWishByEmployee();
        this.deleteIds = new ArrayList();
        return true;
    }

    private StandbyPersonWishCollection getAllWishCollection() {
        StandbyPersonWishCollection wishCol = new StandbyPersonWishCollection();
        int length = this.tblMain.getRowCount();
        for (int i = 0; i < length; ++i) {
            IRow row = this.tblMain.getRow(i);
            StandbyPersonWishInfo wishInfo = new StandbyPersonWishInfo();
            PersonInfo perInfo = new PersonInfo();
            perInfo.setId(BOSUuid.read((String)this.empId));
            wishInfo.setEmployee(perInfo);
            if (row.getCell("id").getValue() != null) {
                wishInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
            }
            if (row.getCell("toPosition").getValue() != null) {
                wishInfo.setToPosition((PositionInfo)row.getCell("toPosition").getValue());
            }
            if (row.getCell("careerPlan").getValue() != null) {
                wishInfo.setCareerPlan(row.getCell("careerPlan").getValue().toString());
            } else {
                wishInfo.setCareerPlan("");
            }
            if (row.getCell("excellence").getValue() != null) {
                wishInfo.setExcellence(row.getCell("excellence").getValue().toString());
            } else {
                wishInfo.setExcellence("");
            }
            if (row.getCell("shortage").getValue() != null) {
                wishInfo.setShortage(row.getCell("shortage").getValue().toString());
            } else {
                wishInfo.setShortage("");
            }
            if (row.getCell("request").getValue() != null) {
                wishInfo.setRequest(row.getCell("request").getValue().toString());
            } else {
                wishInfo.setRequest("");
            }
            wishCol.add(wishInfo);
        }
        return wishCol;
    }

    public void actionAddWish_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.addRow();
    }

    public void actionDeleteWish_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (rowIndex < 0 || rowIndex >= this.tblMain.getRowCount()) {
            return;
        }
        ICell cell = this.tblMain.getRow(rowIndex).getCell("id");
        if (cell.getValue() != null) {
            this.deleteIds.add(cell.getValue().toString());
        }
        this.tblMain.removeRow(rowIndex);
    }

    public boolean isModify() {
        return false;
    }
}

