/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.client.IHRBillEditUIBiz;
import com.kingdee.eas.hr.standby.StandbyException;
import com.kingdee.eas.hr.standby.StandbyPersonAuditRecordInfo;
import com.kingdee.eas.hr.standby.StandbyPersonCourseInfo;
import com.kingdee.eas.hr.standby.StandbyPersonPlanCollection;
import com.kingdee.eas.hr.standby.StandbyPersonPlanFactory;
import com.kingdee.eas.hr.standby.StandbyPersonPlanInfo;
import com.kingdee.eas.hr.standby.StandbyReviewBizBillFactory;
import com.kingdee.eas.hr.standby.StandbyReviewBizBillInfo;
import com.kingdee.eas.hr.standby.StandbyTrainingItemCollection;
import com.kingdee.eas.hr.standby.StandbyTrainingItemFactory;
import com.kingdee.eas.hr.standby.StandbyTrainingItemInfo;
import com.kingdee.eas.hr.standby.client.AbstractStandbyReviewBizBillEditUI;
import com.kingdee.eas.hr.standby.client.PlanProject;
import com.kingdee.eas.hr.standby.client.StandbyReviewBizBillEditUIBiz;
import com.kingdee.eas.hr.standby.client.StandbyUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class StandbyReviewBizBillEditUI
extends AbstractStandbyReviewBizBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(StandbyReviewBizBillEditUI.class);
    private static final String dateFormatStr = "%r{yyyy-MM-dd}t";
    private StandbyReviewBizBillInfo srbbInfo = null;
    private PersonInfo personInfo = null;
    private HashMap srbbMap = null;
    private HashMap traceMap = null;
    private HashMap recordMap = null;
    private HashMap ttMap = null;
    private HashMap rrMap = null;
    private KDComboBox cboPersonPlan = new KDComboBox();
    private int curCourRowID = -1;
    private String TRAINTRACE = "trainTrace~";
    private String REVIEWRECORD = "reviewRecord~";

    protected void beforeOnLoad() throws Exception {
        StandbyUtils.checkUserHavePerson();
        super.beforeOnLoad();
    }

    public void onLoad() throws Exception {
        this.srbbMap = new HashMap();
        this.traceMap = new HashMap();
        this.recordMap = new HashMap();
        this.srbbMap.put("trainTrace", this.traceMap);
        this.srbbMap.put("reviewRecord", this.recordMap);
        super.onLoad();
        if (this.editData != null && this.editData.getId() != null) {
            BOSUuid srbbId = this.editData.getId();
            this.srbbInfo = (StandbyReviewBizBillInfo)StandbyReviewBizBillFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(srbbId));
            if (this.srbbInfo.get("traceAndRecord") != null) {
                this.srbbMap = (HashMap)this.srbbInfo.get("traceAndRecord");
                this.traceMap = (HashMap)this.srbbMap.get("trainTrace");
                this.recordMap = (HashMap)this.srbbMap.get("reviewRecord");
            }
        }
        this.changeTraceAndRecordStatus();
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.kdtEntrys_detailPanel.getAddNewLineButton().setVisible(false);
        this.actionTrainTraceAdd.setEnabled(true);
        this.actionTrainTraceDelete.setEnabled(true);
        this.actionReviewRecordAdd.setEnabled(true);
        this.actionReviewRecordDelete.setEnabled(true);
        this.setTableCellEditor();
        this.ignoreDetailPanelAction();
    }

    private void setTableCellEditor() throws Exception {
        this.tblTrainTrace.checkParsed();
        this.tblTrainTrace.getColumn("personPlan").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cboPersonPlan));
        this.tblTrainTrace.getColumn("personPlan").getStyleAttributes().setBackground(StandbyUtils.MUSTINPUT_BGCOLOR);
        KDTextField txtSummary = new KDTextField();
        txtSummary.setMaxLength(200);
        this.tblTrainTrace.getColumn("summary").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtSummary));
        this.tblTrainTrace.getColumn("realBeginDate").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblTrainTrace.getColumn("realBeginDate").getStyleAttributes().setNumberFormat(dateFormatStr);
        this.tblTrainTrace.getColumn("realEndDate").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblTrainTrace.getColumn("realEndDate").getStyleAttributes().setNumberFormat(dateFormatStr);
        KDTextField txtRealResult = new KDTextField();
        txtRealResult.setMaxLength(200);
        this.tblTrainTrace.getColumn("realResult").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtRealResult));
        KDTextField txtIsReachTarget = new KDTextField();
        txtIsReachTarget.setMaxLength(80);
        this.tblTrainTrace.getColumn("isReachTarget").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtIsReachTarget));
        KDTextField txtFailReason = new KDTextField();
        txtFailReason.setMaxLength(200);
        this.tblTrainTrace.getColumn("failReason").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtFailReason));
        this.cboPersonPlan.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (StandbyReviewBizBillEditUI.this.cboPersonPlan.getSelectedItem() == null) {
                    return;
                }
                String ppId = ((PlanProject)StandbyReviewBizBillEditUI.this.cboPersonPlan.getSelectedItem()).getId();
                try {
                    StandbyReviewBizBillEditUI.this.tblTrainTrace.getRow(StandbyReviewBizBillEditUI.this.curCourRowID).getCell("summary").setValue((Object)StandbyReviewBizBillEditUI.this.getSummaryByPPId(ppId));
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.tblTrainTrace.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                StandbyReviewBizBillEditUI.this.curCourRowID = e.getRowIndex();
                try {
                    if (e.getColIndex() == 1) {
                        StandbyReviewBizBillEditUI.this.loadCboPersonPlan(StandbyReviewBizBillEditUI.this.personInfo.getId().toString());
                    }
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.tblReviewRecord.checkParsed();
        KDTextField txtProject = new KDTextField();
        txtProject.setMaxLength(80);
        this.tblReviewRecord.getColumn("project").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtProject));
        this.tblReviewRecord.getColumn("project").getStyleAttributes().setBackground(StandbyUtils.MUSTINPUT_BGCOLOR);
        KDTextField txtResult = new KDTextField();
        txtResult.setMaxLength(200);
        this.tblReviewRecord.getColumn("result").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtResult));
        this.tblReviewRecord.getColumn("result").getStyleAttributes().setBackground(StandbyUtils.MUSTINPUT_BGCOLOR);
        KDTextField txtExcellence = new KDTextField();
        txtExcellence.setMaxLength(80);
        this.tblReviewRecord.getColumn("excellence").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtExcellence));
        KDTextField txtShortage = new KDTextField();
        txtShortage.setMaxLength(80);
        this.tblReviewRecord.getColumn("shortage").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtShortage));
        KDTextField txtSumUp = new KDTextField();
        txtSumUp.setMaxLength(200);
        this.tblReviewRecord.getColumn("sumUp").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtSumUp));
    }

    private String getSummaryByPPId(String ppId) throws EASBizException, BOSException {
        String strSummary = "";
        if (ppId != null) {
            StandbyPersonPlanInfo planInfo = StandbyPersonPlanFactory.getRemoteInstance().getStandbyPersonPlanInfo((IObjectPK)new ObjectUuidPK(ppId));
            strSummary = planInfo.getSummary();
        }
        return strSummary;
    }

    private void loadCboPersonPlan(String personId) throws BOSException {
        int i;
        int size;
        DefaultComboBoxModel<PlanProject> model = new DefaultComboBoxModel<PlanProject>();
        this.cboPersonPlan.setModel(model);
        StandbyPersonPlanCollection infos = StandbyPersonPlanFactory.getRemoteInstance().getStandbyPersonPlanCollection("Select * Where employee = '" + personId + "' and isAudited = 1");
        StringBuffer trainingItemId = new StringBuffer();
        if (infos.size() > 0) {
            int size2 = infos.size();
            for (int i2 = 0; i2 < size2; ++i2) {
                if (infos.get(i2).getTrainingItem() == null) continue;
                trainingItemId.append("'");
                trainingItemId.append(infos.get(i2).getTrainingItem().getId().toString());
                if (i2 == size2 - 1) {
                    trainingItemId.append("'");
                    continue;
                }
                trainingItemId.append("',");
            }
        }
        if (trainingItemId == null || trainingItemId.length() <= 0) {
            return;
        }
        HashMap<String, String> trainingItemMap = new HashMap<String, String>();
        StandbyTrainingItemCollection trainingItem = StandbyTrainingItemFactory.getRemoteInstance().getStandbyTrainingItemCollection("where id in (" + trainingItemId + ")");
        if (trainingItem.size() > 0) {
            size = trainingItem.size();
            for (i = 0; i < size; ++i) {
                trainingItemMap.put(trainingItem.get(i).getId().toString(), trainingItem.get(i).getName());
            }
        }
        if (infos.size() > 0 && !trainingItemMap.isEmpty()) {
            size = infos.size();
            for (i = 0; i < size; ++i) {
                StandbyPersonPlanInfo planInfo = infos.get(i);
                if (planInfo.getTrainingItem() == null || trainingItemMap.get(planInfo.getTrainingItem().getId().toString()) == null) continue;
                PlanProject planPrj = new PlanProject(planInfo.getId().toString(), trainingItemMap.get(planInfo.getTrainingItem().getId().toString()).toString());
                model.addElement(planPrj);
            }
            this.cboPersonPlan.setModel(model);
            this.tblTrainTrace.getColumn("personPlan").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cboPersonPlan));
        }
    }

    protected IHRBillEditUIBiz getBillBiz() {
        return new StandbyReviewBizBillEditUIBiz();
    }

    protected DetailPanel getIgnoredDetailPanel() {
        this.kdtEntrys_detailPanel.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"PERSON_SELECT"));
        return this.kdtEntrys_detailPanel;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnTrainTraceAdd.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnTrainTraceDelete.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnReviewRecordAdd.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnReviewRecordDelete.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.kdtEntrys_detailPanel.getInsertLineButton().setIcon(EASResource.getIcon((String)"imgTbtn_releasebyuser"));
        StyleAttributes saTrainTrace = this.tblTrainTrace.getStyleAttributes();
        saTrainTrace.setWrapText(true);
        saTrainTrace.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        saTrainTrace.setVerticalAlign(Styles.VerticalAlignment.TOP);
        StyleAttributes saReviewRecord = this.tblReviewRecord.getStyleAttributes();
        saReviewRecord.setWrapText(true);
        saReviewRecord.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        saReviewRecord.setVerticalAlign(Styles.VerticalAlignment.TOP);
        this.setControlProperties();
    }

    private void setControlProperties() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.tblTrainTrace.getStyleAttributes().setLocked(true);
            this.btnTrainTraceAdd.setEnabled(false);
            this.btnTrainTraceDelete.setEnabled(false);
            this.tblReviewRecord.getStyleAttributes().setLocked(true);
            this.btnReviewRecordAdd.setEnabled(false);
            this.btnReviewRecordDelete.setEnabled(false);
        }
    }

    public void actionColumnCopyAll_actionPerformed(ActionEvent e) throws Exception {
        int i;
        ((StandbyReviewBizBillEditUIBiz)this.biz).copyColumn(this.kdtEntrys, false);
        ((StandbyReviewBizBillEditUIBiz)this.biz).copyColumn(this.tblTrainTrace, false);
        ((StandbyReviewBizBillEditUIBiz)this.biz).copyColumn(this.tblReviewRecord, false);
        int row = this.tblReviewRecord.getRowCount();
        for (i = 0; i < row; ++i) {
            this.fillRRMap(i);
        }
        row = this.tblTrainTrace.getRowCount();
        for (i = 0; i < row; ++i) {
            this.fillTTMap(i);
        }
    }

    public void actionColumnCopySelect_actionPerformed(ActionEvent e) throws Exception {
        int i;
        ((StandbyReviewBizBillEditUIBiz)this.biz).copyColumn(this.kdtEntrys, true);
        ((StandbyReviewBizBillEditUIBiz)this.biz).copyColumn(this.tblTrainTrace, true);
        ((StandbyReviewBizBillEditUIBiz)this.biz).copyColumn(this.tblReviewRecord, true);
        int row = this.tblReviewRecord.getRowCount();
        for (i = 0; i < row; ++i) {
            this.fillRRMap(i);
        }
        row = this.tblTrainTrace.getRowCount();
        for (i = 0; i < row; ++i) {
            this.fillTTMap(i);
        }
    }

    protected void lockUIForViewStatus() {
        super.lockUIForViewStatus();
        this.kdtEntrys_detailPanel.getAddNewLineButton().setEnabled(false);
        this.kdtEntrys_detailPanel.getInsertLineButton().setEnabled(false);
        this.kdtEntrys_detailPanel.getRemoveLinesButton().setEnabled(false);
    }

    protected IObjectValue createNewData() {
        StandbyReviewBizBillInfo objectValue = new StandbyReviewBizBillInfo();
        UserInfo info = SysContext.getSysContext().getCurrentUserInfo();
        objectValue.setBillState(HRBillStateEnum.SAVED);
        objectValue.setApplier(info.getPerson());
        objectValue.put("traceAndRecord", this.srbbMap);
        return objectValue;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    protected void initListener() {
        this.kdtEntrys.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent event) {
                StandbyReviewBizBillEditUI.this.tblTrainTrace.removeRows();
                StandbyReviewBizBillEditUI.this.tblReviewRecord.removeRows();
                if (StandbyReviewBizBillEditUI.this.kdtEntrys.getRowCount() <= 0) {
                    return;
                }
                int row = StandbyReviewBizBillEditUI.this.kdtEntrys.getSelectManager().getActiveRowIndex();
                StandbyReviewBizBillEditUI.this.personInfo = (PersonInfo)StandbyReviewBizBillEditUI.this.kdtEntrys.getRow(row).getCell("person").getValue();
                try {
                    StandbyReviewBizBillEditUI.this.fillTrainTraceValue(StandbyReviewBizBillEditUI.this.personInfo.getId().toString());
                    StandbyReviewBizBillEditUI.this.fillReviewRecordValue(StandbyReviewBizBillEditUI.this.personInfo.getId().toString());
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        });
    }

    private void fillTrainTraceValue(String personId) {
        String key = this.TRAINTRACE + personId;
        if (this.traceMap.get(key) == null) {
            return;
        }
        this.ttMap = (HashMap)this.traceMap.get(key);
        for (Object ttKey : this.ttMap.keySet()) {
            StandbyPersonCourseInfo ttInfo = (StandbyPersonCourseInfo)this.ttMap.get(ttKey);
            IRow row = this.tblTrainTrace.addRow();
            row.getCell("id").setValue((Object)ttInfo.getId().toString());
            if (ttInfo.getPlan() != null) {
                StandbyPersonPlanInfo ppInfo = ttInfo.getPlan();
                PlanProject planPrj = new PlanProject(ppInfo.getId().toString(), ppInfo.getTrainingItem().getName());
                row.getCell("personPlan").setValue((Object)planPrj);
            }
            if (ttInfo.getSummary() != null) {
                row.getCell("summary").setValue((Object)ttInfo.getSummary());
            }
            if (ttInfo.getRealBeginDate() != null) {
                row.getCell("realBeginDate").setValue((Object)ttInfo.getRealBeginDate());
            }
            if (ttInfo.getRealEndDate() != null) {
                row.getCell("realEndDate").setValue((Object)ttInfo.getRealEndDate());
            }
            if (ttInfo.getRealResult() != null) {
                row.getCell("realResult").setValue((Object)ttInfo.getRealResult());
            }
            if (ttInfo.getIsReachTarget() != null) {
                row.getCell("isReachTarget").setValue((Object)ttInfo.getIsReachTarget());
            }
            if (ttInfo.getFailReason() == null) continue;
            row.getCell("failReason").setValue((Object)ttInfo.getFailReason());
        }
    }

    private void fillReviewRecordValue(String personId) {
        String key = this.REVIEWRECORD + personId;
        if (this.recordMap.get(key) == null) {
            return;
        }
        this.rrMap = (HashMap)this.recordMap.get(key);
        for (Object rrKey : this.rrMap.keySet()) {
            StandbyPersonAuditRecordInfo rrInfo = (StandbyPersonAuditRecordInfo)this.rrMap.get(rrKey);
            IRow row = this.tblReviewRecord.addRow();
            row.getCell("id").setValue((Object)rrInfo.getId().toString());
            if (rrInfo.getProject() != null) {
                row.getCell("project").setValue((Object)rrInfo.getProject());
            }
            if (rrInfo.getResult() != null) {
                row.getCell("result").setValue((Object)rrInfo.getResult());
            }
            if (rrInfo.getExcellence() != null) {
                row.getCell("excellence").setValue((Object)rrInfo.getExcellence());
            }
            if (rrInfo.getShortAge() != null) {
                row.getCell("shortage").setValue((Object)rrInfo.getShortAge());
            }
            if (rrInfo.getSumUp() == null) continue;
            row.getCell("sumUp").setValue((Object)rrInfo.getSumUp());
        }
    }

    public void actionReviewRecordAdd_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntrys.getSelectManager().getActiveRowIndex() == -1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.SELECT_PERSON_FIRST"));
            return;
        }
        StandbyPersonAuditRecordInfo rrInfo = new StandbyPersonAuditRecordInfo();
        IRow row = this.tblReviewRecord.addRow();
        BOSUuid rrId = BOSUuid.create((BOSObjectType)rrInfo.getBOSType());
        row.getCell("id").setValue((Object)rrId.toString());
        rrInfo.setId(rrId);
        rrInfo.setEmployee(this.personInfo);
        String key = this.REVIEWRECORD + this.personInfo.getId().toString();
        this.rrMap = this.recordMap.get(key) != null ? (HashMap)this.recordMap.get(key) : new HashMap();
        this.rrMap.put(rrId.toString(), rrInfo);
        this.recordMap.put(key, this.rrMap);
    }

    public void actionReviewRecordDelete_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntrys.getSelectManager().getActiveRowIndex() == -1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.SELECT_PERSON_FIRST"));
            return;
        }
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblReviewRecord);
        if (rowIndex < 0 || rowIndex >= this.tblReviewRecord.getRowCount()) {
            return;
        }
        String pwId = this.tblReviewRecord.getRow(rowIndex).getCell("id").getValue().toString();
        String key = this.REVIEWRECORD + this.personInfo.getId().toString();
        if (this.recordMap.get(key) != null) {
            this.rrMap = (HashMap)this.recordMap.get(key);
            this.rrMap.remove(pwId);
            this.recordMap.put(key, this.rrMap);
        }
        this.tblReviewRecord.removeRow(rowIndex);
    }

    public void actionTrainTraceAdd_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntrys.getSelectManager().getActiveRowIndex() == -1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.SELECT_PERSON_FIRST"));
            return;
        }
        StandbyPersonCourseInfo ttInfo = new StandbyPersonCourseInfo();
        IRow row = this.tblTrainTrace.addRow();
        BOSUuid ttId = BOSUuid.create((BOSObjectType)ttInfo.getBOSType());
        row.getCell("id").setValue((Object)ttId.toString());
        ttInfo.setId(ttId);
        String key = this.TRAINTRACE + this.personInfo.getId().toString();
        this.ttMap = this.traceMap.get(key) != null ? (HashMap)this.traceMap.get(key) : new HashMap();
        this.ttMap.put(ttId.toString(), ttInfo);
        this.traceMap.put(key, this.ttMap);
    }

    public void actionTrainTraceDelete_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntrys.getSelectManager().getActiveRowIndex() == -1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.SELECT_PERSON_FIRST"));
            return;
        }
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblTrainTrace);
        if (rowIndex < 0 || rowIndex >= this.tblTrainTrace.getRowCount()) {
            return;
        }
        String traceId = this.tblTrainTrace.getRow(rowIndex).getCell("id").getValue().toString();
        String key = this.TRAINTRACE + this.personInfo.getId().toString();
        if (this.traceMap.get(key) != null) {
            this.ttMap = (HashMap)this.traceMap.get(key);
            this.ttMap.remove(traceId);
            this.traceMap.put(key, this.ttMap);
        }
        this.tblTrainTrace.removeRow(rowIndex);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.changeTraceAndRecordStatus();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.changeTraceAndRecordStatus();
        this.tblReviewRecord.removeRows();
        this.tblTrainTrace.removeRows();
        this.rrMap.clear();
        this.recordMap.clear();
        this.ttMap.clear();
        this.traceMap.clear();
    }

    private void changeTraceAndRecordStatus() {
        if (this.getOprtState().equals("VIEW")) {
            this.actionTrainTraceAdd.setEnabled(false);
            this.actionTrainTraceDelete.setEnabled(false);
            this.actionReviewRecordAdd.setEnabled(false);
            this.actionReviewRecordDelete.setEnabled(false);
            this.tblTrainTrace.getStyleAttributes().setLocked(true);
            this.tblReviewRecord.getStyleAttributes().setLocked(true);
        } else {
            this.actionTrainTraceAdd.setEnabled(true);
            this.actionTrainTraceDelete.setEnabled(true);
            this.actionReviewRecordAdd.setEnabled(true);
            this.actionReviewRecordDelete.setEnabled(true);
            this.tblTrainTrace.getStyleAttributes().setLocked(false);
            this.tblReviewRecord.getStyleAttributes().setLocked(false);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.get("traceAndRecord") == null) {
            this.editData.put("traceAndRecord", this.srbbMap);
        }
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.get("traceAndRecord") == null) {
            this.editData.put("traceAndRecord", this.srbbMap);
        }
        super.actionSubmit_actionPerformed(e);
    }

    protected void tblReviewRecord_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = this.tblReviewRecord.getSelectManager().getActiveRowIndex();
        this.fillRRMap(rowIndex);
        if (e.getOldValue() != null && !e.getOldValue().equals(e.getValue()) || e.getOldValue() == null && e.getValue() != null) {
            this.editData.put("change", "true");
        }
    }

    private void fillRRMap(int rowIndex) {
        if (rowIndex == -1) {
            return;
        }
        IRow row = this.tblReviewRecord.getRow(rowIndex);
        String rrId = row.getCell("id").getValue().toString();
        StandbyPersonAuditRecordInfo rrInfo = null;
        rrInfo = this.rrMap.get(rrId) != null ? (StandbyPersonAuditRecordInfo)this.rrMap.get(rrId) : new StandbyPersonAuditRecordInfo();
        if (row.getCell("project").getValue() != null) {
            rrInfo.setProject(row.getCell("project").getValue().toString());
        }
        if (row.getCell("result").getValue() != null) {
            rrInfo.setResult(row.getCell("result").getValue().toString());
        }
        if (row.getCell("excellence").getValue() != null) {
            rrInfo.setExcellence(row.getCell("excellence").getValue().toString());
        } else {
            rrInfo.setExcellence("");
        }
        if (row.getCell("shortage").getValue() != null) {
            rrInfo.setShortAge(row.getCell("shortage").getValue().toString());
        } else {
            rrInfo.setShortAge("");
        }
        if (row.getCell("sumUp").getValue() != null) {
            rrInfo.setSumUp(row.getCell("sumUp").getValue().toString());
        } else {
            rrInfo.setSumUp("");
        }
    }

    protected void tblTrainTrace_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = this.tblTrainTrace.getSelectManager().getActiveRowIndex();
        this.fillTTMap(rowIndex);
        if (e.getOldValue() != null && !e.getOldValue().equals(e.getValue()) || e.getOldValue() == null && e.getValue() != null) {
            this.editData.put("change", "true");
        }
    }

    private void fillTTMap(int rowIndex) {
        if (rowIndex == -1) {
            return;
        }
        IRow row = this.tblTrainTrace.getRow(rowIndex);
        String ttId = row.getCell("id").getValue().toString();
        StandbyPersonCourseInfo ttInfo = null;
        ttInfo = this.ttMap.get(ttId) != null ? (StandbyPersonCourseInfo)this.ttMap.get(ttId) : new StandbyPersonCourseInfo();
        if (row.getCell("personPlan").getValue() != null) {
            StandbyPersonPlanInfo ppInfo = new StandbyPersonPlanInfo();
            PlanProject planProject = (PlanProject)row.getCell("personPlan").getValue();
            ppInfo.setId(BOSUuid.read((String)planProject.getId()));
            StandbyTrainingItemInfo trainingItem = new StandbyTrainingItemInfo();
            trainingItem.setName(planProject.getText());
            ppInfo.setTrainingItem(trainingItem);
            ttInfo.setPlan(ppInfo);
        }
        if (row.getCell("summary").getValue() != null) {
            ttInfo.setSummary(row.getCell("summary").getValue().toString());
        } else {
            ttInfo.setSummary("");
        }
        ttInfo.setRealBeginDate((Date)row.getCell("realBeginDate").getValue());
        ttInfo.setRealEndDate((Date)row.getCell("realEndDate").getValue());
        if (row.getCell("realResult").getValue() != null) {
            ttInfo.setRealResult(row.getCell("realResult").getValue().toString());
        } else {
            ttInfo.setRealResult("");
        }
        if (row.getCell("isReachTarget").getValue() != null) {
            ttInfo.setIsReachTarget(row.getCell("isReachTarget").getValue().toString());
        } else {
            ttInfo.setIsReachTarget("");
        }
        if (row.getCell("failReason").getValue() != null) {
            ttInfo.setFailReason(row.getCell("failReason").getValue().toString());
        } else {
            ttInfo.setFailReason("");
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        int rowCount = this.kdtEntrys.getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            PersonInfo empInfo = (PersonInfo)this.kdtEntrys.getRow(row).getCell("person").getValue();
            String empName = empInfo.getName();
            String personId = empInfo.getId().toString();
            String traceKey = this.TRAINTRACE + personId;
            String recordKey = this.REVIEWRECORD + personId;
            boolean result = false;
            StandbyPersonCourseInfo ttInfo = null;
            if (this.traceMap != null) {
                if (this.traceMap.get(traceKey) == null) {
                    result = true;
                } else {
                    HashMap tMap = (HashMap)this.traceMap.get(traceKey);
                    if (tMap == null || tMap.isEmpty()) {
                        result = true;
                    } else {
                        Iterator ttItr = tMap.entrySet().iterator();
                        ArrayList<BOSUuid> ttList = new ArrayList<BOSUuid>();
                        while (ttItr.hasNext()) {
                            boolean flagOfDate;
                            Map.Entry entry = ttItr.next();
                            ttInfo = (StandbyPersonCourseInfo)entry.getValue();
                            if (ttInfo.getPlan() == null) {
                                throw new StandbyException(StandbyException.EXIST_NULL_PLAN, new Object[]{empName});
                            }
                            if (ttInfo.getRealBeginDate() != null && ttInfo.getRealEndDate() != null && (flagOfDate = DateTimeUtils.dayAfter((Date)ttInfo.getRealBeginDate(), (Date)ttInfo.getRealEndDate()))) {
                                throw new StandbyException(StandbyException.EXIST_REALBEGIN_AFTER_REALEND, new Object[]{empName});
                            }
                            ttList.add(ttInfo.getPlan().getId());
                        }
                        int size = ttList.size();
                        for (int i = 0; i < size; ++i) {
                            int len = ttList.size() - i;
                            for (int j = i + 1; j < len; ++j) {
                                if (!ttList.get(i).equals(ttList.get(j))) continue;
                                throw new StandbyException(StandbyException.EXIST_REPEATTRAINITEM, new Object[]{empName});
                            }
                        }
                    }
                }
            }
            if (this.recordMap == null) continue;
            if (this.recordMap.get(recordKey) == null) {
                if (!result) continue;
                throw new StandbyException(StandbyException.TRACE_RECORD_ALL_NULL, new Object[]{empName});
            }
            HashMap rMap = (HashMap)this.recordMap.get(recordKey);
            if (rMap == null || rMap.isEmpty()) {
                if (!result) continue;
                throw new StandbyException(StandbyException.TRACE_RECORD_ALL_NULL, new Object[]{empName});
            }
            Iterator rrItr = rMap.entrySet().iterator();
            StandbyPersonAuditRecordInfo rrInfo = null;
            Object rrKey = null;
            Map.Entry entry = null;
            while (rrItr.hasNext()) {
                entry = rrItr.next();
                rrKey = entry.getKey();
                rrInfo = (StandbyPersonAuditRecordInfo)entry.getValue();
                if (!StringUtils.isEmpty((String)rrInfo.getProject()) && !StringUtils.isEmpty((String)rrInfo.getResult())) continue;
                throw new StandbyException(StandbyException.EXIST_NULL_PROJECTORRESULT, new Object[]{empName});
            }
        }
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.onLoad();
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.onLoad();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.onLoad();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.onLoad();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return StandbyReviewBizBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected void changeDataByEntryInfo() {
        if (this.kdtEntrys.getRowCount() <= 0) {
            return;
        }
        int top = this.kdtEntrys.getSelectManager().get().getTop();
        this.personInfo = (PersonInfo)this.kdtEntrys.getRow(top).getCell("person").getValue();
        if (this.personInfo != null && this.personInfo.getId() != null) {
            this.deleteRelationMap(this.personInfo.getId().toString());
        }
        if (top < 0 || top >= this.kdtEntrys.getRowCount()) {
            return;
        }
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.kdtEntrys);
        int maxLength = 0;
        if (indexs.length <= 1) {
            maxLength = top + 1;
        } else {
            int size = indexs.length;
            for (int i = 0; i < size; ++i) {
                if (indexs[i] == top || maxLength >= indexs[i]) continue;
                maxLength = indexs[i];
            }
        }
        if (maxLength < this.kdtEntrys.getRowCount()) {
            this.tblTrainTrace.removeRows();
            this.tblReviewRecord.removeRows();
            this.personInfo = (PersonInfo)this.kdtEntrys.getRow(maxLength).getCell("person").getValue();
            try {
                this.fillTrainTraceValue(this.personInfo.getId().toString());
                this.fillReviewRecordValue(this.personInfo.getId().toString());
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    private void deleteRelationMap(String personID) {
        String keyRecord;
        String keyTraintrace = this.TRAINTRACE + this.personInfo.getId().toString();
        if (this.traceMap.get(keyTraintrace) != null) {
            this.traceMap.remove(keyTraintrace);
        }
        if (this.recordMap.get(keyRecord = this.REVIEWRECORD + this.personInfo.getId().toString()) != null) {
            this.recordMap.remove(keyRecord);
        }
    }

    protected void removeStandbyLine(KDTable table) throws Exception {
        this.changeDataByEntryInfo();
    }

    protected void ignoreDetailPanelAction() {
        if (this.kdtEntrys_detailPanel != null) {
            KDWorkButton btn = this.kdtEntrys_detailPanel.getRemoveLinesButton();
            btn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        StandbyReviewBizBillEditUI.this.removeStandbyLine(StandbyReviewBizBillEditUI.this.kdtEntrys);
                    }
                    catch (Exception e1) {
                        StandbyReviewBizBillEditUI.this.handUIException(e1);
                    }
                }
            });
        }
    }
}

