/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.OrgBlankException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.standby.StandbyTrainingItemFactory;
import com.kingdee.eas.hr.standby.StandbyTrainingItemInfo;
import com.kingdee.eas.hr.standby.client.AbstractStandbyTrainingItemEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class StandbyTrainingItemEditUI
extends AbstractStandbyTrainingItemEditUI {
    private static final Logger logger = CoreUIObject.getLogger(StandbyTrainingItemEditUI.class);

    protected IObjectValue createNewData() {
        return new StandbyTrainingItemInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return StandbyTrainingItemFactory.getRemoteInstance();
    }

    public void loadFields() {
        this.setAutoNumberByOrg("HRO");
        super.loadFields();
    }

    protected void setAutoNumberByOrg(String orgType) {
        if (this.editData.getNumber() == null) {
            try {
                String companyID = null;
                if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
                } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
                }
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                if (iCodingRuleManager.isExist((IObjectValue)this.editData, companyID)) {
                    if (iCodingRuleManager.isAddView((IObjectValue)this.editData, companyID)) {
                        this.editData.setNumber(iCodingRuleManager.getNumber((IObjectValue)this.editData, companyID));
                    }
                    this.tfNumber.setEnabled(false);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
                this.oldData = this.editData;
                SysUtil.abort();
            }
        } else if (this.editData.getNumber().trim().length() > 0) {
            this.tfNumber.setText(this.editData.getNumber());
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.tfNumber.isEnabled() && this.tfNumber.getText().trim().length() == 0) {
            this.tfNumber.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NUMBER_CAN_NOT_BLANK);
        }
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            this.tfName.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NAME_CAN_NOT_BLANK);
        }
    }

    public IObjectPK runSubmit() throws Exception {
        boolean isIntermit = false;
        String orgUnitId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            boolean result = codingRuleManager.isExist((IObjectValue)this.editData, orgUnitId);
            if (result && OprtState.ADDNEW.equals(this.getOprtState()) && (isIntermit = codingRuleManager.isUseIntermitNumber((IObjectValue)this.editData, orgUnitId))) {
                this.editData.setNumber(codingRuleManager.getNumber((IObjectValue)this.editData, orgUnitId));
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        return super.runSubmit();
    }
}

