/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.client;

import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgBlankException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.standby.StandbyException;
import com.kingdee.eas.hr.standby.StandbyTypeFactory;
import com.kingdee.eas.hr.standby.StandbyTypeInfo;
import com.kingdee.eas.hr.standby.client.AbstractStandbyTypeEditUI;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class StandbyTypeEditUI
extends AbstractStandbyTypeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(StandbyTypeEditUI.class);

    protected IObjectValue createNewData() {
        StandbyTypeInfo newType = new StandbyTypeInfo();
        newType.setParent((StandbyTypeInfo)this.getUIContext().get("ParentNode"));
        newType.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        newType.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        return newType;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initWorkButton();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return StandbyTypeFactory.getRemoteInstance();
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("simpleName"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("parent"));
        return sic;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setVisible(false);
        this.actionSave.setEnabled(false);
        this.btnCancelCancel.setVisible(false);
        this.actionCancelCancel.setEnabled(false);
        this.btnCopy.setVisible(false);
        this.actionCopy.setEnabled(false);
        this.actionCopy.setVisible(false);
        this.btnPrint.setVisible(false);
        this.actionPrint.setEnabled(false);
        this.btnPrintPreview.setVisible(false);
        this.actionPrintPreview.setEnabled(false);
        this.txtNumber.setMaxLength(80);
        this.txtName.setMaxLength(80);
        this.txtSimpleName.setMaxLength(80);
        this.txtDescription.setMaxLength(200);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.editData.getNumber())) {
            this.txtNumber.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NUMBER_CAN_NOT_BLANK);
        }
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            this.txtName.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NAME_CAN_NOT_BLANK);
        }
        if (this.editData.getNumber().length() >= 80) {
            this.txtNumber.requestFocusInWindow();
            throw new StandbyException(StandbyException.NO_TOOLONG);
        }
        super.verifyInput(e);
    }

    public void storeFields() {
        super.storeFields();
        if (this.editData.getNumber() != null) {
            this.editData.setNumber(this.editData.getNumber().trim());
        }
        if (this.editData.getName() != null) {
            this.editData.setName(this.editData.getName().trim());
        }
    }
}

