/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.client.chart;

import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.client.GetDataDialog;
import com.kingdee.eas.base.core.client.GetDataTaskAdapter;
import com.kingdee.eas.basedata.org.client.chart.HistoryNode;
import com.kingdee.eas.basedata.org.client.chart.OrgChartInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.eas.hr.base.BaseInnerFacadeFactory;
import com.kingdee.eas.hr.base.IBaseInnerFacade;
import com.kingdee.eas.hr.base.OutputExcelUtil;
import com.kingdee.eas.hr.base.util.HRFileUtil;
import com.kingdee.eas.hr.org.JobException;
import com.kingdee.eas.hr.org.client.OrgCharSetingUI;
import com.kingdee.eas.hr.standby.client.chart.DrawStandbyPersonPanel;
import com.kingdee.eas.hr.standby.client.chart.OrgUnit;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import javax.swing.Icon;
import javax.swing.border.EtchedBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;

public class DrawStandbyPerson
extends KDPanel {
    private KDPanel bar = new KDPanel();
    public KDWorkButton preButton = new KDWorkButton();
    public KDWorkButton nextButton = new KDWorkButton();
    private KDWorkButton btnPicture = new KDWorkButton();
    private KDCheckBox cboPShow = null;
    private KDComboBox cboLevel = new KDComboBox();
    private KDWorkButton btnDisplayModel = new KDWorkButton();
    private DrawStandbyPersonPanel standbyPersonPanel = new DrawStandbyPersonPanel(this);
    private KDScrollPane scrollPane = null;
    private FontMetrics fontM = null;
    private float maxy = 0.0f;
    private float maxx = 0.0f;
    static final float FixHeight = 20.0f;
    private float FixWidth = 20.0f;
    private float temp = 0.0f;
    protected HistoryNode historyNode = null;
    public boolean horizontal = true;
    private int interval = 0;
    protected Timer timer = new Timer();
    private DefaultMutableTreeNode rootNode = null;
    private DefaultMutableTreeNode lastNode = null;
    public int baseLevel = 0;
    boolean displayPerson = false;
    private HashMap perMap = null;
    private HashMap adminMap = null;
    private static String oldSessionId = null;
    public int chartType = 0;
    public boolean isPenetrable = true;
    private boolean loadFinish = false;
    public int chooseLevel = 0;
    private boolean firstLoad = true;
    private Icon hIcon = EASResource.getIcon((String)"imgTbtn_collect");
    private Icon vIcon = EASResource.getIcon((String)"imgTbtn_collect1");
    private String H_STR = EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.H_STR");
    private String V_STR = EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.V_STR");
    private String strResource = "com.kingdee.eas.hr.base.HRBasedataResource.";

    public DrawStandbyPerson(int width, int height, DefaultMutableTreeNode rootNode, int type, boolean isPenetrable) throws Exception {
        this.initOrgUnitPanel(width, height, rootNode, type, isPenetrable, 0, true, false);
    }

    public DrawStandbyPerson(int width, int height, DefaultMutableTreeNode rootNode, int type, boolean isPenetrable, int level, boolean horizontal, boolean displayPerson) throws Exception {
        this.initOrgUnitPanel(width, height, rootNode, type, isPenetrable, level, horizontal, displayPerson);
    }

    public DrawStandbyPerson(int width, int height, DefaultMutableTreeNode rootNode, int type, boolean isPenetrable, int level, boolean horizontal, boolean displayPerson, boolean includeSealup) throws Exception {
        this.initOrgUnitPanel(width, height, rootNode, type, isPenetrable, level, horizontal, displayPerson);
    }

    private void initOrgUnitPanel(int width, int height, DefaultMutableTreeNode rootNode, int type, boolean isPenetrable, int level, boolean horizontal, boolean displayPerson) throws Exception {
        if (rootNode == null) {
            return;
        }
        if (oldSessionId != null && !SysContext.getSysContext().getSessionID().equals(oldSessionId)) {
            this.perMap = null;
            this.adminMap = null;
        }
        oldSessionId = SysContext.getSysContext().getSessionID();
        if (!isPenetrable) {
            this.preButton.setVisible(false);
            this.nextButton.setVisible(false);
        }
        this.chooseLevel = level;
        this.horizontal = !horizontal;
        this.displayPerson = displayPerson;
        this.setPersonVisible(displayPerson);
        this.chartType = type;
        this.isPenetrable = isPenetrable;
        this.rootNode = rootNode;
        this.setBorder(new EtchedBorder(0));
        this.drawOrg();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                try {
                    DrawStandbyPerson.this.changeSize();
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
    }

    public void setRepaintData(int level, boolean horizontal, boolean displayPerson) throws Exception {
        this.chooseLevel = level;
        this.horizontal = horizontal;
        this.displayPerson = displayPerson;
        this.setPersonVisible(displayPerson);
    }

    public void setRepaintData(int level, boolean horizontal, boolean displayPerson, boolean includeSealup) throws Exception {
        this.chooseLevel = level;
        this.horizontal = !horizontal;
        this.displayPerson = displayPerson;
        this.cboPShow.setSelected(displayPerson);
        this.setPersonVisible(displayPerson);
    }

    public void clearCacheData() throws Exception {
        this.perMap = null;
        this.adminMap = null;
        this.cboPShow.setSelected(false);
        this.setPersonVisible(false);
    }

    public void setRootNode(DefaultMutableTreeNode rootNode) throws Exception {
        this.rootNode = rootNode;
        this.init();
        this.standbyPersonPanel.clearSelectNode();
        this.preButton.setEnabled(false);
        this.nextButton.setEnabled(false);
    }

    private void getPositionAndPersonData() throws Exception {
        this.perMap = new HashMap();
        this.adminMap = new HashMap();
        IBaseInnerFacade iBaseInner = BaseInnerFacadeFactory.getRemoteInstance();
        ArrayList list = iBaseInner.getStandbyChartData(false);
        if (null == list || list.size() != 2) {
            return;
        }
        IRowSet rows = (IRowSet)list.get(1);
        List empList = null;
        while (rows.next()) {
            if (rows.getString("EMPLOYEE.ID") == null) continue;
            PersonInfo empInfo = new PersonInfo();
            empInfo.setId(BOSUuid.read((String)rows.getString("employee.id")));
            empInfo.setName(rows.getString("employee.name"));
            String adminId = null;
            adminId = rows.getString("toUnit.id") != null ? rows.getString("toUnit.id") : rows.getString("toPositionUnit.id");
            empList = this.perMap.containsKey(adminId) ? (List)this.perMap.get(adminId) : new ArrayList();
            if (!empList.contains(empInfo)) {
                empList.add(empInfo);
            }
            this.perMap.put(adminId, empList);
        }
    }

    private void setPersonVisible(boolean vis) throws Exception {
        this.displayPerson = vis;
        if (this.horizontal) {
            this.btnDisplayModel.setIcon(this.vIcon);
            this.btnDisplayModel.setToolTipText(this.V_STR);
        } else {
            this.btnDisplayModel.setIcon(this.hIcon);
            this.btnDisplayModel.setToolTipText(this.H_STR);
        }
        this.FixWidth = vis ? 100.0f : 20.0f;
        if (vis && (this.adminMap == null || this.adminMap.size() == 0)) {
            GetDataDialog dlg = null;
            Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
            dlg = ownerWindow instanceof Frame ? new GetDataDialog((Frame)ownerWindow) : (ownerWindow instanceof Dialog ? new GetDataDialog((Dialog)ownerWindow) : new GetDataDialog((Frame)null));
            dlg.setGetDataTask(new GetDataTaskAdapter(){

                public Object exec() throws Exception {
                    DrawStandbyPerson.this.getPositionAndPersonData();
                    return null;
                }
            });
            dlg.show();
        }
        this.startDraw();
    }

    private void changeSize() throws Exception {
        this.startDraw();
    }

    private void drawOrg() throws Exception {
        this.setLayout(new BorderLayout());
        this.bar.setLayout((LayoutManager)new FlowLayout(2));
        this.bar.setPreferredSize(new Dimension(0, 30));
        this.preButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                try {
                    DrawStandbyPerson.this.preClick();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                try {
                    DrawStandbyPerson.this.nextClick();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
        this.preButton.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.nextButton.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.preButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.nextButton.setToolTipText(EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.ORG_CHART_GO"));
        this.preButton.setToolTipText(EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.ORG_CHART_BACK"));
        this.cboPShow = new KDCheckBox(EASResource.getString((String)(this.strResource + "SHOW_STANDBY_COUNT")));
        this.cboPShow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                try {
                    if (DrawStandbyPerson.this.cboPShow.isSelected()) {
                        DrawStandbyPerson.this.setPersonVisible(true);
                    } else {
                        DrawStandbyPerson.this.setPersonVisible(false);
                    }
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
        this.cboPShow.setSelected(this.displayPerson);
        this.addSetingButton(this.bar);
        this.addDisplayModeButton(this.bar);
        if (this.chartType == 0) {
            this.addOrgLevelSelButton(this.bar);
            this.bar.add((Component)this.cboPShow);
        }
        this.addSaveToJPGButton(this.bar);
        this.bar.add((Component)this.preButton);
        this.bar.add((Component)this.nextButton);
        this.add((Component)this.bar, "North");
        this.standbyPersonPanel = new DrawStandbyPersonPanel(this);
        this.scrollPane = new KDScrollPane((Component)((Object)this.standbyPersonPanel));
        this.add((Component)this.scrollPane, "Center");
        this.init();
    }

    private void addDisplayModeButton(KDPanel bar) throws Exception {
        if (this.horizontal) {
            this.btnDisplayModel.setIcon(this.vIcon);
            this.btnDisplayModel.setToolTipText(this.V_STR);
        } else {
            this.btnDisplayModel.setIcon(this.hIcon);
            this.btnDisplayModel.setToolTipText(this.H_STR);
        }
        this.btnDisplayModel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                try {
                    boolean bl = DrawStandbyPerson.this.horizontal = !DrawStandbyPerson.this.horizontal;
                    if (DrawStandbyPerson.this.horizontal) {
                        DrawStandbyPerson.this.btnDisplayModel.setIcon(DrawStandbyPerson.this.vIcon);
                        DrawStandbyPerson.this.btnDisplayModel.setToolTipText(DrawStandbyPerson.this.V_STR);
                    } else {
                        DrawStandbyPerson.this.btnDisplayModel.setIcon(DrawStandbyPerson.this.hIcon);
                        DrawStandbyPerson.this.btnDisplayModel.setToolTipText(DrawStandbyPerson.this.H_STR);
                    }
                    DrawStandbyPerson.this.startDraw();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
        bar.add((Component)this.btnDisplayModel);
    }

    private void addSetingButton(KDPanel bar) throws Exception {
        KDWorkButton btnSetting = new KDWorkButton(EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.SET_CHART_COLOR"));
        btnSetting.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                try {
                    DrawStandbyPerson.this.showOrgCharSettingUI();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
        bar.add((Component)btnSetting);
    }

    private void showOrgCharSettingUI() throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this.getParent().getParent());
        uiContext.put((Object)"ID", (Object)this.getCurOrgChartInfo());
        IUIFactory uiFactory = null;
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow curDialog = uiFactory.create(OrgCharSetingUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        curDialog.show();
        this.setCurOrgChartInfo(((OrgCharSetingUI)curDialog.getUIObject()).info);
    }

    private OrgChartInfo getCurOrgChartInfo() {
        OrgChartInfo info = new OrgChartInfo();
        info.currOrgRectColor = this.standbyPersonPanel.currOrgRectColor;
        info.currRectLineColor = this.standbyPersonPanel.currRectLineColor;
        info.lineColor = this.standbyPersonPanel.lineColor;
        info.orgRectColor = this.standbyPersonPanel.orgRectColor;
        info.otherRectColor = this.standbyPersonPanel.otherRectColor;
        info.rectLineColor = this.standbyPersonPanel.rectLineColor;
        info.selOrgRectColor = this.standbyPersonPanel.selOrgRectColor;
        info.selOtherRectColor = this.standbyPersonPanel.selOtherRectColor;
        info.selRectLineColor = this.standbyPersonPanel.selRectLineColor;
        info.selSeparateLineColor = this.standbyPersonPanel.selSeparateLineColor;
        info.separateLineColor = this.standbyPersonPanel.separateLineColor;
        info.textColor = this.standbyPersonPanel.textColor;
        info.currOtherRectColor = this.standbyPersonPanel.currOtherRectColor;
        info.currSeparateLineColor = this.standbyPersonPanel.currSeparateLineColor;
        info.bgColor = this.standbyPersonPanel.bgColor;
        return info;
    }

    private void setCurOrgChartInfo(OrgChartInfo info) {
        this.standbyPersonPanel.currOrgRectColor = info.currOrgRectColor;
        this.standbyPersonPanel.currRectLineColor = info.currRectLineColor;
        this.standbyPersonPanel.lineColor = info.lineColor;
        this.standbyPersonPanel.orgRectColor = info.orgRectColor;
        this.standbyPersonPanel.otherRectColor = info.otherRectColor;
        this.standbyPersonPanel.rectLineColor = info.rectLineColor;
        this.standbyPersonPanel.selOrgRectColor = info.selOrgRectColor;
        this.standbyPersonPanel.selOtherRectColor = info.selOtherRectColor;
        this.standbyPersonPanel.selRectLineColor = info.selRectLineColor;
        this.standbyPersonPanel.selSeparateLineColor = info.selSeparateLineColor;
        this.standbyPersonPanel.separateLineColor = info.separateLineColor;
        this.standbyPersonPanel.textColor = info.textColor;
        this.standbyPersonPanel.currOtherRectColor = info.currOtherRectColor;
        this.standbyPersonPanel.currSeparateLineColor = info.currSeparateLineColor;
        this.standbyPersonPanel.bgColor = info.bgColor;
        this.standbyPersonPanel.repaint();
    }

    private void addOrgLevelSelButton(KDPanel bar) throws Exception {
        KDLabel labLevel = new KDLabel(EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.CHART_DISPLAY_ORG"));
        this.cboLevel.setPreferredSize(new Dimension(40, 15));
        this.cboLevel.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && DrawStandbyPerson.this.loadFinish) {
                    DrawStandbyPerson.this.chooseLevel = (Integer)DrawStandbyPerson.this.cboLevel.getSelectedItem();
                    try {
                        DrawStandbyPerson.this.startDraw();
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            }
        });
        if (this.chooseLevel >= this.cboLevel.getItemCount()) {
            this.cboLevel.setSelectedIndex(this.cboLevel.getItemCount() - 1);
        } else {
            this.cboLevel.setSelectedIndex(this.chooseLevel - 1);
        }
        KDLabel labLevel2 = new KDLabel(EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.CHART_DISPLAY_LEVEL"));
        bar.add((Component)labLevel);
        bar.add((Component)this.cboLevel);
        bar.add((Component)labLevel2);
    }

    private void addSaveToJPGButton(KDPanel bar) throws Exception {
        this.btnPicture.setIcon(EASResource.getIcon((String)"imgTbtn_showpicture"));
        this.btnPicture.setToolTipText(EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.CHART_SAVE_TO_JPG"));
        this.btnPicture.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                try {
                    DrawStandbyPerson.this.saveToJPG();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
        bar.add((Component)this.btnPicture);
    }

    private void saveToJPG() throws Exception {
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = OutputExcelUtil.getExtension((File)f);
                if (extension != null) {
                    return extension.equalsIgnoreCase("jpg") || extension.equalsIgnoreCase("jpeg");
                }
                return false;
            }

            public String getDescription() {
                return "JPEG ( *.jpg;*.jpeg )";
            }
        });
        int result = fileChooser.showSaveDialog((Component)((Object)this));
        if (result != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        if (null != file.getParentFile() && !file.getParentFile().isDirectory()) {
            throw new BaseException(BaseException.OUTPUT_FILE_ERROR);
        }
        if (!file.getAbsolutePath().endsWith(".jpg") && !file.getAbsolutePath().endsWith(".jpeg")) {
            file = new File(file.getAbsolutePath() + ".jpg");
        }
        if (file.exists()) {
            if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.FILE_IS_EXIST")) != 0) {
                return;
            }
        } else {
            try {
                HRFileUtil.validateFile((File)file);
            }
            catch (IOException e) {
                throw new JobException(JobException.FILE_NAME_ERROR);
            }
        }
        try {
            int w = this.standbyPersonPanel.getWidth();
            int h = this.standbyPersonPanel.getHeight();
            BufferedImage image = (BufferedImage)this.standbyPersonPanel.createImage(w, h);
            Graphics2D g2 = image.createGraphics();
            this.standbyPersonPanel.print(g2);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)bos);
            JPEGEncodeParam jep = encoder.getDefaultJPEGEncodeParam(image);
            jep.setQuality(1.0f, false);
            encoder.setJPEGEncodeParam(jep);
            encoder.encode(image);
            bos.close();
        }
        catch (Throwable e) {
            throw new BaseException(BaseException.SAVE_TO_PIC_ERROR);
        }
    }

    private void init() throws Exception {
        this.historyNode = new HistoryNode();
        this.historyNode.previous = null;
        this.historyNode.next = null;
        this.historyNode.value = ((OrgUnit)this.rootNode.getUserObject()).ID;
        this.historyNode.curNode = this.rootNode;
        this.startDraw();
        this.firstLoad = false;
    }

    private void preClick() throws Exception {
        if (this.standbyPersonPanel.selOrgUnit != null) {
            this.standbyPersonPanel.selOrgUnit.isSelected = false;
        }
        HistoryNode hisNode = this.historyNode;
        this.historyNode = hisNode.previous;
        this.historyNode.next = hisNode;
        this.standbyPersonPanel.clearSelectNode();
        this.startDraw();
        if (this.historyNode.previous == null) {
            this.preButton.setEnabled(false);
        }
        this.nextButton.setEnabled(true);
    }

    private void nextClick() throws Exception {
        if (this.standbyPersonPanel.selOrgUnit != null) {
            this.standbyPersonPanel.selOrgUnit.isSelected = false;
        }
        HistoryNode hisNode = this.historyNode;
        this.historyNode = hisNode.next;
        this.historyNode.previous = hisNode;
        this.standbyPersonPanel.clearSelectNode();
        this.startDraw();
        if (this.historyNode.next == null) {
            this.nextButton.setEnabled(false);
        }
        this.preButton.setEnabled(true);
    }

    private void setLevelData() {
        this.loadFinish = false;
        this.cboLevel.removeAllItems();
        int depth = this.historyNode.curNode.getDepth() + 1;
        for (int i = 1; i <= depth; ++i) {
            this.cboLevel.addItem((Object)i);
        }
        if (this.chooseLevel != 0 && this.chooseLevel < depth + 1) {
            this.cboLevel.setSelectedIndex(this.chooseLevel - 1);
        } else {
            this.cboLevel.setSelectedIndex(depth - 1);
        }
        this.loadFinish = true;
        if (this.firstLoad) {
            this.chooseLevel = depth;
        }
    }

    public void startDraw() throws Exception {
        this.maxx = 0.0f;
        this.maxy = 0.0f;
        if (this.historyNode == null) {
            return;
        }
        if (this.chartType == 0) {
            this.setLevelData();
        } else {
            this.FixWidth = 80.0f;
        }
        this.baseLevel = this.historyNode.curNode.getLevel();
        this.buildFromTreeNode(this.historyNode.curNode);
        this.moveCoordinate(this.historyNode.curNode);
        if (this.horizontal) {
            this.rollCoordinate(this.historyNode.curNode);
            this.standbyPersonPanel.setRoot(this.historyNode.curNode);
            this.standbyPersonPanel.setDrawingPaneSize((int)this.maxy, (int)this.maxx);
            OrgUnit orgUnit = (OrgUnit)this.historyNode.curNode.getUserObject();
            Rectangle rect = new Rectangle((int)orgUnit.X - this.getWidth() / 2 + (int)orgUnit.width / 2, 0, this.getWidth(), this.getHeight());
            if (this.scrollPane.getParent() != null) {
                this.scrollPane.getParent().validate();
            }
            this.scrollPane.getViewport().setViewSize(new Dimension((int)this.maxy, (int)this.maxx));
            if (this.maxy > (float)this.getWidth()) {
                this.scrollPane.getViewport().setViewPosition(new Point(rect.x, rect.y));
            }
        } else {
            this.standbyPersonPanel.setRoot(this.historyNode.curNode);
            this.standbyPersonPanel.setDrawingPaneSize((int)this.maxx, (int)this.maxy);
            OrgUnit orgUnit = (OrgUnit)this.historyNode.curNode.getUserObject();
            Rectangle rect = new Rectangle(0, (int)orgUnit.Y - this.getWidth() / 2 + (int)orgUnit.width / 2, this.getWidth(), this.getHeight());
            if (this.scrollPane.getParent() != null) {
                this.scrollPane.getParent().validate();
            }
            this.scrollPane.getViewport().setViewSize(new Dimension((int)this.maxx, (int)this.maxy));
            if (this.maxy > (float)this.getHeight()) {
                this.scrollPane.getViewport().setViewPosition(new Point(rect.x, rect.y));
            }
        }
    }

    private void buildFromTreeNode(DefaultMutableTreeNode root) {
        int i;
        OrgUnit orgUnit = (OrgUnit)root.getUserObject();
        OrgUnit lastOrgUnit = null;
        if (this.lastNode != null) {
            lastOrgUnit = (OrgUnit)this.lastNode.getUserObject();
        }
        if (this.fontM == null) {
            this.fontM = this.standbyPersonPanel.getFontMetrics(this.standbyPersonPanel.getFont());
        }
        if (root.getLevel() - this.baseLevel + 1 > this.chooseLevel && this.chartType == 0) {
            return;
        }
        if (root.getLevel() == this.baseLevel) {
            orgUnit.X = 20.0f;
            orgUnit.Y = 20.0f;
        } else if (root.getLevel() == this.lastNode.getLevel() + 1) {
            orgUnit.Y = lastOrgUnit.Y;
            orgUnit.X = this.horizontal ? lastOrgUnit.X + this.FixWidth + 40.0f : lastOrgUnit.X + lastOrgUnit.width + 40.0f;
        } else if (root.getLevel() == this.lastNode.getLevel()) {
            orgUnit.X = lastOrgUnit.X;
            orgUnit.Y = this.horizontal ? lastOrgUnit.Y + lastOrgUnit.height + 20.0f : lastOrgUnit.Y + this.FixWidth + 20.0f;
        } else {
            this.interval = this.lastNode.getLevel() - root.getLevel();
            for (i = 0; i < this.interval; ++i) {
                this.lastNode = (DefaultMutableTreeNode)this.lastNode.getParent();
            }
            lastOrgUnit = (OrgUnit)this.lastNode.getUserObject();
            orgUnit.Y = this.maxy + 20.0f;
            orgUnit.X = lastOrgUnit.X;
        }
        if (this.displayPerson && orgUnit.ID != null) {
            orgUnit.empInfo = this.getPersonByAdmin(orgUnit.ID);
        }
        if (this.horizontal) {
            orgUnit.width = this.FixWidth;
            orgUnit.height = (float)this.getNameMaxLength(orgUnit) + 20.0f;
        } else {
            orgUnit.width = (float)this.getNameMaxLength(orgUnit) + 20.0f;
            orgUnit.height = this.FixWidth;
        }
        this.lastNode = root;
        lastOrgUnit = (OrgUnit)this.lastNode.getUserObject();
        if (this.maxy < lastOrgUnit.height + lastOrgUnit.Y) {
            this.maxy = lastOrgUnit.height + lastOrgUnit.Y;
        }
        if (this.maxx < lastOrgUnit.width + lastOrgUnit.X) {
            this.maxx = lastOrgUnit.width + lastOrgUnit.X;
        }
        if (this.horizontal) {
            for (i = 0; i < root.getChildCount(); ++i) {
                this.buildFromTreeNode((DefaultMutableTreeNode)root.getChildAt(i));
            }
        } else {
            for (i = root.getChildCount() - 1; i >= 0; --i) {
                this.buildFromTreeNode((DefaultMutableTreeNode)root.getChildAt(i));
            }
        }
    }

    private int getNameMaxLength(OrgUnit orgUnit) {
        int length1 = 0;
        length1 = StringUtils.isEmpty((String)orgUnit.name) ? 0 : this.fontM.stringWidth(orgUnit.name);
        if (this.chartType == 1) {
            int length2 = this.fontM.stringWidth(EASResource.getString((String)"com.kingdee.eas.basedata.org.ORGAutoGenerateResource", (String)"0_DrawingPanel") + orgUnit.bzCount);
            int length3 = this.fontM.stringWidth(EASResource.getString((String)"com.kingdee.eas.basedata.org.ORGAutoGenerateResource", (String)"1_DrawingPanel") + orgUnit.factCount);
            int length4 = this.fontM.stringWidth(orgUnit.otherInfo);
            return StrictMath.max(length4, StrictMath.max(length1, StrictMath.max(length2, length3)));
        }
        if (this.displayPerson && orgUnit.ID != null) {
            int length2 = 0;
            if (!StringUtils.isEmpty((String)orgUnit.name)) {
                length2 = this.fontM.stringWidth(orgUnit.name);
            }
            int length3 = 0;
            int length4 = 0;
            int length5 = 0;
            if (orgUnit.empInfo != null) {
                int size = orgUnit.empInfo.size();
                if (size > 0 && !StringUtils.isEmpty((String)((PersonInfo)orgUnit.empInfo.get(0)).getName())) {
                    length3 = this.fontM.stringWidth(((PersonInfo)orgUnit.empInfo.get(0)).getName());
                }
                if (size > 1 && !StringUtils.isEmpty((String)((PersonInfo)orgUnit.empInfo.get(1)).getName())) {
                    length4 = this.fontM.stringWidth(((PersonInfo)orgUnit.empInfo.get(1)).getName());
                }
                if (size == 3 && !StringUtils.isEmpty((String)((PersonInfo)orgUnit.empInfo.get(2)).getName())) {
                    length5 = this.fontM.stringWidth(((PersonInfo)orgUnit.empInfo.get(2)).getName());
                }
            }
            return StrictMath.max(length1, StrictMath.max(length2, StrictMath.max(length3, StrictMath.max(length4, length5))));
        }
        return length1;
    }

    private List getPersonByAdmin(String adminId) {
        if (this.perMap != null) {
            return (List)this.perMap.get(adminId);
        }
        return null;
    }

    private void rollCoordinate(DefaultMutableTreeNode root) {
        if (root.getLevel() - this.baseLevel + 1 > this.chooseLevel && this.chartType == 0) {
            return;
        }
        OrgUnit orgUnit = (OrgUnit)root.getUserObject();
        this.temp = orgUnit.Y + orgUnit.height;
        orgUnit.Y = orgUnit.X;
        orgUnit.X = this.maxy + 1.0f - this.temp;
        this.temp = orgUnit.width;
        orgUnit.width = orgUnit.height;
        orgUnit.height = this.temp;
        orgUnit.rect = new Rectangle((int)orgUnit.X, (int)orgUnit.Y, (int)orgUnit.width, (int)orgUnit.height);
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.rollCoordinate((DefaultMutableTreeNode)root.getChildAt(i));
        }
    }

    private void moveCoordinate(DefaultMutableTreeNode root) {
        if (root.getLevel() - this.baseLevel + 1 > this.chooseLevel && this.chartType == 0) {
            return;
        }
        if (root.getLevel() - this.baseLevel + 1 < this.chooseLevel || this.chartType == 1) {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.moveCoordinate((DefaultMutableTreeNode)root.getChildAt(i));
            }
        }
        if ((root.getLevel() - this.baseLevel + 1 < this.chooseLevel || this.chartType == 1) && root.getChildCount() > 1) {
            DefaultMutableTreeNode lastChildNode = (DefaultMutableTreeNode)root.getLastChild();
            DefaultMutableTreeNode firstChildNode = (DefaultMutableTreeNode)root.getFirstChild();
            OrgUnit firstUnit = (OrgUnit)firstChildNode.getUserObject();
            OrgUnit endUnit = (OrgUnit)lastChildNode.getUserObject();
            OrgUnit rootUnit = (OrgUnit)root.getUserObject();
            rootUnit.Y = firstUnit.Y / 2.0f + firstUnit.height / 4.0f + endUnit.Y / 2.0f + endUnit.height / 4.0f - rootUnit.height / 2.0f;
        } else if ((root.getLevel() - this.baseLevel + 1 < this.chooseLevel || this.chartType == 1) && root.getChildCount() == 1) {
            OrgUnit orgUnit = (OrgUnit)((DefaultMutableTreeNode)root.getLastChild()).getUserObject();
            OrgUnit rootUnit = (OrgUnit)root.getUserObject();
            if (rootUnit.height < orgUnit.height) {
                rootUnit.Y = orgUnit.Y + (orgUnit.height - rootUnit.height) / 2.0f;
            } else if (rootUnit.height == orgUnit.height) {
                rootUnit.Y = orgUnit.Y;
            } else if (rootUnit.Y < orgUnit.Y) {
                rootUnit.Y = orgUnit.Y + (orgUnit.height - rootUnit.height) / 2.0f;
            } else {
                this.updateNodeY((DefaultMutableTreeNode)root.getLastChild(), (rootUnit.height - orgUnit.height) / 2.0f);
            }
        }
    }

    private void updateNodeY(DefaultMutableTreeNode child, float height) {
        OrgUnit childUnit = (OrgUnit)child.getUserObject();
        childUnit.Y += height;
        for (int i = 0; i < child.getChildCount(); ++i) {
            this.updateNodeY((DefaultMutableTreeNode)child.getChildAt(i), height);
        }
    }

    public void setUserComponents(Component[] comps) {
        if (comps != null) {
            for (int i = 0; i < comps.length; ++i) {
                this.bar.add(comps[i]);
            }
        }
    }

    public OrgUnit getSelectNode() {
        return this.standbyPersonPanel.selOrgUnit;
    }
}

