/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.client.chart;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.client.GetDataDialog;
import com.kingdee.eas.base.core.client.GetDataTaskAdapter;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.basedata.org.client.chart.HistoryNode;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.util.UIConfigUtility;
import com.kingdee.eas.hr.org.client.AdminOrgUnitEditUI;
import com.kingdee.eas.hr.standby.client.StandbyPersonAdminListUI;
import com.kingdee.eas.hr.standby.client.chart.DrawStandbyPerson;
import com.kingdee.eas.hr.standby.client.chart.OrgUnit;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

public class DrawStandbyPersonPanel
extends KDPanel
implements MouseListener,
MouseMotionListener {
    private DefaultMutableTreeNode root = null;
    private DrawStandbyPerson drawStandbyPerson = null;
    public OrgUnit selOrgUnit = null;
    private OrgUnit currOrgUnit = null;
    private int translateX = 0;
    private int translateY = 0;
    public Color rectLineColor = new Color(0x9E9E9E);
    public Color currRectLineColor = new Color(14581776);
    public Color selRectLineColor = new Color(14588434);
    public Color orgRectColor = new Color(13296622);
    public Color currOrgRectColor = new Color(16247737);
    public Color selOrgRectColor = new Color(15653292);
    public Color otherRectColor = new Color(0xFFFFFF);
    public Color selOtherRectColor = new Color(16314050);
    public Color textColor = Color.BLACK;
    public Color separateLineColor = new Color(0xE6E6E6);
    public Color selSeparateLineColor = new Color(15653292);
    public Color lineColor = new Color(4145719);
    public Color currOtherRectColor = new Color(0xFFFFFF);
    public Color currSeparateLineColor = new Color(0xE6E6E6);
    public Color noPPBackgroudColor = new Color(0xD9D9D0);
    public Color bgColor = new Color(0xD9D9D0);
    private Point startPoint = null;
    private Point endPoint = null;
    private boolean finded = false;

    public void setRoot(DefaultMutableTreeNode root) {
        this.root = root;
    }

    public void clearSelectNode() {
        this.selOrgUnit = null;
        this.currOrgUnit = null;
    }

    public void setDrawingPaneSize(int maxX, int maxY) {
        this.setPreferredSize(new Dimension(maxX + 30, maxY + 30));
        this.translateX = 0;
        this.translateY = 0;
        if (this.drawStandbyPerson.horizontal) {
            if (maxX < this.drawStandbyPerson.getWidth()) {
                this.translateX = (this.drawStandbyPerson.getWidth() - maxX) / 2;
            }
        } else if (maxY < this.drawStandbyPerson.getHeight()) {
            this.translateY = (this.drawStandbyPerson.getHeight() - maxY) / 2 - 30;
        }
    }

    public DrawStandbyPersonPanel(DrawStandbyPerson drawStandbyPerson) {
        this.drawStandbyPerson = drawStandbyPerson;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.setBackground(this.bgColor);
        g2.translate(this.translateX, this.translateY);
        if (this.root != null) {
            this.drawOrgNode(g2, this.root);
            g2.setColor(this.lineColor);
            if (this.drawStandbyPerson.horizontal) {
                this.drawOrgUnitLineH(g2, this.root);
            } else {
                this.drawOrgUnitLineV(g2, this.root);
            }
        }
    }

    private void drawOrgUnit(Graphics2D g2, OrgUnit orgUnit) {
        Color tempRectLineColor = null;
        Color tempOrgRectColor = null;
        Color tempTextColor = this.textColor;
        Color tempOtherRectColor = null;
        if (orgUnit.isMain || orgUnit.isCurrent) {
            tempRectLineColor = this.currRectLineColor;
            tempOrgRectColor = this.currOrgRectColor;
            tempOtherRectColor = this.currOtherRectColor;
        } else if (orgUnit.isSelected) {
            tempRectLineColor = this.selRectLineColor;
            tempOrgRectColor = this.selOrgRectColor;
            tempOtherRectColor = this.selOtherRectColor;
        } else {
            tempRectLineColor = this.rectLineColor;
            tempOrgRectColor = this.orgRectColor;
            tempOtherRectColor = orgUnit.canView ? this.otherRectColor : this.noPPBackgroudColor;
        }
        orgUnit.rect = new Rectangle((int)orgUnit.X, (int)orgUnit.Y, (int)orgUnit.width, (int)orgUnit.height);
        g2.setColor(tempOrgRectColor);
        g2.fillRoundRect((int)orgUnit.X, (int)orgUnit.Y, (int)orgUnit.width, (int)orgUnit.height, 10, 10);
        g2.setColor(tempTextColor);
        int length = 0;
        if (StringUtils.isEmpty((String)orgUnit.name)) {
            length = 0;
            g2.drawString("", (int)orgUnit.X + ((int)orgUnit.width - length) / 2, (int)orgUnit.Y + 15);
        } else {
            length = g2.getFontMetrics().stringWidth(orgUnit.name);
            g2.drawString(orgUnit.name, (int)orgUnit.X + ((int)orgUnit.width - length) / 2, (int)orgUnit.Y + 15);
        }
        if (this.drawStandbyPerson.displayPerson) {
            g2.setColor(tempOtherRectColor);
            g2.fillRoundRect((int)orgUnit.X, (int)orgUnit.Y + 20, (int)orgUnit.width, 80, 10, 10);
            g2.fillRect((int)orgUnit.X, (int)orgUnit.Y + 20, (int)orgUnit.width, 20);
            g2.setColor(tempTextColor);
            if (orgUnit.empInfo != null) {
                int size = orgUnit.empInfo.size();
                length = g2.getFontMetrics().stringWidth(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.STANDBYPERSONCOUNT") + "1");
                g2.drawString(EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource.STANDBYPERSONCOUNT") + size, (int)orgUnit.X + ((int)orgUnit.width - length) / 2, (int)orgUnit.Y + 57);
            }
        }
        g2.setColor(tempRectLineColor);
        g2.drawRoundRect((int)orgUnit.X, (int)orgUnit.Y, (int)orgUnit.width, (int)orgUnit.height, 10, 10);
    }

    private void drawOrgNode(Graphics2D g2, DefaultMutableTreeNode node) {
        if (node.getLevel() - this.drawStandbyPerson.baseLevel + 1 > this.drawStandbyPerson.chooseLevel && this.drawStandbyPerson.chartType == 0) {
            return;
        }
        OrgUnit orgUnit = (OrgUnit)node.getUserObject();
        this.drawOrgUnit(g2, orgUnit);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.drawOrgNode(g2, (DefaultMutableTreeNode)node.getChildAt(i));
        }
    }

    private void drawOrgUnitLineV(Graphics2D g, DefaultMutableTreeNode node) {
        if (node.getLevel() - this.drawStandbyPerson.baseLevel + 1 > this.drawStandbyPerson.chooseLevel && this.drawStandbyPerson.chartType == 0) {
            return;
        }
        if ((node.getLevel() - this.drawStandbyPerson.baseLevel + 1 < this.drawStandbyPerson.chooseLevel || this.drawStandbyPerson.chartType == 1) && node.getChildCount() == 1) {
            this.startPoint = this.getStartPointV(node);
            this.endPoint = new Point();
            this.endPoint.y = this.startPoint.y;
            this.endPoint.x = this.startPoint.x + 40;
            g.drawLine(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
            this.drawOrgUnitLineV(g, (DefaultMutableTreeNode)node.getLastChild());
        } else if ((node.getLevel() - this.drawStandbyPerson.baseLevel + 1 < this.drawStandbyPerson.chooseLevel || this.drawStandbyPerson.chartType == 1) && node.getChildCount() > 1) {
            this.startPoint = this.getStartPointV(node);
            this.endPoint = new Point();
            this.endPoint.y = this.startPoint.y;
            this.endPoint.x = this.startPoint.x + 20;
            g.drawLine(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
            DefaultMutableTreeNode lastChildNode = (DefaultMutableTreeNode)node.getLastChild();
            DefaultMutableTreeNode firstChildNode = (DefaultMutableTreeNode)node.getFirstChild();
            OrgUnit startOrg = (OrgUnit)firstChildNode.getUserObject();
            OrgUnit endOrg = (OrgUnit)lastChildNode.getUserObject();
            g.drawLine((int)(startOrg.X - 20.0f), (int)(startOrg.Y + startOrg.height / 2.0f), (int)(endOrg.X - 20.0f), (int)(endOrg.Y + endOrg.height / 2.0f));
            for (int i = 0; i < node.getChildCount(); ++i) {
                lastChildNode = (DefaultMutableTreeNode)node.getChildAt(i);
                this.endPoint = this.getEndPointV(lastChildNode);
                this.startPoint.y = this.endPoint.y;
                this.startPoint.x = this.endPoint.x - 20;
                g.drawLine(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
                this.drawOrgUnitLineV(g, lastChildNode);
            }
        }
    }

    private void drawOrgUnitLineH(Graphics2D g, DefaultMutableTreeNode node) {
        if (node.getLevel() - this.drawStandbyPerson.baseLevel + 1 > this.drawStandbyPerson.chooseLevel && this.drawStandbyPerson.chartType == 0) {
            return;
        }
        if ((node.getLevel() - this.drawStandbyPerson.baseLevel + 1 < this.drawStandbyPerson.chooseLevel || this.drawStandbyPerson.chartType == 1) && node.getChildCount() == 1) {
            this.startPoint = this.getStartPointH(node);
            this.endPoint = new Point();
            this.endPoint.x = this.startPoint.x;
            this.endPoint.y = this.startPoint.y + 40;
            g.drawLine(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
            this.drawOrgUnitLineH(g, (DefaultMutableTreeNode)node.getLastChild());
        } else if ((node.getLevel() - this.drawStandbyPerson.baseLevel + 1 < this.drawStandbyPerson.chooseLevel || this.drawStandbyPerson.chartType == 1) && node.getChildCount() > 1) {
            this.startPoint = this.getStartPointH(node);
            this.endPoint = new Point();
            this.endPoint.x = this.startPoint.x;
            this.endPoint.y = this.startPoint.y + 20;
            g.drawLine(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
            DefaultMutableTreeNode lastChildNode = (DefaultMutableTreeNode)node.getLastChild();
            DefaultMutableTreeNode firstChildNode = (DefaultMutableTreeNode)node.getFirstChild();
            OrgUnit startOrg = (OrgUnit)firstChildNode.getUserObject();
            OrgUnit endOrg = (OrgUnit)lastChildNode.getUserObject();
            g.drawLine((int)(startOrg.X + startOrg.width / 2.0f), (int)(startOrg.Y - 20.0f), (int)(endOrg.X + endOrg.width / 2.0f), (int)(endOrg.Y - 20.0f));
            for (int i = 0; i < node.getChildCount(); ++i) {
                lastChildNode = (DefaultMutableTreeNode)node.getChildAt(i);
                this.endPoint = this.getEndPointH(lastChildNode);
                this.startPoint.x = this.endPoint.x;
                this.startPoint.y = this.endPoint.y - 20;
                g.drawLine(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
                this.drawOrgUnitLineH(g, lastChildNode);
            }
        }
    }

    private Point getStartPointV(DefaultMutableTreeNode node) {
        Point point = new Point();
        OrgUnit orgUnit = (OrgUnit)node.getUserObject();
        point.x = (int)(orgUnit.X + orgUnit.width);
        point.y = (int)(orgUnit.Y + orgUnit.height / 2.0f);
        return point;
    }

    private Point getEndPointV(DefaultMutableTreeNode node) {
        Point point = new Point();
        OrgUnit orgUnit = (OrgUnit)node.getUserObject();
        point.x = (int)orgUnit.X;
        point.y = (int)(orgUnit.Y + orgUnit.height / 2.0f);
        return point;
    }

    private Point getStartPointH(DefaultMutableTreeNode node) {
        Point point = new Point();
        OrgUnit orgUnit = (OrgUnit)node.getUserObject();
        point.x = (int)(orgUnit.X + orgUnit.width / 2.0f);
        point.y = (int)(orgUnit.Y + orgUnit.height);
        return point;
    }

    private Point getEndPointH(DefaultMutableTreeNode node) {
        Point point = new Point();
        OrgUnit orgUnit = (OrgUnit)node.getUserObject();
        point.x = (int)(orgUnit.X + orgUnit.width / 2.0f);
        point.y = (int)orgUnit.Y;
        return point;
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        try {
            Point point = e.getPoint();
            point.x -= this.translateX;
            point.y -= this.translateY;
            if (SwingUtilities.isRightMouseButton(e)) {
                this.clickTreeNode(e, this.root, point, false);
            } else {
                this.clickTreeNode(e, this.root, point, true);
            }
            this.finded = false;
        }
        catch (Exception ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
    }

    private void clickTreeNode(MouseEvent e, DefaultMutableTreeNode node, Point point, boolean flag) throws Exception {
        if (node.getLevel() - this.drawStandbyPerson.baseLevel + 1 > this.drawStandbyPerson.chooseLevel && this.drawStandbyPerson.chartType == 0) {
            return;
        }
        OrgUnit orgUnit = (OrgUnit)node.getUserObject();
        Rectangle tempRect = new Rectangle(orgUnit.rect.x, orgUnit.rect.y, orgUnit.rect.width, orgUnit.rect.height);
        if (tempRect.contains(point)) {
            this.currOrgUnit = null;
            if (this.selOrgUnit != null) {
                this.selOrgUnit.isSelected = false;
            }
            if (e.getClickCount() == 1) {
                Graphics2D g2 = (Graphics2D)this.getGraphics();
                g2.translate(this.translateX, this.translateY);
                if (this.selOrgUnit != null) {
                    this.drawOrgUnit(g2, this.selOrgUnit);
                }
                orgUnit.isSelected = true;
                orgUnit.isCurrent = false;
                this.selOrgUnit = orgUnit;
                this.drawOrgUnit(g2, this.selOrgUnit);
                if (flag) {
                    return;
                }
            }
            if (e.getClickCount() == 2) {
                if (!flag || !this.drawStandbyPerson.isPenetrable) {
                    return;
                }
                if (this.drawStandbyPerson.historyNode != null && this.drawStandbyPerson.historyNode.value.equalsIgnoreCase(orgUnit.ID)) {
                    return;
                }
                orgUnit.isCurrent = false;
                orgUnit.isSelected = false;
                HistoryNode hisNode = new HistoryNode();
                hisNode.previous = this.drawStandbyPerson.historyNode;
                hisNode.next = null;
                hisNode.value = orgUnit.ID;
                hisNode.curNode = node;
                this.drawStandbyPerson.preButton.setEnabled(true);
                this.drawStandbyPerson.nextButton.setEnabled(false);
                this.drawStandbyPerson.historyNode = hisNode;
                this.drawStandbyPerson.startDraw();
            } else if (!flag) {
                tempRect = new Rectangle(orgUnit.rect.x, orgUnit.rect.y, orgUnit.rect.width, 20);
                if (tempRect.contains(point)) {
                    if (orgUnit.canView) {
                        this.showOrgViewUI(orgUnit);
                    } else {
                        PermItemInfo permItemInfo = PermItemFactory.getRemoteInstance().getPermItemInfoByNumber("HR_Org_View");
                        Object[] objs = new Object[]{orgUnit.name, permItemInfo.getAlias()};
                        throw new PermissionException(PermissionException.HAS_NOT_ORG_FUNCTION_PERMISSION, objs);
                    }
                }
                if ((tempRect = new Rectangle(orgUnit.rect.x, orgUnit.rect.y + 40, orgUnit.rect.width, 20)).contains(point) && orgUnit.canView) {
                    this.showEmpViewUI(orgUnit, 1);
                }
            }
            this.finded = true;
            return;
        }
        for (int i = 0; i < node.getChildCount() && !this.finded; ++i) {
            this.clickTreeNode(e, (DefaultMutableTreeNode)node.getChildAt(i), point, flag);
        }
    }

    private void showEmpViewUI(OrgUnit orgUnit, int index) throws Exception {
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"adminId", (Object)orgUnit.ID);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(StandbyPersonAdminListUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
        uiWindow.show();
    }

    private void showOrgViewUI(final OrgUnit orgUnit) throws Exception {
        GetDataDialog dlg = new GetDataDialog((Frame)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"Owner", (Object)this);
                uiContext.put((Object)"ID", (Object)orgUnit.ID);
                uiContext.put((Object)"FromChart", (Object)"YES");
                IUIFactory uiFactory = null;
                uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                IUIWindow curDialog = uiFactory.create(AdminOrgUnitEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
                return curDialog;
            }

            public void finish(Object obj) throws Exception {
                ((IUIWindow)obj).show();
            }
        });
        dlg.show();
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        this.setCursor(Cursor.getDefaultCursor());
        Rectangle tempRect = null;
        if (this.currOrgUnit != null && (tempRect = new Rectangle(this.currOrgUnit.rect.x + this.translateX, this.currOrgUnit.rect.y + this.translateY, this.currOrgUnit.rect.width, this.currOrgUnit.rect.height)).contains(e.getPoint())) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        if (this.currOrgUnit != null && this.currOrgUnit.isCurrent && !tempRect.contains(e.getPoint()) && !this.currOrgUnit.isMain) {
            this.currOrgUnit.isCurrent = false;
            Graphics2D g2 = (Graphics2D)this.getGraphics();
            g2.translate(this.translateX, this.translateY);
            this.drawOrgUnit(g2, this.currOrgUnit);
            this.currOrgUnit = null;
        }
        if (this.root != null) {
            this.setCurrentNode(this.root, e.getPoint());
        }
    }

    private void setCurrentNode(DefaultMutableTreeNode node, Point point) {
        if (node.getLevel() - this.drawStandbyPerson.baseLevel + 1 > this.drawStandbyPerson.chooseLevel && this.drawStandbyPerson.chartType == 0) {
            return;
        }
        OrgUnit orgUnit = (OrgUnit)node.getUserObject();
        if (orgUnit.rect == null) {
            return;
        }
        Rectangle tempRect = new Rectangle(orgUnit.rect.x + this.translateX, orgUnit.rect.y + this.translateY, orgUnit.rect.width, orgUnit.rect.height);
        if (tempRect.contains(point) && !orgUnit.isCurrent) {
            if (orgUnit.isSelected) {
                return;
            }
            this.currOrgUnit = orgUnit;
            this.currOrgUnit.isCurrent = true;
            Graphics2D g2 = (Graphics2D)this.getGraphics();
            g2.translate(this.translateX, this.translateY);
            this.drawOrgUnit(g2, this.currOrgUnit);
            return;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.setCurrentNode((DefaultMutableTreeNode)node.getChildAt(i), point);
        }
    }

    private String getEditUIModal() {
        String openModel = UIConfigUtility.getOpenModel();
        if (openModel != null) {
            return openModel;
        }
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }
}

