/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class StateTrainCommonUtils {
    private static Logger logger = Logger.getLogger(StateTrainCommonUtils.class);

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isEmpty(CoreBaseInfo info) {
        return info == null || info.getId() == null;
    }

    public static boolean greaterThan(Date dt1, Date dt2) {
        return dt1.after(dt2) || dt1.equals(dt2);
    }

    public static boolean lessThan(Date dt1, Date dt2) {
        return dt1.before(dt2) || dt1.equals(dt2);
    }

    public static String collectionToStrings(Collection collection) {
        StringBuffer sb = new StringBuffer();
        if (collection != null && collection.size() > 0) {
            Iterator it = collection.iterator();
            int index = 0;
            while (it.hasNext()) {
                if (index++ != 0) {
                    sb.append(",");
                }
                sb.append("'");
                sb.append(it.next());
                sb.append("'");
            }
        }
        return sb.toString();
    }

    public static String collectionToStrings(Collection collection, String split) {
        StringBuffer sb = new StringBuffer();
        if (collection != null && collection.size() > 0) {
            if (StateTrainCommonUtils.isEmpty(split)) {
                split = ",";
            }
            Iterator it = collection.iterator();
            int index = 0;
            while (it.hasNext()) {
                if (index++ != 0) {
                    sb.append(split);
                }
                sb.append(it.next());
            }
        }
        return sb.toString();
    }

    public static String[] parseString(String str, String split) {
        String[] result = null;
        if (!StateTrainCommonUtils.isEmpty(str)) {
            if (!StateTrainCommonUtils.isEmpty(split)) {
                StringTokenizer tokenizer = new StringTokenizer(str, split);
                result = new String[tokenizer.countTokens()];
                int index = 0;
                while (tokenizer.hasMoreTokens()) {
                    result[index++] = tokenizer.nextToken();
                }
            } else {
                result = new String[]{str};
            }
        }
        return result;
    }

    public static Set assembleSetByArray(Object[] coreBaseInfos) {
        HashSet<String> result = null;
        if (coreBaseInfos != null && coreBaseInfos.length > 0) {
            result = new HashSet<String>();
            for (int i = 0; i < coreBaseInfos.length; ++i) {
                CoreBaseInfo info;
                if (!(coreBaseInfos[i] instanceof CoreBaseInfo) || (info = (CoreBaseInfo)coreBaseInfos[i]).getId() == null) continue;
                result.add(info.getId().toString());
            }
        }
        return result;
    }

    public static Set collectionToKeySet(IObjectCollection collection) {
        HashSet<String> result = null;
        if (collection != null && collection.size() > 0) {
            result = new HashSet<String>();
            CoreBaseInfo info = null;
            for (int i = 0; i < collection.size(); ++i) {
                if (!(collection.getObject(i) instanceof CoreBaseInfo) || (info = (CoreBaseInfo)collection.getObject(i)).getId() == null) continue;
                result.add(info.getId().toString());
            }
        }
        return result;
    }

    public static String getResource(String resource, String key, Object[] params, Locale locale) {
        String str = ResourceBase.getString((String)resource, (String)key, (Locale)locale);
        return MessageFormat.format(str, params);
    }

    public static String countTime(long start, long end) {
        String str = "cost time : " + new BigDecimal((end - start) / 1000L).setScale(2).toString() + " s";
        logger.info((Object)str);
        return str;
    }

    public static boolean compareObject(CoreBaseInfo one, CoreBaseInfo two) {
        if (one == null && two == null) {
            return true;
        }
        if (one != null && one.getId() != null && two != null && two.getId() != null) {
            return one.getId().equals((Object)two.getId());
        }
        return false;
    }

    public static String convertToHTML(String source) {
        if (StateTrainCommonUtils.isEmpty(source)) {
            return source;
        }
        String newLine = System.getProperty("line.separator");
        return source.replaceAll(newLine, "<br>").replaceAll(" ", "&nbsp;");
    }
}

