/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.base.client.FilterUIUtil;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.state.client.AbstractArchivesLoanBillFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ArchivesLoanBillFilterUI
extends AbstractArchivesLoanBillFilterUI {
    private static final String MESRES = "com.kingdee.eas.hr.state.MessageTWOResource";
    private static final String RES = "com.kingdee.eas.hr.state.ArchivesResource";
    private static final Logger logger = CoreUIObject.getLogger(ArchivesLoanBillFilterUI.class);
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.initAllEditor();
        this.pkEndDate.setValue(null);
        this.pkStartDate.setValue(null);
        this.chkIsIncludeOrg.setEnabled(false);
        this.chkIsSearch.setEnabled(true);
        this.prmtAdminOrg.setEnabled(false);
        this.prmtLoanPerson.setEnabled(true);
        this.prmtPosition.setEnabled(false);
        this.kDRadioLoanPerson.setSelected(true);
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        register.registerAdminByOrgRangePromptBox(this.prmtAdminOrg);
        register.registerPositionPromptBox2(this.prmtPosition);
        register.registerEmployeeMultiF7PromptBox(this.prmtLoanPerson, true);
    }

    private void initAllEditor() throws Exception {
        this.kdGroup.add((AbstractButton)this.kDRadioLoanPerson);
        this.kdGroup.add((AbstractButton)this.kDRadioAdminOrg);
        this.kdGroup.add((AbstractButton)this.kDRadioPosition);
        this.kDRadioLoanPerson.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                ArchivesLoanBillFilterUI.this.setSelect("loanPerson");
            }
        });
        this.kDRadioAdminOrg.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                ArchivesLoanBillFilterUI.this.setSelect("adminOrg");
            }
        });
        this.kDRadioPosition.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeevent) {
                ArchivesLoanBillFilterUI.this.setSelect("position");
            }
        });
        this.chkIsSearch.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeevent) {
                ArchivesLoanBillFilterUI.this.setSearchType();
            }
        });
    }

    private void setSelect(String selectType) {
        if ("loanPerson".equals(selectType) && this.kDRadioLoanPerson.isSelected()) {
            this.prmtLoanPerson.setEnabled(true);
            this.prmtLoanPerson.setVisible(true);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(true);
            this.prmtAdminOrg.setData(null);
            this.prmtAdminOrg.setEnabled(false);
            this.chkIsIncludeOrg.setSelected(false);
            this.chkIsIncludeOrg.setEnabled(false);
            this.prmtPosition.setData(null);
            this.prmtPosition.setEnabled(false);
            this.txtLoanPerson.setText(null);
            this.txtLoanPerson.setEnabled(false);
            this.txtLoanPerson.setVisible(false);
        }
        if ("adminOrg".equals(selectType) && this.kDRadioAdminOrg.isSelected()) {
            this.prmtAdminOrg.setEnabled(true);
            this.chkIsIncludeOrg.setEnabled(true);
            this.prmtLoanPerson.setData(null);
            this.prmtLoanPerson.setEnabled(false);
            this.prmtLoanPerson.setVisible(true);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(false);
            this.prmtPosition.setEnabled(false);
            this.prmtPosition.setData(null);
            this.txtLoanPerson.setText(null);
            this.txtLoanPerson.setEnabled(false);
            this.txtLoanPerson.setVisible(false);
        }
        if ("position".equals(selectType) && this.kDRadioPosition.isSelected()) {
            this.prmtPosition.setEnabled(true);
            this.prmtLoanPerson.setData(null);
            this.prmtLoanPerson.setEnabled(false);
            this.prmtLoanPerson.setVisible(true);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(false);
            this.prmtAdminOrg.setData(null);
            this.prmtAdminOrg.setEnabled(false);
            this.chkIsIncludeOrg.setSelected(false);
            this.chkIsIncludeOrg.setEnabled(false);
            this.txtLoanPerson.setText(null);
            this.txtLoanPerson.setEnabled(false);
            this.txtLoanPerson.setVisible(false);
        }
    }

    public void clear() {
        super.clear();
        this.pkEndDate.setValue(null);
        this.pkStartDate.setValue(null);
        this.chkIsIncludeOrg.setEnabled(false);
        this.chkIsSearch.setEnabled(true);
        this.prmtAdminOrg.setEnabled(false);
        this.prmtLoanPerson.setEnabled(true);
        this.prmtPosition.setEnabled(false);
        this.kDRadioLoanPerson.setSelected(true);
    }

    private void setSearchType() {
        if (this.kDRadioLoanPerson.isSelected()) {
            if (this.chkIsSearch.isSelected()) {
                this.prmtLoanPerson.setValue(null);
                this.prmtLoanPerson.setEnabled(false);
                this.prmtLoanPerson.setVisible(false);
                this.txtLoanPerson.setEnabled(true);
                this.txtLoanPerson.setEditable(true);
                this.txtLoanPerson.setVisible(true);
            } else {
                this.prmtLoanPerson.setEnabled(true);
                this.prmtLoanPerson.setVisible(true);
                this.txtLoanPerson.setEditable(false);
                this.txtLoanPerson.setText(null);
                this.txtLoanPerson.setEnabled(false);
                this.txtLoanPerson.setVisible(false);
            }
        }
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getMainOrg();
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.saveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.retriveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
    }

    public FilterInfo getFilterInfo() {
        PositionInfo positionInfo;
        AdminOrgUnitInfo orgUnit;
        FilterInfo orgFilter;
        FilterInfo filter = new FilterInfo();
        this.setDateFilter(filter);
        if (this.kDRadioLoanPerson.isSelected()) {
            if (this.chkIsSearch.isSelected()) {
                String personNumberOrName = this.txtLoanPerson.getText();
                if (personNumberOrName != null) {
                    if (filter.getFilterItems().size() > 0) {
                        orgFilter = new FilterInfo();
                        orgFilter.getFilterItems().add(new FilterItemInfo("entrys.loanPerson.number", (Object)("%" + personNumberOrName + "%"), CompareType.LIKE));
                        orgFilter.getFilterItems().add(new FilterItemInfo("entrys.loanPerson.name", (Object)("%" + personNumberOrName + "%"), CompareType.LIKE));
                        orgFilter.setMaskString("#0 or #1");
                        try {
                            filter.mergeFilter(orgFilter, "and");
                        }
                        catch (BOSException e) {
                            ExceptionHandler.handle((Throwable)e);
                        }
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("entrys.loanPerson.number", (Object)("%" + personNumberOrName + "%"), CompareType.LIKE));
                        filter.getFilterItems().add(new FilterItemInfo("entrys.loanPerson.name", (Object)("%" + personNumberOrName + "%"), CompareType.LIKE));
                        filter.setMaskString("#0 or #1");
                    }
                }
            } else {
                PersonInfo pInfo = (PersonInfo)this.prmtLoanPerson.getData();
                if (pInfo != null) {
                    filter.getFilterItems().add(new FilterItemInfo("entrys.loanPerson.id", (Object)pInfo.getId().toString(), CompareType.EQUALS));
                }
            }
        }
        if (this.kDRadioAdminOrg.isSelected() && (orgUnit = (AdminOrgUnitInfo)this.prmtAdminOrg.getData()) != null) {
            if (this.chkIsIncludeOrg.isSelected()) {
                if (filter.getFilterItems().size() > 0) {
                    orgFilter = new FilterInfo();
                    orgFilter.getFilterItems().add(new FilterItemInfo("adminOrg1.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
                    orgFilter.getFilterItems().add(new FilterItemInfo("adminOrg1.longNumber", (Object)(orgUnit.getLongNumber() + "!%"), CompareType.LIKE));
                    orgFilter.setMaskString("#0 or #1");
                    try {
                        filter.mergeFilter(orgFilter, "and");
                    }
                    catch (BOSException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("adminOrg1.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("adminOrg1.longNumber", (Object)(orgUnit.getLongNumber() + "!%"), CompareType.LIKE));
                    filter.setMaskString(" #0 or #1 ");
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("adminOrg1.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
            }
        }
        if (this.kDRadioPosition.isSelected() && (positionInfo = (PositionInfo)this.prmtPosition.getData()) != null) {
            filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)positionInfo.getId().toString(), CompareType.EQUALS));
        }
        return filter;
    }

    private void setDateFilter(FilterInfo filter) {
        if (filter == null) {
            return;
        }
        Date startDate = (Date)this.pkStartDate.getValue();
        Date endDate = (Date)this.pkEndDate.getValue();
        if (endDate != null) {
            endDate.setHours(23);
            endDate.setMinutes(59);
            endDate.setSeconds(59);
        }
        if (startDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("entrys.loanDate", (Object)this.simpleDateFormat.format(startDate), CompareType.GREATER_EQUALS));
        }
        if (endDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("entrys.loanDate", (Object)endDate, CompareType.LESS_EQUALS));
        }
    }

    public boolean verify() {
        if (this.prmtHROrg.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)MESRES, (String)"mustInputHr"));
            this.prmtHROrg.requestFocus();
            SysUtil.abort();
        }
        Date startDate = (Date)this.pkStartDate.getValue();
        Date endDate = (Date)this.pkEndDate.getValue();
        if (startDate != null && endDate != null && startDate.getTime() > endDate.getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"StartDate_EndDate_Error_Loan"));
            this.pkEndDate.requestFocus();
            SysUtil.abort();
        }
        return super.verify();
    }
}

