/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.client.EmployeeTreeEditUI;
import com.kingdee.eas.hr.state.BirthControlCollection;
import com.kingdee.eas.hr.state.BirthControlFactory;
import com.kingdee.eas.hr.state.BirthControlInfo;
import com.kingdee.eas.hr.state.client.AbstractBirthControlEditUI;
import com.kingdee.eas.hr.state.client.HRStateTWOClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class BirthControlEditUI
extends AbstractBirthControlEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BirthControlEditUI.class);
    private EmployeeTreeEditUI treeEditUI;

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.treeEditUI = (EmployeeTreeEditUI)this.getUIContext().get("GroupListEditUI");
    }

    private CtrlUnitInfo getCurrentCU() {
        if (this.treeEditUI != null && this.treeEditUI.getMainBizOrgInfo() != null) {
            return this.treeEditUI.getMainBizOrgInfo().getCU();
        }
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private HROrgUnitInfo getCurrentHRO() {
        if (this.treeEditUI != null && this.treeEditUI.getMainBizOrgInfo() != null) {
            return this.treeEditUI.getMainBizOrgInfo();
        }
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(this.getCurrentHRO().getId());
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        String recordId = null;
        if (this.getUIContext().get("CUR_OBJ_ID") != null) {
            recordId = this.getUIContext().get("CUR_OBJ_ID").toString();
        }
        if (recordId != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)recordId));
            view.put("selector", (Object)this.getMergedSelector());
            view.setFilter(filter);
            BirthControlCollection pcmCol = BirthControlFactory.getRemoteInstance().getBirthControlCollection(view);
            this.editData = pcmCol.size() <= 0 ? (BirthControlInfo)this.createNewData() : pcmCol.get(0);
        }
        this.setDataObject((IObjectValue)this.editData);
        this.editData.copyNewToOld();
        return this.editData;
    }

    @Override
    public void loadFields() {
        try {
            this.getValue(null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        super.loadFields();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        this.person_information();
        super.beforeStoreFields(e);
    }

    @Override
    protected IObjectValue createNewData() {
        BirthControlInfo info = new BirthControlInfo();
        PersonInfo pInfo = new PersonInfo();
        try {
            pInfo = HRStateTWOClientUtils.getPersonInfo(BOSUuid.read((String)this.getUIContext().get("ID").toString()));
        }
        catch (UuidException e) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.state.SocietyPostResource", (String)"noPerson"));
            SysUtil.abort();
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.state.SocietyPostResource", (String)"noPerson"));
            SysUtil.abort();
        }
        info.setPerson(pInfo);
        info.getPerson().getName();
        return info;
    }

    protected void person_information() {
        PersonInfo pInfo = new PersonInfo();
        pInfo.setId(BOSUuid.read((String)this.getUIContext().get("CUR_OBJ_ID").toString()));
        PersonPositionInfo PPinfo = null;
        try {
            PPinfo = HRStateTWOClientUtils.getPersonPositionInfo(pInfo.getId());
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.state.SocietyPostResource", (String)"noPerson"));
            SysUtil.abort();
        }
        if (PPinfo != null) {
            this.editData.setPosition(PPinfo.getPrimaryPosition());
            this.editData.setAdminOrg(PPinfo.getPersonDep());
        }
        this.editData.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        if (this.getUIContext().get("NO_PERMISSION") == null) {
            super.handlePermissionForItemAction(action);
        }
    }
}

