/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.base.client.FilterUIUtil;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.state.client.AbstractBirthControlFilterUI;
import org.apache.log4j.Logger;

public class BirthControlFilterUI
extends AbstractBirthControlFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BirthControlFilterUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void clear() {
        super.clear();
        this.kDBizPromptBox1.setValue(null);
        this.kDBizPromptBox2.setValue(null);
        this.kDRadioButton1.setSelected(true);
        this.kDRadioButton2.setSelected(false);
        this.kDCheckBox1.setSelected(false);
        this.kDCheckBox2.setSelected(false);
        this.kDTextField1.setText("");
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        AdminByOrgRangePromptBox adminOrgF7 = new AdminByOrgRangePromptBox();
        this.kDBizPromptBox2.setEditable(false);
        this.kDBizPromptBox2.setSelector((KDPromptSelector)adminOrgF7);
        EmployeeMultiF7PromptBox empF7 = new EmployeeMultiF7PromptBox();
        empF7.setUserOrgRangeFilter(true);
        empF7.showNoPositionPerson(true);
        this.kDBizPromptBox1.setEditable(false);
        this.kDBizPromptBox1.setSelector((KDPromptSelector)empF7);
    }

    public FilterInfo getFilterInfo() {
        Object adminOrg;
        FilterInfo filterInfo = new FilterInfo();
        if (this.kDRadioButton1.isSelected()) {
            Object employee = this.kDBizPromptBox1.getData();
            this.setEmployeeFilter(this.kDCheckBox1.isSelected(), employee, filterInfo);
        } else if (this.kDRadioButton2.isSelected() && (adminOrg = this.kDBizPromptBox2.getData()) != null && adminOrg instanceof AdminOrgUnitInfo) {
            this.setAdminOrgFilter(this.kDCheckBox2.isSelected(), (AdminOrgUnitInfo)adminOrg, filterInfo);
        }
        return filterInfo;
    }

    private void setAdminOrgFilter(boolean isIncludeChild, AdminOrgUnitInfo org, FilterInfo filter) {
        if (isIncludeChild) {
            filter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(org.getLongNumber() + "!%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)org.getNumber(), CompareType.EQUALS));
            filter.setMaskString("#0 or #1");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("adminOrg.id", (Object)org.getId(), CompareType.EQUALS));
        }
    }

    private void setEmployeeFilter(boolean isLikeStyle, Object employee, FilterInfo filter) {
        if (isLikeStyle) {
            String condStr = this.kDTextField1.getText();
            filter.getFilterItems().add(new FilterItemInfo("person.number", (Object)("%" + condStr + "%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("person.name", (Object)("%" + condStr + "%"), CompareType.LIKE));
            filter.setMaskString("#0 or #1");
        } else if (employee != null && employee instanceof PersonInfo) {
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)((PersonInfo)employee).getId().toString(), CompareType.EQUALS));
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.saveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.retriveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
    }

    public boolean verify() {
        return true;
    }
}

