/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.state.DepartureFactory;
import com.kingdee.eas.hr.state.DepartureInfo;
import com.kingdee.eas.hr.state.client.AbstractDepartureEditUI;
import com.kingdee.eas.hr.state.client.HRStateClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class DepartureEditUI
extends AbstractDepartureEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DepartureEditUI.class);
    public static final String RES = "com.kingdee.eas.hr.state.DepartureResource";
    public static final String PRES = "com.kingdee.eas.hr.state.MessageResource";
    protected EmployeeMultiF7PromptBox employeeF7 = null;

    @Override
    protected IObjectValue createNewData() {
        DepartureInfo info = new DepartureInfo();
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DepartureFactory.getRemoteInstance();
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.contHROrg.setVisible(false);
        this.no_edit();
        this.txtDaysCount.setPrecision(2);
        this.txtDaysCount.setHorizontalAlignment(4);
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.initEmployeeF7();
        this.prmtAccompanier.setSelector((KDPromptSelector)this.employeeF7);
        this.prmtAccompanier.setEnabledMultiSelection(true);
        this.prmtAccompanier.setEditable(false);
        this.prmtAccompanier.setDisplayFormat("$name$");
        this.prmtAccompanier.setEditFormat("$number$");
        this.prmtAccompanier.setCommitFormat("$number$");
        if (this.editData.getDaysCount() == null || this.editData.getDaysCount().intValue() == 0) {
            this.txtDaysCount.setText("");
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        String value;
        this.check_required();
        this.check_DateOfPlan();
        if (this.prmtAccompanier != null && (value = this.prmtAccompanier.getText()) != null && value.trim().length() > 0) {
            this.editData.setAccompanier(value);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.prmtAccompanier.setValue(null);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("reason"));
        sic.add(new SelectorItemInfo("destination"));
        sic.add(new SelectorItemInfo("bgcdNum"));
        sic.add(new SelectorItemInfo("bgcOrg"));
        sic.add(new SelectorItemInfo("daysCount"));
        sic.add(new SelectorItemInfo("bgcTerm"));
        sic.add(new SelectorItemInfo("areSource"));
        sic.add(new SelectorItemInfo("abnormalCir"));
        sic.add(new SelectorItemInfo("appraise"));
        sic.add(new SelectorItemInfo("orgGroupUnit"));
        sic.add(new SelectorItemInfo("groupPosition"));
        sic.add(new SelectorItemInfo("healthStatus"));
        sic.add(new SelectorItemInfo("signContractStatus"));
        sic.add(new SelectorItemInfo("honestyEvaluate"));
        sic.add(new SelectorItemInfo("departureType.*"));
        sic.add(new SelectorItemInfo("remark"));
        sic.add(new SelectorItemInfo("accompanier"));
        return sic;
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void loadFields() {
        String value = this.editData.getAccompanier();
        this.prmtAccompanier.setValue((Object)value);
        super.loadFields();
    }

    protected void check_required() {
        BigDecimal decimal;
        if ("".equals(this.pkStartDate.getText())) {
            this.pkStartDate.requestFocusInWindow();
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"startDate_not_null"));
            SysUtil.abort();
        }
        if ("".equals(this.pkEndDate.getText())) {
            this.pkEndDate.requestFocusInWindow();
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"endDate_not_null"));
            SysUtil.abort();
        }
        if (this.txtReason.getText() == null || this.txtReason.getText().trim().equals("")) {
            this.txtReason.requestFocusInWindow();
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"reason_not_null"));
            SysUtil.abort();
        }
        if (this.txtDestination.getText() == null || this.txtDestination.getText().trim().equals("")) {
            this.txtDestination.requestFocusInWindow();
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"destination_not_null"));
            SysUtil.abort();
        }
        if (this.kDBizPromptBox1.getText() == null || this.kDBizPromptBox1.getText().trim().equals("")) {
            this.kDBizPromptBox1.requestFocusInWindow();
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"BizPromptBox1_not_null"));
            SysUtil.abort();
        }
        if ((decimal = this.txtDaysCount.getBigDecimalValue()) == null) {
            this.txtDaysCount.requestFocusInWindow();
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"daysCount_not_null"));
            SysUtil.abort();
        } else if (decimal.floatValue() <= 0.0f) {
            this.txtDaysCount.requestFocusInWindow();
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"greater"));
            SysUtil.abort();
        }
        this.person_information();
    }

    protected void person_information() {
        PersonInfo pInfo = new PersonInfo();
        pInfo.setId(BOSUuid.read((String)this.getUIContext().get("PersonID").toString()));
        pInfo.setName(this.getUIContext().get("personName").toString());
        PersonPositionInfo PPinfo = null;
        try {
            PPinfo = HRStateClientUtils.getPersonPositionInfo(pInfo.getId());
        }
        catch (Exception e) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"checkDateOfPlan"));
        }
        if (PPinfo != null) {
            this.editData.setPosition(PPinfo.getPrimaryPosition());
            this.editData.setAdminOrg(PPinfo.getPersonDep());
        }
        this.editData.setPerson(pInfo);
        this.editData.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
    }

    protected void check_DateOfPlan() {
        Date dateEnd;
        Date dateStart = (Date)this.pkStartDate.getValue();
        if (dateStart.after(dateEnd = (Date)this.pkEndDate.getValue())) {
            this.pkEndDate.requestFocusInWindow();
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"checkDateOfPlan"));
            this.pkEndDate.setValue(null);
            SysUtil.abort();
        }
    }

    protected void no_edit() {
        this.kDBizPromptBox1.setEditable(true);
    }

    protected void lockUIForViewStatus() {
        super.lockUIForViewStatus();
    }

    private void setButtonStateByView() {
        this.btnSubmit.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnRemove.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        this.menuItemSubmit.setVisible(false);
        this.menuItemCopy.setVisible(false);
        this.menuItemEdit.setVisible(false);
        this.menuItemRemove.setVisible(false);
    }

    protected void initEmployeeF7() {
        if (this.employeeF7 == null) {
            this.employeeF7 = new EmployeeMultiF7PromptBox();
            this.employeeF7.setIsSingleSelect(false);
            this.employeeF7.setUserOrgRangeFilter(true);
            this.employeeF7.setEnabledMultiSelection(true);
        }
    }
}

