/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.base.client.HRBillEditUIBiz;
import com.kingdee.eas.hr.base.client.f7.EditorCreator;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.state.DepartureBillEntryCollection;
import com.kingdee.eas.hr.state.DepartureBillEntryFactory;
import com.kingdee.eas.hr.state.DepartureBillEntryInfo;
import com.kingdee.eas.hr.state.DepartureBillInfo;
import com.kingdee.eas.hr.state.DepartureCollection;
import com.kingdee.eas.hr.state.DepartureFactory;
import com.kingdee.eas.hr.state.DepartureReportBillEntryInfo;
import com.kingdee.eas.hr.state.IDeparture;
import com.kingdee.eas.hr.state.client.HRStateClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class DepartureReportBillEditUIBiz
extends HRBillEditUIBiz {
    private static Logger logger = Logger.getLogger(DepartureReportBillEditUIBiz.class);
    private KDBizPromptBox prmtDepartureBillBox = null;
    public final String RESResource = "com.kingdee.eas.hr.state.MessageResource";

    protected void initEmpF7() {
        super.initEmpF7();
        this.empF7.showNoPositionPerson(true);
    }

    public void beforeStoreField(ActionEvent actionevent) throws Exception {
        super.beforeStoreField(actionevent);
        this.checkDate();
    }

    protected void initEntryEditor() {
        this.initDepartureBill();
        this.lockSomeAttributes();
        this.kdtEntrys.getColumn("daysCount").setEditor(EditorCreator.getNumberCellEditor((int)13, (int)10, (int)0));
        this.kdtEntrys.getColumn("daysCount").getStyleAttributes().setNumberFormat("0.00");
        this.kdtEntrys.getColumn("startDate").setEditor(EditorCreator.getDateCellEditor());
        this.kdtEntrys.getColumn("startDate").getStyleAttributes().setNumberFormat("yyyy-mm-dd");
        this.kdtEntrys.getColumn("endDate").setEditor(EditorCreator.getDateCellEditor());
        this.kdtEntrys.getColumn("endDate").getStyleAttributes().setNumberFormat("yyyy-mm-dd");
    }

    public void initDepartureBill() {
        this.prmtDepartureBillBox = new KDBizPromptBox();
        this.prmtDepartureBillBox.setDisplayFormat("$number$");
        this.prmtDepartureBillBox.setEditFormat("$number$");
        this.prmtDepartureBillBox.setCommitFormat("$number$");
        this.prmtDepartureBillBox.setQueryInfo("com.kingdee.eas.hr.state.app.F7DepartureBillQuery");
        this.kdtEntrys.getColumn("departureBill").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmtDepartureBillBox));
        this.prmtDepartureBillBox.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                if (e.getData() != null) {
                    DepartureReportBillEditUIBiz.this.handleResult(e);
                } else {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.state.MessageResource", (String)"GetObjectFailure"));
                }
            }
        });
    }

    public void lockSomeAttributes() {
        this.kdtEntrys.getColumn(this.getApplierCol()).getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn(this.getAdminOrgCol()).getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn(this.getPositionCol()).getStyleAttributes().setLocked(true);
    }

    public void handleResult(PreChangeEvent e) {
        int rowIndex = HRStateClientUtils.getCurrentRowIndex(this.kdtEntrys);
        IRow row = this.kdtEntrys.getRow(rowIndex);
        if (e.getData() instanceof DepartureBillInfo) {
            DepartureBillInfo departureBillInfo = (DepartureBillInfo)e.getData();
            BOSUuid departureBillInfoId = departureBillInfo.getId();
            StringBuffer oql = new StringBuffer("select startDate,endDate,reason,destination,departureType.name where bill.id= '");
            oql.append(departureBillInfoId).append("'");
            oql.append(" and applier.id = '");
            oql.append(((PersonInfo)row.getCell("applier").getValue()).getId().toString()).append("'");
            DepartureBillEntryCollection collection = null;
            try {
                collection = DepartureBillEntryFactory.getRemoteInstance().getDepartureBillEntryCollection(oql.toString());
            }
            catch (BOSException e1) {
                logger.error((Object)e1.getMessage());
            }
            if (collection != null) {
                DepartureBillEntryInfo info = collection.get(0);
                row.getCell("reason").setValue((Object)info.getReason());
                row.getCell("destination").setValue((Object)info.getDestination());
                row.getCell("departureType").setValue((Object)info.getDepartureType());
                Object startDate = row.getCell("startDate").getValue();
                Object endDate = row.getCell("endDate").getValue();
                if (startDate == null) {
                    row.getCell("startDate").setValue((Object)info.getStartDate());
                }
                if (endDate == null) {
                    row.getCell("endDate").setValue((Object)info.getEndDate());
                }
            } else {
                row.getCell("reason").setValue(null);
                row.getCell("destination").setValue(null);
                row.getCell("departureType").setValue(null);
            }
        } else {
            row.getCell("reason").setValue(null);
            row.getCell("destination").setValue(null);
            row.getCell("departureType").setValue(null);
        }
    }

    protected IObjectValue createNewDetailData(PersonInfo personInfo) {
        DepartureReportBillEntryInfo info = new DepartureReportBillEntryInfo();
        PersonPositionInfo PPinfo = null;
        info.setApplier(personInfo);
        BOSUuid personID = personInfo.getId();
        try {
            PPinfo = HRStateClientUtils.getPersonPositionInfo(personID);
        }
        catch (Exception e) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.state.MessageResource", (String)"notPosition"));
            SysUtil.abort();
        }
        if (PPinfo != null) {
            info.setPosition(PPinfo.getPrimaryPosition());
            info.setAdminOrg(PPinfo.getPersonDep());
        }
        return info;
    }

    public void entryEditStopped(KDTEditEvent e) throws Exception {
        boolean checked = false;
        double days = 0.0;
        String dateStr = this.kdtEntrys.getColumnKey(e.getColIndex());
        BigDecimal daysCount = (BigDecimal)this.kdtEntrys.getRow(e.getRowIndex()).getCell(this.getDaysCountCol()).getValue();
        if (daysCount != null && daysCount.doubleValue() == days) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.state.MessageResource", (String)"daysCount_not_zero"));
            this.kdtEntrys.getRow(e.getRowIndex()).getCell(this.getDaysCountCol()).setValue(null);
            SysUtil.abort();
        }
        if (dateStr.equalsIgnoreCase(this.getStartDateCol()) || dateStr.equalsIgnoreCase(this.getEndDateCol())) {
            Date dateStart = (Date)this.kdtEntrys.getRow(e.getRowIndex()).getCell(this.getStartDateCol()).getValue();
            Date dateEnd = (Date)this.kdtEntrys.getRow(e.getRowIndex()).getCell(this.getEndDateCol()).getValue();
            if (dateStart != null && dateEnd != null && dateStart.after(dateEnd)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.state.MessageResource", (String)"inputEndDate"));
                this.kdtEntrys.getRow(e.getRowIndex()).getCell(this.getEndDateCol()).setValue(null);
                SysUtil.abort();
            }
        }
    }

    protected void entryEditStarting(KDTEditEvent e) throws Exception {
    }

    protected void setFilterItemOfDepartureBillF7(BOSUuid personID) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (personID != null) {
            EntityViewInfo departureViewInfo = new EntityViewInfo();
            FilterInfo departureFilter = new FilterInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            departureFilter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personID.toString(), CompareType.EQUALS));
            departureFilter.getFilterItems().add(new FilterItemInfo("departureBill.id", null, CompareType.NOTEQUALS));
            departureFilter.getFilterItems().add(new FilterItemInfo("daysCount", (Object)"0", CompareType.LESS_EQUALS));
            departureFilter.getFilterItems().add(new FilterItemInfo("isSelect", (Object)"0", CompareType.EQUALS));
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("departureBill.id"));
            departureViewInfo.setSelector(sic);
            departureViewInfo.setFilter(departureFilter);
            HashSet<String> departureBillIdList = new HashSet<String>();
            IDeparture iDepartureDao = DepartureFactory.getRemoteInstance();
            DepartureCollection connection = iDepartureDao.getDepartureCollection(departureViewInfo);
            if (connection != null) {
                for (int i = 0; i < connection.size(); ++i) {
                    departureBillIdList.add(connection.get(i).getDepartureBill().getId().toString());
                }
            }
            filter.getFilterItems().add(new FilterItemInfo("applier.id", (Object)personID.toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billState", (Object)String.valueOf(3), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", departureBillIdList, CompareType.INCLUDE));
            filter.setMaskString("#0 and #1 and #2");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("applier.id", (Object)"", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billState", (Object)String.valueOf(3), CompareType.EQUALS));
            filter.setMaskString("#0 and #1");
        }
        viewInfo.setFilter(filter);
        this.prmtDepartureBillBox.setEntityViewInfo(viewInfo);
    }

    protected void checkUnique() {
        int count = this.kdtEntrys.getRowCount();
        PersonInfo personA = null;
        PersonInfo personB = null;
        DepartureBillInfo departureBillInfoA = null;
        DepartureBillInfo departureBillInfoB = null;
        if (this.kdtEntrys.getRowCount() > 1) {
            for (int i = 0; i < count; ++i) {
                departureBillInfoA = (DepartureBillInfo)this.kdtEntrys.getRow(i).getCell("departureBill").getValue();
                personA = (PersonInfo)this.kdtEntrys.getRow(i).getCell("applier").getValue();
                for (int j = i + 1; j < count; ++j) {
                    personB = (PersonInfo)this.kdtEntrys.getRow(j).getCell("applier").getValue();
                    departureBillInfoB = (DepartureBillInfo)this.kdtEntrys.getRow(j).getCell("departureBill").getValue();
                    if (!personA.getId().toString().equals(personB.getId().toString()) || !departureBillInfoA.getId().toString().equals(departureBillInfoB.getId().toString())) continue;
                    MsgBox.showInfo((Component)this.ctx.getUI(), (String)(EASResource.getString((String)"com.kingdee.eas.hr.state.MessageResource", (String)"the") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.hr.state.MessageResource", (String)"row") + EASResource.getString((String)"com.kingdee.eas.hr.state.MessageResource", (String)"and") + EASResource.getString((String)"com.kingdee.eas.hr.state.MessageResource", (String)"the") + (j + 1) + EASResource.getString((String)"com.kingdee.eas.hr.state.MessageResource", (String)"row") + EASResource.getString((String)"com.kingdee.eas.hr.state.MessageResource", (String)"applierAndDepartureBillRepeat")));
                    SysUtil.abort();
                }
            }
        }
    }

    protected boolean confirmAudit() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.hr.state.MessageResource", (String)"Confirm_Audit")));
    }

    private void checkDate() {
        int rowCount = this.kdtEntrys.getRowCount();
        IRow row = null;
        Object value = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.kdtEntrys.getRow(i);
            Date dateStart = (Date)row.getCell(this.getStartDateCol()).getValue();
            Date dateEnd = (Date)row.getCell(this.getEndDateCol()).getValue();
            if (dateStart == null || dateEnd == null || !dateStart.after(dateEnd)) continue;
            row.getCell(this.getEndDateCol()).setValue(null);
            MsgBox.showInfo((String)("\u7b2c" + (i + 1) + "\u884c\u7684\u201c" + EASResource.getString((String)"com.kingdee.eas.hr.state.MessageResource", (String)"inputEndDate")));
            SysUtil.abort();
        }
    }

    protected String[] getNotNullColumn() {
        String[] notEmptyColStr = new String[]{this.getApplierCol(), this.getStartDateCol(), this.getEndDateCol(), this.getDaysCountCol(), this.getDepartureBillCol()};
        return notEmptyColStr;
    }

    public void afterOnLoad() throws Exception {
        super.afterOnLoad();
    }

    public boolean isAddPersonByF7() {
        return true;
    }

    public String[] getMethodsSupportPlugIn() {
        return null;
    }

    protected String getApplierCol() {
        return "applier";
    }

    protected String getStartDateCol() {
        return "startDate";
    }

    protected String getEndDateCol() {
        return "endDate";
    }

    protected String getDaysCountCol() {
        return "daysCount";
    }

    protected String getDepartureBillCol() {
        return "departureBill";
    }

    protected String getAdminOrgCol() {
        return "adminOrgUnit";
    }

    protected String getPositionCol() {
        return "position";
    }
}

