/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.base.client.FilterUIUtil;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.state.client.AbstractDepartureReportFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class DepartureReportFilterUI
extends AbstractDepartureReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(DepartureReportFilterUI.class);
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final String RES = "com.kingdee.eas.hr.state.MessageResource";

    protected void beforeOnLoad() throws Exception {
        this.chkIsSearch.setEnabled(true);
        this.chkIsIncludeOrg.setEnabled(false);
        this.kdradioApplier.setSelected(true);
        this.prmtAdminOrgUnit.setData(null);
        this.prmtAdminOrgUnit.setEnabled(false);
        this.prmtPosition.setData(null);
        this.prmtPosition.setEnabled(false);
        this.prmtApplier.setEditable(false);
        this.prmtAdminOrgUnit.setEditable(false);
        this.prmtPosition.setEditable(false);
    }

    public void clear() {
        super.clear();
        this.prmtApplier.setValue(null);
        this.prmtAdminOrgUnit.setValue(null);
        this.prmtPosition.setValue(null);
        this.chkIsIncludeOrg.setSelected(false);
        this.chkIsIncludeOrg.setEnabled(false);
        this.chkIsSearch.setSelected(false);
        this.txFieldApplier.setEditable(false);
        this.txFieldApplier.setEnabled(false);
        this.txFieldApplier.setVisible(false);
        this.chkIsIncludeOrg.setEnabled(false);
        this.chkIsSearch.setEnabled(true);
        this.kdradioApplier.setSelected(true);
        this.pkStartDate.setValue(null);
        this.pkStartDateToEnd.setValue(null);
        this.pkEndDate.setValue(null);
        this.pkEndDateToEnd.setValue(null);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllEditor();
    }

    private void initAllEditor() {
        this.kdbGroup.add((AbstractButton)this.kdradioApplier);
        this.kdbGroup.add((AbstractButton)this.kdradioAdminOrgUnit);
        this.kdbGroup.add((AbstractButton)this.kdradioPosition);
        this.kdradioApplier.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                DepartureReportFilterUI.this.setSelect("applier");
            }
        });
        this.kdradioAdminOrgUnit.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                DepartureReportFilterUI.this.setSelect("adminOrg");
            }
        });
        this.kdradioPosition.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeevent) {
                DepartureReportFilterUI.this.setSelect("position");
            }
        });
        this.chkIsSearch.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeevent) {
                DepartureReportFilterUI.this.setSearchType();
            }
        });
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        register.registerAdminByOrgRangePromptBox(this.prmtAdminOrgUnit);
        register.registerPositionPromptBox2(this.prmtPosition);
        register.registerEmployeeMultiF7PromptBox(this.prmtApplier);
        register.registerEmployeeMultiF7PromptBox(this.prmtApplier, true);
    }

    private void setSelect(String selectType) {
        if ("applier".equals(selectType) && this.kdradioApplier.isSelected()) {
            this.prmtApplier.setEnabled(true);
            this.prmtApplier.setVisible(true);
            this.prmtApplier.setEditable(true);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(true);
            this.prmtAdminOrgUnit.setData(null);
            this.prmtAdminOrgUnit.setEnabled(false);
            this.chkIsIncludeOrg.setSelected(false);
            this.chkIsIncludeOrg.setEnabled(false);
            this.prmtPosition.setData(null);
            this.prmtPosition.setEnabled(false);
            this.txFieldApplier.setText(null);
            this.txFieldApplier.setEnabled(false);
            this.txFieldApplier.setVisible(false);
        } else if ("adminOrg".equals(selectType) && this.kdradioAdminOrgUnit.isSelected()) {
            this.prmtAdminOrgUnit.setEnabled(true);
            this.prmtAdminOrgUnit.setEditable(true);
            this.chkIsIncludeOrg.setEnabled(true);
            this.prmtApplier.setData(null);
            this.prmtApplier.setEnabled(false);
            this.prmtApplier.setVisible(true);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(false);
            this.prmtPosition.setEnabled(false);
            this.prmtPosition.setData(null);
            this.txFieldApplier.setText(null);
            this.txFieldApplier.setEnabled(false);
            this.txFieldApplier.setVisible(false);
        } else if ("position".equals(selectType) && this.kdradioPosition.isSelected()) {
            this.prmtPosition.setEnabled(true);
            this.prmtPosition.setEditable(true);
            this.prmtApplier.setData(null);
            this.prmtApplier.setEnabled(false);
            this.prmtApplier.setVisible(true);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(false);
            this.prmtAdminOrgUnit.setData(null);
            this.prmtAdminOrgUnit.setEnabled(false);
            this.chkIsIncludeOrg.setSelected(false);
            this.chkIsIncludeOrg.setEnabled(false);
            this.txFieldApplier.setText(null);
            this.txFieldApplier.setEnabled(false);
            this.txFieldApplier.setVisible(false);
        }
    }

    private void setSearchType() {
        if (this.kdradioApplier.isSelected()) {
            if (this.chkIsSearch.isSelected()) {
                this.prmtApplier.setValue(null);
                this.prmtApplier.setEnabled(false);
                this.prmtApplier.setVisible(false);
                this.txFieldApplier.setEnabled(true);
                this.txFieldApplier.setEditable(true);
                this.txFieldApplier.setVisible(true);
            } else {
                this.prmtApplier.setEnabled(true);
                this.prmtApplier.setEditable(true);
                this.prmtApplier.setVisible(true);
                this.txFieldApplier.setEditable(false);
                this.txFieldApplier.setText(null);
                this.txFieldApplier.setEnabled(false);
                this.txFieldApplier.setVisible(false);
            }
        }
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getMainOrg();
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.saveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.retriveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
    }

    public FilterInfo getFilterInfo() {
        PositionInfo positionInfo;
        AdminOrgUnitInfo orgUnit;
        FilterInfo orgFilter;
        FilterInfo filter = new FilterInfo();
        this.setStartDateFilter(filter);
        this.setEndDateFilter(filter);
        if (this.kdradioApplier.isSelected()) {
            if (this.chkIsSearch.isSelected()) {
                String applierNumberOrName = this.txFieldApplier.getText();
                if (applierNumberOrName != null) {
                    if (filter.getFilterItems().size() > 0) {
                        orgFilter = new FilterInfo();
                        orgFilter.getFilterItems().add(new FilterItemInfo("entrys.applier.number", (Object)("%" + applierNumberOrName + "%"), CompareType.LIKE));
                        orgFilter.getFilterItems().add(new FilterItemInfo("entrys.applier.name", (Object)("%" + applierNumberOrName + "%"), CompareType.LIKE));
                        orgFilter.setMaskString("#0 or #1");
                        try {
                            filter.mergeFilter(orgFilter, "and");
                        }
                        catch (BOSException e) {
                            ExceptionHandler.handle((Throwable)e);
                        }
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("entrys.applier.number", (Object)("%" + applierNumberOrName + "%"), CompareType.LIKE));
                        filter.getFilterItems().add(new FilterItemInfo("entrys.applier.name", (Object)("%" + applierNumberOrName + "%"), CompareType.LIKE));
                        filter.setMaskString("#0 or #1");
                    }
                }
            } else {
                PersonInfo pInfo = (PersonInfo)this.prmtApplier.getData();
                if (pInfo != null) {
                    filter.getFilterItems().add(new FilterItemInfo("entrys.applier.id", (Object)pInfo.getId().toString(), CompareType.EQUALS));
                }
            }
        }
        if (this.kdradioAdminOrgUnit.isSelected() && (orgUnit = (AdminOrgUnitInfo)this.prmtAdminOrgUnit.getData()) != null) {
            if (this.chkIsIncludeOrg.isSelected()) {
                if (filter.getFilterItems().size() > 0) {
                    orgFilter = new FilterInfo();
                    orgFilter.getFilterItems().add(new FilterItemInfo("entrys.adminOrg.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
                    orgFilter.getFilterItems().add(new FilterItemInfo("entrys.adminOrg.number", (Object)(orgUnit.getLongNumber() + "!%"), CompareType.LIKE));
                    orgFilter.setMaskString("#0 or #1");
                    try {
                        filter.mergeFilter(orgFilter, "and");
                    }
                    catch (BOSException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("entrys.adminOrg.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("entrys.adminOrg.number", (Object)(orgUnit.getLongNumber() + "!%"), CompareType.LIKE));
                    filter.setMaskString(" #0 or #1 ");
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("entrys.adminOrg.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
            }
        }
        if (this.kdradioPosition.isSelected() && (positionInfo = (PositionInfo)this.prmtPosition.getData()) != null) {
            filter.getFilterItems().add(new FilterItemInfo("entrys.position.id", (Object)positionInfo.getId().toString(), CompareType.EQUALS));
        }
        return filter;
    }

    private void setStartDateFilter(FilterInfo filter) {
        if (filter == null) {
            return;
        }
        Date startDateStart = (Date)this.pkStartDate.getValue();
        Date startDateEnd = (Date)this.pkStartDateToEnd.getValue();
        if (startDateStart != null) {
            filter.getFilterItems().add(new FilterItemInfo("entrys.startDate", (Object)this.simpleDateFormat.format(startDateStart), CompareType.GREATER_EQUALS));
        }
        if (startDateEnd != null) {
            filter.getFilterItems().add(new FilterItemInfo("entrys.startDate", (Object)this.simpleDateFormat.format(startDateEnd), CompareType.LESS_EQUALS));
        }
    }

    private void setEndDateFilter(FilterInfo filter) {
        if (filter == null) {
            return;
        }
        Date endDateStart = (Date)this.pkEndDate.getValue();
        Date endDateEnd = (Date)this.pkEndDateToEnd.getValue();
        if (endDateStart != null) {
            filter.getFilterItems().add(new FilterItemInfo("entrys.endDate", (Object)this.simpleDateFormat.format(endDateStart), CompareType.GREATER_EQUALS));
        }
        if (endDateEnd != null) {
            filter.getFilterItems().add(new FilterItemInfo("entrys.endDate", (Object)this.simpleDateFormat.format(endDateEnd), CompareType.LESS_EQUALS));
        }
    }

    public boolean verify() {
        Date startDateStart = (Date)this.pkStartDate.getValue();
        Date startDateEnd = (Date)this.pkStartDateToEnd.getValue();
        if (startDateStart != null && startDateEnd != null && startDateStart.getTime() > startDateEnd.getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"StartDate_Not_After_EndDate"));
            return false;
        }
        Date endDateStart = (Date)this.pkEndDate.getValue();
        Date endDateEnd = (Date)this.pkEndDateToEnd.getValue();
        if (endDateStart != null && endDateEnd != null && endDateStart.getTime() > endDateEnd.getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"EndDateStart_Not_After_EndDateToEnd"));
            return false;
        }
        return super.verify();
    }
}

