/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.framework.ICUIDGetterFacade;
import com.kingdee.eas.basedata.framework.client.ClientControlStrategy;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.state.DepartureTypeEnum;
import com.kingdee.eas.hr.state.DepartureTypeFactory;
import com.kingdee.eas.hr.state.DepartureTypeInfo;
import com.kingdee.eas.hr.state.client.AbstractDepartureTypeEditUI;
import com.kingdee.eas.hr.state.client.HRStateClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class DepartureTypeEditUI
extends AbstractDepartureTypeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DepartureTypeEditUI.class);
    protected final String MessageRES = "com.kingdee.eas.hr.state.MessageResource";
    private ClientControlStrategy ccStrategy = null;
    private String controlType = null;
    private String currentCUID = null;

    public DepartureTypeEditUI() throws Exception {
        this.initStrategy();
    }

    private void initStrategy() throws Exception {
        String controlType = this.getControlType();
        this.ccStrategy = ClientControlStrategy.create((String)controlType, null);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkForSType("ACTION_ADDNEW");
        super.actionAddNew_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.ccStrategy.checkCanAdd();
        super.actionCopy_actionPerformed(e);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        HRStateClientUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        HRStateClientUtils.verifyEmpty((CoreUIObject)this, this.txtName);
    }

    private String getControlType() throws Exception {
        this.controlType = "";
        if (this.getBizInterface() == null) {
            return this.controlType;
        }
        try {
            EntityObjectInfo eoi = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(this.getBizType());
            if (eoi.containsExtendedPropertyKey("controlType")) {
                this.controlType = eoi.getExtendedProperty("controlType");
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        return this.controlType;
    }

    protected String getCurrentCUID() {
        if (this.currentCUID == null) {
            this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        }
        return this.currentCUID;
    }

    private void checkForSType(String actionName) throws Exception {
        this.checkPermission(actionName);
    }

    private void checkPermission(String action) throws Exception {
        if (this.getControlType().equalsIgnoreCase("S1")) {
            if (!this.getCurrentCUID().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                this.throwsExceptionForNoPermission(action);
            }
        } else if ((this.getControlType().equalsIgnoreCase("S3") || this.getControlType().equalsIgnoreCase("S4")) && !action.equals("ACTION_ADDNEW") && !this.getCurrentCUID().equals(this.getCUIDFromBizobject())) {
            this.throwsExceptionForNoPermission(action);
        }
    }

    private void throwsExceptionForNoPermission(String action) throws Exception {
        if (action.equals("ACTION_ADDNEW")) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_ADD);
        }
        if (action.equals("ACTION_DELETE")) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE);
        }
        if (action.equals("ACTION_MODIFY")) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
    }

    private String getCUIDFromBizobject() throws Exception {
        return this.getICGF().getCUID(this.editData.getId().toString());
    }

    private ICUIDGetterFacade getICGF() throws Exception {
        return CUIDGetterFacadeFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        DepartureTypeInfo objectValue = new DepartureTypeInfo();
        objectValue.setType(DepartureTypeEnum.getEnum(1));
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setHrOrgUnit(HRStateClientUtils.getCurrentHROrgUnit());
        return objectValue;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DepartureTypeFactory.getRemoteInstance();
    }

    @Override
    protected void recycleNumberByOrg(IObjectValue editData, String orgType, String number) {
        if (!StringUtils.isEmpty((String)number)) {
            try {
                String companyID = null;
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
                } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
                }
                if (!StringUtils.isEmpty(companyID) && iCodingRuleManager.isExist(editData, companyID) && iCodingRuleManager.isUseIntermitNumber(editData, companyID)) {
                    iCodingRuleManager.recycleNumber(editData, companyID, number);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
        if (this.editData.getNumber() == null) {
            try {
                String companyID = null;
                if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
                } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
                }
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                if (iCodingRuleManager.isExist((IObjectValue)this.editData, companyID)) {
                    if (iCodingRuleManager.isAddView((IObjectValue)this.editData, companyID)) {
                        this.editData.setNumber(iCodingRuleManager.getNumber((IObjectValue)this.editData, companyID));
                    }
                    this.txtNumber.setEnabled(false);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
                this.oldData = this.editData;
                SysUtil.abort();
            }
        } else if (this.editData.getNumber().trim().length() > 0) {
            this.txtNumber.setText(this.editData.getNumber());
        }
    }

    @Override
    public void loadFields() {
        this.setAutoNumberByOrg("HRO");
        this.dataBinder.loadFields();
    }

    @Override
    protected void removeByPK(IObjectPK pk) throws Exception {
        DepartureTypeInfo editData = this.editData;
        super.removeByPK(pk);
        this.recycleNumberByOrg((IObjectValue)editData, "HRO", editData.getString("number"));
    }
}

