/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.client.EmployeeTreeEditUI;
import com.kingdee.eas.hr.state.DepartureBillException;
import com.kingdee.eas.hr.state.DependantInfo;
import com.kingdee.eas.hr.state.client.AbstractDependantEditUI;
import com.kingdee.eas.hr.state.client.HRStateTWOClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class DependantEditUI
extends AbstractDependantEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DependantEditUI.class);
    public static final String RES = "com.kingdee.eas.hr.state.DependantResource";
    private EmployeeTreeEditUI treeEditUI;

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.txtpayment.setEditable(false);
            this.txtpayment.setEnabled(true);
        }
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.txtpayment.setMaximumValue((Comparable)new BigDecimal("1000000000"));
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        HRStateTWOClientUtils.verifyEmpty((CoreUIObject)this, RES, this.txtdependantName, "DEPENDANTNAME_NOT_NULL");
        HRStateTWOClientUtils.verifyEmpty((CoreUIObject)this, RES, this.txtpersonRelation, "PERSONRELATION_NOT_NULL");
        Number val = this.txtpayment.getNumberValue();
        if (this.chkisPay.isSelected() && val != null && val.doubleValue() < 0.0) {
            throw new DepartureBillException(DepartureBillException.PAYMENTISMINUS);
        }
    }

    @Override
    public void chkisPay_stateChanged(ChangeEvent e) {
        if (this.chkisPay.isSelected()) {
            this.txtpayment.setEnabled(true);
            this.txtpayment.setText("");
            this.txtpayment.setHorizontalAlignment(4);
        } else {
            this.txtpayment.setValue(null);
            this.txtpayment.setEnabled(false);
        }
    }

    @Override
    protected IObjectValue createNewData() {
        DependantInfo objectValue = new DependantInfo();
        this.loadDependantInfo(objectValue);
        return objectValue;
    }

    protected void loadDependantInfo(DependantInfo objectValue) {
        String recordId = null;
        Object temp = this.getUIContext().get("PersonID");
        if (temp != null) {
            recordId = temp.toString();
        }
        PersonInfo pInfo = null;
        PersonPositionInfo ppInfo = null;
        PositionInfo psInfo = null;
        AdminOrgUnitInfo adminOrg = null;
        try {
            pInfo = HRStateTWOClientUtils.getPersonInfo(BOSUuid.read((String)recordId));
            ppInfo = HRStateTWOClientUtils.getPersonPositionInfo(BOSUuid.read((String)recordId));
            psInfo = ppInfo.getPrimaryPosition();
            adminOrg = ppInfo.getPersonDep();
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"noPerson"));
            SysUtil.abort();
        }
        objectValue.setPerson(pInfo);
        objectValue.setPosition(psInfo);
        objectValue.setAdminOrg(adminOrg);
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        DependantInfo dependantInfo = new DependantInfo();
        this.loadDependantInfo(dependantInfo);
        this.editData.setAdminOrg(dependantInfo.getAdminOrg());
        this.editData.setPosition(dependantInfo.getPosition());
        this.editData.setPerson(dependantInfo.getPerson());
        this.editData.setHrOrgUnit(dependantInfo.getHrOrgUnit());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionCopy.setVisible(false);
            this.actionSubmit.setVisible(false);
            this.actionRemove.setVisible(false);
        } else {
            this.actionAddNew.setVisible(true);
            this.actionEdit.setVisible(true);
            this.actionCopy.setVisible(true);
            this.actionSubmit.setVisible(true);
            this.actionRemove.setVisible(true);
        }
    }
}

