/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.base.client.FilterUIUtil;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.state.client.AbstractDependantFormsFilterUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import javax.swing.AbstractButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class DependantFormsFilterUI
extends AbstractDependantFormsFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(DependantFormsFilterUI.class);

    protected void beforeOnLoad() throws Exception {
        this.chkIsSearch.setEnabled(true);
        this.chkIsIncludeOrg.setEnabled(false);
        this.kdRadioPerson.setSelected(true);
        this.prmtPerson.setEditable(false);
        this.prmtAdminOrg.setEditable(false);
        this.prmtAdminOrg.setData(null);
        this.prmtAdminOrg.setEnabled(false);
    }

    public void clear() {
        super.clear();
        this.prmtPerson.setValue(null);
        this.prmtAdminOrg.setValue(null);
        this.chkIsIncludeOrg.setSelected(false);
        this.chkIsIncludeOrg.setEnabled(false);
        this.chkIsSearch.setSelected(false);
        this.txtPerson.setEditable(false);
        this.txtPerson.setEnabled(false);
        this.txtPerson.setVisible(false);
        this.chkIsIncludeOrg.setEnabled(false);
        this.chkIsSearch.setEnabled(true);
        this.kdRadioPerson.setSelected(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllEditor();
    }

    private void initAllEditor() {
        this.kDBGroup.add((AbstractButton)this.kdRadioPerson);
        this.kDBGroup.add((AbstractButton)this.kdRadioAdminOrg);
        this.kdRadioPerson.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                DependantFormsFilterUI.this.setSelect("employee");
            }
        });
        this.kdRadioAdminOrg.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                DependantFormsFilterUI.this.setSelect("adminOrg");
            }
        });
        this.chkIsSearch.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeevent) {
                DependantFormsFilterUI.this.setSearchType();
            }
        });
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        AdminByOrgRangePromptBox adminOrgF7 = new AdminByOrgRangePromptBox();
        this.prmtAdminOrg.setEditFormat("$number$");
        this.prmtAdminOrg.setDisplayFormat("$name$");
        this.prmtAdminOrg.setCommitFormat("$number$");
        this.prmtAdminOrg.setSelector((KDPromptSelector)adminOrgF7);
        EmployeeMultiF7PromptBox empF7 = new EmployeeMultiF7PromptBox();
        empF7.setUserOrgRangeFilter(true);
        empF7.showNoPositionPerson(true);
        this.prmtPerson.setEditFormat("$number$");
        this.prmtPerson.setDisplayFormat("$name$");
        this.prmtPerson.setCommitFormat("$number$");
        this.prmtPerson.setSelector((KDPromptSelector)empF7);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getMainOrg();
    }

    public boolean verify() {
        return true;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.saveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.retriveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
    }

    public FilterInfo getFilterInfo() {
        AdminOrgUnitInfo orgUnit;
        FilterInfo orgFilter;
        FilterInfo filter = new FilterInfo();
        if (this.kdRadioPerson.isSelected()) {
            if (this.chkIsSearch.isSelected()) {
                String personNumberOrName = this.txtPerson.getText().trim();
                if (personNumberOrName != null) {
                    if (filter.getFilterItems().size() > 0) {
                        orgFilter = new FilterInfo();
                        orgFilter.getFilterItems().add(new FilterItemInfo("person.number", (Object)("%" + personNumberOrName + "%"), CompareType.LIKE));
                        orgFilter.getFilterItems().add(new FilterItemInfo("person.name", (Object)("%" + personNumberOrName + "%"), CompareType.LIKE));
                        orgFilter.setMaskString("#0 or #1");
                        try {
                            filter.mergeFilter(orgFilter, "and");
                        }
                        catch (BOSException e) {
                            ExceptionHandler.handle((Throwable)e);
                        }
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("person.number", (Object)("%" + personNumberOrName + "%"), CompareType.LIKE));
                        filter.getFilterItems().add(new FilterItemInfo("person.name", (Object)("%" + personNumberOrName + "%"), CompareType.LIKE));
                        filter.setMaskString("#0 or #1");
                    }
                }
            } else {
                PersonInfo pInfo = (PersonInfo)this.prmtPerson.getData();
                if (pInfo != null) {
                    filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)pInfo.getId().toString(), CompareType.EQUALS));
                }
            }
        }
        if (this.kdRadioAdminOrg.isSelected() && (orgUnit = (AdminOrgUnitInfo)this.prmtAdminOrg.getData()) != null) {
            if (this.chkIsIncludeOrg.isSelected()) {
                if (filter.getFilterItems().size() > 0) {
                    orgFilter = new FilterInfo();
                    orgFilter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
                    orgFilter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(orgUnit.getLongNumber() + "!%"), CompareType.LIKE));
                    orgFilter.setMaskString("#0 or #1");
                    try {
                        filter.mergeFilter(orgFilter, "and");
                    }
                    catch (BOSException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(orgUnit.getLongNumber() + "!%"), CompareType.LIKE));
                    filter.setMaskString(" #0 or #1 ");
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
            }
        }
        return filter;
    }

    private void setSelect(String selectType) {
        if ("employee".equals(selectType) && this.kdRadioPerson.isSelected()) {
            this.prmtPerson.setEnabled(true);
            this.prmtPerson.setVisible(true);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(true);
            this.prmtAdminOrg.setData(null);
            this.prmtAdminOrg.setEnabled(false);
            this.chkIsIncludeOrg.setSelected(false);
            this.chkIsIncludeOrg.setEnabled(false);
            this.txtPerson.setText(null);
            this.txtPerson.setEnabled(false);
            this.txtPerson.setVisible(false);
        } else if ("adminOrg".equals(selectType) && this.kdRadioAdminOrg.isSelected()) {
            this.prmtAdminOrg.setEnabled(true);
            this.chkIsIncludeOrg.setEnabled(true);
            this.prmtPerson.setData(null);
            this.prmtPerson.setEnabled(false);
            this.prmtPerson.setVisible(true);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(false);
            this.txtPerson.setText(null);
            this.txtPerson.setEnabled(false);
            this.txtPerson.setVisible(false);
        }
    }

    private void setSearchType() {
        if (this.kdRadioPerson.isSelected()) {
            if (this.chkIsSearch.isSelected()) {
                this.prmtPerson.setValue(null);
                this.prmtPerson.setEnabled(false);
                this.prmtPerson.setVisible(false);
                this.txtPerson.setEnabled(true);
                this.txtPerson.setEditable(true);
                this.txtPerson.setVisible(true);
            } else {
                this.prmtPerson.setEnabled(true);
                this.prmtPerson.setVisible(true);
                this.txtPerson.setEditable(false);
                this.txtPerson.setText(null);
                this.txtPerson.setEnabled(false);
                this.txtPerson.setVisible(false);
            }
        }
    }
}

