/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.competmodel.CompetenceIndexCollection;
import com.kingdee.eas.hr.competmodel.CompetenceIndexFactory;
import com.kingdee.eas.hr.competmodel.CompetenceIndexInfo;
import com.kingdee.eas.hr.competmodel.IndexGradeCollection;
import com.kingdee.eas.hr.competmodel.IndexGradeFactory;
import com.kingdee.eas.hr.competmodel.IndexGradeInfo;
import com.kingdee.eas.hr.state.DirectorBasicFactory;
import com.kingdee.eas.hr.state.DirectorBasicInfo;
import com.kingdee.eas.hr.state.DirectorCompetenceCollection;
import com.kingdee.eas.hr.state.DirectorCompetenceInfo;
import com.kingdee.eas.hr.state.DirectorJobCollection;
import com.kingdee.eas.hr.state.DirectorJobInfo;
import com.kingdee.eas.hr.state.IDirectorBasic;
import com.kingdee.eas.hr.state.client.AbstractDirectorBasicEditUI;
import com.kingdee.eas.hr.state.client.HRStateTWOClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class DirectorBasicEditUI
extends AbstractDirectorBasicEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DirectorBasicEditUI.class);
    protected final String RES = "com.kingdee.eas.hr.state.DirectorResource";
    private int competenceIndex = 0;
    private int jobIndex = 1;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    private void loadEntry() {
        this.kdtDirectorCompetence.checkParsed();
        this.kdtDirectorJob.checkParsed();
        if (!this.oprtState.equalsIgnoreCase("ADDNEW")) {
            DirectorBasicInfo directorBasicInfo = null;
            String id = this.editData.getId().toString();
            try {
                directorBasicInfo = ((IDirectorBasic)this.getBizInterface()).getDirectorBasicInfo((IObjectPK)new ObjectUuidPK(id));
            }
            catch (Exception e) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.state.DirectorResource", (String)"Onload_DirectorBasicInfo"));
                SysUtil.abort();
            }
            if (directorBasicInfo != null) {
                DirectorJobCollection job;
                DirectorCompetenceCollection competence = directorBasicInfo.getDirectorCompetence();
                if (competence != null && competence.size() > 0) {
                    int size = competence.size();
                    for (int i = 0; i < size; ++i) {
                        this.fillCompetence(competence.get(i));
                    }
                }
                if ((job = directorBasicInfo.getDirectorJob()) != null && job.size() > 0) {
                    int size = job.size();
                    for (int i = 0; i < size; ++i) {
                        this.fillJob(job.get(i));
                    }
                }
            }
        }
    }

    public void onLoad() throws Exception {
        this.actionFirst.setVisible(true);
        this.actionPre.setVisible(true);
        this.actionNext.setVisible(true);
        this.actionLast.setVisible(true);
        super.onLoad();
        this.initkdtEntrys();
    }

    private void fillCompetence(DirectorCompetenceInfo directorCompetenceInfo) {
        if (directorCompetenceInfo == null) {
            return;
        }
        ICell iCell = null;
        IRow iRow = null;
        int length = this.kdtDirectorCompetence.getRowCount();
        for (int i = 0; i < length; ++i) {
            iCell = this.kdtDirectorCompetence.getRow(i).getCell("id");
            if (iCell.getValue() == null || !iCell.getValue().toString().equals(directorCompetenceInfo.getId().toString())) continue;
            return;
        }
        iRow = this.kdtDirectorCompetence.addRow();
        iCell = iRow.getCell("id");
        if (iCell != null) {
            iCell.setValue((Object)directorCompetenceInfo.getId());
        }
        if ((iCell = iRow.getCell("competenceIndex")) != null) {
            iCell.setValue((Object)directorCompetenceInfo.getCompetenceIndex());
        }
        if ((iCell = iRow.getCell("type")) != null) {
            iCell.setValue((Object)directorCompetenceInfo.getType());
        }
        if ((iCell = iRow.getCell("indexGrade")) != null) {
            iCell.setValue((Object)directorCompetenceInfo.getIndexGrade());
        }
        if ((iCell = iRow.getCell("actDescription")) != null) {
            iCell.setValue((Object)directorCompetenceInfo.getActDescription());
        }
        if ((iCell = iRow.getCell("description")) != null) {
            iCell.setValue((Object)directorCompetenceInfo.getDescription());
        }
        if ((iCell = iRow.getCell("basic")) != null) {
            iCell.setValue((Object)directorCompetenceInfo.getBasic());
        }
    }

    private void fillJob(DirectorJobInfo directorJobInfo) {
        if (directorJobInfo == null) {
            return;
        }
        ICell iCell = null;
        IRow iRow = null;
        int length = this.kdtDirectorJob.getRowCount();
        for (int i = 0; i < length; ++i) {
            iCell = this.kdtDirectorJob.getRow(i).getCell("id");
            if (iCell.getValue() == null || !iCell.getValue().toString().equals(directorJobInfo.getId().toString())) continue;
            return;
        }
        iRow = this.kdtDirectorJob.addRow();
        iCell = iRow.getCell("id");
        if (iCell != null) {
            iCell.setValue((Object)directorJobInfo.getId());
        }
        if ((iCell = iRow.getCell("dateStart")) != null) {
            iCell.setValue((Object)directorJobInfo.getDateStart());
        }
        if ((iCell = iRow.getCell("dateEnd")) != null) {
            iCell.setValue((Object)directorJobInfo.getDateEnd());
        }
        if ((iCell = iRow.getCell("jobHistory")) != null) {
            iCell.setValue((Object)directorJobInfo.getJobHistory());
        }
        if ((iCell = iRow.getCell("exam")) != null) {
            iCell.setValue((Object)directorJobInfo.getExam());
        }
        if ((iCell = iRow.getCell("basic")) != null) {
            iCell.setValue((Object)directorJobInfo.getBasic());
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnDeleteLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnCopyLine.setIcon(EASResource.getIcon((String)"imgTbtn_copyline"));
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.deleteNullLine();
        super.actionSubmit_actionPerformed(e);
    }

    private void deleteNullLine() {
        int col;
        int row;
        for (row = 0; row < this.kdtDirectorCompetence.getRowCount(); ++row) {
            boolean competenceHaveEntrys = false;
            for (col = 1; col < this.kdtDirectorCompetence.getColumnCount(); ++col) {
                if (this.kdtDirectorCompetence.getRow(row).getCell(col).getValue() == null) continue;
                competenceHaveEntrys = true;
            }
            if (competenceHaveEntrys) continue;
            this.kdtDirectorCompetence.removeRow(row);
        }
        for (row = 0; row < this.kdtDirectorJob.getRowCount(); ++row) {
            boolean jobHaveEntrys = false;
            for (col = 1; col < this.kdtDirectorJob.getColumnCount(); ++col) {
                if (this.kdtDirectorJob.getRow(row).getCell(col).getValue() == null) continue;
                jobHaveEntrys = true;
            }
            if (jobHaveEntrys) continue;
            this.kdtDirectorJob.removeRow(row);
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.kDTabbedPane1.getSelectedIndex() == this.competenceIndex) {
            this.kdtDirectorCompetence.addRow();
        }
        if (this.kDTabbedPane1.getSelectedIndex() == this.jobIndex) {
            this.kdtDirectorJob.addRow();
        }
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        int top = 0;
        if (this.kDTabbedPane1.getSelectedIndex() == this.competenceIndex) {
            if (this.kdtDirectorCompetence.getSelectManager().size() > 0) {
                top = this.kdtDirectorCompetence.getSelectManager().get().getTop();
                this.kdtDirectorCompetence.addRow(top + 1);
            } else {
                this.kdtDirectorCompetence.addRow();
            }
        }
        if (this.kDTabbedPane1.getSelectedIndex() == this.jobIndex) {
            if (this.kdtDirectorJob.getSelectManager().size() > 0) {
                top = this.kdtDirectorJob.getSelectManager().get().getTop();
                this.kdtDirectorJob.addRow(top + 1);
            } else {
                this.kdtDirectorJob.addRow();
            }
        }
    }

    @Override
    public void actionDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        int top = 0;
        if (this.kDTabbedPane1.getSelectedIndex() == this.competenceIndex && this.kdtDirectorCompetence.getSelectManager().size() > 0) {
            top = this.kdtDirectorCompetence.getSelectManager().get().getTop();
            this.kdtDirectorCompetence.removeRow(top);
        }
        if (this.kDTabbedPane1.getSelectedIndex() == this.jobIndex && this.kdtDirectorJob.getSelectManager().size() > 0) {
            top = this.kdtDirectorJob.getSelectManager().get().getTop();
            this.kdtDirectorJob.removeRow(top);
        }
    }

    @Override
    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.kDTabbedPane1.getSelectedIndex() == this.competenceIndex) {
            if (this.kdtDirectorCompetence.getSelectManager().size() > 0) {
                this.copyLine(this.kdtDirectorCompetence, true);
            } else {
                this.copyLine(this.kdtDirectorCompetence, false);
            }
        }
        if (this.kDTabbedPane1.getSelectedIndex() == this.jobIndex) {
            if (this.kdtDirectorJob.getSelectManager().size() > 0) {
                this.copyLine(this.kdtDirectorJob, true);
            } else {
                this.copyLine(this.kdtDirectorJob, false);
            }
        }
    }

    @Override
    protected void kdtDirectorCompetence_editStopped(KDTEditEvent e) throws Exception {
        this.kdtDirectorCompetence.checkParsed();
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        if (oldValue != newValue) {
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            IRow row = this.kdtDirectorCompetence.getRow(rowIndex);
            if (this.kdtDirectorCompetence.getColumn("competenceIndex").getColumnIndex() == colIndex) {
                CompetenceIndexInfo competenceIndexInfo = null;
                String oql = "select id,type.id,type.name where id = '" + ((CompetenceIndexInfo)row.getCell(colIndex).getValue()).getId() + "'";
                CompetenceIndexCollection c = CompetenceIndexFactory.getRemoteInstance().getCompetenceIndexCollection(oql);
                if (c.size() > 0) {
                    competenceIndexInfo = c.get(0);
                }
                if (competenceIndexInfo != null) {
                    row.getCell("competenceIndexId").setValue((Object)competenceIndexInfo.getId());
                    row.getCell("type").setValue((Object)competenceIndexInfo.getType().getName());
                }
            } else if (this.kdtDirectorCompetence.getColumn("indexGrade").getColumnIndex() == colIndex) {
                IndexGradeInfo indexGrade = null;
                String oql = "select id,description where id = '" + ((IndexGradeInfo)row.getCell(colIndex).getValue()).getId() + "'";
                IndexGradeCollection c = IndexGradeFactory.getRemoteInstance().getIndexGradeCollection(oql);
                if (c.size() > 0) {
                    indexGrade = c.get(0);
                }
                if (indexGrade != null) {
                    row.getCell("indexGradeId").setValue((Object)indexGrade.getId());
                    row.getCell("actDescription").setValue((Object)indexGrade.getDescription());
                }
            }
        }
    }

    @Override
    protected void kdtDirectorJob_editStopped(KDTEditEvent e) throws Exception {
        this.kdtDirectorJob.checkParsed();
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        if (oldValue != newValue) {
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            IRow row = this.kdtDirectorJob.getRow(rowIndex);
            if (this.kdtDirectorJob.getColumn("dateStart").getColumnIndex() == colIndex || this.kdtDirectorJob.getColumn("dateEnd").getColumnIndex() == colIndex) {
                Date dateStart = (Date)row.getCell("dateStart").getValue();
                Date dateEnd = (Date)row.getCell("dateEnd").getValue();
                if (dateStart != null && dateEnd != null && dateStart.after(dateEnd)) {
                    this.kdtDirectorJob.getRow(rowIndex).getCell(colIndex).setValue(null);
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.state.DirectorResource", (String)"dateEndMustAfterdateStart"));
                    SysUtil.abort();
                }
            }
        }
    }

    public void copyLine(KDTable table, boolean isSelect) throws Exception {
        if (table == null) {
            return;
        }
        int row = this.getDataRow(table);
        if (row == -1) {
            return;
        }
        this.lineCopy(table, this.getFillRows(table, isSelect), row);
    }

    private int getDataRow(KDTable table) {
        KDTSelectBlock sb = null;
        int size = table.getSelectManager().size();
        if (size > 0) {
            sb = table.getSelectManager().get(0);
            int row = sb.getTop();
            return row;
        }
        return -1;
    }

    private int[] getFillRows(KDTable table, boolean isSelected) {
        if (isSelected) {
            KDTSelectBlock sb = null;
            int size = table.getSelectManager().size();
            ArrayList<Integer> rows = new ArrayList<Integer>();
            for (int i = 0; i < size; ++i) {
                sb = table.getSelectManager().get(i);
                for (int j = sb.getBeginRow(); j <= sb.getEndRow(); ++j) {
                    rows.add(j);
                }
            }
            int[] r = new int[rows.size()];
            int len = rows.size();
            for (int i = 0; i < len; ++i) {
                r[i] = (Integer)rows.get(i);
            }
            return r;
        }
        int count = table.getRowCount();
        int[] rows = new int[count];
        for (int i = 0; i < count; ++i) {
            rows[i] = i;
        }
        return rows;
    }

    public void lineCopy(KDTable table, int[] fillRows, int dataRow) throws Exception {
        if (table == null || fillRows == null) {
            return;
        }
        IRow dRow = null;
        dRow = table.getRow(dataRow);
        if (dRow == null) {
            return;
        }
        if (fillRows.length == 1 && dataRow == fillRows[0]) {
            fillRows[0] = table.addRow().getRowIndex();
        }
        IRow row = null;
        for (int i = 0; i < fillRows.length; ++i) {
            if (dataRow == fillRows[i]) continue;
            row = table.getRow(fillRows[i]);
            this.fillRow(table, row, dRow);
        }
    }

    protected void fillRow(KDTable table, IRow row, IRow dataRow) throws Exception {
        if (row == null) {
            return;
        }
        int count = table.getColumnCount();
        for (int copyCol = 0; copyCol < count; ++copyCol) {
            ICell dataCell = dataRow.getCell(copyCol);
            Object value = dataCell.getValue();
            ICell cell = row.getCell(copyCol);
            if (cell == null) {
                return;
            }
            if ("id".equals(table.getColumn(cell.getColumnIndex()).getKey())) continue;
            cell.setValue(value);
        }
    }

    protected void initkdtEntrys() {
        KDBizPromptBox prmtCompetenceIndex = new KDBizPromptBox();
        prmtCompetenceIndex.setQueryInfo("com.kingdee.eas.hr.competmodel.app.CompetenceIndexListQuery");
        prmtCompetenceIndex.setEditFormat("$number$");
        prmtCompetenceIndex.setDisplayFormat("$name$");
        prmtCompetenceIndex.setCommitFormat("$number$");
        KDTDefaultCellEditor competenceIndexItemEditor = new KDTDefaultCellEditor((IKDEditor)prmtCompetenceIndex);
        this.kdtDirectorCompetence.getColumn("competenceIndex").setEditor((ICellEditor)competenceIndexItemEditor);
        KDBizPromptBox prmtIndexGrade = new KDBizPromptBox();
        prmtIndexGrade.setQueryInfo("com.kingdee.eas.hr.state.app.IndexGradeF7Query");
        prmtIndexGrade.setEditFormat("$number$");
        prmtIndexGrade.setDisplayFormat("$name$");
        prmtIndexGrade.setCommitFormat("$number$");
        KDTDefaultCellEditor indexGradeItemEditor = new KDTDefaultCellEditor((IKDEditor)prmtIndexGrade);
        this.kdtDirectorCompetence.getColumn("indexGrade").setEditor((ICellEditor)indexGradeItemEditor);
        KDTextField textField = new KDTextField();
        textField.setMaxLength(255);
        KDTDefaultCellEditor textFieldEditor = new KDTDefaultCellEditor((JTextField)textField);
        this.kdtDirectorCompetence.getColumn("description").setEditor((ICellEditor)textFieldEditor);
        this.kdtDirectorJob.getColumn("jobHistory").setEditor((ICellEditor)textFieldEditor);
        this.kdtDirectorJob.getColumn("exam").setEditor((ICellEditor)textFieldEditor);
        KDDatePicker dateStartPicker = new KDDatePicker();
        this.kdtDirectorJob.getColumn("dateStart").setEditor((ICellEditor)new KDTDefaultCellEditor(dateStartPicker));
        this.kdtDirectorJob.getColumn("dateStart").getStyleAttributes().setNumberFormat("yyyy-MM-dd");
        KDDatePicker dateEndPicker = new KDDatePicker();
        this.kdtDirectorJob.getColumn("dateEnd").setEditor((ICellEditor)new KDTDefaultCellEditor(dateEndPicker));
        this.kdtDirectorJob.getColumn("dateEnd").getStyleAttributes().setNumberFormat("yyyy-MM-dd");
    }

    protected void lockUIForViewStatus() {
        super.lockUIForViewStatus();
        this.setButtonStateByView();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setButtonStateByEdit();
    }

    private void setButtonStateByView() {
        this.btnAddLine.setEnabled(false);
        this.btnInsertLine.setEnabled(false);
        this.btnDeleteLine.setEnabled(false);
        this.btnCopyLine.setEnabled(false);
        this.kdtDirectorCompetence.setEditable(false);
        this.kdtDirectorJob.setEditable(false);
    }

    private void setButtonStateByEdit() {
        this.btnAddLine.setEnabled(true);
        this.btnInsertLine.setEnabled(true);
        this.btnDeleteLine.setEnabled(true);
        this.btnCopyLine.setEnabled(true);
        this.kdtDirectorCompetence.setEditable(true);
        this.kdtDirectorJob.setEditable(true);
    }

    protected void verifyInput(ActionEvent actionevent) throws Exception {
        HRStateTWOClientUtils.verifyEmpty((CoreUIObject)this, "com.kingdee.eas.hr.state.DirectorResource", this.txtNumber, "mustInputTheNumber");
        HRStateTWOClientUtils.verifyEmpty((CoreUIObject)this, "com.kingdee.eas.hr.state.DirectorResource", this.txtName, "mustInputTheName");
    }

    @Override
    protected IObjectValue createNewData() {
        return new DirectorBasicInfo();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DirectorBasicFactory.getRemoteInstance();
    }
}

