/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.client.HRBillEditUIBiz;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.state.EventCensorBillEntryInfo;
import com.kingdee.eas.hr.state.EventCensorBillFactory;
import com.kingdee.eas.hr.state.EventCensorBillInfo;
import com.kingdee.eas.hr.state.HistoricalEventInfo;
import com.kingdee.eas.hr.state.client.HRStateClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class EventCensorBillEditUIBiz
extends HRBillEditUIBiz {
    protected final String MessageRES = "com.kingdee.eas.hr.state.MessageResource";
    private static final String ERES = "com.kingdee.eas.hr.state.EventBillResource";
    private String res = "com.kingdee.eas.hr.state.PersonHistoricalEventResource";

    protected void initEmpF7() {
        super.initEmpF7();
        this.empF7.showNoPositionPerson(true);
    }

    protected void initEditor() throws Exception {
        super.initEditor();
        KDBizPromptBox prmtHistoricalEvent = new KDBizPromptBox();
        prmtHistoricalEvent.setEditFormat("$number$");
        prmtHistoricalEvent.setCommitFormat("$number$");
        prmtHistoricalEvent.setDisplayFormat("$number$");
        prmtHistoricalEvent.setQueryInfo("com.kingdee.eas.hr.state.app.HistoricalEventQuery");
        this.kdtEntrys.getColumn("historicalEvent").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtHistoricalEvent));
        this.kdtEntrys.getColumn("person").getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn("adminOrgUnit").getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn("position").getStyleAttributes().setLocked(true);
    }

    protected IObjectValue createNewDetailData(PersonInfo personInfo) {
        EventCensorBillEntryInfo info = new EventCensorBillEntryInfo();
        PersonPositionInfo PPinfo = null;
        info.setPerson(personInfo);
        BOSUuid personID = personInfo.getId();
        try {
            PPinfo = HRStateClientUtils.getPersonPositionInfo(personID);
        }
        catch (Exception e) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.state.MessageResource", (String)"notPosition"));
            SysUtil.abort();
        }
        if (PPinfo != null) {
            info.setPosition(PPinfo.getPrimaryPosition());
            info.setAdminOrgUnit(PPinfo.getPersonDep());
        }
        return info;
    }

    protected void initData(EventCensorBillInfo billInfo) {
        billInfo.setCreateDate(new Date());
        billInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        billInfo.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        billInfo.setAdminOrg(SysContext.getSysContext().getCurrentAdminUnit());
    }

    protected void checkBillEntry() {
        int count = this.kdtEntrys.getRowCount();
        HashMap<PersonInfo, HistoricalEventInfo> entryMap = new HashMap<PersonInfo, HistoricalEventInfo>();
        if (count == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)ERES, (String)"entriesisNULL"));
            SysUtil.abort();
        }
        for (int i = 0; i < count; ++i) {
            Object person = this.kdtEntrys.getRow(i).getCell("person").getValue();
            Object historicalEvent = this.kdtEntrys.getRow(i).getCell("historicalEvent").getValue();
            if (person == null) {
                MsgBox.showInfo((String)(EASResource.getString((String)ERES, (String)"the") + (i + 1) + EASResource.getString((String)ERES, (String)"personisNULL")));
                this.kdtEntrys.getSelectManager().select(i, this.kdtEntrys.getColumn("person").getColumnIndex());
                SysUtil.abort();
            }
            if (historicalEvent == null) {
                MsgBox.showInfo((String)(EASResource.getString((String)ERES, (String)"the") + (i + 1) + EASResource.getString((String)ERES, (String)"historicalEventisNULL")));
                this.kdtEntrys.getSelectManager().select(i, this.kdtEntrys.getColumn("historicalEvent").getColumnIndex());
                SysUtil.abort();
            }
            if (this.kdtEntrys.getRow(i).getCell("appraisalResult").getValue() == null || this.kdtEntrys.getRow(i).getCell("appraisalResult").getValue().toString().trim().equals("")) {
                MsgBox.showInfo((String)(EASResource.getString((String)ERES, (String)"the") + (i + 1) + EASResource.getString((String)ERES, (String)"appraisalResultisNULL")));
                this.kdtEntrys.getSelectManager().select(i, this.kdtEntrys.getColumn("appraisalResult").getColumnIndex());
                SysUtil.abort();
            }
            entryMap.put((PersonInfo)person, (HistoricalEventInfo)historicalEvent);
        }
        ArrayList personList = null;
        StringBuffer personStr = new StringBuffer();
        try {
            personList = EventCensorBillFactory.getRemoteInstance().getHistoricalEventRepeatPerson(entryMap);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (personList != null && personList.size() > 0) {
            int size = personList.size();
            for (int j = 0; j < size; ++j) {
                personStr.append(((PersonInfo)personList.get(j)).getName());
                personStr.append("\uff0c");
            }
            MsgBox.showInfo((String)(EASResource.getString((String)this.res, (String)"APPLICANT") + personStr.substring(0, personStr.length() - 1) + EASResource.getString((String)this.res, (String)"DE") + EASResource.getString((String)this.res, (String)"HISTORICAL_EVENT") + EASResource.getString((String)this.res, (String)"EXIST")));
            SysUtil.abort();
        }
    }

    protected String[] getNotDupColumn() {
        return new String[]{"person"};
    }

    public boolean isAddPersonByF7() {
        return true;
    }

    public String[] getMethodsSupportPlugIn() {
        return null;
    }

    protected String getIdentityCol() {
        return "identity";
    }

    protected String getDuty() {
        return "duty";
    }

    protected String getContent() {
        return "content";
    }

    protected String getCensorInstitution() {
        return "censorInstitution";
    }

    protected String getAppraisalResult() {
        return "appraisalResult";
    }

    protected String getRemark() {
        return "remark";
    }
}

