/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.base.client.FilterUIUtil;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.state.HistoricalEventInfo;
import com.kingdee.eas.hr.state.client.AbstractEventCensorBillFilterUI;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class EventCensorBillFilterUI
extends AbstractEventCensorBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(EventCensorBillFilterUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllEditor();
    }

    protected void beforeOnLoad() throws Exception {
        this.chkIsSearch.setEnabled(true);
        this.chkIsIncludeOrg.setEnabled(false);
        this.kdradioPerson.setSelected(true);
        this.prmtAdminOrgUnit.setData(null);
        this.prmtAdminOrgUnit.setEnabled(false);
        this.prmtPosition.setData(null);
        this.prmtPosition.setEnabled(false);
    }

    private void initAllEditor() {
        this.kdradioAdminOrgUnit.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    EventCensorBillFilterUI.this.setSelect("org");
                }
                catch (Exception exc) {
                    EventCensorBillFilterUI.this.handUIException(exc);
                }
            }
        });
        this.kdradioPerson.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    EventCensorBillFilterUI.this.setSelect("emp");
                }
                catch (Exception exc) {
                    EventCensorBillFilterUI.this.handUIException(exc);
                }
            }
        });
        this.kdradioPosition.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    EventCensorBillFilterUI.this.setSelect("position");
                }
                catch (Exception exc) {
                    EventCensorBillFilterUI.this.handUIException(exc);
                }
            }
        });
        this.chkIsSearch.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EventCensorBillFilterUI.this.setSearchType();
            }
        });
    }

    public void clear() {
        super.clear();
        this.prmtPerson.setValue(null);
        this.prmtAdminOrgUnit.setValue(null);
        this.prmtPosition.setValue(null);
        this.prmtHistoricalEvent.setValue(null);
        this.kdradioAdminOrgUnit.setSelected(false);
        this.kdradioPerson.setSelected(true);
        this.kdradioPosition.setSelected(false);
        this.chkIsIncludeOrg.setSelected(false);
        this.chkIsSearch.setSelected(false);
        this.txFiledPerson.setText("");
    }

    private void setSelect(String selectType) {
        if ("emp".equals(selectType) && this.kdradioPerson.isSelected()) {
            this.prmtPerson.setEnabled(true);
            this.prmtPerson.setVisible(true);
            this.prmtAdminOrgUnit.setData(null);
            this.prmtAdminOrgUnit.setEnabled(false);
            this.prmtPosition.setData(null);
            this.prmtPosition.setEnabled(false);
            this.chkIsIncludeOrg.setSelected(false);
            this.chkIsIncludeOrg.setEnabled(false);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(true);
            this.txFiledPerson.setEnabled(false);
            this.txFiledPerson.setVisible(false);
        }
        if ("org".equals(selectType) && this.kdradioAdminOrgUnit.isSelected()) {
            this.prmtAdminOrgUnit.setEnabled(true);
            this.chkIsIncludeOrg.setEnabled(true);
            this.prmtPerson.setData(null);
            this.prmtPerson.setEnabled(false);
            this.prmtPerson.setVisible(true);
            this.prmtPosition.setData(null);
            this.prmtPosition.setEnabled(false);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(false);
            this.txFiledPerson.setText(null);
            this.txFiledPerson.setEnabled(false);
            this.txFiledPerson.setVisible(false);
        }
        if ("position".equals(selectType) && this.kdradioPosition.isSelected()) {
            this.prmtPosition.setEnabled(true);
            this.prmtAdminOrgUnit.setData(null);
            this.prmtAdminOrgUnit.setEnabled(false);
            this.prmtPerson.setData(null);
            this.prmtPerson.setEnabled(false);
            this.prmtPerson.setVisible(true);
            this.chkIsIncludeOrg.setSelected(false);
            this.chkIsIncludeOrg.setEnabled(false);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(false);
            this.txFiledPerson.setText(null);
            this.txFiledPerson.setEnabled(false);
            this.txFiledPerson.setVisible(false);
        }
    }

    private void setSearchType() {
        if (this.kdradioPerson.isSelected()) {
            if (this.chkIsSearch.isSelected()) {
                this.prmtPerson.setValue(null);
                this.prmtPerson.setEnabled(false);
                this.prmtPerson.setVisible(false);
                this.txFiledPerson.setEnabled(true);
                this.txFiledPerson.setEditable(true);
                this.txFiledPerson.setVisible(true);
            } else {
                this.prmtPerson.setEnabled(true);
                this.prmtPerson.setVisible(true);
                this.txFiledPerson.setEditable(false);
                this.txFiledPerson.setText(null);
                this.txFiledPerson.setEnabled(false);
                this.txFiledPerson.setVisible(false);
            }
        }
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        register.registerEmployeeMultiF7PromptBox(this.prmtPerson, true);
        register.registerAdminByOrgRangePromptBox(this.prmtAdminOrgUnit, false, false);
        register.registerPositionPromptBox2(this.prmtPosition);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getMainOrg();
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.saveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.retriveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
    }

    public FilterInfo getFilterInfo() {
        Object position;
        HistoricalEventInfo historicalEvent = (HistoricalEventInfo)this.prmtHistoricalEvent.getData();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = filterInfo.getFilterItems();
        FilterItemInfo itemInfo = null;
        if (this.kdradioPerson.isSelected()) {
            Object employee = this.prmtPerson.getData();
            this.setEmployeeFilter(this.chkIsSearch.isSelected(), employee, filterInfo);
        } else if (this.kdradioAdminOrgUnit.isSelected()) {
            Object adminOrg = this.prmtAdminOrgUnit.getData();
            if (adminOrg != null && adminOrg instanceof AdminOrgUnitInfo) {
                this.setAdminOrgFilter(this.chkIsIncludeOrg.isSelected(), (AdminOrgUnitInfo)adminOrg, filterInfo);
            }
        } else if (this.kdradioPosition.isSelected() && (position = this.prmtPosition.getData()) != null && position instanceof PositionInfo) {
            itemInfo = new FilterItemInfo("entries.position.id", (Object)((PositionInfo)position).getId(), CompareType.EQUALS);
            itemCollection.add(itemInfo);
        }
        if (historicalEvent != null) {
            itemInfo = new FilterItemInfo("entries.historicalEvent.id", (Object)historicalEvent.getId().toString(), CompareType.EQUALS);
            itemCollection.add(itemInfo);
        }
        return filterInfo;
    }

    private void setAdminOrgFilter(boolean isIncludeChild, AdminOrgUnitInfo org, FilterInfo filter) {
        if (isIncludeChild) {
            filter.getFilterItems().add(new FilterItemInfo("entries.adminOrgUnit.longNumber", (Object)(org.getLongNumber() + "!%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("entries.adminOrgUnit.number", (Object)org.getNumber(), CompareType.EQUALS));
            filter.setMaskString("#0 or #1");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("entries.adminOrgUnit.id", (Object)org.getId(), CompareType.EQUALS));
        }
    }

    private void setEmployeeFilter(boolean isLikeStyle, Object employee, FilterInfo filter) {
        if (isLikeStyle) {
            String condStr = this.txFiledPerson.getText();
            filter.getFilterItems().add(new FilterItemInfo("entries.person.number", (Object)("%" + condStr + "%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("entries.person.name", (Object)("%" + condStr + "%"), CompareType.LIKE));
            filter.setMaskString("#0 or #1");
        } else if (employee != null && employee instanceof PersonInfo) {
            filter.getFilterItems().add(new FilterItemInfo("entries.person.id", (Object)((PersonInfo)employee).getId().toString(), CompareType.EQUALS));
        }
    }
}

