/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.JButton;

public class HRStateClientUtils {
    private static Pattern pattern = Pattern.compile("^[+\\-]?\\d+(.\\d+)?");
    public static final String pubResource = "com.kingdee.eas.hr.state.MessageResource";

    public static void setMutilTableFromBIM(KDContainer container, KDTable table) {
        container.getContentPane().removeAll();
        container.getContentPane().add((Component)table);
    }

    public static IRow addLine(KDTable table) {
        if (table == null) {
            return null;
        }
        return table.addRow();
    }

    public static IRow insertLine(KDTable table) {
        if (table == null) {
            return null;
        }
        IRow row = null;
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            row = HRStateClientUtils.isTableColumnSelected(table) ? table.addRow() : table.addRow(top);
        } else {
            row = table.addRow();
        }
        return row;
    }

    private static boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    public static int[] getSelectedRows(KDTable table) {
        if (table.getRowCount() == 0 || table.getSelectManager().size() == 0) {
            return new int[0];
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            IBlock block = KDTBlock.change((KDTable)table, (IBlock)table.getSelectManager().get(i));
            for (int j = block.getTop(); j <= block.getBottom(); ++j) {
                if (j < 0) continue;
                set.add(j);
            }
        }
        int[] rows = new int[set.size()];
        Iterator iter = set.iterator();
        int k = 0;
        while (iter.hasNext()) {
            rows[k++] = (Integer)iter.next();
        }
        return rows;
    }

    public static int[] getSelectedColumns(KDTable table) {
        if (table.getSelectManager().size() == 0) {
            return new int[0];
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            IBlock block = KDTBlock.change((KDTable)table, (IBlock)table.getSelectManager().get(i));
            for (int j = block.getLeft(); j <= block.getRight(); ++j) {
                set.add(j);
            }
        }
        int[] columns = new int[set.size()];
        Iterator iter = set.iterator();
        int k = 0;
        while (iter.hasNext()) {
            columns[k++] = (Integer)iter.next();
        }
        return columns;
    }

    public static void removeRow(KDTable table, int rowIndex) {
        IObjectCollection collection;
        int index;
        Object detailData = table.getRow(rowIndex).getUserObject();
        table.removeRow(rowIndex);
        if (detailData != null && (index = HRStateClientUtils.getCollectionIndex(collection = (IObjectCollection)table.getUserObject(), (IObjectValue)detailData)) >= 0 && collection.size() > index) {
            collection.removeObject(index);
        }
    }

    private static int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    public static void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0 || HRStateClientUtils.isTableColumnSelected(table)) {
            return;
        }
        int[] selectRowsIndex = HRStateClientUtils.getSelectedRows(table);
        if (selectRowsIndex.length > 0) {
            int[] selectedColumnIndexs = HRStateClientUtils.getSelectedColumns(table);
            Arrays.sort(selectRowsIndex);
            for (int i = selectRowsIndex.length - 1; i >= 0; --i) {
                HRStateClientUtils.removeRow(table, selectRowsIndex[i]);
            }
            if (table.getRowCount() > 0) {
                Arrays.sort(selectedColumnIndexs);
                int columnIndex = 0;
                if (selectedColumnIndexs.length > 0) {
                    columnIndex = selectedColumnIndexs[0];
                }
                table.getSelectManager().select(selectRowsIndex[0], columnIndex);
            }
        }
    }

    public static void initMutilTableFromBIM(KDContainer container, Action actionAddLine2, Action actionInsertLine2, Action actionRemoveLine) {
        JButton btnAddLine = container.add(actionAddLine2);
        btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        btnAddLine.setToolTipText("\u65b0\u589e\u5206\u5f55");
        btnAddLine.setText(null);
        JButton btnInsertLine = container.add(actionInsertLine2);
        btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        btnInsertLine.setToolTipText("\u63d2\u5165\u5206\u5f55");
        btnInsertLine.setText(null);
        JButton btnRemoveLine = container.add(actionRemoveLine);
        btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        btnRemoveLine.setToolTipText("\u5220\u9664\u5206\u5f55");
        btnRemoveLine.setText(null);
    }

    public static ItemAction[] addButtonsToMutilTable(KDContainer container, KDTable table) {
        HRStateClientUtils.setMutilTableFromBIM(container, table);
        class _cls1ActionRow
        extends ItemAction {
            private String name;
            private KDTable table;

            public void actionPerformed(ActionEvent e) {
                if (!"ActionAddLine".equals(this.name) && !"ActionInsertLine".equals(this.name) && "ActionRemoveLine".equals(this.name)) {
                    HRStateClientUtils.removeLine(this.table);
                }
            }

            _cls1ActionRow(KDTable table, String name) {
                this.table = table;
                this.name = name;
            }
        }
        _cls1ActionRow actionAddLine2 = new _cls1ActionRow(table, "ActionAddLine");
        _cls1ActionRow actionInsertLine2 = new _cls1ActionRow(table, "ActionInsertLine");
        _cls1ActionRow actionRemoveLine = new _cls1ActionRow(table, "ActionRemoveLine");
        HRStateClientUtils.initMutilTableFromBIM(container, (Action)((Object)actionAddLine2), (Action)((Object)actionInsertLine2), (Action)((Object)actionRemoveLine));
        ItemAction[] actions = new ItemAction[]{actionAddLine2, actionInsertLine2, actionRemoveLine};
        return actions;
    }

    public static String getDatePatternStr() {
        return "yyyy-MM-dd";
    }

    public static boolean isNumeric(String str) {
        return pattern.matcher(str).matches();
    }

    public static void verifyEmpty(CoreUIObject ui, KDTextField txtNumber) {
        HRStateClientUtils.verifyEmpty(ui, null, txtNumber, null);
    }

    public static void verifyEmpty(CoreUIObject ui, KDBizMultiLangBox txtName) {
        HRStateClientUtils.verifyEmpty(ui, null, txtName, null);
    }

    public static void verifyEmpty(CoreUIObject ui, KDBizPromptBox bizBox) {
        HRStateClientUtils.verifyEmpty(ui, null, bizBox, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDBizMultiLangBox txtName, String msg) {
        Object txt = txtName.getSelectedItem();
        if (txt == null || txt.toString().trim().equals("")) {
            txtName.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath != null && msg != null ? EASResource.getString((String)resourcePath, (String)msg) : HRStateClientUtils.getMessage((Component)txtName)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDTextField txtNumber, String msg) {
        if (!txtNumber.isEnabled()) {
            return;
        }
        String txt = txtNumber.getText();
        if (txt == null || txt.trim().equals("")) {
            txtNumber.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath != null && msg != null ? EASResource.getString((String)resourcePath, (String)msg) : HRStateClientUtils.getMessage((Component)txtNumber)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDBizPromptBox bizBox, String msg) {
        Object content = bizBox.getData();
        if (content == null) {
            bizBox.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath != null && msg != null ? EASResource.getString((String)resourcePath, (String)msg) : HRStateClientUtils.getMessage((Component)bizBox)));
            SysUtil.abort();
        }
    }

    public static String getMessage(Component component) {
        String text = HRStateClientUtils.getBoundLabelText(component);
        return text + EASResource.getString((String)pubResource, (String)"CanNotBeNull");
    }

    private static String getBoundLabelText(Component component) {
        String text = "";
        if (component.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)component.getParent()).getBoundLabelText();
        }
        return text;
    }

    public static int getCurrentRowIndex(KDTable kdTable) {
        int rowIndex = -1;
        KDTSelectBlock selectBlock = kdTable.getSelectManager().get();
        if (selectBlock != null) {
            rowIndex = selectBlock.getTop();
        }
        return rowIndex;
    }

    public static PersonPositionInfo getPersonPositionInfo(BOSUuid personID) throws Exception {
        String oql = "select primaryPosition.id, primaryPosition.name, primaryPosition.number ,id,personDep.id,personDep.name,personDep.number where person.id = '" + personID + "'";
        PersonPositionCollection c = PersonPositionFactory.getRemoteInstance().getPersonPositionCollection(oql);
        if (c.size() > 0) {
            return c.get(0);
        }
        return null;
    }

    public static PersonInfo getPersonInfo(BOSUuid personID) throws Exception {
        String oql = "select id, name where id = '" + personID + "'";
        PersonCollection c = PersonFactory.getRemoteInstance().getPersonCollection(oql);
        if (c.size() > 0) {
            return c.get(0);
        }
        return null;
    }

    public static String getResource(String RES, String message) {
        return EASResource.getString((String)RES, (String)message);
    }

    public static String getResource(String RES, String message, Object[] params) {
        String str = HRStateClientUtils.getResource(RES, message);
        return MessageFormat.format(str, params);
    }

    public static void showErrorMessage(String RES, String message, CoreUI uiObject) {
        MsgBox.showError((Component)uiObject, (String)HRStateClientUtils.getResource(RES, message));
        uiObject.setCursorOfDefault();
        SysUtil.abort();
    }

    public static final String QBchange(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] >= '\uff5e') continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }

    public static HROrgUnitInfo getCurrentHROrgUnit() {
        HROrgUnitInfo info = SysContext.getSysContext().getCurrentHRUnit();
        return info;
    }

    public static boolean checkFull_width(String number) {
        boolean checked = false;
        byte[] bytes = number.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != -95) continue;
            bytes[i] = 32;
        }
        number = new String(bytes).trim();
        if (number.trim().equals("") || number == null) {
            checked = true;
        }
        return checked;
    }

    public static long getCompareDate(Date startDate, Date endDate) {
        long len = endDate.getTime() - startDate.getTime();
        long days = len / 86400000L;
        return days;
    }

    public static FilterItemInfo getHRAndAdminRangeFilterInfo(String orgUnitColumnName, String hrOrgUnitID) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgUnitID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        FilterItemInfo item = new FilterItemInfo(orgUnitColumnName, (Object)sql.toString(), CompareType.INNER);
        return item;
    }
}

