/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTimePicker;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.state.HRStatTWOReportFacadeFactory;
import com.kingdee.eas.hr.state.IHRStatTWOReportFacade;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.Date;
import java.util.regex.Pattern;

public class HRStateTWOClientUtils {
    private static Pattern pattern = Pattern.compile("^[+\\-]?\\d+(.\\d+)?");
    public static final String pubResource = "com.kingdee.eas.hr.state.MessageTWOResource";

    public static String getDatePatternStr() {
        return "yyyy-MM-dd";
    }

    public static boolean isNumeric(String str) {
        return pattern.matcher(str).matches();
    }

    public static void verifyEmpty(CoreUIObject ui, KDTextField txtNumber) {
        HRStateTWOClientUtils.verifyEmpty(ui, null, txtNumber, null);
    }

    public static void verifyEmpty(CoreUIObject ui, KDBizMultiLangBox txtName) {
        HRStateTWOClientUtils.verifyEmpty(ui, null, txtName, null);
    }

    public static void verifyEmpty(CoreUIObject ui, KDDatePicker date) {
        HRStateTWOClientUtils.verifyEmpty(ui, null, date, null);
    }

    public static void verifyEmpty(CoreUIObject ui, KDTextArea textAreacontent) {
        HRStateTWOClientUtils.verifyEmpty(ui, null, textAreacontent, null);
    }

    public static void checkFullWidthBlank(String number) {
        boolean checked = false;
        if (number != null && (checked = HRStateTWOClientUtils.checkFull_width(number))) {
            MsgBox.showInfo((String)EASResource.getString((String)pubResource, (String)"BillNumber_Not_Null"));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDBizPromptBox bizBox) {
        HRStateTWOClientUtils.verifyEmpty(ui, null, bizBox, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDBizMultiLangBox txtName, String msg) {
        Object txt = txtName.getSelectedItem();
        if (txt == null || txt.toString().trim().equals("")) {
            txtName.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath != null && msg != null ? EASResource.getString((String)resourcePath, (String)msg) : HRStateTWOClientUtils.getMessage((Component)txtName)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDTextField txtNumber, String msg) {
        if (!txtNumber.isEnabled()) {
            return;
        }
        String txt = txtNumber.getText();
        if (txt == null || txt.trim().equals("")) {
            txtNumber.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath != null && msg != null ? EASResource.getString((String)resourcePath, (String)msg) : HRStateTWOClientUtils.getMessage((Component)txtNumber)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDDatePicker date, String msg) {
        Object content = date.getValue();
        if (content == null) {
            date.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath != null && msg != null ? EASResource.getString((String)resourcePath, (String)msg) : HRStateTWOClientUtils.getMessage((Component)date)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDTimePicker time, String msg) {
        Object content = time.getValue();
        if (content == null) {
            time.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath != null && msg != null ? EASResource.getString((String)resourcePath, (String)msg) : HRStateTWOClientUtils.getMessage((Component)time)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDBizPromptBox bizBox, String msg) {
        Object content = bizBox.getData();
        if (content == null) {
            bizBox.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath != null && msg != null ? EASResource.getString((String)resourcePath, (String)msg) : HRStateTWOClientUtils.getMessage((Component)bizBox)));
            SysUtil.abort();
        }
    }

    public static String getMessage(Component component) {
        String text = HRStateTWOClientUtils.getBoundLabelText(component);
        return text + EASResource.getString((String)pubResource, (String)"CanNotBeNull");
    }

    private static String getBoundLabelText(Component component) {
        String text = "";
        if (component.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)component.getParent()).getBoundLabelText();
        }
        if (text.length() != 0 && (text.substring(text.length() - 1).equals(":") || text.substring(text.length() - 1).equals("\uff1a"))) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    public static int getCurrentRowIndex(KDTable kdTable) {
        int rowIndex = -1;
        KDTSelectBlock selectBlock = kdTable.getSelectManager().get();
        if (selectBlock != null) {
            rowIndex = selectBlock.getTop();
        }
        return rowIndex;
    }

    public static PersonPositionInfo getPersonPositionInfo(BOSUuid personID) throws Exception {
        String oql = "select primaryPosition.id, primaryPosition.name, primaryPosition.number ,id,personDep.id,personDep.name,personDep.number where person.id = '" + personID + "'";
        PersonPositionCollection c = PersonPositionFactory.getRemoteInstance().getPersonPositionCollection(oql);
        if (c.size() > 0) {
            return c.get(0);
        }
        return null;
    }

    public static PersonInfo getPersonInfo(BOSUuid personID) throws Exception {
        String oql = "select id, name where id = '" + personID + "'";
        PersonCollection c = PersonFactory.getRemoteInstance().getPersonCollection(oql);
        if (c.size() > 0) {
            return c.get(0);
        }
        return null;
    }

    public static String getResource(String RES, String message) {
        return EASResource.getString((String)RES, (String)message);
    }

    public static String getResource(String RES, String message, Object[] params) {
        String str = HRStateTWOClientUtils.getResource(RES, message);
        return MessageFormat.format(str, params);
    }

    public static void showErrorMessage(String RES, String message, CoreUI uiObject) {
        MsgBox.showError((Component)uiObject, (String)HRStateTWOClientUtils.getResource(RES, message));
        uiObject.setCursorOfDefault();
        SysUtil.abort();
    }

    public static final String QBchange(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] >= '\uff5e') continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }

    public static HROrgUnitInfo getCurrentHROrgUnit() {
        HROrgUnitInfo info = SysContext.getSysContext().getCurrentHRUnit();
        return info;
    }

    public static boolean checkFull_width(String number) {
        boolean checked = false;
        byte[] bytes = number.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != -95) continue;
            bytes[i] = 32;
        }
        number = new String(bytes).trim();
        if (number.trim().equals("") || number == null) {
            checked = true;
        }
        return checked;
    }

    public static long getCompareDate(Date startDate, Date endDate) {
        long len = endDate.getTime() - startDate.getTime();
        long days = len / 86400000L;
        return days;
    }

    protected static boolean confirmAudit() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((String)EASResource.getString((String)pubResource, (String)"Confirm_Audit")));
    }

    public static FilterItemInfo getHRAndAdminRangeFilterInfo(String orgUnitColumnName, String hrOrgUnitID) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgUnitID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        FilterItemInfo item = new FilterItemInfo(orgUnitColumnName, (Object)sql.toString(), CompareType.INNER);
        return item;
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDTextArea textArea, String msg) {
        if (!textArea.isEnabled()) {
            return;
        }
        String content = textArea.getText();
        if (content == null || content.toString().trim().equals("")) {
            textArea.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath != null && msg != null ? EASResource.getString((String)resourcePath, (String)msg) : HRStateTWOClientUtils.getMessage((Component)textArea)));
            SysUtil.abort();
        }
    }

    public static IRowSet query(EntityViewInfo view, String queryPath, String queryName) throws BOSException {
        if (queryPath == null || queryPath.trim().equals("")) {
            return null;
        }
        if (queryName == null || queryName.trim().equals("")) {
            return null;
        }
        IRowSet dataRows = null;
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(queryPath, queryName));
        iqec.setObjectView(view);
        dataRows = iqec.executeQuery();
        return dataRows;
    }

    public static String metaQueryToSQL(EntityViewInfo view, String queryPath, String queryName) throws BOSException {
        if (queryPath == null || queryPath.trim().equals("")) {
            return null;
        }
        if (queryName == null || queryName.trim().equals("")) {
            return null;
        }
        String sql = null;
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(queryPath, queryName));
        iqec.setObjectView(view);
        sql = iqec.getSQL();
        return sql;
    }

    public static IRowSet query(String queryStr) throws BOSException {
        IRowSet dataRows = null;
        IHRStatTWOReportFacade tool = HRStatTWOReportFacadeFactory.getRemoteInstance();
        dataRows = tool.createQuery(queryStr);
        return dataRows;
    }

    public static void makeMaskString(StringBuffer maskString, int index, String logicWord) {
        if (index == 0) {
            maskString.append("#" + index);
        } else {
            maskString.append(logicWord + "#" + index);
        }
    }

    public static FilterItemInfo getDefaultFilterForQuery(String adminOrg) {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userId);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        FilterItemInfo filterItem = new FilterItemInfo(adminOrg, (Object)sql.toString(), CompareType.INNER);
        return filterItem;
    }
}

