/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.base.client.FilterUIUtil;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.state.client.AbstractInjuryFilingBillFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class InjuryFilingBillFilterUI
extends AbstractInjuryFilingBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(InjuryFilingBillFilterUI.class);
    private static final String RES = "com.kingdee.eas.hr.state.JobInjuryResource";
    public static final String LATITUDE_TYPE_ADMINORG = "adminOrg";
    public static final String LATITUDE_TYPE_POSITION = "position";
    public static final String LATITUDE_TYPE_PERSON = "person";
    private static final String MESRES = "com.kingdee.eas.hr.state.MessageTWOResource";
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllEditor();
    }

    private void initAllEditor() {
        this.kdbGroup.add((AbstractButton)this.kDRadioAdminOrg);
        this.kdbGroup.add((AbstractButton)this.kDRadioPosition);
        this.kdbGroup.add((AbstractButton)this.kDRadioEmployees);
        this.kDRadioAdminOrg.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    InjuryFilingBillFilterUI.this.setSelect(InjuryFilingBillFilterUI.LATITUDE_TYPE_ADMINORG);
                }
                catch (Exception exc) {
                    InjuryFilingBillFilterUI.this.handUIException(exc);
                }
            }
        });
        this.kDRadioEmployees.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    InjuryFilingBillFilterUI.this.setSelect(InjuryFilingBillFilterUI.LATITUDE_TYPE_PERSON);
                }
                catch (Exception exc) {
                    InjuryFilingBillFilterUI.this.handUIException(exc);
                }
            }
        });
        this.kDRadioPosition.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    InjuryFilingBillFilterUI.this.setSelect(InjuryFilingBillFilterUI.LATITUDE_TYPE_POSITION);
                }
                catch (Exception exc) {
                    InjuryFilingBillFilterUI.this.handUIException(exc);
                }
            }
        });
        this.chkIsSearch.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                InjuryFilingBillFilterUI.this.setSearchType();
            }
        });
    }

    public void clear() {
        super.clear();
        this.prmtEmployees.setValue(null);
        this.prmtAdminOrg.setValue(null);
        this.prmtPosition.setValue(null);
        this.kDRadioAdminOrg.setSelected(false);
        this.kDRadioEmployees.setSelected(true);
        this.kDRadioPosition.setSelected(false);
        this.chkIsSearch.setSelected(false);
        this.chkIsIncludeOrg.setSelected(false);
        this.txtEmployees.setText("");
        this.pkDateEnd.setValue(null);
        this.pkDateEnd2.setValue(null);
        this.pkDateBegin.setValue(null);
        this.pkDateBegin2.setValue(null);
    }

    public boolean verify() {
        if (this.prmtHROrg.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)MESRES, (String)"mustInputHr"));
            this.prmtHROrg.requestFocus();
            SysUtil.abort();
        }
        Date DateBegin = (Date)this.pkDateBegin.getValue();
        Date DateEnd = (Date)this.pkDateEnd.getValue();
        Date DateBegin2 = (Date)this.pkDateBegin2.getValue();
        Date DateEnd2 = (Date)this.pkDateEnd2.getValue();
        Date Date1 = DateEnd;
        Date Date2 = DateBegin2;
        if (DateBegin != null && DateEnd != null && DateBegin.getTime() > DateEnd.getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"ApplyDate"));
            this.pkDateEnd.requestFocus();
            SysUtil.abort();
        }
        if (DateEnd == null) {
            Date1 = DateBegin;
        }
        if (DateBegin2 == null) {
            Date2 = DateEnd2;
        }
        if (Date1 != null && Date2 != null && Date1.getTime() > Date2.getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"DetermineDate"));
            SysUtil.abort();
        }
        return super.verify();
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        register.registerAdminByOrgRangePromptBox(this.prmtAdminOrg);
        register.registerEmployeeMultiF7PromptBox(this.prmtEmployees, true);
        register.registerPositionPromptBox2(this.prmtPosition);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getMainOrg();
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.saveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.retriveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
    }

    private void setSearchType() {
        boolean style = this.chkIsSearch.isSelected();
        if (style) {
            this.prmtEmployees.setValue(null);
            this.prmtEmployees.setEnabled(false);
            this.prmtEmployees.setVisible(false);
            this.txtEmployees.setEnabled(true);
            this.txtEmployees.setVisible(true);
        } else {
            this.prmtEmployees.setEnabled(true);
            this.prmtEmployees.setVisible(true);
            this.txtEmployees.setText("");
            this.txtEmployees.setEnabled(false);
            this.txtEmployees.setVisible(false);
        }
    }

    private void setSelect(String selectType) {
        if (selectType.equals(LATITUDE_TYPE_ADMINORG) && this.kDRadioAdminOrg.isSelected()) {
            this.prmtAdminOrg.setEnabled(true);
            this.chkIsIncludeOrg.setEnabled(true);
            this.chkIsIncludeOrg.setSelected(false);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(false);
            this.setSearchType();
            this.prmtEmployees.setEnabled(false);
            this.prmtEmployees.setValue(null);
            this.prmtPosition.setEnabled(false);
            this.prmtPosition.setValue(null);
        } else if (selectType.equals(LATITUDE_TYPE_PERSON) && this.kDRadioEmployees.isSelected()) {
            this.chkIsSearch.setEnabled(true);
            this.chkIsSearch.setSelected(false);
            this.setSearchType();
            this.prmtAdminOrg.setEnabled(false);
            this.prmtAdminOrg.setValue(null);
            this.chkIsIncludeOrg.setSelected(false);
            this.chkIsIncludeOrg.setEnabled(false);
            this.prmtPosition.setEnabled(false);
            this.prmtPosition.setValue(null);
        } else if (selectType.equals(LATITUDE_TYPE_POSITION) && this.kDRadioPosition.isSelected()) {
            this.prmtPosition.setEnabled(true);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(false);
            this.setSearchType();
            this.chkIsIncludeOrg.setSelected(false);
            this.chkIsIncludeOrg.setEnabled(false);
            this.prmtEmployees.setEnabled(false);
            this.prmtEmployees.setValue(null);
            this.prmtAdminOrg.setEnabled(false);
            this.prmtAdminOrg.setValue(null);
        }
    }

    public FilterInfo getFilterInfo() {
        Object position;
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = filterInfo.getFilterItems();
        FilterItemInfo itemInfo = null;
        if (this.kDRadioEmployees.isSelected()) {
            Object Person = this.prmtEmployees.getData();
            this.setPersonFilter(this.chkIsSearch.isSelected(), Person, filterInfo);
        } else if (this.kDRadioAdminOrg.isSelected()) {
            Object adminOrg = this.prmtAdminOrg.getData();
            if (adminOrg != null && adminOrg instanceof AdminOrgUnitInfo) {
                this.setAdminOrgFilter(this.chkIsIncludeOrg.isSelected(), (AdminOrgUnitInfo)adminOrg, filterInfo);
            }
        } else if (this.kDRadioPosition.isSelected() && (position = this.prmtPosition.getData()) != null && position instanceof PositionInfo) {
            itemInfo = new FilterItemInfo("position.id", (Object)((PositionInfo)position).getId(), CompareType.EQUALS);
            itemCollection.add(itemInfo);
        }
        if (this.pkDateBegin.getValue() != null) {
            itemCollection.add(new FilterItemInfo("entrys.occurrenceTime", (Object)((Date)this.pkDateBegin.getValue()), CompareType.GREATER_EQUALS));
        }
        if (this.pkDateEnd.getValue() != null) {
            Date endDateEnd = (Date)this.pkDateEnd.getValue();
            Date nextDate = new Date();
            if (endDateEnd != null) {
                long nd = endDateEnd.getTime() / 1000L + 86400L;
                nextDate.setTime(nd * 1000L);
                itemCollection.add(new FilterItemInfo("entrys.occurrenceTime", (Object)this.simpleDateFormat.format(nextDate), CompareType.LESS_EQUALS));
            }
        }
        if (this.pkDateBegin2.getValue() != null) {
            itemCollection.add(new FilterItemInfo("entrys.determineDate", (Object)((Date)this.pkDateBegin2.getValue()), CompareType.GREATER_EQUALS));
        }
        if (this.pkDateEnd2.getValue() != null) {
            itemCollection.add(new FilterItemInfo("entrys.determineDate", (Object)((Date)this.pkDateEnd2.getValue()), CompareType.LESS_EQUALS));
        }
        return filterInfo;
    }

    private void setPersonFilter(boolean isLikeStyle, Object person, FilterInfo filter) {
        if (isLikeStyle) {
            String condStr = this.txtEmployees.getText();
            if (filter.getFilterItems().size() > 0) {
                FilterInfo personFilter = new FilterInfo();
                personFilter.getFilterItems().add(new FilterItemInfo("entrys.perNum.number", (Object)("%" + condStr + "%"), CompareType.LIKE));
                personFilter.getFilterItems().add(new FilterItemInfo("entrys.person.name", (Object)("%" + condStr + "%"), CompareType.LIKE));
                personFilter.setMaskString("#0 or #1");
                try {
                    filter.mergeFilter(personFilter, "and");
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("entrys.perNum.number", (Object)("%" + condStr + "%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("entrys.person.name", (Object)("%" + condStr + "%"), CompareType.LIKE));
                filter.setMaskString("#0 or #1");
            }
        } else if (person != null && person instanceof PersonInfo) {
            filter.getFilterItems().add(new FilterItemInfo("entrys_person.id", (Object)((PersonInfo)person).getId(), CompareType.EQUALS));
        }
    }

    private void setAdminOrgFilter(boolean isIncludeChild, AdminOrgUnitInfo org, FilterInfo filter) {
        if (isIncludeChild) {
            if (filter.getFilterItems().size() > 0) {
                FilterInfo orgFilter = new FilterInfo();
                orgFilter.getFilterItems().add(new FilterItemInfo("adminOrg1.longNumber", (Object)(org.getLongNumber() + "!%"), CompareType.LIKE));
                orgFilter.getFilterItems().add(new FilterItemInfo("adminOrg1.number", (Object)org.getNumber(), CompareType.EQUALS));
                orgFilter.setMaskString("#0 or #1");
                try {
                    filter.mergeFilter(orgFilter, "and");
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("adminOrg1.longNumber", (Object)(org.getLongNumber() + "!%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("adminOrg1.number", (Object)org.getNumber(), CompareType.EQUALS));
                filter.setMaskString("#0 or #1");
            }
        } else {
            filter.getFilterItems().add(new FilterItemInfo("adminOrg1.id", (Object)org.getId(), CompareType.EQUALS));
        }
    }
}

