/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.base.client.PlugInUIDecorator;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.state.InjuryRateFactory;
import com.kingdee.eas.hr.state.InjuryRateInfo;
import com.kingdee.eas.hr.state.InjuryTypesFactory;
import com.kingdee.eas.hr.state.InjuryTypesInfo;
import com.kingdee.eas.hr.state.client.AbstractInjuryStatFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class InjuryStatFilterUI
extends AbstractInjuryStatFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(InjuryStatFilterUI.class);
    protected final String MessageRES = "com.kingdee.eas.hr.state.MessageTWOResource";
    private int latitudeType;
    protected PlugInUIDecorator plugin = (PlugInUIDecorator)super.getPlugIn();

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.initFirstEditor();
    }

    public void clear() {
        super.clear();
        this.initFirstEditor();
    }

    private void initFirstEditor() {
        this.pkOccurDateFrom.setValue(null);
        this.pkOccurDateTo.setValue(null);
        this.pkDeterDateFrom.setValue(null);
        this.pkDeterDateTo.setValue(null);
        this.prmtAdminOrg.setValue(null);
        this.kdRadioAdminOrg.setSelected(true);
        this.prmtAdminOrg.setEnabled(true);
        this.prmtPosition.setEnabled(false);
        this.prmtPosition.setValue(null);
        this.chkIncludeChild.setEnabled(true);
        this.chkIncludeChild.setSelected(false);
        this.prmtRates.setValue(null);
        this.prmtTypes.setValue(null);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllEditor();
        this.initFirstEditor();
        this.latitudeType = 0;
    }

    private void initAllEditor() {
        this.kdRadioAdminOrg.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                InjuryStatFilterUI.this.setSelect("adminOrg");
            }
        });
        this.kdRadioPosition.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                InjuryStatFilterUI.this.setSelect("position");
            }
        });
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        AdminByOrgRangePromptBox adminOrgF7 = new AdminByOrgRangePromptBox();
        this.prmtAdminOrg.setEditFormat("$number$");
        this.prmtAdminOrg.setDisplayFormat("$name$");
        this.prmtAdminOrg.setCommitFormat("$number$");
        this.prmtAdminOrg.setSelector((KDPromptSelector)adminOrgF7);
        PositionPromptBox2 positionF7 = new PositionPromptBox2();
        this.prmtPosition.setEditFormat("$number$");
        this.prmtPosition.setDisplayFormat("$name$");
        this.prmtPosition.setCommitFormat("$number$");
        this.prmtPosition.setSelector((KDPromptSelector)positionF7);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getMainOrg();
    }

    public boolean verify() {
        Date endDate;
        Date startDate;
        if (this.pkOccurDateFrom.getValue() != null && this.pkOccurDateTo.getValue() != null && (startDate = (Date)this.pkOccurDateFrom.getValue()).after(endDate = (Date)this.pkOccurDateTo.getValue())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.state.MessageTWOResource", (String)"OccurDateToAfterFrom"));
            this.pkOccurDateTo.requestFocus();
            SysUtil.abort();
            return false;
        }
        if (this.pkDeterDateFrom.getValue() != null && this.pkDeterDateTo.getValue() != null && (startDate = (Date)this.pkDeterDateFrom.getValue()).after(endDate = (Date)this.pkDeterDateTo.getValue())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.state.MessageTWOResource", (String)"DeterDateToAfterFrom"));
            this.pkDeterDateTo.requestFocus();
            SysUtil.abort();
            return false;
        }
        return true;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = filterInfo.getFilterItems();
        if (this.pkOccurDateFrom.getValue() != null) {
            itemCollection.add(new FilterItemInfo("occurrenceTime", (Object)((Date)this.pkOccurDateFrom.getValue()), CompareType.GREATER_EQUALS));
        }
        if (this.pkOccurDateTo.getValue() != null) {
            itemCollection.add(new FilterItemInfo("occurrenceTime", (Object)this.endDate((Date)this.pkOccurDateTo.getValue()), CompareType.LESS_EQUALS));
        }
        if (this.pkDeterDateFrom.getValue() != null) {
            itemCollection.add(new FilterItemInfo("determineDate", (Object)((Date)this.pkDeterDateFrom.getValue()), CompareType.GREATER_EQUALS));
        }
        if (this.pkDeterDateTo.getValue() != null) {
            itemCollection.add(new FilterItemInfo("determineDate", (Object)this.endDate((Date)this.pkDeterDateTo.getValue()), CompareType.LESS_EQUALS));
        }
        if (this.kdRadioPosition.isSelected() && this.prmtPosition.getValue() != null) {
            itemCollection.add(new FilterItemInfo("position.id", (Object)((PositionInfo)this.prmtPosition.getValue()).getId(), CompareType.EQUALS));
        }
        if (this.kdRadioAdminOrg.isSelected() && this.prmtAdminOrg.getValue() != null) {
            this.setAdminOrgFilter(this.chkIncludeChild.isSelected(), (AdminOrgUnitInfo)this.prmtAdminOrg.getValue(), filterInfo);
        }
        if (itemCollection.size() == 0) {
            itemCollection.add(new FilterItemInfo("id", null, CompareType.ISNOT));
        }
        return filterInfo;
    }

    private Date endDate(Date temp) {
        if (temp != null) {
            Date nextDate = new Date();
            long nd = temp.getTime() / 1000L + 86400L;
            nextDate.setTime(nd * 1000L);
            return nextDate;
        }
        return null;
    }

    @Override
    protected void kdRadioAdminOrg_stateChanged(ChangeEvent e) throws Exception {
        this.btnLatitude_stateChange();
    }

    @Override
    protected void kdRadioPosition_stateChanged(ChangeEvent e) throws Exception {
        this.btnLatitude_stateChange();
    }

    private void btnLatitude_stateChange() {
        if (this.kdRadioAdminOrg.isSelected()) {
            this.latitudeType = 0;
        } else if (this.kdRadioPosition.isSelected()) {
            this.latitudeType = 1;
        }
    }

    public HashMap getStatusMap() {
        int i;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("latitudeType", this.latitudeType);
        map.put("isIncludeChild", this.chkIncludeChild.isSelected());
        map.put("types", new HashSet());
        map.put("rates", new HashSet());
        if (this.prmtAdminOrg.getValue() != null) {
            map.put("adminID", ((AdminOrgUnitInfo)this.prmtAdminOrg.getValue()).getId().toString());
            map.put("longNumber", ((AdminOrgUnitInfo)this.prmtAdminOrg.getValue()).getLongNumber());
        }
        if (this.prmtPosition.getValue() != null) {
            map.put("positionID", ((PositionInfo)this.prmtPosition.getValue()).getId().toString());
        }
        if (this.prmtHROrg.getValue() != null) {
            map.put("hrOrgID", ((HROrgUnitInfo)this.prmtHROrg.getValue()).getId().toString());
        }
        if (this.prmtTypes.getValue() != null) {
            Object[] types = (Object[])this.prmtTypes.getValue();
            HashSet<String> typesIDSet = new HashSet<String>();
            for (i = 0; i < types.length; ++i) {
                if (types[i] == null) continue;
                typesIDSet.add(((InjuryTypesInfo)types[i]).getId().toString());
            }
            map.put("types", typesIDSet);
        }
        if (this.prmtRates.getValue() != null) {
            Object[] rates = (Object[])this.prmtRates.getValue();
            HashSet<String> ratesIDSet = new HashSet<String>();
            for (i = 0; i < rates.length; ++i) {
                if (rates[i] == null) continue;
                ratesIDSet.add(((InjuryRateInfo)rates[i]).getId().toString());
            }
            map.put("rates", ratesIDSet);
        }
        return map;
    }

    private void setSelect(String selectType) {
        if ("adminOrg".equals(selectType) && this.kdRadioAdminOrg.isSelected()) {
            this.chkIncludeChild.setEnabled(true);
            this.chkIncludeChild.setSelected(false);
            this.prmtAdminOrg.setEnabled(true);
            this.prmtPosition.setData(null);
            this.prmtPosition.setEnabled(false);
        } else if ("position".equals(selectType) && this.kdRadioPosition.isSelected()) {
            this.chkIncludeChild.setSelected(false);
            this.chkIncludeChild.setEnabled(false);
            this.prmtPosition.setEnabled(true);
            this.prmtAdminOrg.setData(null);
            this.prmtAdminOrg.setEnabled(false);
        }
    }

    private void setAdminOrgFilter(boolean isIncludeChild, AdminOrgUnitInfo org, FilterInfo filter) {
        if (isIncludeChild) {
            FilterInfo orgFilter = new FilterInfo();
            orgFilter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(org.getLongNumber() + "!%"), CompareType.LIKE));
            orgFilter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)org.getNumber(), CompareType.EQUALS));
            orgFilter.setMaskString("#0 or #1");
            try {
                filter.mergeFilter(orgFilter, "and");
            }
            catch (BOSException e) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.state.MessageTWOResource", (String)"FilterError"));
                SysUtil.abort();
            }
        } else {
            filter.getFilterItems().add(new FilterItemInfo("adminOrg.id", (Object)org.getId(), CompareType.EQUALS));
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        cp.putInt("latitudeType", this.latitudeType);
        cp.putDate("pkOccurDateFrom", (Date)this.pkOccurDateFrom.getValue());
        cp.putDate("pkOccurDateTo", (Date)this.pkOccurDateTo.getValue());
        cp.putDate("pkDeterDateFrom", (Date)this.pkDeterDateFrom.getValue());
        cp.putDate("pkDeterDateTo", (Date)this.pkDeterDateTo.getValue());
        if (this.kdRadioAdminOrg.isSelected()) {
            if (this.prmtAdminOrg.getValue() != null) {
                cp.addCustomerParam("adminID", ((AdminOrgUnitInfo)this.prmtAdminOrg.getValue()).getId().toString());
            }
            cp.putBoolean("isIncludeChild", this.chkIncludeChild.isSelected());
        }
        if (this.kdRadioPosition.isSelected() && this.prmtPosition.getValue() != null) {
            cp.addCustomerParam("positionID", ((PositionInfo)this.prmtPosition.getValue()).getId().toString());
        }
        Object[] types = null;
        int i = 0;
        if (this.prmtTypes.getValue() != null) {
            types = (Object[])this.prmtTypes.getValue();
            for (i = 0; i < types.length; ++i) {
                if (!(types[i] instanceof InjuryTypesInfo)) continue;
                cp.addCustomerParam("typesID" + i, ((InjuryTypesInfo)types[i]).getId().toString());
            }
        }
        cp.putInt("typesCount", i);
        Object[] rates = null;
        i = 0;
        if (this.prmtRates.getValue() != null) {
            rates = (Object[])this.prmtRates.getValue();
            for (i = 0; i < rates.length; ++i) {
                if (!(rates[i] instanceof InjuryRateInfo)) continue;
                cp.addCustomerParam("ratesID" + i, ((InjuryRateInfo)rates[i]).getId().toString());
            }
        }
        cp.putInt("ratesCount", i);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            this._setCustomerParams(cp);
        }
        catch (Exception e) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.state.MessageTWOResource", (String)"setQueryError"));
            SysUtil.abort();
        }
    }

    public void _setCustomerParams(CustomerParams cp) throws Exception {
        String id;
        int latitudeType;
        this.pkOccurDateFrom.setValue((Object)cp.getDate("pkOccurDateFrom"));
        this.pkOccurDateTo.setValue((Object)cp.getDate("pkOccurDateTo"));
        this.pkDeterDateFrom.setValue((Object)cp.getDate("pkDeterDateFrom"));
        this.pkDeterDateTo.setValue((Object)cp.getDate("pkDeterDateTo"));
        ObjectUuidPK pk = null;
        if (cp.getCustomerParam("adminID") != null) {
            String adminID = cp.getCustomerParam("adminID");
            AdminOrgUnitInfo adminOrg = null;
            pk = new ObjectUuidPK(BOSUuid.read((String)adminID));
            adminOrg = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)pk);
            this.prmtAdminOrg.setValue((Object)adminOrg);
        }
        if (cp.getCustomerParam("positionID") != null) {
            String positionID = cp.getCustomerParam("positionID");
            PositionInfo position = null;
            pk = new ObjectUuidPK(BOSUuid.read((String)positionID));
            position = PositionFactory.getRemoteInstance().getPositionInfo((IObjectPK)pk);
            this.prmtPosition.setValue((Object)position);
        }
        if ((latitudeType = cp.getInt("latitudeType")) == 0) {
            this.kdRadioAdminOrg.setSelected(true);
        } else if (latitudeType == 1) {
            this.kdRadioPosition.setSelected(true);
        }
        this.chkIncludeChild.setSelected(cp.getBoolean("isIncludeChild"));
        int count = cp.getInt("typesCount");
        Object[] dataArray = new Object[count];
        InjuryTypesInfo types = null;
        for (int i = 0; i < count; ++i) {
            id = cp.getCustomerParam("typesID" + i);
            pk = new ObjectUuidPK(BOSUuid.read((String)id));
            types = InjuryTypesFactory.getRemoteInstance().getInjuryTypesInfo((IObjectPK)pk);
            dataArray[i] = types;
        }
        this.prmtTypes.setValue((Object)dataArray);
        count = cp.getInt("ratesCount");
        dataArray = new Object[count];
        InjuryRateInfo rates = null;
        for (int i = 0; i < count; ++i) {
            id = cp.getCustomerParam("ratesID" + i);
            pk = new ObjectUuidPK(BOSUuid.read((String)id));
            rates = InjuryRateFactory.getRemoteInstance().getInjuryRateInfo((IObjectPK)pk);
            dataArray[i] = rates;
        }
        this.prmtRates.setValue((Object)dataArray);
    }
}

